/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.spatial.util.MortonEncoder;
import org.apache.lucene.util.BitUtil;
import org.elasticsearch.common.geo.GeoPoint;

public class GeoHashUtils {
    private static final char[] BASE_32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final String BASE_32_STRING = new String(BASE_32);
    public static final int PRECISION = 12;
    public static final short BITS = 31;
    private static final double LAT_SCALE = 1.1930464711111112E7;
    private static final double LON_SCALE = 5965232.355555556;
    private static final short MORTON_OFFSET = 2;

    private GeoHashUtils() {
    }

    public static long encodeLatLon(double lat, double lon) {
        long result = MortonEncoder.encode((double)lat, (double)lon);
        if (result == -1L) {
            return result & 0xC000000000000000L;
        }
        return result >>> 2;
    }

    public static final long longEncode(double lon, double lat, int level) {
        short msf = (short)((12 - level) * 5 + 2);
        return BitUtil.flipFlop((long)GeoHashUtils.encodeLatLon(lat, lon)) >>> msf << 4 | (long)level;
    }

    public static final long longEncode(String hash) {
        int level = hash.length() - 1;
        long l = 0L;
        for (char c : hash.toCharArray()) {
            long b = BASE_32_STRING.indexOf(c);
            l |= b << level-- * 5;
        }
        return l << 4 | (long)hash.length();
    }

    public static long longEncode(long geohash, int level) {
        short precision = (short)(geohash & 0xFL);
        if (precision == level) {
            return geohash;
        }
        if (precision > level) {
            return geohash >>> (precision - level) * 5 + 4 << 4 | (long)level;
        }
        return geohash >>> 4 << (level - precision) * 5 + 4 | (long)level;
    }

    public static long fromMorton(long morton, int level) {
        long mFlipped = BitUtil.flipFlop((long)morton);
        return (mFlipped >>>= (12 - level) * 5 + 2) << 4 | (long)level;
    }

    public static final String stringEncode(long geoHashLong) {
        int level = (int)geoHashLong & 0xF;
        geoHashLong >>>= 4;
        char[] chars = new char[level];
        do {
            chars[--level] = BASE_32[(int)(geoHashLong & 0x1FL)];
            geoHashLong >>>= 5;
        } while (level > 0);
        return new String(chars);
    }

    public static final String stringEncode(double lon, double lat) {
        return GeoHashUtils.stringEncode(lon, lat, 12);
    }

    public static final String stringEncode(double lon, double lat, int level) {
        long ghLong = GeoHashUtils.fromMorton(GeoHashUtils.encodeLatLon(lat, lon), level);
        return GeoHashUtils.stringEncode(ghLong);
    }

    public static final String stringEncodeFromMortonLong(long hashedVal) throws Exception {
        return GeoHashUtils.stringEncode(hashedVal, 12.0);
    }

    public static final String stringEncodeFromMortonLong(long hashedVal, int level) {
        hashedVal = BitUtil.flipFlop((long)hashedVal);
        StringBuilder geoHash = new StringBuilder();
        int precision = 0;
        int msf = 57;
        long mask = 0x3E00000000000000L;
        do {
            geoHash.append(BASE_32[(int)((mask & hashedVal) >>> 57 - precision * 5)]);
            mask >>>= 5;
        } while ((precision = (int)((short)(precision + 1))) < level);
        return geoHash.toString();
    }

    public static final long mortonEncode(String hash) {
        int level = 11;
        long l = 0L;
        for (char c : hash.toCharArray()) {
            long b = BASE_32_STRING.indexOf(c);
            l |= b << level-- * 5 + 2;
        }
        return BitUtil.flipFlop((long)l);
    }

    public static final long mortonEncode(long geoHashLong) {
        int level = (int)(geoHashLong & 0xFL);
        short odd = (short)(level & 1);
        return BitUtil.flipFlop((long)(geoHashLong >>> 4 << odd << (12 - level) * 5 + (2 - odd)));
    }

    private static char encode(int x, int y) {
        return BASE_32[((x & 1) + (y & 1) * 2 + (x & 2) * 2 + (y & 2) * 4 + (x & 4) * 4) % 32];
    }

    public static Rectangle bbox(String geohash) {
        GeoPoint bottomLeft = GeoPoint.fromGeohash(geohash);
        long ghLong = GeoHashUtils.longEncode(geohash);
        long lat = BitUtil.deinterleave((long)((ghLong >>>= 4) >>> 1)) + 1L;
        long lon = BitUtil.deinterleave((long)ghLong) + 1L;
        GeoPoint topRight = GeoPoint.fromGeohash(BitUtil.interleave((int)((int)lon), (int)((int)lat)) << 4 | (long)geohash.length());
        return new Rectangle(bottomLeft.lat(), topRight.lat(), bottomLeft.lon(), topRight.lon());
    }

    public static Collection<? extends CharSequence> neighbors(String geohash) {
        return GeoHashUtils.addNeighbors(geohash, geohash.length(), new ArrayList(8));
    }

    public static final String neighbor(String geohash, int level, int dx, int dy) {
        int ny;
        int cell = BASE_32_STRING.indexOf(geohash.charAt(level - 1));
        int x0 = cell & 1;
        int y0 = cell & 2;
        int x1 = cell & 4;
        int y1 = cell & 8;
        int x2 = cell & 0x10;
        int x = x0 + x1 / 2 + x2 / 4;
        int y = y0 / 2 + y1 / 4;
        if (level == 1) {
            if (dy < 0 && y == 0 || dy > 0 && y == 3) {
                return null;
            }
            return Character.toString(GeoHashUtils.encode(x + dx, y + dy));
        }
        int nx = level % 2 == 1 ? x + dx : x + dy;
        int n = ny = level % 2 == 1 ? y + dy : y + dx;
        if (nx >= 0 && nx <= 7 && ny >= 0 && ny <= 3) {
            return geohash.substring(0, level - 1) + GeoHashUtils.encode(nx, ny);
        }
        String neighbor = GeoHashUtils.neighbor(geohash, level - 1, dx, dy);
        return neighbor != null ? neighbor + GeoHashUtils.encode(nx, ny) : neighbor;
    }

    public static final <E extends Collection<? super String>> E addNeighbors(String geohash, E neighbors) {
        return GeoHashUtils.addNeighbors(geohash, geohash.length(), neighbors);
    }

    public static final <E extends Collection<? super String>> E addNeighbors(String geohash, int length, E neighbors) {
        String south = GeoHashUtils.neighbor(geohash, length, 0, -1);
        String north = GeoHashUtils.neighbor(geohash, length, 0, 1);
        if (north != null) {
            neighbors.add((String)GeoHashUtils.neighbor(north, length, -1, 0));
            neighbors.add((String)north);
            neighbors.add((String)GeoHashUtils.neighbor(north, length, 1, 0));
        }
        neighbors.add((String)GeoHashUtils.neighbor(geohash, length, -1, 0));
        neighbors.add((String)GeoHashUtils.neighbor(geohash, length, 1, 0));
        if (south != null) {
            neighbors.add((String)GeoHashUtils.neighbor(south, length, -1, 0));
            neighbors.add((String)south);
            neighbors.add((String)GeoHashUtils.neighbor(south, length, 1, 0));
        }
        return (E)neighbors;
    }

    public static final double decodeLongitude(long hash) {
        return GeoHashUtils.unscaleLon(BitUtil.deinterleave((long)hash));
    }

    public static final double decodeLatitude(long hash) {
        return GeoHashUtils.unscaleLat(BitUtil.deinterleave((long)(hash >>> 1)));
    }

    private static double unscaleLon(long val) {
        return (double)val / 5965232.355555556 - 180.0;
    }

    private static double unscaleLat(long val) {
        return (double)val / 1.1930464711111112E7 - 90.0;
    }

    public static final double decodeLatitude(String geohash) {
        return GeoHashUtils.decodeLatitude(GeoHashUtils.mortonEncode(geohash));
    }

    public static final double decodeLongitude(String geohash) {
        return GeoHashUtils.decodeLongitude(GeoHashUtils.mortonEncode(geohash));
    }
}

