/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.index.engine.DeleteVersionValue;
import org.elasticsearch.index.engine.VersionValue;

final class LiveVersionMap
implements ReferenceManager.RefreshListener,
Accountable {
    private final KeyedLock<BytesRef> keyedLock = new KeyedLock();
    private final Map<BytesRef, DeleteVersionValue> tombstones = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private volatile Maps maps = new Maps();
    private volatile Maps unsafeKeysMap = new Maps();
    private static final long BASE_BYTES_PER_BYTESREF = RamUsageEstimator.shallowSizeOfInstance(BytesRef.class) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 3L;
    private static final long BASE_BYTES_PER_CHM_ENTRY;
    final AtomicLong ramBytesUsedCurrent = new AtomicLong();
    final AtomicLong ramBytesUsedTombstones = new AtomicLong();

    LiveVersionMap() {
    }

    public void beforeRefresh() throws IOException {
        this.maps = this.maps.buildTransitionMap();
        assert ((this.unsafeKeysMap = this.unsafeKeysMap.buildTransitionMap()) != null);
        this.ramBytesUsedCurrent.set(0L);
    }

    public void afterRefresh(boolean didRefresh) throws IOException {
        this.maps = this.maps.invalidateOldMap();
        assert ((this.unsafeKeysMap = this.unsafeKeysMap.invalidateOldMap()) != null);
    }

    VersionValue getUnderLock(BytesRef uid) {
        return this.getUnderLock(uid, this.maps);
    }

    private VersionValue getUnderLock(BytesRef uid, Maps currentMaps) {
        assert (this.keyedLock.isHeldByCurrentThread(uid));
        VersionValue value = currentMaps.current.get(uid);
        if (value != null) {
            return value;
        }
        value = currentMaps.old.get(uid);
        if (value != null) {
            return value;
        }
        return this.tombstones.get(uid);
    }

    VersionValue getVersionForAssert(BytesRef uid) {
        VersionValue value = this.getUnderLock(uid, this.maps);
        if (value == null) {
            value = this.getUnderLock(uid, this.unsafeKeysMap);
        }
        return value;
    }

    boolean isUnsafe() {
        return this.maps.current.isUnsafe() || this.maps.old.isUnsafe();
    }

    void enforceSafeAccess() {
        this.maps.needsSafeAccess = true;
    }

    boolean isSafeAccessRequired() {
        return this.maps.isSafeAccessMode();
    }

    void maybePutUnderLock(BytesRef uid, VersionValue version) {
        assert (this.keyedLock.isHeldByCurrentThread(uid));
        Maps maps = this.maps;
        if (maps.isSafeAccessMode()) {
            this.putUnderLock(uid, version, maps);
        } else {
            maps.current.markAsUnsafe();
            assert (this.putAssertionMap(uid, version));
        }
    }

    private boolean putAssertionMap(BytesRef uid, VersionValue version) {
        this.putUnderLock(uid, version, this.unsafeKeysMap);
        return true;
    }

    void putUnderLock(BytesRef uid, VersionValue version) {
        Maps maps = this.maps;
        this.putUnderLock(uid, version, maps);
    }

    private void putUnderLock(BytesRef uid, VersionValue version, Maps maps) {
        VersionValue prevTombstone;
        assert (this.keyedLock.isHeldByCurrentThread(uid));
        assert (uid.bytes.length == uid.length) : "Oversized _uid! UID length: " + uid.length + ", bytes length: " + uid.bytes.length;
        long uidRAMBytesUsed = BASE_BYTES_PER_BYTESREF + (long)uid.bytes.length;
        VersionValue prev = maps.current.put(uid, version);
        if (prev != null) {
            long prevBytes = BASE_BYTES_PER_CHM_ENTRY;
            if (!prev.isDelete()) {
                prevBytes += prev.ramBytesUsed() + uidRAMBytesUsed;
            }
            this.ramBytesUsedCurrent.addAndGet(-prevBytes);
        }
        long newBytes = BASE_BYTES_PER_CHM_ENTRY;
        if (!version.isDelete()) {
            newBytes += version.ramBytesUsed() + uidRAMBytesUsed;
        }
        this.ramBytesUsedCurrent.addAndGet(newBytes);
        if (version.isDelete()) {
            prevTombstone = this.tombstones.put(uid, (DeleteVersionValue)version);
            this.ramBytesUsedTombstones.addAndGet(BASE_BYTES_PER_CHM_ENTRY + version.ramBytesUsed() + uidRAMBytesUsed);
            if (prevTombstone == null && prev != null && prev.isDelete()) {
                this.ramBytesUsedCurrent.addAndGet(-(prev.ramBytesUsed() + uidRAMBytesUsed));
            }
        } else {
            prevTombstone = this.tombstones.remove(uid);
        }
        if (prevTombstone != null) {
            long v = this.ramBytesUsedTombstones.addAndGet(-(BASE_BYTES_PER_CHM_ENTRY + prevTombstone.ramBytesUsed() + uidRAMBytesUsed));
            assert (v >= 0L) : "bytes=" + v;
        }
    }

    void removeTombstoneUnderLock(BytesRef uid) {
        VersionValue curVersion;
        assert (this.keyedLock.isHeldByCurrentThread(uid));
        long uidRAMBytesUsed = BASE_BYTES_PER_BYTESREF + (long)uid.bytes.length;
        VersionValue prev = this.tombstones.remove(uid);
        if (prev != null) {
            assert (prev.isDelete());
            long v = this.ramBytesUsedTombstones.addAndGet(-(BASE_BYTES_PER_CHM_ENTRY + prev.ramBytesUsed() + uidRAMBytesUsed));
            assert (v >= 0L) : "bytes=" + v;
        }
        if ((curVersion = this.maps.current.get(uid)) != null && curVersion.isDelete()) {
            this.ramBytesUsedCurrent.addAndGet(curVersion.ramBytesUsed() + uidRAMBytesUsed);
        }
    }

    DeleteVersionValue getTombstoneUnderLock(BytesRef uid) {
        assert (this.keyedLock.isHeldByCurrentThread(uid));
        return this.tombstones.get(uid);
    }

    Iterable<Map.Entry<BytesRef, DeleteVersionValue>> getAllTombstones() {
        return this.tombstones.entrySet();
    }

    void clearTombstones() {
        this.tombstones.clear();
    }

    synchronized void clear() {
        this.maps = new Maps();
        this.tombstones.clear();
        this.ramBytesUsedCurrent.set(0L);
    }

    public long ramBytesUsed() {
        return this.ramBytesUsedCurrent.get() + this.ramBytesUsedTombstones.get();
    }

    long ramBytesUsedForRefresh() {
        return this.ramBytesUsedCurrent.get();
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    Map<BytesRef, VersionValue> getAllCurrent() {
        return this.maps.current.map;
    }

    Releasable acquireLock(BytesRef uid) {
        return this.keyedLock.acquire(uid);
    }

    Releasable tryAcquireLock(BytesRef uid) {
        return this.keyedLock.tryAcquire(uid);
    }

    static {
        ConcurrentMap<Integer, Integer> map = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
        map.put(0, 0);
        long chmEntryShallowSize = RamUsageEstimator.shallowSizeOf(map.entrySet().iterator().next());
        BASE_BYTES_PER_CHM_ENTRY = chmEntryShallowSize + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    }

    private static final class Maps {
        final VersionLookup current;
        final VersionLookup old;
        boolean needsSafeAccess;
        final boolean previousMapsNeededSafeAccess;

        Maps(VersionLookup current, VersionLookup old, boolean previousMapsNeededSafeAccess) {
            this.current = current;
            this.old = old;
            this.previousMapsNeededSafeAccess = previousMapsNeededSafeAccess;
        }

        Maps() {
            this(new VersionLookup(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency()), VersionLookup.EMPTY, false);
        }

        boolean isSafeAccessMode() {
            return this.needsSafeAccess || this.previousMapsNeededSafeAccess;
        }

        boolean shouldInheritSafeAccess() {
            boolean mapHasNotSeenAnyOperations = this.current.isEmpty() && !this.current.isUnsafe();
            return this.needsSafeAccess || mapHasNotSeenAnyOperations && this.previousMapsNeededSafeAccess;
        }

        Maps buildTransitionMap() {
            return new Maps(new VersionLookup(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency(this.current.size())), this.current, this.shouldInheritSafeAccess());
        }

        Maps invalidateOldMap() {
            return new Maps(this.current, VersionLookup.EMPTY, this.previousMapsNeededSafeAccess);
        }
    }

    private static final class VersionLookup {
        private static final VersionLookup EMPTY = new VersionLookup(Collections.emptyMap());
        private final Map<BytesRef, VersionValue> map;
        private boolean unsafe;

        private VersionLookup(Map<BytesRef, VersionValue> map) {
            this.map = map;
        }

        VersionValue get(BytesRef key) {
            return this.map.get(key);
        }

        VersionValue put(BytesRef key, VersionValue value) {
            return this.map.put(key, value);
        }

        boolean isEmpty() {
            return this.map.isEmpty();
        }

        int size() {
            return this.map.size();
        }

        boolean isUnsafe() {
            return this.unsafe;
        }

        void markAsUnsafe() {
            this.unsafe = true;
        }
    }
}

