/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.execution.taskgraph.TaskFailureCollector;
import org.gradle.execution.taskgraph.TaskInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInfoFactory {
    private final Map<Task, TaskInfo> nodes = new HashMap<Task, TaskInfo>();
    private final TaskFailureCollector failureCollector;

    public TaskInfoFactory(TaskFailureCollector failureCollector) {
        this.failureCollector = failureCollector;
    }

    public Set<Task> getTasks() {
        return this.nodes.keySet();
    }

    public TaskInfo createNode(Task task) {
        TaskInfo node = this.nodes.get(task);
        if (node == null) {
            node = task instanceof IncludedBuildTaskResource ? new TaskResourceTaskInfo((TaskInternal)task, this.failureCollector) : new TaskInfo((TaskInternal)task);
            this.nodes.put(task, node);
        }
        return node;
    }

    public void clear() {
        this.nodes.clear();
    }

    private static class TaskResourceTaskInfo
    extends TaskInfo {
        private final TaskFailureCollector failureCollector;
        private boolean complete;

        public TaskResourceTaskInfo(TaskInternal task, TaskFailureCollector failureCollector) {
            super(task);
            this.failureCollector = failureCollector;
            this.doNotRequire();
        }

        public void require() {
        }

        public boolean isComplete() {
            if (this.complete) {
                return true;
            }
            IncludedBuildTaskResource task = (IncludedBuildTaskResource)((Object)this.getTask());
            try {
                this.complete = task.isComplete();
            }
            catch (Exception e) {
                this.complete = true;
                this.failureCollector.addFailure(e);
            }
            return this.complete;
        }
    }
}

