/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.ProcessLauncher;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.operations.CurrentBuildOperationPreservingRunnable;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.ExecHandleRunner;
import org.gradle.process.internal.ExecHandleShutdownHookAction;
import org.gradle.process.internal.ExecHandleState;
import org.gradle.process.internal.ProcessSettings;
import org.gradle.process.internal.StreamsHandler;
import org.gradle.process.internal.shutdown.ShutdownHookActionRegister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecHandle
implements ExecHandle,
ProcessSettings {
    private static final Logger LOGGER = Logging.getLogger(DefaultExecHandle.class);
    private final String displayName;
    private final File directory;
    private final String command;
    private final List<String> arguments;
    private final Map<String, String> environment;
    private final StreamsHandler outputHandler;
    private final StreamsHandler inputHandler;
    private final boolean redirectErrorStream;
    private final ProcessLauncher processLauncher;
    private int timeoutMillis;
    private boolean daemon;
    private final Lock lock;
    private final Condition stateChanged;
    private final Executor executor;
    private ExecHandleState state;
    private ExecHandleRunner execHandleRunner;
    private ExecResultImpl execResult;
    private final ListenerBroadcast<ExecHandleListener> broadcast;
    private final ExecHandleShutdownHookAction shutdownHookAction;

    DefaultExecHandle(String displayName, File directory, String command, List<String> arguments, Map<String, String> environment, StreamsHandler outputHandler, StreamsHandler inputHandler, List<ExecHandleListener> listeners, boolean redirectErrorStream, int timeoutMillis, boolean daemon, Executor executor) {
        this.displayName = displayName;
        this.directory = directory;
        this.command = command;
        this.arguments = arguments;
        this.environment = environment;
        this.outputHandler = outputHandler;
        this.inputHandler = inputHandler;
        this.redirectErrorStream = redirectErrorStream;
        this.timeoutMillis = timeoutMillis;
        this.daemon = daemon;
        this.executor = executor;
        this.lock = new ReentrantLock();
        this.stateChanged = this.lock.newCondition();
        this.state = ExecHandleState.INIT;
        this.processLauncher = (ProcessLauncher)NativeServices.getInstance().get(ProcessLauncher.class);
        this.shutdownHookAction = new ExecHandleShutdownHookAction(this);
        this.broadcast = new ListenerBroadcast(ExecHandleListener.class);
        this.broadcast.addAll(listeners);
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public List<String> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this.environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecHandleState getState() {
        this.lock.lock();
        try {
            ExecHandleState execHandleState = this.state;
            return execHandleState;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ExecHandleState state) {
        this.lock.lock();
        try {
            LOGGER.debug("Changing state to: {}", (Object)state);
            this.state = state;
            this.stateChanged.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stateIn(ExecHandleState ... states) {
        this.lock.lock();
        try {
            boolean bl = Arrays.asList(states).contains(this.state);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEndStateInfo(ExecHandleState newState, int exitValue, Throwable failureCause) {
        ExecHandleState currentState;
        ShutdownHookActionRegister.removeAction(this.shutdownHookAction);
        this.lock.lock();
        try {
            currentState = this.state;
        }
        finally {
            this.lock.unlock();
        }
        ExecResultImpl newResult = new ExecResultImpl(exitValue, this.execExceptionFor(failureCause, currentState), this.displayName);
        if (!currentState.isTerminal() && newState != ExecHandleState.DETACHED) {
            try {
                ((ExecHandleListener)this.broadcast.getSource()).executionFinished((ExecHandle)this, (ExecResult)newResult);
            }
            catch (Exception e) {
                newResult = new ExecResultImpl(exitValue, this.execExceptionFor(e, currentState), this.displayName);
            }
        }
        this.lock.lock();
        try {
            this.setState(newState);
            this.execResult = newResult;
        }
        finally {
            this.lock.unlock();
        }
        LOGGER.debug("Process '{}' finished with exit value {} (state: {})", new Object[]{this.displayName, exitValue, newState});
    }

    @Nullable
    private ExecException execExceptionFor(Throwable failureCause, ExecHandleState currentState) {
        return failureCause != null ? new ExecException(this.failureMessageFor(currentState), failureCause) : null;
    }

    private String failureMessageFor(ExecHandleState currentState) {
        return currentState == ExecHandleState.STARTING ? String.format("A problem occurred starting process '%s'", this.displayName) : String.format("A problem occurred waiting for process '%s' to complete.", this.displayName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecHandle start() {
        LOGGER.info("Starting process '{}'. Working directory: {} Command: {}", new Object[]{this.displayName, this.directory, this.command + ' ' + Joiner.on((char)' ').useForNull("null").join(this.arguments)});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Environment for process '{}': {}", (Object)this.displayName, this.environment);
        }
        this.lock.lock();
        try {
            if (!this.stateIn(ExecHandleState.INIT)) {
                throw new IllegalStateException(String.format("Cannot start process '%s' because it has already been started", this.displayName));
            }
            this.setState(ExecHandleState.STARTING);
            this.execHandleRunner = new ExecHandleRunner(this, new CompositeStreamsHandler(), this.processLauncher, this.executor);
            this.executor.execute((Runnable)new CurrentBuildOperationPreservingRunnable((Runnable)this.execHandleRunner));
            while (this.stateIn(ExecHandleState.STARTING)) {
                LOGGER.debug("Waiting until process started: {}.", (Object)this.displayName);
                try {
                    this.stateChanged.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.execResult != null) {
                this.execResult.rethrowFailure();
            }
            LOGGER.info("Successfully started process '{}'", (Object)this.displayName);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        this.lock.lock();
        try {
            if (this.stateIn(ExecHandleState.SUCCEEDED, ExecHandleState.FAILED, ExecHandleState.ABORTED)) {
                return;
            }
            if (!this.stateIn(ExecHandleState.STARTED, ExecHandleState.DETACHED)) {
                throw new IllegalStateException(String.format("Cannot abort process '%s' because it is not in started or detached state", this.displayName));
            }
            this.execHandleRunner.abortProcess();
            this.waitForFinish();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExecResult waitForFinish() {
        this.lock.lock();
        try {
            while (!this.state.isTerminal()) {
                try {
                    this.stateChanged.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    return this.result();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecResult result() {
        this.lock.lock();
        try {
            ExecResult execResult = this.execResult.rethrowFailure();
            return execResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    void detached() {
        this.setEndStateInfo(ExecHandleState.DETACHED, 0, null);
    }

    void started() {
        ShutdownHookActionRegister.addAction(this.shutdownHookAction);
        this.setState(ExecHandleState.STARTED);
        ((ExecHandleListener)this.broadcast.getSource()).executionStarted((ExecHandle)this);
    }

    void finished(int exitCode) {
        if (exitCode != 0) {
            this.setEndStateInfo(ExecHandleState.FAILED, exitCode, null);
        } else {
            this.setEndStateInfo(ExecHandleState.SUCCEEDED, 0, null);
        }
    }

    void aborted(int exitCode) {
        if (exitCode == 0) {
            exitCode = -1;
        }
        this.setEndStateInfo(ExecHandleState.ABORTED, exitCode, null);
    }

    void failed(Throwable failureCause) {
        this.setEndStateInfo(ExecHandleState.FAILED, -1, failureCause);
    }

    public void addListener(ExecHandleListener listener) {
        this.broadcast.add((Object)listener);
    }

    public void removeListener(ExecHandleListener listener) {
        this.broadcast.remove((Object)listener);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean getRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    public int getTimeout() {
        return this.timeoutMillis;
    }

    private class CompositeStreamsHandler
    implements StreamsHandler {
        private CompositeStreamsHandler() {
        }

        public void connectStreams(Process process, String processName, Executor executor) {
            DefaultExecHandle.this.inputHandler.connectStreams(process, processName, executor);
            DefaultExecHandle.this.outputHandler.connectStreams(process, processName, executor);
        }

        public void start() {
            DefaultExecHandle.this.inputHandler.start();
            DefaultExecHandle.this.outputHandler.start();
        }

        public void stop() {
            DefaultExecHandle.this.inputHandler.stop();
            DefaultExecHandle.this.outputHandler.stop();
        }
    }

    private static class ExecResultImpl
    implements ExecResult {
        private final int exitValue;
        private final ExecException failure;
        private final String displayName;

        ExecResultImpl(int exitValue, ExecException failure, String displayName) {
            this.exitValue = exitValue;
            this.failure = failure;
            this.displayName = displayName;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public ExecResult assertNormalExitValue() throws ExecException {
            if (this.exitValue != 0) {
                throw new ExecException(String.format("Process '%s' finished with non-zero exit value %d", this.displayName, this.exitValue));
            }
            return this;
        }

        public ExecResult rethrowFailure() throws ExecException {
            if (this.failure != null) {
                throw this.failure;
            }
            return this;
        }

        public String toString() {
            return "{exitValue=" + this.exitValue + ", failure=" + this.failure + "}";
        }
    }
}

