/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines.experimental.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.internal.ThreadSafeHeapNode;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J!\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00028\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016\u00a2\u0006\u0002\u0010\u0017J\u000f\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0001\u00a2\u0006\u0002\u0010\u0019J\r\u0010\u001a\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007H\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\rH\u0001\u00a2\u0006\u0002\u0010!J$\u0010\"\u001a\u0004\u0018\u00018\u00002\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0$H\u0086\b\u00a2\u0006\u0002\u0010%J\r\u0010&\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\rH\u0002R\u001a\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0018\u0010\f\u001a\u00020\r8\u0000@\u0000X\u0081\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u0005\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/internal/ThreadSafeHeap;", "T", "Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/internal/ThreadSafeHeapNode;", "", "", "()V", "a", "", "[Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/internal/ThreadSafeHeapNode;", "isEmpty", "", "()Z", "size", "", "size$annotations", "addImpl", "", "node", "(Lkotlinx/coroutines/experimental/internal/ThreadSafeHeapNode;)V", "addLast", "addLastIf", "cond", "Lkotlin/Function0;", "(Lkotlinx/coroutines/experimental/internal/ThreadSafeHeapNode;Lkotlin/jvm/functions/Function0;)Z", "firstImpl", "()Lkotlinx/coroutines/experimental/internal/ThreadSafeHeapNode;", "peek", "realloc", "()[Lkotlinx/coroutines/experimental/internal/ThreadSafeHeapNode;", "remove", "(Lkotlinx/coroutines/experimental/internal/ThreadSafeHeapNode;)Z", "removeAtImpl", "index", "(I)Lkotlinx/coroutines/experimental/internal/ThreadSafeHeapNode;", "removeFirstIf", "predicate", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Lkotlinx/coroutines/experimental/internal/ThreadSafeHeapNode;", "removeFirstOrNull", "swap", "i", "j", "kotlinx-coroutines-core"})
public final class ThreadSafeHeap<T extends ThreadSafeHeapNode & Comparable<? super T>> {
    private T[] a;
    @JvmField
    public volatile int size;

    @PublishedApi
    public static /* synthetic */ void size$annotations() {
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T peek() {
        T t;
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            t = this.firstImpl();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T removeFirstOrNull() {
        T t;
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            t = this.size > 0 ? (T)this.removeAtImpl(0) : null;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T removeFirstIf(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            T t;
            try {
                T t2;
                T t3 = this.firstImpl();
                if (t3 == null) {
                    t2 = null;
                } else {
                    T first2 = t3;
                    t2 = ((Boolean)predicate.invoke(first2)).booleanValue() ? (T)this.removeAtImpl(0) : null;
                }
                t = t2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl16 : MonitorExitStatement: MONITOREXIT : var3_2
                InlineMarker.finallyEnd((int)1);
            }
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addLast(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            this.addImpl(node);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addLastIf(@NotNull T node, @NotNull Function0<Boolean> cond) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        Intrinsics.checkParameterIsNotNull(cond, (String)"cond");
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            boolean bl2;
            if (((Boolean)cond.invoke()).booleanValue()) {
                this.addImpl(node);
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(@NotNull T node) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        ThreadSafeHeap threadSafeHeap = this;
        synchronized (threadSafeHeap) {
            boolean bl2;
            if (node.getIndex() < 0) {
                bl2 = false;
            } else {
                this.removeAtImpl(node.getIndex());
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    @PublishedApi
    @Nullable
    public final T firstImpl() {
        return (T)(this.a != null ? (ThreadSafeHeapNode)this.a[0] : null);
    }

    @PublishedApi
    @NotNull
    public final T removeAtImpl(int index2) {
        boolean bl;
        boolean bl2 = bl = this.size > 0;
        if (!bl) {
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.a == null) {
            Intrinsics.throwNpe();
        }
        T[] a = this.a;
        int n = this.size;
        this.size = n + -1;
        if (index2 < this.size) {
            int j;
            this.swap(index2, this.size);
            int i = index2;
            while ((j = 2 * i + 1) < this.size) {
                if (j + 1 < this.size) {
                    T t = a[j + 1];
                    if (t == null) {
                        Intrinsics.throwNpe();
                    }
                    Comparable comparable = (Comparable)t;
                    T t2 = a[j];
                    if (t2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (comparable.compareTo(t2) < 0) {
                        ++j;
                    }
                }
                T t = a[i];
                if (t == null) {
                    Intrinsics.throwNpe();
                }
                Comparable comparable = (Comparable)t;
                T t3 = a[j];
                if (t3 == null) {
                    Intrinsics.throwNpe();
                }
                if (comparable.compareTo(t3) <= 0) break;
                this.swap(i, j);
                i = j;
            }
        }
        T t = a[this.size];
        if (t == null) {
            Intrinsics.throwNpe();
        }
        T result2 = t;
        result2.setIndex(-1);
        a[this.size] = null;
        return result2;
    }

    @PublishedApi
    public final void addImpl(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        ThreadSafeHeapNode[] a = this.realloc();
        int n = this.size;
        this.size = n + 1;
        int i = n;
        a[i] = node;
        node.setIndex(i);
        while (i > 0) {
            int j = (i - 1) / 2;
            ThreadSafeHeapNode threadSafeHeapNode = a[j];
            if (threadSafeHeapNode == null) {
                Intrinsics.throwNpe();
            }
            Comparable comparable = (Comparable)((Object)threadSafeHeapNode);
            ThreadSafeHeapNode threadSafeHeapNode2 = a[i];
            if (threadSafeHeapNode2 == null) {
                Intrinsics.throwNpe();
            }
            if (comparable.compareTo(threadSafeHeapNode2) <= 0) break;
            this.swap(i, j);
            i = j;
        }
    }

    private final T[] realloc() {
        Object[] objectArray;
        T[] a = this.a;
        if (a == null) {
            ThreadSafeHeapNode[] threadSafeHeapNodeArray;
            ThreadSafeHeapNode[] it = threadSafeHeapNodeArray = new ThreadSafeHeapNode[4];
            this.a = it;
            objectArray = threadSafeHeapNodeArray;
        } else if (this.size >= a.length) {
            T[] TArray = a;
            int it = this.size * 2;
            T[] TArray2 = Arrays.copyOf(TArray, it);
            Intrinsics.checkExpressionValueIsNotNull(TArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            TArray = TArray2;
            ThreadSafeHeapNode[] it2 = (ThreadSafeHeapNode[])TArray;
            this.a = it2;
            objectArray = (ThreadSafeHeapNode[])TArray;
        } else {
            objectArray = a;
        }
        return objectArray;
    }

    private final void swap(int i, int j) {
        if (this.a == null) {
            Intrinsics.throwNpe();
        }
        T[] a = this.a;
        T t = a[j];
        if (t == null) {
            Intrinsics.throwNpe();
        }
        T ni = t;
        T t2 = a[i];
        if (t2 == null) {
            Intrinsics.throwNpe();
        }
        T nj = t2;
        a[i] = ni;
        a[j] = nj;
        ni.setIndex(i);
        nj.setIndex(j);
    }
}

