/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependentsAccumulator;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingResult;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;

public class CompilationResultAnalyzer
implements FileVisitor {
    private final ClassDependenciesAnalyzer analyzer;
    private final ClassDependentsAccumulator accumulator;
    private final FileHasher hasher;

    public CompilationResultAnalyzer(ClassDependenciesAnalyzer analyzer, FileHasher fileHasher) {
        this(analyzer, fileHasher, new ClassDependentsAccumulator());
    }

    CompilationResultAnalyzer(ClassDependenciesAnalyzer analyzer, FileHasher fileHasher, ClassDependentsAccumulator accumulator) {
        this.analyzer = analyzer;
        this.hasher = fileHasher;
        this.accumulator = accumulator;
    }

    public void visitDir(FileVisitDetails dirDetails) {
    }

    public void visitFile(FileVisitDetails fileDetails) {
        if (!fileDetails.getName().endsWith(".class")) {
            return;
        }
        HashCode hash = this.hasher.hash((FileTreeElement)fileDetails);
        ClassAnalysis analysis = this.analyzer.getClassAnalysis(hash, (FileTreeElement)fileDetails);
        this.accumulator.addClass(fileDetails.getFile(), analysis);
    }

    public ClassSetAnalysisData getAnalysis() {
        return this.accumulator.getAnalysis();
    }

    public void visitAnnotationProcessingResult(AnnotationProcessingResult annotationProcessingResult) {
        if (annotationProcessingResult == null) {
            this.accumulator.fullRebuildNeeded("the chosen compiler did not support incremental annotation processing");
        } else {
            this.accumulator.addAnnotationProcessingResult(annotationProcessingResult);
        }
    }
}

