/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Arrays;
import javajs.util.AU;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.PolyhedronStereoSorter;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.VTemp;
import org.jmol.util.Edge;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;

public class SmilesStereo {
    private int chiralClass = Integer.MIN_VALUE;
    int chiralOrder = Integer.MIN_VALUE;
    int atomCount;
    private String details;
    private SmilesSearch search;
    private Node[] jmolAtoms;
    private String directives;
    public static final int DEFAULT = 0;
    public static final int POLYHEDRAL = 1;
    public static final int ALLENE = 2;
    public static final int TRIGONAL_PYRAMIDAL = 3;
    public static final int TETRAHEDRAL = 4;
    public static final int TRIGONAL_BIPYRAMIDAL = 5;
    public static final int OCTAHEDRAL = 6;
    public static final int SQUARE_PLANAR = 7;
    public static final int T_SHAPED = 8;
    public static final int SEESAW = 9;
    private static final int[] PERM_TB = new int[]{0, 1, 4, 0, -1, 4, 0, 1, 3, 0, -1, 3, 0, 1, 2, 0, -1, 2, 0, 1, 1, 0, -1, 1, 1, 1, 4, 1, 1, 3, 1, -1, 4, 1, -1, 3, 1, 1, 2, 1, -1, 2, 2, 1, 4, 2, 1, 3, 3, 1, 4, 3, -1, 4, 2, -1, 3, 2, -1, 4};
    private static final int[] PERM_OCT = new int[]{0, 1, 5, 0, -1, 5, 0, 1, 4, 0, 3, 5, 0, 3, 4, 0, 1, 3, 0, 3, 3, 0, 2, 5, 0, 2, 4, 0, -2, 5, 0, -2, 4, 0, 2, 3, 0, -2, 3, 0, -3, 5, 0, -3, 4, 0, -1, 4, 0, -3, 3, 0, -1, 3, 0, 1, 2, 0, 3, 2, 0, 2, 2, 0, -2, 2, 0, -3, 2, 0, -1, 2, 0, 1, 1, 0, 3, 1, 0, 2, 1, 0, -2, 1, 0, -3, 1, 0, -1, 1};
    private static final int[] PERM_SS = new int[]{0, 1, 3, 0, -1, 3, 0, 1, 2, 0, -1, 2, 0, 1, 1, 0, -1, 1, 1, 1, 3, 1, -1, 3, 1, 1, 2, 1, -1, 2, 2, 1, 3, 2, -1, 3};
    VTemp v;
    private int[][] polyhedralOrders;
    private boolean isNot;
    private PolyhedronStereoSorter sorter;

    private static int getChiralityClass(String xx) {
        return ("0;PH;AL;TP;TH;TB;OH;SP;TS;SS;".indexOf(xx) + 1) / 3;
    }

    public static SmilesStereo newStereo(SmilesSearch search) throws InvalidSmilesException {
        SmilesStereo stereo = new SmilesStereo(0, 0, 0, null, null);
        stereo.search = search;
        return stereo;
    }

    SmilesStereo(int chiralClass, int chiralOrder, int atomCount, String details, String directives) throws InvalidSmilesException {
        this.chiralClass = chiralClass;
        this.chiralOrder = chiralOrder;
        this.atomCount = atomCount;
        this.details = details;
        this.directives = directives;
        if (chiralClass == 1) {
            this.getPolyhedralOrders();
        }
    }

    public int getChiralClass(SmilesAtom sAtom) {
        if (this.chiralClass == 0) {
            this.setChiralClass(sAtom);
        }
        return this.chiralClass;
    }

    private int setChiralClass(SmilesAtom sAtom) {
        int nBonds = Math.max(sAtom.explicitHydrogenCount, 0) + sAtom.getBondCount();
        if (this.chiralClass == 0) {
            switch (nBonds) {
                case 2: {
                    this.chiralClass = 2;
                    break;
                }
                case 3: {
                    this.chiralClass = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.chiralClass = nBonds;
                }
            }
        }
        return nBonds;
    }

    void fixStereo(SmilesAtom sAtom) throws InvalidSmilesException {
        int nBonds = this.setChiralClass(sAtom);
        int nH = Math.max(sAtom.explicitHydrogenCount, 0);
        if (nH <= 1) {
            switch (this.chiralClass) {
                case 2: {
                    if (nBonds == 2) break;
                    sAtom.stereo = null;
                    break;
                }
                case 3: 
                case 8: {
                    if (nBonds == 3) break;
                    sAtom.stereo = null;
                    break;
                }
                case 4: 
                case 7: {
                    if (nBonds == 4) break;
                    sAtom.stereo = null;
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    if (nBonds == (this.chiralClass == 9 ? 4 : this.chiralClass) && this.normalizeClass(sAtom)) break;
                    sAtom.stereo = null;
                    break;
                }
                case 1: {
                    if (nBonds == 0 || nBonds == this.atomCount) break;
                    sAtom.stereo = null;
                    break;
                }
                default: {
                    sAtom.stereo = null;
                }
            }
        }
        if (sAtom.stereo == null) {
            throw new InvalidSmilesException("Incorrect number of bonds for stereochemistry descriptor");
        }
    }

    private boolean normalizeClass(SmilesAtom atom) {
        try {
            int i;
            SmilesBond b;
            boolean isAtAt;
            int ilast;
            int[] perm;
            SmilesBond[] bonds = atom.bonds;
            if (this.chiralOrder < 3) {
                return true;
            }
            int pt = (this.chiralOrder - 1) * 3;
            switch (this.chiralClass) {
                case 9: {
                    perm = PERM_SS;
                    ilast = 3;
                    break;
                }
                case 5: {
                    perm = PERM_TB;
                    ilast = 4;
                    break;
                }
                case 6: {
                    perm = PERM_OCT;
                    ilast = 5;
                    break;
                }
                default: {
                    return true;
                }
            }
            if (this.chiralOrder > perm.length) {
                return false;
            }
            int a = perm[pt];
            int z = perm[pt + 2];
            int p = Math.abs(perm[pt + 1]);
            boolean bl = isAtAt = perm[pt + 1] < 0;
            if (a != 0) {
                b = bonds[a];
                for (i = a; i > 0; --i) {
                    bonds[i] = bonds[i - 1];
                }
                bonds[0] = b;
            }
            if (z != ilast) {
                b = bonds[z];
                for (i = z; i < ilast; ++i) {
                    bonds[i] = bonds[i + 1];
                }
                bonds[ilast] = b;
            }
            switch (p) {
                case 1: {
                    break;
                }
                default: {
                    b = bonds[p + 1];
                    bonds[p + 1] = bonds[p];
                    bonds[p] = b;
                }
            }
            this.chiralOrder = isAtAt ? 2 : 1;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean setTopoCoordinates(SmilesAtom atom, SmilesAtom sAtom, SmilesAtom sAtom2, Node[] cAtoms) {
        int[] map;
        int chClass = atom.stereo.chiralClass;
        int chiralOrder = atom.stereo.chiralOrder;
        atom.set(0.0f, 0.0f, 0.0f);
        if (this.jmolAtoms == null) {
            map = new int[]{0, 1, 2, 3};
        } else {
            atom = (SmilesAtom)this.jmolAtoms[sAtom.getMatchingAtomIndex()];
            atom.set(0.0f, 0.0f, 0.0f);
            SmilesAtom a2 = (SmilesAtom)(chClass == 2 ? this.jmolAtoms[sAtom2.getMatchingAtomIndex()] : null);
            map = this.getMappedTopoAtoms(atom, a2, cAtoms);
        }
        switch (chClass) {
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                if (chiralOrder == 2) {
                    int pt = map[0];
                    map[0] = map[1];
                    map[1] = pt;
                }
                cAtoms[map[0]].set(0.0f, 0.0f, 1.0f);
                cAtoms[map[1]].set(1.0f, 0.0f, -1.0f);
                cAtoms[map[2]].set(0.0f, 1.0f, -1.0f);
                cAtoms[map[3]].set(-1.0f, -1.0f, -1.0f);
                break;
            }
            case 7: {
                switch (chiralOrder) {
                    case 1: {
                        cAtoms[map[0]].set(1.0f, 0.0f, 0.0f);
                        cAtoms[map[1]].set(0.0f, 1.0f, 0.0f);
                        cAtoms[map[2]].set(-1.0f, 0.0f, 0.0f);
                        cAtoms[map[3]].set(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 2: {
                        cAtoms[map[0]].set(1.0f, 0.0f, 0.0f);
                        cAtoms[map[1]].set(-1.0f, 0.0f, 0.0f);
                        cAtoms[map[2]].set(0.0f, 1.0f, 0.0f);
                        cAtoms[map[3]].set(0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case 3: {
                        cAtoms[map[0]].set(1.0f, 0.0f, 0.0f);
                        cAtoms[map[1]].set(0.0f, 1.0f, 0.0f);
                        cAtoms[map[2]].set(0.0f, -1.0f, 0.0f);
                        cAtoms[map[3]].set(-1.0f, 0.0f, 0.0f);
                    }
                }
                break;
            }
            case 8: {
                switch (chiralOrder) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        int pt = map[2];
                        map[2] = map[1];
                        map[1] = pt;
                        break;
                    }
                    case 3: {
                        int pt = map[0];
                        map[0] = map[1];
                        map[1] = pt;
                    }
                }
                cAtoms[map[0]].set(0.0f, 0.0f, -1.0f);
                cAtoms[map[1]].set(0.0f, 1.0f, 0.0f);
                cAtoms[map[2]].set(0.0f, 0.0f, 1.0f);
                break;
            }
            case 9: {
                if (chiralOrder == 2) {
                    int pt = map[0];
                    map[0] = map[3];
                    map[3] = pt;
                }
                cAtoms[map[0]].set(0.0f, 0.0f, 1.0f);
                cAtoms[map[1]].set(0.0f, 1.0f, 0.0f);
                cAtoms[map[1]].set(1.0f, 1.0f, 0.0f);
                cAtoms[map[2]].set(0.0f, 0.0f, -1.0f);
                break;
            }
            case 5: 
            case 6: {
                int n = map.length;
                if (chiralOrder == 2) {
                    int pt = map[0];
                    map[0] = map[n - 1];
                    map[n - 1] = pt;
                }
                cAtoms[map[0]].set(0.0f, 0.0f, 1.0f);
                cAtoms[map[n - 1]].set(0.0f, 0.0f, -1.0f);
                cAtoms[map[1]].set(1.0f, 0.0f, 0.0f);
                cAtoms[map[2]].set(0.0f, 1.0f, 0.0f);
                cAtoms[map[3]].set(-1.0f, 0.0f, 0.0f);
                if (n != 6) break;
                cAtoms[map[4]].set(0.0f, -1.0f, 0.0f);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private int[] getMappedTopoAtoms(SmilesAtom atom, SmilesAtom a2, Node[] cAtoms) {
        int i;
        int[] map = new int[cAtoms[4] == null ? 4 : (cAtoms[5] == null ? 5 : 6)];
        for (int i2 = 0; i2 < map.length; ++i2) {
            map[i2] = cAtoms[i2] == null ? 10004 + i2 * 10000 : cAtoms[i2].getIndex();
        }
        SmilesBond[] bonds = atom.bonds;
        SmilesBond[] b2 = (SmilesBond[])(a2 == null ? null : a2.getEdges());
        for (i = 0; i < map.length; ++i) {
            SmilesAtom c = (SmilesAtom)cAtoms[i];
            if (SmilesStereo.getTopoMapPt(map, i, atom, c, bonds, 10000)) continue;
            SmilesStereo.getTopoMapPt(map, i, a2, c, b2, 30000);
        }
        Arrays.sort(map);
        for (i = 0; i < map.length; ++i) {
            map[i] = map[i] % 10;
        }
        return map;
    }

    private static boolean getTopoMapPt(int[] map, int i, SmilesAtom atom, SmilesAtom cAtom, SmilesBond[] bonds, int n000) {
        if (cAtom.index == Integer.MIN_VALUE) {
            map[i] = (bonds[0].isFromPreviousTo(atom) ? 100 : 0) + n000 + i;
            return true;
        }
        int n = bonds.length;
        for (int k = 0; k < n; ++k) {
            SmilesAtom bAtom = (SmilesAtom)bonds[k].getOtherNode((SimpleNode)atom);
            if (bAtom != cAtom) continue;
            map[i] = (k + 1) * 10 + n000 + i;
            return true;
        }
        return false;
    }

    private Node getJmolAtom(int i) {
        return i < 0 || i >= this.jmolAtoms.length ? null : this.jmolAtoms[i];
    }

    void sortBondsByStereo(SimpleNode atom, SimpleNode atomPrev, T3 ref, SimpleEdge[] bonds, V3 vTemp) {
        if (bonds.length < 2 || !(atom instanceof T3)) {
            return;
        }
        if (atomPrev == null) {
            atomPrev = bonds[0].getOtherNode(atom);
        }
        Object[][] aTemp = new Object[bonds.length][0];
        if (this.sorter == null) {
            this.sorter = new PolyhedronStereoSorter();
        }
        vTemp.sub2((T3)atomPrev, ref);
        this.sorter.setRef(vTemp);
        int i = bonds.length;
        while (--i >= 0) {
            float f;
            SimpleNode a = bonds[i].getOtherNode(atom);
            float f2 = a == atomPrev ? 0.0f : (f = this.sorter.isAligned((T3)a, ref, (T3)atomPrev) ? -999.0f : Measure.computeTorsion((T3)((T3)atom), (T3)((T3)atomPrev), (T3)ref, (T3)((T3)a), (boolean)true));
            if (bonds.length > 2) {
                f += 360.0f;
            }
            aTemp[i] = new Object[]{bonds[i], Float.valueOf(f), a};
        }
        Arrays.sort(aTemp, this.sorter);
        if (Logger.debugging) {
            Logger.info((String)Escape.e((Object)aTemp));
        }
        i = bonds.length;
        while (--i >= 0) {
            bonds[i] = (Edge)aTemp[i][0];
        }
    }

    boolean checkStereoChemistry(SmilesSearch search, VTemp v) {
        this.v = v;
        this.search = search;
        this.jmolAtoms = search.targetAtoms;
        boolean haveTopo = search.haveTopo;
        boolean invertStereochemistry = search.invertStereochemistry;
        if (Logger.debugging) {
            Logger.debug((String)"checking stereochemistry...");
        }
        block5: for (int i = 0; i < search.ac; ++i) {
            SmilesAtom pAtom = search.patternAtoms[i];
            if (pAtom.stereo == null) continue;
            boolean isNot = pAtom.not != invertStereochemistry;
            Node atom0 = pAtom.getMatchingAtom();
            switch (this.checkStereoForAtom(pAtom, atom0, isNot, haveTopo)) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    return true;
                }
                case -1: {
                    return false;
                }
            }
        }
        return true;
    }

    public int checkStereoForAtom(SmilesAtom pAtom, Node atom0, boolean isNot, boolean haveTopo) {
        Node atom1 = null;
        Node atom2 = null;
        Node atom3 = null;
        Node atom4 = null;
        Node atom5 = null;
        Node atom6 = null;
        SmilesAtom pAtom2 = null;
        SmilesAtom sAtom0 = null;
        if (haveTopo) {
            sAtom0 = (SmilesAtom)atom0;
        }
        int nH = Math.max(pAtom.explicitHydrogenCount, 0);
        int order = pAtom.stereo.chiralOrder;
        int chiralClass = pAtom.stereo.chiralClass;
        if (haveTopo && sAtom0.getChiralClass() != chiralClass) {
            return -1;
        }
        if (Logger.debugging) {
            Logger.debug((String)("...type " + chiralClass + " for pattern atom \n " + (Object)((Object)pAtom) + "\n " + atom0));
        }
        switch (chiralClass) {
            case 1: {
                if (pAtom.stereo.isNot) {
                    boolean bl = isNot = !isNot;
                }
                if (nH > 1 || pAtom.bondCount == 0) {
                    return 0;
                }
                if (haveTopo) {
                    return 0;
                }
                SmilesBond[] bonds = pAtom.bonds;
                int jHpt = -1;
                if (nH == 1) {
                    int n = jHpt = pAtom.isFirst ? 0 : 1;
                    if (pAtom.getBondCount() != 3) {
                        return -1;
                    }
                    this.v.vA.set(0.0f, 0.0f, 0.0f);
                    for (int j = 0; j < 3; ++j) {
                        this.v.vA.add((T3)bonds[j].getOtherAtom(sAtom0).getMatchingAtom());
                    }
                    this.v.vA.scale(0.3333f);
                    this.v.vA.sub2((T3)atom0, (T3)this.v.vA);
                    this.v.vA.add((T3)atom0);
                }
                int[][] po = pAtom.stereo.polyhedralOrders;
                int j = po.length;
                while (--j >= 0) {
                    int[] orders = po[j];
                    if (orders == null || orders.length < 2) continue;
                    int pt = j > jHpt ? j - nH : j;
                    V3 ta1 = j == jHpt ? this.v.vA : (T3)bonds[pt].getOtherAtom(pAtom).getMatchingAtom();
                    float flast = isNot ? Float.MAX_VALUE : 0.0f;
                    V3 ta2 = null;
                    for (int k = 0; k < orders.length; ++k) {
                        V3 ta3;
                        pt = orders[k];
                        if (pt == jHpt) {
                            ta3 = this.v.vA;
                        } else {
                            if (pt > jHpt) {
                                --pt;
                            }
                            ta3 = (T3)bonds[pt].getOtherAtom(pAtom).getMatchingAtom();
                        }
                        if (k == 0) {
                            ta2 = ta3;
                            continue;
                        }
                        float f = Measure.computeTorsion((T3)ta3, (T3)ta1, (T3)((T3)atom0), (T3)ta2, (boolean)true);
                        if (Float.isNaN(f)) {
                            f = 180.0f;
                        }
                        if (orders.length == 2) {
                            return f < 0.0f != isNot ? 1 : -1;
                        }
                        if (f < 0.0f) {
                            f += 360.0f;
                        }
                        if (f < flast != isNot) {
                            return -1;
                        }
                        flast = f;
                    }
                }
                return 0;
            }
            case 2: {
                Node[] jn = this.getAlleneAtoms(pAtom, null);
                if (jn == null) {
                    return 0;
                }
                if (haveTopo && !this.setTopoCoordinates(sAtom0, pAtom, pAtom2, jn)) {
                    return -1;
                }
                if (!SmilesStereo.checkStereochemistryAll(isNot, (SimpleNode)atom0, chiralClass, order, (SimpleNode)jn[0], (SimpleNode)jn[1], (SimpleNode)jn[2], (SimpleNode)jn[3], null, null, this.v)) {
                    return -1;
                }
                return 0;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                atom1 = this.getJmolAtom(pAtom.getMatchingBondedAtom(0));
                switch (nH) {
                    case 0: {
                        atom2 = this.getJmolAtom(pAtom.getMatchingBondedAtom(1));
                        break;
                    }
                    case 1: {
                        atom2 = this.search.findImplicitHydrogen(pAtom.getMatchingAtom());
                        if (!pAtom.isFirst) break;
                        Node a = atom2;
                        atom2 = atom1;
                        atom1 = a;
                        break;
                    }
                    default: {
                        return 0;
                    }
                }
                atom3 = this.getJmolAtom(pAtom.getMatchingBondedAtom(2 - nH));
                atom4 = this.getJmolAtom(pAtom.getMatchingBondedAtom(3 - nH));
                atom5 = this.getJmolAtom(pAtom.getMatchingBondedAtom(4 - nH));
                atom6 = this.getJmolAtom(pAtom.getMatchingBondedAtom(5 - nH));
                if (haveTopo && !this.setTopoCoordinates(sAtom0, pAtom, null, new Node[]{atom1, atom2, atom3, atom4, atom5, atom6})) {
                    return -1;
                }
                if (!SmilesStereo.checkStereochemistryAll(isNot, (SimpleNode)atom0, chiralClass, order, (SimpleNode)atom1, (SimpleNode)atom2, (SimpleNode)atom3, (SimpleNode)atom4, (SimpleNode)atom5, (SimpleNode)atom6, this.v)) {
                    return -1;
                }
                return 0;
            }
        }
        return 0;
    }

    public Node[] getAlleneAtoms(SmilesAtom pAtom, SmilesAtom pAtom1) {
        SmilesBond b;
        int k;
        SmilesAtom pAtom2;
        if (pAtom1 == null) {
            pAtom1 = pAtom.getBond(0).getOtherAtom(pAtom);
        }
        if ((pAtom2 = pAtom.getBond(1).getOtherAtom(pAtom)) == pAtom1) {
            pAtom2 = pAtom.getBond(0).getOtherAtom(pAtom);
        }
        if (pAtom1 == null || pAtom2 == null) {
            return null;
        }
        SmilesAtom pAtom1a = pAtom;
        SmilesAtom pAtom2a = pAtom;
        while (pAtom1.getBondCount() == 2 && pAtom2.getBondCount() == 2 && pAtom1.getValence() == 4 && pAtom2.getValence() == 4) {
            SmilesBond b2 = pAtom1.getBondNotTo(pAtom1a, true);
            pAtom1a = pAtom1;
            pAtom1 = b2.getOtherAtom(pAtom1);
            b2 = pAtom2.getBondNotTo(pAtom2a, true);
            pAtom2a = pAtom2;
            pAtom2 = b2.getOtherAtom(pAtom2);
        }
        pAtom = pAtom1;
        Node[] jn = new Node[6];
        jn[4] = new SmilesAtom().setIndex(60004);
        int nBonds = pAtom.getBondCount();
        if (nBonds != 2 && nBonds != 3) {
            return null;
        }
        int p = 0;
        for (k = 0; k < nBonds; ++k) {
            b = pAtom.bonds[k];
            pAtom1 = b.getOtherAtom(pAtom);
            if (b.getMatchingBond().getCovalentOrder() == 2) {
                if (pAtom2 != null) continue;
                pAtom2 = pAtom1;
                continue;
            }
            if (b.atom1 == pAtom1) {
                p = 0;
            } else if (jn[1] == null) {
                p = 1;
            } else {
                p = 1;
                jn[0] = jn[1];
            }
            jn[p] = pAtom1.getMatchingAtom();
        }
        if (pAtom2 == null) {
            return null;
        }
        nBonds = pAtom2.getBondCount();
        if (nBonds != 2 && nBonds != 3) {
            return null;
        }
        int p2 = 0;
        for (int k2 = 0; k2 < nBonds; ++k2) {
            b = pAtom2.bonds[k2];
            pAtom1 = b.getOtherAtom(pAtom2);
            if (b.getMatchingBond().getCovalentOrder() == 2) continue;
            if (b.atom1 == pAtom1) {
                p2 = 2;
            } else if (jn[3] == null) {
                p2 = 3;
            } else {
                p2 = 3;
                jn[2] = jn[3];
            }
            jn[p2] = pAtom1.getMatchingAtom();
        }
        for (k = 0; k < 4; ++k) {
            if (jn[k] != null) continue;
            this.addAlleneLonePair(k < 2 ? pAtom : pAtom2, jn, k);
        }
        return jn;
    }

    private void addAlleneLonePair(SmilesAtom pAtom, Node[] jn, int k) {
        Node atom = pAtom.getMatchingAtom();
        jn[k] = this.search.findImplicitHydrogen(atom);
        if (jn[k] != null) {
            return;
        }
        V3 v = new V3();
        for (int i = 0; i < 4; ++i) {
            if (jn[i] == null) continue;
            v.sub((T3)((P3)jn[i]));
        }
        if (v.length() == 0.0f) {
            v.setT((T3)((P3)jn[4]));
        } else {
            v.scaleAdd2(2.0f, (T3)((P3)pAtom.getMatchingAtom()), (T3)v);
        }
        jn[k] = new SmilesAtom().setIndex(Integer.MIN_VALUE);
        ((P3)jn[k]).setT((T3)v);
    }

    static String getStereoFlag(SimpleNode atom0, SimpleNode[] atoms, int nAtoms, VTemp v) {
        SimpleNode atom1 = atoms[0];
        SimpleNode atom2 = atoms[1];
        SimpleNode atom3 = atoms[2];
        SimpleNode atom4 = atoms[3];
        SimpleNode atom5 = atoms[4];
        SimpleNode atom6 = atoms[5];
        int chiralClass = 4;
        switch (nAtoms) {
            default: {
                return SmilesStereo.checkStereochemistryAll(false, atom0, chiralClass, 1, atom1, atom2, atom3, atom4, atom5, atom6, v) ? "@" : "@@";
            }
            case 2: 
            case 4: 
        }
        if (atom3 == null || atom4 == null) {
            return "";
        }
        float d = Measure.getNormalThroughPoints((T3)((P3)atom1), (T3)((P3)atom2), (T3)((P3)atom3), (T3)v.vTemp, (T3)v.vA);
        if (Math.abs(Measure.distanceToPlaneV((V3)v.vTemp, (float)d, (P3)((P3)atom4))) < 0.2f) {
            chiralClass = 7;
            if (SmilesStereo.checkStereochemistryAll(false, atom0, chiralClass, 1, atom1, atom2, atom3, atom4, atom5, atom6, v)) {
                return "@SP1";
            }
            if (SmilesStereo.checkStereochemistryAll(false, atom0, chiralClass, 2, atom1, atom2, atom3, atom4, atom5, atom6, v)) {
                return "@SP2";
            }
            if (SmilesStereo.checkStereochemistryAll(false, atom0, chiralClass, 3, atom1, atom2, atom3, atom4, atom5, atom6, v)) {
                return "@SP3";
            }
        } else {
            return SmilesStereo.checkStereochemistryAll(false, atom0, chiralClass, 1, atom1, atom2, atom3, atom4, atom5, atom6, v) ? "@" : "@@";
        }
        return "";
    }

    private static boolean checkStereochemistryAll(boolean isNot, SimpleNode atom0, int chiralClass, int order, SimpleNode atom1, SimpleNode atom2, SimpleNode atom3, SimpleNode atom4, SimpleNode atom5, SimpleNode atom6, VTemp v) {
        switch (chiralClass) {
            default: {
                return true;
            }
            case 2: 
            case 4: {
                return isNot == (SmilesStereo.getHandedness(atom2, atom3, atom4, atom1, v) != order);
            }
            case 7: {
                SmilesStereo.getPlaneNormals((P3)atom1, (P3)atom2, (P3)atom3, (P3)atom4, v);
                return v.vNorm2.dot((T3)v.vNorm3) < 0.0f ? isNot == (order != 3) : (v.vNorm3.dot((T3)v.vNorm4) < 0.0f ? isNot == (order != 2) : isNot == (order != 1));
            }
            case 3: {
                return isNot == (SmilesStereo.getHandedness(atom1, atom2, atom3, atom0, v) != order);
            }
            case 5: {
                if (!SmilesStereo.isDiaxial(atom0, atom0, atom5, atom1, v, -0.95f)) {
                    return false;
                }
                return isNot == (SmilesStereo.getHandedness(atom2, atom3, atom4, atom1, v) != order);
            }
            case 8: {
                switch (order) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        atom3 = atom2;
                        break;
                    }
                    case 3: {
                        atom1 = atom2;
                    }
                }
                return isNot == !SmilesStereo.isDiaxial(atom0, atom0, atom1, atom3, v, -0.95f);
            }
            case 9: {
                if (!SmilesStereo.isDiaxial(atom0, atom0, atom4, atom1, v, -0.95f)) {
                    return false;
                }
                return isNot == (SmilesStereo.getHandedness(atom2, atom3, atom4, atom1, v) != order);
            }
            case 6: {
                if (!(SmilesStereo.isDiaxial(atom0, atom0, atom6, atom1, v, -0.95f) && SmilesStereo.isDiaxial(atom0, atom0, atom2, atom4, v, -0.95f) && SmilesStereo.isDiaxial(atom0, atom0, atom3, atom5, v, -0.95f))) {
                    return false;
                }
                SmilesStereo.getPlaneNormals((P3)atom2, (P3)atom3, (P3)atom4, (P3)atom5, v);
                if (v.vNorm2.dot((T3)v.vNorm3) < 0.0f || v.vNorm3.dot((T3)v.vNorm4) < 0.0f) {
                    return false;
                }
                v.vNorm3.sub2((T3)((P3)atom0), (T3)((P3)atom1));
                return isNot == ((v.vNorm2.dot((T3)v.vNorm3) < 0.0f ? 2 : 1) == order);
            }
            case 1: 
        }
        return true;
    }

    static boolean isDiaxial(SimpleNode atomA, SimpleNode atomB, SimpleNode atom1, SimpleNode atom2, VTemp v, float f) {
        v.vA.sub2((T3)((P3)atomA), (T3)((P3)atom1));
        v.vB.sub2((T3)((P3)atomB), (T3)((P3)atom2));
        v.vA.normalize();
        v.vB.normalize();
        return v.vA.dot((T3)v.vB) < f;
    }

    static int getHandedness(SimpleNode a, SimpleNode b, SimpleNode c, SimpleNode pt, VTemp v) {
        float d = Measure.getNormalThroughPoints((T3)((P3)a), (T3)((P3)b), (T3)((P3)c), (T3)v.vTemp, (T3)v.vA);
        return (d = Measure.distanceToPlaneV((V3)v.vTemp, (float)d, (P3)((P3)pt))) > 0.0f ? 1 : 2;
    }

    private static void getPlaneNormals(P3 atom1, P3 atom2, P3 atom3, P3 atom4, VTemp v) {
        Measure.getNormalThroughPoints((T3)atom1, (T3)atom2, (T3)atom3, (T3)v.vNorm2, (T3)v.vTemp1);
        Measure.getNormalThroughPoints((T3)atom2, (T3)atom3, (T3)atom4, (T3)v.vNorm3, (T3)v.vTemp1);
        Measure.getNormalThroughPoints((T3)atom3, (T3)atom4, (T3)atom1, (T3)v.vNorm4, (T3)v.vTemp1);
    }

    static int checkChirality(SmilesSearch search, String pattern, int index, SmilesAtom newAtom) throws InvalidSmilesException {
        int stereoClass = 0;
        int order = Integer.MIN_VALUE;
        int len = pattern.length();
        String details = null;
        String directives = null;
        int atomCount = 0;
        stereoClass = 0;
        order = 1;
        boolean isPoly = false;
        if (++index < len) {
            char ch = pattern.charAt(index);
            switch (ch) {
                case '@': {
                    order = 2;
                    ++index;
                    break;
                }
                case '+': 
                case '-': 
                case 'H': {
                    break;
                }
                case 'P': {
                    isPoly = true;
                }
                case 'A': 
                case 'O': 
                case 'S': 
                case 'T': {
                    stereoClass = index + 1 < len ? SmilesStereo.getChiralityClass(pattern.substring(index, index + 2)) : -1;
                    index += 2;
                    break;
                }
                default: {
                    order = PT.isDigit((char)ch) ? 1 : -1;
                }
            }
            if (order == 1 || isPoly) {
                int pt;
                for (pt = index; pt < len && PT.isDigit((char)pattern.charAt(pt)); ++pt) {
                }
                if (pt > index) {
                    try {
                        int n = Integer.parseInt(pattern.substring(index, pt));
                        if (isPoly) {
                            atomCount = n;
                            if (pt < len && pattern.charAt(pt) == '(') {
                                details = SmilesParser.getSubPattern(pattern, pt, '(');
                                pt += details.length() + 2;
                            }
                            if (pt < len && pattern.charAt(pt) == '/') {
                                directives = SmilesParser.getSubPattern(pattern, pt, '/');
                                pt += directives.length() + 2;
                            }
                        } else {
                            order = n;
                        }
                    }
                    catch (NumberFormatException e) {
                        order = -1;
                    }
                    index = pt;
                }
            }
            if (order < 1 || stereoClass < 0) {
                throw new InvalidSmilesException("Invalid stereochemistry descriptor");
            }
        }
        newAtom.stereo = new SmilesStereo(stereoClass, order, atomCount, details, directives);
        newAtom.stereo.search = search;
        if (SmilesParser.getChar(pattern, index) == '?') {
            Logger.info((String)"Ignoring '?' in stereochemistry");
            ++index;
        }
        return index;
    }

    private void getPolyhedralOrders() throws InvalidSmilesException {
        this.polyhedralOrders = AU.newInt2((int)this.atomCount);
        int[][] po = this.polyhedralOrders;
        if (this.details == null) {
            return;
        }
        int[] temp = new int[this.details.length()];
        int[] ret = new int[1];
        String msg = null;
        int pt = 0;
        String s = this.details + "/";
        int n = 0;
        int len = s.length();
        int index = 0;
        int atomPt = 0;
        do {
            char ch = s.charAt(index);
            switch (ch) {
                case '!': {
                    this.isNot = true;
                    ++index;
                    break;
                }
                case '.': 
                case '/': {
                    pt = atomPt;
                    if (pt >= this.atomCount) {
                        msg = "Too many descriptors";
                        break;
                    }
                    po[atomPt] = new int[n];
                    int[] a = po[atomPt];
                    while (--n >= 0) {
                        a[n] = temp[n];
                    }
                    n = 0;
                    if (Logger.debugging) {
                        Logger.info((String)PT.toJSON((String)("@PH" + this.atomCount + "[" + atomPt + "]"), (Object)a));
                    }
                    index = ch == '/' ? Integer.MAX_VALUE : ++index;
                    ++atomPt;
                    break;
                }
                default: {
                    index = SmilesParser.getRingNumber(s, index, ch, ret);
                    int n2 = n++;
                    int n3 = ret[0] - 1;
                    temp[n2] = n3;
                    pt = n3;
                    if (pt == atomPt) {
                        msg = "Atom cannot connect to itself";
                        break;
                    }
                    if (pt < 0 || pt >= this.atomCount) {
                        msg = "Connection number outside of range (1-" + this.atomCount + ")";
                        break;
                    }
                    if (n < this.atomCount) break;
                    msg = "Too many connections indicated";
                }
            }
            if (msg == null) continue;
            msg = msg + ": " + s.substring(0, index) + "<<";
            throw new InvalidSmilesException(msg);
        } while (index < len);
    }
}

