/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.layer.ActivateLayerAction;
import org.openstreetmap.josm.gui.dialogs.layer.DeleteLayerAction;
import org.openstreetmap.josm.gui.dialogs.layer.DuplicateAction;
import org.openstreetmap.josm.gui.dialogs.layer.LayerListTransferHandler;
import org.openstreetmap.josm.gui.dialogs.layer.LayerVisibilityAction;
import org.openstreetmap.josm.gui.dialogs.layer.MergeAction;
import org.openstreetmap.josm.gui.dialogs.layer.MoveDownAction;
import org.openstreetmap.josm.gui.dialogs.layer.MoveUpAction;
import org.openstreetmap.josm.gui.dialogs.layer.ShowHideLayerAction;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.gui.util.MultikeyActionsHandler;
import org.openstreetmap.josm.gui.util.MultikeyShortcutAction;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.gui.widgets.ScrollableTable;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Shortcut;

public class LayerListDialog
extends ToggleDialog
implements TileSourceDisplaySettings.DisplaySettingsChangeListener {
    private static volatile LayerListDialog instance;
    private final LayerListModel model;
    private final LayerList layerList;
    private final ActivateLayerAction activateLayerAction;
    private final ShowHideLayerAction showHideLayerAction;
    private final transient Shortcut[] visibilityToggleShortcuts = new Shortcut[10];
    private final ToggleLayerIndexVisibility[] visibilityToggleActions = new ToggleLayerIndexVisibility[10];
    private final transient MainLayerManager layerManager;

    public static void createInstance(MainLayerManager layerManager) {
        if (instance != null) {
            throw new IllegalStateException("Dialog was already created");
        }
        instance = new LayerListDialog(layerManager);
    }

    public static LayerListDialog getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Dialog not created yet. Invoke createInstance() first");
        }
        return instance;
    }

    private void createVisibilityToggleShortcuts() {
        for (int i = 0; i < 10; ++i) {
            int i1 = i + 1;
            this.visibilityToggleShortcuts[i] = Shortcut.registerShortcut("subwindow:layers:toggleLayer" + i1, I18n.tr("Toggle visibility of layer: {0}", i1), 48 + i1 % 10, 5004);
            this.visibilityToggleActions[i] = new ToggleLayerIndexVisibility(i);
            MainApplication.registerActionShortcut(this.visibilityToggleActions[i], this.visibilityToggleShortcuts[i]);
        }
    }

    public LayerListDialog(MainLayerManager layerManager) {
        super(I18n.tr("Layers", new Object[0]), "layerlist", I18n.tr("Open a list of all loaded layers.", new Object[0]), Shortcut.registerShortcut("subwindow:layers", I18n.tr("Toggle: {0}", I18n.tr("Layers", new Object[0])), 76, 5007), 100, true);
        this.layerManager = layerManager;
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        selectionModel.setSelectionMode(2);
        this.model = new LayerListModel(layerManager, selectionModel);
        this.layerList = new LayerList(this.model);
        this.layerList.setSelectionModel(selectionModel);
        this.layerList.addMouseListener(new PopupMenuHandler());
        this.layerList.setBackground(UIManager.getColor("Button.background"));
        this.layerList.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.layerList.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.layerList.setSelectionMode(2);
        this.layerList.setTableHeader(null);
        this.layerList.setShowGrid(false);
        this.layerList.setIntercellSpacing(new Dimension(0, 0));
        this.layerList.getColumnModel().getColumn(0).setCellRenderer(new ActiveLayerCellRenderer());
        this.layerList.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new ActiveLayerCheckBox()));
        this.layerList.getColumnModel().getColumn(0).setMaxWidth(12);
        this.layerList.getColumnModel().getColumn(0).setPreferredWidth(12);
        this.layerList.getColumnModel().getColumn(0).setResizable(false);
        this.layerList.getColumnModel().getColumn(1).setCellRenderer(new NativeScaleLayerCellRenderer());
        this.layerList.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(new NativeScaleLayerCheckBox()));
        this.layerList.getColumnModel().getColumn(1).setMaxWidth(12);
        this.layerList.getColumnModel().getColumn(1).setPreferredWidth(12);
        this.layerList.getColumnModel().getColumn(1).setResizable(false);
        this.layerList.getColumnModel().getColumn(2).setCellRenderer(new OffsetLayerCellRenderer());
        this.layerList.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(new OffsetLayerCheckBox()));
        this.layerList.getColumnModel().getColumn(2).setMaxWidth(16);
        this.layerList.getColumnModel().getColumn(2).setPreferredWidth(16);
        this.layerList.getColumnModel().getColumn(2).setResizable(false);
        this.layerList.getColumnModel().getColumn(3).setCellRenderer(new LayerVisibleCellRenderer());
        this.layerList.getColumnModel().getColumn(3).setCellEditor(new LayerVisibleCellEditor(new LayerVisibleCheckBox()));
        this.layerList.getColumnModel().getColumn(3).setMaxWidth(16);
        this.layerList.getColumnModel().getColumn(3).setPreferredWidth(16);
        this.layerList.getColumnModel().getColumn(3).setResizable(false);
        this.layerList.getColumnModel().getColumn(4).setCellRenderer(new LayerNameCellRenderer());
        this.layerList.getColumnModel().getColumn(4).setCellEditor(new LayerNameCellEditor(new DisableShortcutsOnFocusGainedTextField()));
        for (KeyStroke ks : new KeyStroke[]{KeyStroke.getKeyStroke(67, Main.platform.getMenuShortcutKeyMaskEx()), KeyStroke.getKeyStroke(86, Main.platform.getMenuShortcutKeyMaskEx()), KeyStroke.getKeyStroke(40, 64), KeyStroke.getKeyStroke(38, 64), KeyStroke.getKeyStroke(37, 64), KeyStroke.getKeyStroke(39, 64), KeyStroke.getKeyStroke(40, 128), KeyStroke.getKeyStroke(38, 128), KeyStroke.getKeyStroke(37, 128), KeyStroke.getKeyStroke(39, 128), KeyStroke.getKeyStroke(33, 0), KeyStroke.getKeyStroke(34, 0), KeyStroke.getKeyStroke(9, 0), KeyStroke.getKeyStroke(119, 0)}) {
            this.layerList.getInputMap(1).put(ks, new Object());
        }
        this.model.populate();
        this.model.setSelectedLayer(layerManager.getActiveLayer());
        this.model.addLayerListModelListener(new LayerListModelListener(){

            @Override
            public void makeVisible(int row, Layer layer) {
                LayerListDialog.this.layerList.scrollToVisible(row, 0);
                LayerListDialog.this.layerList.repaint();
            }

            @Override
            public void refresh() {
                LayerListDialog.this.layerList.repaint();
            }
        });
        MoveUpAction moveUpAction = new MoveUpAction(this.model);
        this.adaptTo((IEnabledStateUpdating)moveUpAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveUpAction, selectionModel);
        MoveDownAction moveDownAction = new MoveDownAction(this.model);
        this.adaptTo((IEnabledStateUpdating)moveDownAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveDownAction, selectionModel);
        this.activateLayerAction = new ActivateLayerAction(this.model);
        this.activateLayerAction.updateEnabledState();
        MultikeyActionsHandler.getInstance().addAction(this.activateLayerAction);
        this.adaptTo((IEnabledStateUpdating)this.activateLayerAction, selectionModel);
        JumpToMarkerActions.initialize();
        this.showHideLayerAction = new ShowHideLayerAction(this.model);
        MultikeyActionsHandler.getInstance().addAction(this.showHideLayerAction);
        this.adaptTo((IEnabledStateUpdating)this.showHideLayerAction, selectionModel);
        LayerVisibilityAction visibilityAction = new LayerVisibilityAction(this.model);
        this.adaptTo((IEnabledStateUpdating)visibilityAction, selectionModel);
        SideButton visibilityButton = new SideButton((Action)visibilityAction, false);
        visibilityAction.setCorrespondingSideButton(visibilityButton);
        DeleteLayerAction deleteLayerAction = new DeleteLayerAction(this.model);
        this.layerList.getActionMap().put("deleteLayer", deleteLayerAction);
        this.adaptTo((IEnabledStateUpdating)deleteLayerAction, selectionModel);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", deleteLayerAction);
        InputMapUtils.addEnterAction(this.layerList, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerListDialog.this.activateLayerAction.actionPerformed(null);
                LayerListDialog.this.layerList.requestFocus();
            }
        });
        InputMapUtils.addSpacebarAction(this.layerList, this.showHideLayerAction);
        this.createLayout(this.layerList, true, Arrays.asList(new SideButton((Action)moveUpAction, false), new SideButton((Action)moveDownAction, false), new SideButton((Action)this.activateLayerAction, false), visibilityButton, new SideButton((Action)deleteLayerAction, false)));
        this.createVisibilityToggleShortcuts();
    }

    public MainLayerManager getLayerManager() {
        return this.layerManager;
    }

    @Override
    public void showNotify() {
        this.layerManager.addActiveLayerChangeListener(this.activateLayerAction);
        this.layerManager.addAndFireLayerChangeListener(this.model);
        this.layerManager.addAndFireActiveLayerChangeListener(this.model);
        this.model.populate();
    }

    @Override
    public void hideNotify() {
        this.layerManager.removeAndFireLayerChangeListener(this.model);
        this.layerManager.removeActiveLayerChangeListener(this.model);
        this.layerManager.removeActiveLayerChangeListener(this.activateLayerAction);
    }

    public LayerListModel getModel() {
        return this.model;
    }

    protected void adaptTo(IEnabledStateUpdating listener, ListSelectionModel listSelectionModel) {
        listSelectionModel.addListSelectionListener(e -> listener.updateEnabledState());
    }

    protected void adaptTo(IEnabledStateUpdating listener, LayerListModel listModel) {
        listModel.addTableModelListener(e -> listener.updateEnabledState());
    }

    @Override
    public void destroy() {
        for (int i = 0; i < 10; ++i) {
            MainApplication.unregisterActionShortcut(this.visibilityToggleActions[i], this.visibilityToggleShortcuts[i]);
        }
        MultikeyActionsHandler.getInstance().removeAction(this.activateLayerAction);
        MultikeyActionsHandler.getInstance().removeAction(this.showHideLayerAction);
        JumpToMarkerActions.unregisterActions();
        super.destroy();
        instance = null;
    }

    public ShowHideLayerAction createShowHideLayerAction() {
        return new ShowHideLayerAction(this.model);
    }

    public DeleteLayerAction createDeleteLayerAction() {
        return new DeleteLayerAction(this.model);
    }

    public ActivateLayerAction createActivateLayerAction(Layer layer) {
        return new ActivateLayerAction(layer, this.model);
    }

    public MergeAction createMergeLayerAction(Layer layer) {
        return new MergeAction(layer, this.model);
    }

    public DuplicateAction createDuplicateLayerAction(Layer layer) {
        return new DuplicateAction(layer, this.model);
    }

    public static Layer getLayerForIndex(int index) {
        List<Layer> layers = MainApplication.getLayerManager().getLayers();
        if (index < layers.size() && index >= 0) {
            return layers.get(index);
        }
        return null;
    }

    public static List<MultikeyShortcutAction.MultikeyInfo> getLayerInfoByClass(Class<?> layerClass) {
        ArrayList<MultikeyShortcutAction.MultikeyInfo> result = new ArrayList<MultikeyShortcutAction.MultikeyInfo>();
        List<Layer> layers = MainApplication.getLayerManager().getLayers();
        int index = 0;
        for (Layer l : layers) {
            if (layerClass.isAssignableFrom(l.getClass())) {
                result.add(new MultikeyShortcutAction.MultikeyInfo(index, l.getName()));
            }
            ++index;
        }
        return result;
    }

    public static boolean isLayerValid(Layer l) {
        if (l == null) {
            return false;
        }
        return MainApplication.getLayerManager().containsLayer(l);
    }

    public static MultikeyShortcutAction.MultikeyInfo getLayerInfo(Layer l) {
        if (l == null) {
            return null;
        }
        int index = MainApplication.getLayerManager().getLayers().indexOf(l);
        if (index < 0) {
            return null;
        }
        return new MultikeyShortcutAction.MultikeyInfo(index, l.getName());
    }

    @Override
    public void displaySettingsChanged(TileSourceDisplaySettings.DisplaySettingsChangeEvent e) {
        if ("displacement".equals(e.getChangedSetting())) {
            this.layerList.repaint();
        }
    }

    static class LayerList
    extends ScrollableTable {
        LayerList(LayerListModel dataModel) {
            super(dataModel);
            dataModel.setLayerList(this);
            if (!GraphicsEnvironment.isHeadless()) {
                this.setDragEnabled(true);
            }
            this.setDropMode(DropMode.INSERT_ROWS);
            this.setTransferHandler(new LayerListTransferHandler());
        }

        @Override
        public LayerListModel getModel() {
            return (LayerListModel)super.getModel();
        }
    }

    public static final class LayerListModel
    extends AbstractTableModel
    implements LayerManager.LayerChangeListener,
    MainLayerManager.ActiveLayerChangeListener,
    PropertyChangeListener {
        private final DefaultListSelectionModel selectionModel;
        private final CopyOnWriteArrayList<LayerListModelListener> listeners;
        private LayerList layerList;
        private final MainLayerManager layerManager;

        LayerListModel(MainLayerManager layerManager, DefaultListSelectionModel selectionModel) {
            this.layerManager = layerManager;
            this.selectionModel = selectionModel;
            this.listeners = new CopyOnWriteArrayList();
        }

        void setLayerList(LayerList layerList) {
            this.layerList = layerList;
        }

        public MainLayerManager getLayerManager() {
            return this.layerManager;
        }

        public void addLayerListModelListener(LayerListModelListener listener) {
            if (listener != null) {
                this.listeners.addIfAbsent(listener);
            }
        }

        public void removeLayerListModelListener(LayerListModelListener listener) {
            this.listeners.remove(listener);
        }

        private void fireMakeVisible(int index, Layer layer) {
            for (LayerListModelListener listener : this.listeners) {
                listener.makeVisible(index, layer);
            }
        }

        private void fireRefresh() {
            for (LayerListModelListener listener : this.listeners) {
                listener.refresh();
            }
        }

        public void populate() {
            for (Layer layer : this.getLayers()) {
                layer.removePropertyChangeListener(this);
                layer.addPropertyChangeListener(this);
            }
            this.fireTableDataChanged();
        }

        public void setSelectedLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            int idx = this.getLayers().indexOf(layer);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
            this.ensureSelectedIsVisible();
        }

        public List<Layer> getSelectedLayers() {
            ArrayList<Layer> selected = new ArrayList<Layer>();
            List<Layer> layers = this.getLayers();
            for (int i = 0; i < layers.size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                selected.add(layers.get(i));
            }
            return selected;
        }

        public List<Integer> getSelectedRows() {
            ArrayList<Integer> selected = new ArrayList<Integer>();
            for (int i = 0; i < this.getLayers().size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                selected.add(i);
            }
            return selected;
        }

        private void onRemoveLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.removePropertyChangeListener(this);
            int size = this.getRowCount();
            List<Integer> rows = this.getSelectedRows();
            if (rows.isEmpty() && size > 0) {
                this.selectionModel.setSelectionInterval(size - 1, size - 1);
            }
            this.fireTableDataChanged();
            this.fireRefresh();
            this.ensureActiveSelected();
        }

        private void onAddLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.addPropertyChangeListener(this);
            this.fireTableDataChanged();
            int idx = this.getLayers().indexOf(layer);
            if (this.layerList != null) {
                this.layerList.setRowHeight(idx, Math.max(16, layer.getIcon().getIconHeight()));
            }
            this.selectionModel.setSelectionInterval(idx, idx);
            this.ensureSelectedIsVisible();
            if (layer instanceof AbstractTileSourceLayer) {
                ((AbstractTileSourceLayer)layer).getDisplaySettings().addSettingsChangeListener(LayerListDialog.getInstance());
            }
        }

        public Layer getFirstLayer() {
            if (this.getRowCount() == 0) {
                return null;
            }
            return this.getLayers().get(0);
        }

        public Layer getLayer(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return this.getLayers().get(index);
        }

        public boolean canMoveUp() {
            List<Integer> sel = this.getSelectedRows();
            return !sel.isEmpty() && sel.get(0) > 0;
        }

        public void moveUp() {
            if (!this.canMoveUp()) {
                return;
            }
            List<Integer> sel = this.getSelectedRows();
            List<Layer> layers = this.getLayers();
            MapView mapView = MainApplication.getMap().mapView;
            for (int row : sel) {
                Layer l1 = layers.get(row);
                mapView.moveLayer(l1, row - 1);
            }
            this.fireTableDataChanged();
            this.selectionModel.setValueIsAdjusting(true);
            this.selectionModel.clearSelection();
            for (int row : sel) {
                this.selectionModel.addSelectionInterval(row - 1, row - 1);
            }
            this.selectionModel.setValueIsAdjusting(false);
            this.ensureSelectedIsVisible();
        }

        public boolean canMoveDown() {
            List<Integer> sel = this.getSelectedRows();
            return !sel.isEmpty() && sel.get(sel.size() - 1) < this.getLayers().size() - 1;
        }

        public void moveDown() {
            if (!this.canMoveDown()) {
                return;
            }
            List<Integer> sel = this.getSelectedRows();
            Collections.reverse(sel);
            List<Layer> layers = this.getLayers();
            MapView mapView = MainApplication.getMap().mapView;
            for (int row : sel) {
                Layer l1 = layers.get(row);
                mapView.moveLayer(l1, row + 1);
            }
            this.fireTableDataChanged();
            this.selectionModel.setValueIsAdjusting(true);
            this.selectionModel.clearSelection();
            for (int row : sel) {
                this.selectionModel.addSelectionInterval(row + 1, row + 1);
            }
            this.selectionModel.setValueIsAdjusting(false);
            this.ensureSelectedIsVisible();
        }

        private void ensureSelectedIsVisible() {
            int index = this.selectionModel.getMinSelectionIndex();
            if (index < 0) {
                return;
            }
            List<Layer> layers = this.getLayers();
            if (index >= layers.size()) {
                return;
            }
            Layer layer = layers.get(index);
            this.fireMakeVisible(index, layer);
        }

        public List<Layer> getPossibleMergeTargets(Layer source) {
            ArrayList<Layer> targets = new ArrayList<Layer>();
            if (source == null) {
                return targets;
            }
            for (Layer target : this.getLayers()) {
                if (source == target || !target.isMergable(source) || !source.isMergable(target)) continue;
                targets.add(target);
            }
            return targets;
        }

        public List<Layer> getLayers() {
            return this.getLayerManager().getLayers();
        }

        private void ensureActiveSelected() {
            List<Layer> layers = this.getLayers();
            if (layers.isEmpty()) {
                return;
            }
            Layer activeLayer = this.getActiveLayer();
            if (activeLayer != null) {
                int idx = layers.indexOf(activeLayer);
                this.selectionModel.setSelectionInterval(idx, idx);
                this.ensureSelectedIsVisible();
            } else {
                this.selectionModel.setSelectionInterval(0, 0);
                this.ensureSelectedIsVisible();
            }
        }

        private Layer getActiveLayer() {
            return this.getLayerManager().getActiveLayer();
        }

        @Override
        public int getRowCount() {
            List<Layer> layers = this.getLayers();
            return layers == null ? 0 : layers.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Object getValueAt(int row, int col) {
            List<Layer> layers = this.getLayers();
            if (row >= 0 && row < layers.size()) {
                switch (col) {
                    case 0: {
                        return layers.get(row) == this.getActiveLayer();
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return layers.get(row);
                    }
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0 || this.getActiveLayer() != this.getLayers().get(row);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            List<Layer> layers = this.getLayers();
            if (row < layers.size()) {
                Layer l = layers.get(row);
                switch (col) {
                    case 0: {
                        this.getLayerManager().setActiveLayer(l);
                        l.setVisible(true);
                        break;
                    }
                    case 1: {
                        int idx;
                        MapFrame map = MainApplication.getMap();
                        NativeScaleLayer oldLayer = map.mapView.getNativeScaleLayer();
                        if (oldLayer == l) {
                            map.mapView.setNativeScaleLayer(null);
                            break;
                        }
                        if (!(l instanceof NativeScaleLayer)) break;
                        map.mapView.setNativeScaleLayer((NativeScaleLayer)((Object)l));
                        if (!(oldLayer instanceof Layer) || (idx = this.getLayers().indexOf((Layer)((Object)oldLayer))) < 0) break;
                        this.fireTableCellUpdated(idx, col);
                        break;
                    }
                    case 2: {
                        AbstractTileSourceLayer abstractTileSourceLayer;
                        OffsetBookmark offsetBookmark;
                        if (!(l instanceof AbstractTileSourceLayer) || (offsetBookmark = (abstractTileSourceLayer = (AbstractTileSourceLayer)l).getDisplaySettings().getOffsetBookmark()) == null) break;
                        offsetBookmark.setDisplacement(EastNorth.ZERO);
                        abstractTileSourceLayer.getDisplaySettings().setOffsetBookmark(offsetBookmark);
                        break;
                    }
                    case 3: {
                        l.setVisible((Boolean)value);
                        break;
                    }
                    case 4: {
                        l.rename((String)value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong column: " + col);
                    }
                }
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
            int idx;
            Layer newLayer;
            int idx2;
            Layer oldLayer = e.getPreviousActiveLayer();
            if (oldLayer != null && (idx2 = this.getLayers().indexOf(oldLayer)) >= 0) {
                this.fireTableRowsUpdated(idx2, idx2);
            }
            if ((newLayer = this.getActiveLayer()) != null && (idx = this.getLayers().indexOf(newLayer)) >= 0) {
                this.fireTableRowsUpdated(idx, idx);
            }
            this.ensureActiveSelected();
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent e) {
            this.onAddLayer(e.getAddedLayer());
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent e) {
            this.onRemoveLayer(e.getRemovedLayer());
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
            this.fireTableDataChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof Layer) {
                Layer layer = (Layer)evt.getSource();
                int idx = this.getLayers().indexOf(layer);
                if (idx < 0) {
                    return;
                }
                this.fireRefresh();
            }
        }
    }

    public static interface LayerListModelListener {
        public void makeVisible(int var1, Layer var2);

        public void refresh();
    }

    class PopupMenuHandler
    extends PopupMenuLauncher {
        PopupMenuHandler() {
        }

        @Override
        public void showMenu(MouseEvent evt) {
            this.menu = new LayerListPopup(LayerListDialog.this.getModel().getSelectedLayers());
            super.showMenu(evt);
        }
    }

    private static class LayerNameCellEditor
    extends DefaultCellEditor {
        LayerNameCellEditor(DisableShortcutsOnFocusGainedTextField tf) {
            super(tf);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JosmTextField tf = (JosmTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            tf.setText(value == null ? "" : ((Layer)value).getName());
            return tf;
        }
    }

    private class LayerNameCellRenderer
    extends DefaultTableCellRenderer {
        private LayerNameCellRenderer() {
        }

        protected boolean isActiveLayer(Layer layer) {
            return LayerListDialog.this.getLayerManager().getActiveLayer() == layer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            Layer layer = (Layer)value;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, layer.getName(), isSelected, hasFocus, row, column);
            if (this.isActiveLayer(layer)) {
                label.setFont(label.getFont().deriveFont(1));
            }
            if (Config.getPref().getBoolean("dialog.layer.colorname", true)) {
                Color c;
                AbstractProperty<Color> prop = layer.getColorProperty();
                Color color = c = prop == null ? null : prop.get();
                if (c == null || !LayerListDialog.this.model.getLayers().stream().map(Layer::getColorProperty).filter(Objects::nonNull).map(AbstractProperty::get).anyMatch(oc -> oc != null && !oc.equals(c))) {
                    label.setForeground(UIManager.getColor(isSelected ? "Table.selectionForeground" : "Table.foreground"));
                } else {
                    label.setForeground(c);
                }
            }
            label.setIcon(layer.getIcon());
            label.setToolTipText(layer.getToolTipText());
            return label;
        }
    }

    private static class OffsetLayerCellRenderer
    implements TableCellRenderer {
        private final JCheckBox cb = new OffsetLayerCheckBox();

        OffsetLayerCellRenderer() {
            this.cb.setEnabled(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Layer layer = (Layer)value;
            if (layer instanceof AbstractTileSourceLayer) {
                if (EastNorth.ZERO.equals(((AbstractTileSourceLayer)layer).getDisplaySettings().getDisplacement())) {
                    this.cb.setSelected(false);
                    this.cb.setEnabled(false);
                    this.cb.setToolTipText(I18n.tr("layer is without a user-defined offset", new Object[0]));
                } else {
                    this.cb.setSelected(true);
                    this.cb.setEnabled(true);
                    this.cb.setToolTipText(I18n.tr("layer has a user-defined offset (click to remove offset)", new Object[0]));
                }
            } else {
                this.cb.setSelected(false);
                this.cb.setEnabled(false);
                this.cb.setToolTipText(I18n.tr("this layer can not have an offset", new Object[0]));
            }
            return this.cb;
        }
    }

    private static class NativeScaleLayerCellRenderer
    implements TableCellRenderer {
        private final JCheckBox cb = new NativeScaleLayerCheckBox();

        NativeScaleLayerCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Layer layer = (Layer)value;
            if (layer instanceof NativeScaleLayer) {
                boolean active = (NativeScaleLayer)((Object)layer) == MainApplication.getMap().mapView.getNativeScaleLayer();
                this.cb.setSelected(active);
                this.cb.setToolTipText(active ? I18n.tr("scale follows native resolution of this layer", new Object[0]) : I18n.tr("scale follows native resolution of another layer (click to set this layer)", new Object[0]));
            } else {
                this.cb.setSelected(false);
                this.cb.setToolTipText(I18n.tr("this layer has no native resolution", new Object[0]));
            }
            return this.cb;
        }
    }

    private static class LayerVisibleCellEditor
    extends DefaultCellEditor {
        private final LayerVisibleCheckBox cb;

        LayerVisibleCellEditor(LayerVisibleCheckBox cb) {
            super(cb);
            this.cb = cb;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cb.updateStatus((Layer)value);
            return this.cb;
        }
    }

    private static class LayerVisibleCellRenderer
    implements TableCellRenderer {
        private final LayerVisibleCheckBox cb = new LayerVisibleCheckBox();

        LayerVisibleCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.cb.updateStatus((Layer)value);
            }
            return this.cb;
        }
    }

    private static class ActiveLayerCellRenderer
    implements TableCellRenderer {
        private final JCheckBox cb = new ActiveLayerCheckBox();

        ActiveLayerCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean active = value != null && (Boolean)value != false;
            this.cb.setSelected(active);
            this.cb.setToolTipText(active ? I18n.tr("this layer is the active layer", new Object[0]) : I18n.tr("this layer is not currently active (click to activate)", new Object[0]));
            return this.cb;
        }
    }

    private static class OffsetLayerCheckBox
    extends JCheckBox {
        OffsetLayerCheckBox() {
            this.setHorizontalAlignment(0);
            ImageIcon blank = ImageProvider.get("dialogs/layerlist", "blank");
            ImageIcon withOffset = ImageProvider.get("dialogs/layerlist", "offset");
            this.setIcon(blank);
            this.setSelectedIcon(withOffset);
        }
    }

    private static class NativeScaleLayerCheckBox
    extends JCheckBox {
        NativeScaleLayerCheckBox() {
            this.setHorizontalAlignment(0);
            ImageIcon blank = ImageProvider.get("dialogs/layerlist", "blank");
            ImageIcon active = ImageProvider.get("dialogs/layerlist", "scale");
            this.setIcon(blank);
            this.setSelectedIcon(active);
        }
    }

    private static class LayerVisibleCheckBox
    extends JCheckBox {
        private final ImageIcon iconEye;
        private final ImageIcon iconEyeTranslucent;
        private boolean isTranslucent;

        LayerVisibleCheckBox() {
            this.setHorizontalAlignment(4);
            this.iconEye = ImageProvider.get("dialogs/layerlist", "eye");
            this.iconEyeTranslucent = ImageProvider.get("dialogs/layerlist", "eye-translucent");
            this.setIcon(ImageProvider.get("dialogs/layerlist", "eye-off"));
            this.setPressedIcon(ImageProvider.get("dialogs/layerlist", "eye-pressed"));
            this.setSelectedIcon(this.iconEye);
            this.isTranslucent = false;
        }

        public void setTranslucent(boolean isTranslucent) {
            if (this.isTranslucent == isTranslucent) {
                return;
            }
            if (isTranslucent) {
                this.setSelectedIcon(this.iconEyeTranslucent);
            } else {
                this.setSelectedIcon(this.iconEye);
            }
            this.isTranslucent = isTranslucent;
        }

        public void updateStatus(Layer layer) {
            boolean visible = layer.isVisible();
            this.setSelected(visible);
            this.setTranslucent(layer.getOpacity() < 1.0);
            this.setToolTipText(visible ? I18n.tr("layer is currently visible (click to hide layer)", new Object[0]) : I18n.tr("layer is currently hidden (click to show layer)", new Object[0]));
        }
    }

    private static class ActiveLayerCheckBox
    extends JCheckBox {
        ActiveLayerCheckBox() {
            this.setHorizontalAlignment(0);
            ImageIcon blank = ImageProvider.get("dialogs/layerlist", "blank");
            ImageIcon active = ImageProvider.get("dialogs/layerlist", "active");
            this.setIcon(blank);
            this.setSelectedIcon(active);
            this.setRolloverIcon(blank);
            this.setRolloverSelectedIcon(active);
            this.setPressedIcon(ImageProvider.get("dialogs/layerlist", "active-pressed"));
        }
    }

    private final class ToggleLayerIndexVisibility
    extends AbstractAction {
        private final int layerIndex;

        ToggleLayerIndexVisibility(int layerIndex) {
            this.layerIndex = layerIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer l = LayerListDialog.this.model.getLayer(LayerListDialog.this.model.getRowCount() - this.layerIndex - 1);
            if (l != null) {
                l.toggleVisible();
            }
        }
    }
}

