/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.metadata;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.analyzer.ModuleContent;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.common.CommonAnalyzerFacade;
import org.jetbrains.kotlin.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.metadata.MetadataSerializer;
import org.jetbrains.kotlin.cli.metadata.MetadataSerializerExtension;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPackageFragment;
import org.jetbrains.kotlin.serialization.jvm.JvmModuleProtoBuf;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J.\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u000e\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\n\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/MetadataSerializer;", "", "dependOnOldBuiltIns", "", "(Z)V", "totalFiles", "", "getTotalFiles", "()I", "setTotalFiles", "(I)V", "totalSize", "getTotalSize", "setTotalSize", "createSerializerExtension", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "getClassFilePath", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackageFilePath", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "fileName", "performSerialization", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "destDir", "Ljava/io/File;", "serialize", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "PackageSerializer", "cli"})
public class MetadataSerializer {
    private int totalSize;
    private int totalFiles;
    private final boolean dependOnOldBuiltIns;

    protected final int getTotalSize() {
        return this.totalSize;
    }

    protected final void setTotalSize(int n) {
        this.totalSize = n;
    }

    protected final int getTotalFiles() {
        return this.totalFiles;
    }

    protected final void setTotalFiles(int n) {
        this.totalFiles = n;
    }

    /*
     * WARNING - void declaration
     */
    public final void serialize(@NotNull KotlinCoreEnvironment environment2) {
        void bindingContext;
        Intrinsics.checkParameterIsNotNull((Object)environment2, (String)"environment");
        CompilerConfiguration configuration = environment2.getConfiguration();
        MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        List<KtFile> files2 = environment2.getSourceFiles();
        Name moduleName = Name.special('<' + configuration.getNotNull(CommonConfigurationKeys.MODULE_NAME) + '>');
        File file2 = configuration.get(CLIConfigurationKeys.METADATA_DESTINATION_DIRECTORY);
        if (file2 == null) {
            MetadataSerializer metadataSerializer;
            MetadataSerializer $receiver = metadataSerializer = this;
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Specify destination via -d", null, 4, null);
            return;
        }
        File destDir = file2;
        MessageCollector messageCollector3 = messageCollector2;
        Intrinsics.checkExpressionValueIsNotNull((Object)messageCollector3, (String)"messageCollector");
        AnalyzerWithCompilerReport analyzer2 = new AnalyzerWithCompilerReport(messageCollector3, CommonConfigurationKeysKt.getLanguageVersionSettings(configuration));
        analyzer2.analyzeAndReport((Collection<? extends KtFile>)files2, (Function0<? extends AnalysisResult>)((Function0)new Function0<AnalysisResult>(this, files2, moduleName, configuration, environment2){
            final /* synthetic */ MetadataSerializer this$0;
            final /* synthetic */ List $files;
            final /* synthetic */ Name $moduleName;
            final /* synthetic */ CompilerConfiguration $configuration;
            final /* synthetic */ KotlinCoreEnvironment $environment;

            @NotNull
            public final AnalysisResult invoke() {
                Collection collection = this.$files;
                Name name = this.$moduleName;
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"moduleName");
                return CommonAnalyzerFacade.analyzeFiles$default(CommonAnalyzerFacade.INSTANCE, collection, name, MetadataSerializer.access$getDependOnOldBuiltIns$p(this.this$0), CommonConfigurationKeysKt.getLanguageVersionSettings(this.$configuration), null, (Function2)new Function2<ModuleInfo, ModuleContent, JvmPackagePartProvider>(this){
                    final /* synthetic */ serialize.1 this$0;

                    @NotNull
                    public final JvmPackagePartProvider invoke(@NotNull ModuleInfo $noName_0, @NotNull ModuleContent content) {
                        Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
                        return this.this$0.$environment.createPackagePartProvider(content.getModuleContentScope());
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                }, 16, null);
            }
            {
                this.this$0 = metadataSerializer;
                this.$files = list2;
                this.$moduleName = name;
                this.$configuration = compilerConfiguration;
                this.$environment = kotlinCoreEnvironment;
                super(0);
            }
        }));
        if (analyzer2.hasErrors()) {
            return;
        }
        AnalysisResult analysisResult2 = analyzer2.getAnalysisResult();
        BindingContext $receiver = analysisResult2.component1();
        ModuleDescriptor moduleDescriptor = analysisResult2.component2();
        Collection collection = files2;
        File file3 = destDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"destDir");
        this.performSerialization(collection, (BindingContext)bindingContext, moduleDescriptor, file3);
    }

    protected void performSerialization(@NotNull Collection<? extends KtFile> files2, @NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2, @NotNull File destDir) {
        JvmModuleProtoBuf.Module.Builder builder;
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)destDir, (String)"destDir");
        HashMap packageTable = new HashMap();
        for (KtFile ktFile : files2) {
            Object object;
            FqName packageFqName = ktFile.getPackageFqName();
            ArrayList members = new ArrayList();
            for (KtDeclaration ktDeclaration : ktFile.getDeclarations()) {
                ktDeclaration.accept(new KtVisitorVoid(this, members, bindingContext, destDir, packageFqName){
                    final /* synthetic */ MetadataSerializer this$0;
                    final /* synthetic */ ArrayList $members;
                    final /* synthetic */ BindingContext $bindingContext;
                    final /* synthetic */ File $destDir;
                    final /* synthetic */ FqName $packageFqName;

                    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                        ArrayList arrayList = this.$members;
                        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.$bindingContext.get(BindingContext.FUNCTION, function2);
                        if (simpleFunctionDescriptor == null) {
                            String string = "No descriptor found for function " + function2.getFqName();
                            ArrayList arrayList2 = arrayList;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        arrayList.add((DeclarationDescriptor)simpleFunctionDescriptor);
                    }

                    public void visitProperty(@NotNull KtProperty property) {
                        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                        ArrayList arrayList = this.$members;
                        VariableDescriptor variableDescriptor = (VariableDescriptor)this.$bindingContext.get(BindingContext.VARIABLE, property);
                        if (variableDescriptor == null) {
                            String string = "No descriptor found for property " + property.getFqName();
                            ArrayList arrayList2 = arrayList;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        arrayList.add((DeclarationDescriptor)variableDescriptor);
                    }

                    public void visitTypeAlias(@NotNull KtTypeAlias typeAlias) {
                        Intrinsics.checkParameterIsNotNull((Object)typeAlias, (String)"typeAlias");
                        ArrayList arrayList = this.$members;
                        TypeAliasDescriptor typeAliasDescriptor = (TypeAliasDescriptor)this.$bindingContext.get(BindingContext.TYPE_ALIAS, typeAlias);
                        if (typeAliasDescriptor == null) {
                            String string = "No descriptor found for type alias " + typeAlias.getFqName();
                            ArrayList arrayList2 = arrayList;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        arrayList.add((DeclarationDescriptor)typeAliasDescriptor);
                    }

                    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
                        ClassDescriptor classDescriptor;
                        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
                        ClassDescriptor classDescriptor2 = (ClassDescriptor)this.$bindingContext.get(BindingContext.CLASS, classOrObject);
                        if (classDescriptor2 == null) {
                            String string = "No descriptor found for class " + classOrObject.getFqName();
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        ClassDescriptor classDescriptor3 = classDescriptor = classDescriptor2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor3, (String)"classDescriptor");
                        File destFile = new File(this.$destDir, MetadataSerializer.access$getClassFilePath(this.this$0, new ClassId(this.$packageFqName, classDescriptor3.getName())));
                        this.this$0.new PackageSerializer(CollectionsKt.listOf((Object)classDescriptor), CollectionsKt.emptyList(), this.$packageFqName, destFile).run();
                    }
                    {
                        this.this$0 = $outer;
                        this.$members = $captured_local_variable$1;
                        this.$bindingContext = $captured_local_variable$2;
                        this.$destDir = $captured_local_variable$3;
                        this.$packageFqName = $captured_local_variable$4;
                    }
                });
            }
            Collection collection = members;
            if (!(!collection.isEmpty())) continue;
            String string = ktFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            File file2 = new File(destDir, this.getPackageFilePath(packageFqName, string));
            new PackageSerializer(CollectionsKt.emptyList(), members, packageFqName, file2).run();
            Map $receiver$iv = packageTable;
            Object value$iv = $receiver$iv.get(packageFqName);
            if (value$iv == null) {
                String string2 = packageFqName.asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"packageFqName.asString()");
                PackageParts answer$iv = new PackageParts(string2);
                $receiver$iv.put(packageFqName, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((PackageParts)object).addMetadataPart(FilesKt.getNameWithoutExtension((File)file2));
        }
        File file3 = new File(destDir, JvmCodegenUtil.getMappingFileName(JvmCodegenUtil.getModuleName(module2)));
        JvmModuleProtoBuf.Module.Builder $receiver = builder = JvmModuleProtoBuf.Module.newBuilder();
        for (PackageParts table : packageTable.values()) {
            JvmModuleProtoBuf.Module.Builder builder2 = $receiver;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"this");
            table.addTo(builder2);
        }
        JvmModuleProtoBuf.Module module3 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"JvmModuleProtoBuf.Module\u2026      }\n        }.build()");
        byte[] packageTableBytes = ClassFileUtilsKt.serializeToByteArray(module3);
        file3.getParentFile().mkdirs();
        FilesKt.writeBytes((File)file3, (byte[])packageTableBytes);
    }

    @NotNull
    protected KotlinSerializerExtensionBase createSerializerExtension() {
        return new MetadataSerializerExtension();
    }

    private final String getPackageFilePath(FqName packageFqName, String fileName) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = packageFqName.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageFqName.asString()");
        return stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append("/").append(PackagePartClassUtils.getFilePartShortName(fileName)).append(MetadataPackageFragment.Companion.getDOT_METADATA_FILE_EXTENSION()).toString();
    }

    private final String getClassFilePath(ClassId classId) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = classId.asSingleFqName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classId.asSingleFqName().asString()");
        return stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(MetadataPackageFragment.Companion.getDOT_METADATA_FILE_EXTENSION()).toString();
    }

    public MetadataSerializer(boolean dependOnOldBuiltIns) {
        this.dependOnOldBuiltIns = dependOnOldBuiltIns;
    }

    public static final /* synthetic */ boolean access$getDependOnOldBuiltIns$p(MetadataSerializer $this) {
        return $this.dependOnOldBuiltIns;
    }

    @NotNull
    public static final /* synthetic */ String access$getClassFilePath(MetadataSerializer $this, @NotNull ClassId classId) {
        return $this.getClassFilePath(classId);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0016\u0010\u0017\u001a\u00020\u00112\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/MetadataSerializer$PackageSerializer;", "", "classes", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "members", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "destFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/cli/metadata/MetadataSerializer;Ljava/util/Collection;Ljava/util/Collection;Lorg/jetbrains/kotlin/name/FqName;Ljava/io/File;)V", "extension", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$PackageFragment$Builder;", "kotlin.jvm.PlatformType", "run", "", "serializeBuiltInsFile", "serializeClass", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "serializeClasses", "serializeMembers", "serializeStringTable", "write", "stream", "Ljava/io/ByteArrayOutputStream;", "cli"})
    protected final class PackageSerializer {
        private final ProtoBuf.PackageFragment.Builder proto;
        private final KotlinSerializerExtensionBase extension;
        private final Collection<DeclarationDescriptor> classes;
        private final Collection<DeclarationDescriptor> members;
        private final FqName packageFqName;
        private final File destFile;

        public final void run() {
            this.serializeClasses(this.classes);
            this.serializeMembers(this.members);
            this.serializeStringTable();
            this.serializeBuiltInsFile();
        }

        private final void serializeClass(ClassDescriptor classDescriptor) {
            ProtoBuf.Class classProto = DescriptorSerializer.Companion.createTopLevel(this.extension).classProto(classDescriptor).build();
            this.proto.addClass_(classProto);
            this.serializeClasses(ResolutionScope.DefaultImpls.getContributedDescriptors$default(classDescriptor.getUnsubstitutedInnerClassesScope(), DescriptorKindFilter.CLASSIFIERS, null, 2, null));
        }

        private final void serializeClasses(Collection<? extends DeclarationDescriptor> classes2) {
            for (DeclarationDescriptor declarationDescriptor : DescriptorSerializer.Companion.sort(classes2)) {
                if (!(declarationDescriptor instanceof ClassDescriptor) || ((ClassDescriptor)declarationDescriptor).getKind() == ClassKind.ENUM_ENTRY) continue;
                this.serializeClass((ClassDescriptor)declarationDescriptor);
            }
        }

        private final void serializeMembers(Collection<? extends DeclarationDescriptor> members) {
            ProtoBuf.PackageFragment.Builder builder = this.proto;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"proto");
            builder.setPackage(DescriptorSerializer.Companion.createTopLevel(this.extension).packagePartProto(this.packageFqName, members).build());
        }

        /*
         * WARNING - void declaration
         */
        private final void serializeStringTable() {
            void strings;
            Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = this.extension.getStringTable().buildProto();
            ProtoBuf.StringTable stringTable = (ProtoBuf.StringTable)pair.component1();
            ProtoBuf.QualifiedNameTable qualifiedNames = (ProtoBuf.QualifiedNameTable)pair.component2();
            ProtoBuf.PackageFragment.Builder builder = this.proto;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"proto");
            builder.setStrings((ProtoBuf.StringTable)strings);
            ProtoBuf.PackageFragment.Builder builder2 = this.proto;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"proto");
            builder2.setQualifiedNames(qualifiedNames);
        }

        private final void serializeBuiltInsFile() {
            DataOutputStream dataOutputStream;
            ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
            DataOutputStream $receiver = dataOutputStream = new DataOutputStream(stream2);
            int[] version = BuiltInsBinaryVersion.INSTANCE.toArray();
            $receiver.writeInt(version.length);
            int[] $receiver$iv = version;
            int n = $receiver$iv.length;
            for (int i = 0; i < n; ++i) {
                int element$iv;
                int it = element$iv = $receiver$iv[i];
                $receiver.writeInt(it);
            }
            this.proto.build().writeTo(stream2);
            this.write(stream2);
        }

        private final void write(ByteArrayOutputStream stream2) {
            MetadataSerializer metadataSerializer = MetadataSerializer.this;
            metadataSerializer.setTotalSize(metadataSerializer.getTotalSize() + stream2.size());
            MetadataSerializer metadataSerializer2 = MetadataSerializer.this;
            int n = metadataSerializer2.getTotalFiles();
            metadataSerializer2.setTotalFiles(n + 1);
            int n2 = n = !this.destFile.isDirectory() ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string = "Cannot write because output destination is a directory: " + this.destFile;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.destFile.getParentFile().mkdirs();
            byte[] byArray = stream2.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"stream.toByteArray()");
            FilesKt.writeBytes((File)this.destFile, (byte[])byArray);
        }

        public PackageSerializer(@NotNull Collection<? extends DeclarationDescriptor> classes2, @NotNull Collection<? extends DeclarationDescriptor> members, @NotNull FqName packageFqName, @NotNull File destFile) {
            Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
            Intrinsics.checkParameterIsNotNull(members, (String)"members");
            Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkParameterIsNotNull((Object)destFile, (String)"destFile");
            this.classes = classes2;
            this.members = members;
            this.packageFqName = packageFqName;
            this.destFile = destFile;
            this.proto = ProtoBuf.PackageFragment.newBuilder();
            this.extension = MetadataSerializer.this.createSerializerExtension();
        }
    }
}

