/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.Container;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.Output;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.eclipse.model.internal.ClassFoldersCreator;
import org.gradle.plugins.ide.eclipse.model.internal.EclipseDependenciesCreator;
import org.gradle.plugins.ide.eclipse.model.internal.SourceFoldersCreator;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;

public class ClasspathFactory {
    private final EclipseClasspath classpath;
    private final EclipseDependenciesCreator dependenciesCreator;

    public ClasspathFactory(EclipseClasspath classpath, IdeArtifactRegistry ideArtifactRegistry) {
        this.classpath = classpath;
        this.dependenciesCreator = new EclipseDependenciesCreator(classpath, ideArtifactRegistry);
    }

    public List<ClasspathEntry> createEntries() {
        ArrayList entries = Lists.newArrayList();
        entries.add(this.createOutput());
        entries.addAll(this.createSourceFolders());
        entries.addAll(this.createContainers());
        entries.addAll(this.createDependencies());
        entries.addAll(this.createClassFolders());
        return entries;
    }

    private ClasspathEntry createOutput() {
        return new Output(this.classpath.getProject().relativePath((Object)this.classpath.getDefaultOutputDir()));
    }

    private List<SourceFolder> createSourceFolders() {
        return new SourceFoldersCreator().createSourceFolders(this.classpath);
    }

    private List<ClasspathEntry> createContainers() {
        ArrayList containers = Lists.newArrayList();
        for (String container : this.classpath.getContainers()) {
            Container entry = new Container(container);
            containers.add(entry);
        }
        return containers;
    }

    private List<AbstractClasspathEntry> createDependencies() {
        return this.dependenciesCreator.createDependencyEntries();
    }

    private List<? extends ClasspathEntry> createClassFolders() {
        return this.classpath.isProjectDependenciesOnly() ? Collections.emptyList() : new ClassFoldersCreator().create(this.classpath);
    }
}

