/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.CategorisedOutputEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;

class PlainConsoleDispatchingListener
implements OutputEventListener {
    private final OutputEventListener stderrChain;
    private final OutputEventListener stdoutChain;

    public PlainConsoleDispatchingListener(OutputEventListener stderrChain, OutputEventListener stdoutChain) {
        this.stderrChain = stderrChain;
        this.stdoutChain = stdoutChain;
    }

    public void onOutput(OutputEvent event) {
        if (event.getLogLevel() == null) {
            this.stderrChain.onOutput(event);
            this.stdoutChain.onOutput(event);
        } else if (event.getLogLevel() != LogLevel.ERROR) {
            this.stdoutChain.onOutput(event);
        } else if (event instanceof CategorisedOutputEvent && ((CategorisedOutputEvent)event).getCategory().equals("org.gradle.internal.buildevents.BuildExceptionReporter")) {
            this.stderrChain.onOutput(event);
        } else {
            this.stdoutChain.onOutput(event);
        }
    }
}

