/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VariantNameBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultComponentOverrideMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;

public class ComponentState
implements ComponentResolutionState,
DependencyGraphComponent {
    private final ComponentIdentifier componentIdentifier;
    private final ModuleVersionIdentifier id;
    private final ComponentMetaDataResolver resolver;
    private final VariantNameBuilder variantNameBuilder;
    private final List<NodeState> nodes = Lists.newLinkedList();
    private final Long resultId;
    private final ModuleResolveState module;
    private final ComponentSelectionReasonInternal selectionReason = VersionSelectionReasons.empty();
    private final ImmutableCapability implicitCapability;
    private volatile ComponentResolveMetadata metadata;
    private ComponentSelectionState state = ComponentSelectionState.Selectable;
    private ModuleVersionResolveException failure;
    private SelectorState firstSelectedBy;
    private List<SelectorState> selectedBy;
    private DependencyGraphBuilder.VisitState visitState = DependencyGraphBuilder.VisitState.NotSeen;
    private boolean rejected;

    ComponentState(Long resultId, ModuleResolveState module, ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier, ComponentMetaDataResolver resolver, VariantNameBuilder variantNameBuilder) {
        this.resultId = resultId;
        this.module = module;
        this.id = id;
        this.componentIdentifier = componentIdentifier;
        this.resolver = resolver;
        this.variantNameBuilder = variantNameBuilder;
        this.implicitCapability = new ImmutableCapability(id.getGroup(), id.getName(), id.getVersion());
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public String getVersion() {
        return this.id.getVersion();
    }

    @Override
    public Long getResultId() {
        return this.resultId;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersion() {
        return this.id;
    }

    public ModuleVersionResolveException getFailure() {
        return this.failure;
    }

    public DependencyGraphBuilder.VisitState getVisitState() {
        return this.visitState;
    }

    public void setVisitState(DependencyGraphBuilder.VisitState visitState) {
        this.visitState = visitState;
    }

    public List<NodeState> getNodes() {
        return this.nodes;
    }

    ModuleResolveState getModule() {
        return this.module;
    }

    @Override
    public ComponentResolveMetadata getMetadata() {
        this.resolve();
        return this.metadata;
    }

    @Override
    public ComponentIdentifier getComponentId() {
        if (this.metadata != null) {
            return this.metadata.getId();
        }
        return this.componentIdentifier;
    }

    public void restart(ComponentState selected) {
        for (NodeState configuration : this.nodes) {
            configuration.restart(selected);
        }
    }

    public void selectedBy(SelectorState resolver) {
        if (this.firstSelectedBy == null) {
            this.firstSelectedBy = resolver;
            this.selectedBy = Lists.newLinkedList();
        }
        this.selectedBy.add(resolver);
    }

    public List<SelectorState> getSelectedBy() {
        return this.selectedBy;
    }

    public boolean alreadyResolved() {
        return this.metadata != null || this.failure != null;
    }

    public void resolve() {
        if (this.alreadyResolved()) {
            return;
        }
        DefaultBuildableComponentResolveResult result = new DefaultBuildableComponentResolveResult();
        this.resolver.resolve(this.componentIdentifier, DefaultComponentOverrideMetadata.forDependency(this.firstSelectedBy.getDependencyMetadata()), result);
        if (result.getFailure() != null) {
            this.failure = result.getFailure();
            return;
        }
        this.metadata = result.getMetadata();
    }

    public void setMetadata(ComponentResolveMetadata metaData) {
        this.metadata = metaData;
        this.failure = null;
    }

    public void addConfiguration(NodeState node) {
        this.nodes.add(node);
    }

    @Override
    public ComponentSelectionReasonInternal getSelectionReason() {
        return this.selectionReason;
    }

    @Override
    public void addCause(ComponentSelectionDescriptorInternal reason) {
        this.selectionReason.addCause(reason);
    }

    public void setRoot() {
        this.selectionReason.setCause(VersionSelectionReasons.ROOT);
    }

    @Override
    public String getVariantName() {
        String name = null;
        for (NodeState node : this.nodes) {
            if (!node.isSelected()) continue;
            name = this.variantNameBuilder.getVariantName(name, node.getMetadata().getName());
        }
        return name == null ? "unknown" : name;
    }

    @Override
    public AttributeContainer getVariantAttributes() {
        NodeState selected = this.getSelectedNode();
        return selected == null ? ImmutableAttributes.EMPTY : this.desugarAttributes(selected);
    }

    private NodeState getSelectedNode() {
        for (NodeState node : this.nodes) {
            if (!node.isSelected()) continue;
            return node;
        }
        return null;
    }

    private ImmutableAttributes desugarAttributes(NodeState selected) {
        ImmutableAttributes attributes = selected.getMetadata().getAttributes();
        if (attributes.isEmpty()) {
            return attributes;
        }
        AttributeContainerInternal mutable = selected.getAttributesFactory().mutable();
        ImmutableSet keySet = attributes.keySet();
        for (Attribute attribute : keySet) {
            Object value = attributes.getAttribute(attribute);
            Attribute desugared = (Attribute)Cast.uncheckedCast((Object)attribute);
            if (attribute.getType() == Boolean.class || attribute.getType() == String.class) {
                mutable.attribute(desugared, value);
                continue;
            }
            desugared = (Attribute)Cast.uncheckedCast((Object)Attribute.of((String)attribute.getName(), String.class));
            mutable.attribute(desugared, (Object)value.toString());
        }
        return mutable.asImmutable();
    }

    public List<ComponentState> getDependents() {
        ArrayList incoming = Lists.newArrayListWithCapacity((int)this.nodes.size());
        for (NodeState configuration : this.nodes) {
            for (EdgeState dependencyEdge : configuration.getIncomingEdges()) {
                incoming.add(dependencyEdge.getFrom().getComponent());
            }
        }
        return incoming;
    }

    public boolean isSelected() {
        return this.state == ComponentSelectionState.Selected;
    }

    boolean isSelectable() {
        return this.state.isSelectable();
    }

    public boolean isCandidateForConflictResolution() {
        return this.state.isCandidateForConflictResolution();
    }

    void evict() {
        this.state = ComponentSelectionState.Evicted;
    }

    void select() {
        this.state = ComponentSelectionState.Selected;
    }

    void makeSelectable() {
        this.state = ComponentSelectionState.Selectable;
    }

    @Override
    public void reject() {
        this.rejected = true;
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    public void forEachCapability(Action<? super Capability> action) {
        for (NodeState target : this.nodes) {
            List capabilities = target.getMetadata().getCapabilities().getCapabilities();
            if (capabilities.isEmpty()) continue;
            for (Capability capability : capabilities) {
                action.execute((Object)capability);
            }
        }
    }

    public Capability findCapability(String group, String name) {
        if (this.id.getGroup().equals(group) && this.id.getName().equals(name)) {
            return this.implicitCapability;
        }
        return this.findCapabilityOnTarget(group, name);
    }

    private Capability findCapabilityOnTarget(String group, String name) {
        for (NodeState target : this.nodes) {
            List capabilities = target.getMetadata().getCapabilities().getCapabilities();
            if (capabilities.isEmpty()) continue;
            for (Capability capability : capabilities) {
                if (!capability.getGroup().equals(group) || !capability.getName().equals(name)) continue;
                return capability;
            }
        }
        return null;
    }

    static enum ComponentSelectionState {
        Selectable(true, true),
        Selected(true, false),
        Evicted(false, false);

        private final boolean candidateForConflictResolution;
        private final boolean canSelect;

        private ComponentSelectionState(boolean candidateForConflictResolution, boolean canSelect) {
            this.candidateForConflictResolution = candidateForConflictResolution;
            this.canSelect = canSelect;
        }

        boolean isCandidateForConflictResolution() {
            return this.candidateForConflictResolution;
        }

        public boolean isSelectable() {
            return this.canSelect;
        }
    }
}

