/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableComponentIdResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableComponentIdResolveResult {
    private ModuleVersionResolveException failure;
    private ComponentResolveMetadata metadata;
    private ComponentIdentifier id;
    private ModuleVersionIdentifier moduleVersionId;

    @Override
    public boolean hasResult() {
        return this.id != null || this.failure != null;
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        return this.failure;
    }

    @Override
    public ComponentIdentifier getId() {
        this.assertResolved();
        return this.id;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        this.assertResolved();
        return this.moduleVersionId;
    }

    @Override
    public ComponentResolveMetadata getMetadata() {
        this.assertResolved();
        return this.metadata;
    }

    @Override
    public void resolved(ComponentIdentifier id, ModuleVersionIdentifier moduleVersionIdentifier) {
        this.reset();
        this.id = id;
        this.moduleVersionId = moduleVersionIdentifier;
    }

    @Override
    public void resolved(ComponentResolveMetadata metadata) {
        this.resolved(metadata.getId(), metadata.getModuleVersionId());
        this.metadata = metadata;
    }

    @Override
    public void failed(ModuleVersionResolveException failure) {
        this.reset();
        this.failure = failure;
    }

    private void assertResolved() {
        if (this.failure != null) {
            throw this.failure;
        }
        if (this.id == null) {
            throw new IllegalStateException("Not resolved.");
        }
    }

    private void reset() {
        this.failure = null;
        this.metadata = null;
        this.id = null;
        this.moduleVersionId = null;
    }
}

