/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.MetaPluginInfo;
import org.elasticsearch.plugins.Platforms;
import org.elasticsearch.plugins.PluginInfo;
import org.elasticsearch.plugins.PluginSecurity;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.ProgressInputStream;

class InstallPluginCommand
extends EnvironmentAwareCommand {
    private static final String PROPERTY_STAGING_ID = "es.plugins.staging";
    static final int PLUGIN_EXISTS = 1;
    static final int PLUGIN_MALFORMED = 2;
    static final Set<String> MODULES;
    static final Set<String> OFFICIAL_PLUGINS;
    private final OptionSpec<Void> batchOption;
    private final OptionSpec<String> arguments;
    static final Set<PosixFilePermission> BIN_DIR_PERMS;
    static final Set<PosixFilePermission> BIN_FILES_PERMS;
    static final Set<PosixFilePermission> CONFIG_DIR_PERMS;
    static final Set<PosixFilePermission> CONFIG_FILES_PERMS;
    static final Set<PosixFilePermission> PLUGIN_DIR_PERMS;
    static final Set<PosixFilePermission> PLUGIN_FILES_PERMS;
    private final List<Path> pathsToDeleteOnShutdown = new ArrayList<Path>();

    InstallPluginCommand() {
        super("Install a plugin");
        this.batchOption = this.parser.acceptsAll(Arrays.asList("b", "batch"), "Enable batch mode explicitly, automatic confirmation of security permission");
        this.arguments = this.parser.nonOptions("plugin id");
    }

    protected void printAdditionalHelp(Terminal terminal) {
        terminal.println("The following official plugins may be installed by name:");
        for (String plugin : OFFICIAL_PLUGINS) {
            terminal.println("  " + plugin);
        }
        terminal.println("");
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        String pluginId = (String)this.arguments.value(options);
        boolean isBatch = options.has(this.batchOption) || System.console() == null;
        this.execute(terminal, pluginId, isBatch, env);
    }

    void execute(Terminal terminal, String pluginId, boolean isBatch, Environment env) throws Exception {
        if (pluginId == null) {
            throw new UserException(64, "plugin id is required");
        }
        Path pluginZip = this.download(terminal, pluginId, env.tmpFile());
        Path extractedZip = this.unzip(pluginZip, env.pluginsFile());
        this.install(terminal, isBatch, extractedZip, env);
    }

    private Path download(Terminal terminal, String pluginId, Path tmpDir) throws Exception {
        if (OFFICIAL_PLUGINS.contains(pluginId)) {
            String url = this.getElasticUrl(terminal, this.getStagingHash(), Version.CURRENT, pluginId, Platforms.PLATFORM_NAME);
            terminal.println("-> Downloading " + pluginId + " from elastic");
            return this.downloadZipAndChecksum(terminal, url, tmpDir, false);
        }
        String[] coordinates = pluginId.split(":");
        if (coordinates.length == 3 && !pluginId.contains("/") && !pluginId.startsWith("file:")) {
            String mavenUrl = this.getMavenUrl(terminal, coordinates, Platforms.PLATFORM_NAME);
            terminal.println("-> Downloading " + pluginId + " from maven central");
            return this.downloadZipAndChecksum(terminal, mavenUrl, tmpDir, true);
        }
        if (!pluginId.contains(":")) {
            List<String> plugins = this.checkMisspelledPlugin(pluginId);
            String msg = "Unknown plugin " + pluginId;
            if (!plugins.isEmpty()) {
                msg = msg + ", did you mean " + (plugins.size() == 1 ? "[" + plugins.get(0) + "]" : "any of " + plugins.toString()) + "?";
            }
            throw new UserException(64, msg);
        }
        terminal.println("-> Downloading " + URLDecoder.decode(pluginId, "UTF-8"));
        return this.downloadZip(terminal, pluginId, tmpDir);
    }

    String getStagingHash() {
        return System.getProperty(PROPERTY_STAGING_ID);
    }

    private String getElasticUrl(Terminal terminal, String stagingHash, Version version, String pluginId, String platform) throws IOException {
        String baseUrl = stagingHash != null ? String.format(Locale.ROOT, "https://staging.elastic.co/%s-%s/downloads/elasticsearch-plugins/%s", version, stagingHash, pluginId) : String.format(Locale.ROOT, "https://artifacts.elastic.co/downloads/elasticsearch-plugins/%s", pluginId);
        String platformUrl = String.format(Locale.ROOT, "%s/%s-%s-%s.zip", baseUrl, pluginId, platform, version);
        if (this.urlExists(terminal, platformUrl)) {
            return platformUrl;
        }
        return String.format(Locale.ROOT, "%s/%s-%s.zip", baseUrl, pluginId, version);
    }

    private String getMavenUrl(Terminal terminal, String[] coordinates, String platform) throws IOException {
        String groupId = coordinates[0].replace(".", "/");
        String artifactId = coordinates[1];
        String version = coordinates[2];
        String baseUrl = String.format(Locale.ROOT, "https://repo1.maven.org/maven2/%s/%s/%s", groupId, artifactId, version);
        String platformUrl = String.format(Locale.ROOT, "%s/%s-%s-%s.zip", baseUrl, artifactId, platform, version);
        if (this.urlExists(terminal, platformUrl)) {
            return platformUrl;
        }
        return String.format(Locale.ROOT, "%s/%s-%s.zip", baseUrl, artifactId, version);
    }

    @SuppressForbidden(reason="Make HEAD request using URLConnection.connect()")
    boolean urlExists(Terminal terminal, String urlString) throws IOException {
        terminal.println(Terminal.Verbosity.VERBOSE, "Checking if url exists: " + urlString);
        URL url = new URL(urlString);
        assert ("https".equals(url.getProtocol())) : "Only http urls can be checked";
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.addRequestProperty("User-Agent", "elasticsearch-plugin-installer");
        urlConnection.setRequestMethod("HEAD");
        urlConnection.connect();
        return urlConnection.getResponseCode() == 200;
    }

    private List<String> checkMisspelledPlugin(String pluginId) {
        LevensteinDistance ld = new LevensteinDistance();
        ArrayList<Tuple> scoredKeys = new ArrayList<Tuple>();
        for (String officialPlugin : OFFICIAL_PLUGINS) {
            float distance = ld.getDistance(pluginId, officialPlugin);
            if (!(distance > 0.7f)) continue;
            scoredKeys.add(new Tuple((Object)Float.valueOf(distance), (Object)officialPlugin));
        }
        CollectionUtil.timSort(scoredKeys, (a, b) -> ((Float)b.v1()).compareTo((Float)a.v1()));
        return scoredKeys.stream().map(a -> (String)a.v2()).collect(Collectors.toList());
    }

    @SuppressForbidden(reason="We use getInputStream to download plugins")
    Path downloadZip(Terminal terminal, String urlString, Path tmpDir) throws IOException {
        terminal.println(Terminal.Verbosity.VERBOSE, "Retrieving zip from " + urlString);
        URL url = new URL(urlString);
        Path zip = Files.createTempFile(tmpDir, null, ".zip", new FileAttribute[0]);
        URLConnection urlConnection = url.openConnection();
        urlConnection.addRequestProperty("User-Agent", "elasticsearch-plugin-installer");
        int contentLength = urlConnection.getContentLength();
        try (TerminalProgressInputStream in = new TerminalProgressInputStream(urlConnection.getInputStream(), contentLength, terminal);){
            Files.copy(in, zip, StandardCopyOption.REPLACE_EXISTING);
        }
        return zip;
    }

    @SuppressForbidden(reason="We use openStream to download plugins")
    private Path downloadZipAndChecksum(Terminal terminal, String urlString, Path tmpDir, boolean allowSha1) throws Exception {
        String expectedChecksum;
        Path zip = this.downloadZip(terminal, urlString, tmpDir);
        this.pathsToDeleteOnShutdown.add(zip);
        String checksumUrlString = urlString + ".sha512";
        URL checksumUrl = this.openUrl(checksumUrlString);
        String digestAlgo = "SHA-512";
        if (checksumUrl == null && allowSha1) {
            terminal.println("Warning: sha512 not found, falling back to sha1. This behavior is deprecated and will be removed in a future release. Please update the plugin to use a sha512 checksum.");
            checksumUrlString = urlString + ".sha1";
            checksumUrl = this.openUrl(checksumUrlString);
            digestAlgo = "SHA-1";
        }
        if (checksumUrl == null) {
            throw new UserException(74, "Plugin checksum missing: " + checksumUrlString);
        }
        try (InputStream in = checksumUrl.openStream();){
            if (digestAlgo.equals("SHA-1")) {
                BufferedReader checksumReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                expectedChecksum = checksumReader.readLine();
                if (checksumReader.readLine() != null) {
                    throw new UserException(74, "Invalid checksum file at " + checksumUrl);
                }
            } else {
                BufferedReader checksumReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                String checksumLine = checksumReader.readLine();
                String[] fields = checksumLine.split(" {2}");
                if (fields.length != 2) {
                    throw new UserException(74, "Invalid checksum file at " + checksumUrl);
                }
                expectedChecksum = fields[0];
                String[] segments = URI.create(urlString).getPath().split("/");
                String expectedFile = segments[segments.length - 1];
                if (!fields[1].equals(expectedFile)) {
                    String message = String.format(Locale.ROOT, "checksum file at [%s] is not for this plugin, expected [%s] but was [%s]", checksumUrl, expectedFile, fields[1]);
                    throw new UserException(74, message);
                }
                if (checksumReader.readLine() != null) {
                    throw new UserException(74, "Invalid checksum file at " + checksumUrl);
                }
            }
        }
        byte[] zipbytes = Files.readAllBytes(zip);
        String gotChecksum = MessageDigests.toHexString((byte[])MessageDigest.getInstance(digestAlgo).digest(zipbytes));
        if (!expectedChecksum.equals(gotChecksum)) {
            throw new UserException(74, digestAlgo + " mismatch, expected " + expectedChecksum + " but got " + gotChecksum);
        }
        return zip;
    }

    URL openUrl(String urlString) throws Exception {
        URL checksumUrl = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)checksumUrl.openConnection();
        if (connection.getResponseCode() == 404) {
            return null;
        }
        return checksumUrl;
    }

    private Path unzip(Path zip, Path pluginsDir) throws IOException, UserException {
        Path target = this.stagingDirectory(pluginsDir);
        this.pathsToDeleteOnShutdown.add(target);
        boolean hasEsDir = false;
        try (ZipInputStream zipInput = new ZipInputStream(Files.newInputStream(zip, new OpenOption[0]));){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zipInput.getNextEntry()) != null) {
                if (!entry.getName().startsWith("elasticsearch/")) continue;
                hasEsDir = true;
                Path targetFile = target.resolve(entry.getName().substring("elasticsearch/".length()));
                if (!targetFile.normalize().startsWith(target)) {
                    throw new UserException(2, "Zip contains entry name '" + entry.getName() + "' resolving outside of plugin directory");
                }
                if (!Files.isSymbolicLink(targetFile.getParent())) {
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                }
                if (!entry.isDirectory()) {
                    try (OutputStream out = Files.newOutputStream(targetFile, new OpenOption[0]);){
                        int len;
                        while ((len = zipInput.read(buffer)) >= 0) {
                            out.write(buffer, 0, len);
                        }
                    }
                }
                zipInput.closeEntry();
            }
        }
        Files.delete(zip);
        if (!hasEsDir) {
            IOUtils.rm((Path[])new Path[]{target});
            throw new UserException(2, "`elasticsearch` directory is missing in the plugin zip");
        }
        return target;
    }

    private Path stagingDirectory(Path pluginsDir) throws IOException {
        try {
            return Files.createTempDirectory(pluginsDir, ".installing-", PosixFilePermissions.asFileAttribute(PLUGIN_DIR_PERMS));
        }
        catch (IllegalArgumentException e) {
            StackTraceElement[] elements = e.getStackTrace();
            if (elements.length >= 1 && elements[0].getClassName().equals("com.google.common.jimfs.AttributeService") && elements[0].getMethodName().equals("setAttributeInternal")) {
                return this.stagingDirectoryWithoutPosixPermissions(pluginsDir);
            }
            throw e;
        }
        catch (UnsupportedOperationException e) {
            return this.stagingDirectoryWithoutPosixPermissions(pluginsDir);
        }
    }

    private Path stagingDirectoryWithoutPosixPermissions(Path pluginsDir) throws IOException {
        return Files.createTempDirectory(pluginsDir, ".installing-", new FileAttribute[0]);
    }

    private void verifyPluginName(Path pluginPath, String pluginName, Path candidateDir) throws UserException, IOException {
        Path destination = pluginPath.resolve(pluginName);
        if (Files.exists(destination, new LinkOption[0])) {
            String message = String.format(Locale.ROOT, "plugin directory [%s] already exists; if you need to update the plugin, uninstall it first using command 'remove %s'", destination.toAbsolutePath(), pluginName);
            throw new UserException(1, message);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pluginPath);){
            for (Path plugin : stream) {
                if (candidateDir.equals(plugin.resolve(pluginName)) || !MetaPluginInfo.isMetaPlugin((Path)plugin) || !Files.exists(plugin.resolve(pluginName), new LinkOption[0])) continue;
                MetaPluginInfo info = MetaPluginInfo.readFromProperties((Path)plugin);
                String message = String.format(Locale.ROOT, "plugin name [%s] already exists in a meta plugin; if you need to update the meta plugin, uninstall it first using command 'remove %s'", plugin.resolve(pluginName).toAbsolutePath(), info.getName());
                throw new UserException(1, message);
            }
        }
    }

    private PluginInfo loadPluginInfo(Terminal terminal, Path pluginRoot, boolean isBatch, Environment env) throws Exception {
        PluginInfo info = PluginInfo.readFromProperties((Path)pluginRoot);
        this.verifyPluginName(env.pluginsFile(), info.getName(), pluginRoot);
        PluginsService.checkForFailedPluginRemovals((Path)env.pluginsFile());
        terminal.println(Terminal.Verbosity.VERBOSE, info.toString());
        if (MODULES.contains(info.getName())) {
            throw new UserException(64, "plugin '" + info.getName() + "' cannot be installed like this, it is a system module");
        }
        this.jarHellCheck(info, pluginRoot, env.pluginsFile(), env.modulesFile());
        return info;
    }

    void jarHellCheck(PluginInfo candidateInfo, Path candidateDir, Path pluginsDir, Path modulesDir) throws Exception {
        HashSet jars = new HashSet(JarHell.parseClassPath());
        HashSet<PluginsService.Bundle> bundles = new HashSet<PluginsService.Bundle>(PluginsService.getPluginBundles((Path)pluginsDir));
        bundles.addAll(PluginsService.getModuleBundles((Path)modulesDir));
        bundles.add(new PluginsService.Bundle(candidateInfo, candidateDir));
        List sortedBundles = PluginsService.sortBundles(bundles);
        HashMap transitiveUrls = new HashMap();
        for (PluginsService.Bundle bundle : sortedBundles) {
            PluginsService.checkBundleJarHell((PluginsService.Bundle)bundle, transitiveUrls);
        }
    }

    private void install(Terminal terminal, boolean isBatch, Path tmpRoot, Environment env) throws Exception {
        ArrayList<Path> deleteOnFailure = new ArrayList<Path>();
        deleteOnFailure.add(tmpRoot);
        try {
            if (MetaPluginInfo.isMetaPlugin((Path)tmpRoot)) {
                this.installMetaPlugin(terminal, isBatch, tmpRoot, env, deleteOnFailure);
            } else {
                this.installPlugin(terminal, isBatch, tmpRoot, env, deleteOnFailure);
            }
        }
        catch (Exception installProblem) {
            try {
                IOUtils.rm((Path[])deleteOnFailure.toArray(new Path[0]));
            }
            catch (IOException exceptionWhileRemovingFiles) {
                installProblem.addSuppressed(exceptionWhileRemovingFiles);
            }
            throw installProblem;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void installMetaPlugin(Terminal terminal, boolean isBatch, Path tmpRoot, Environment env, List<Path> deleteOnFailure) throws Exception {
        void var12_17;
        PluginInfo info;
        MetaPluginInfo metaInfo = MetaPluginInfo.readFromProperties((Path)tmpRoot);
        this.verifyPluginName(env.pluginsFile(), metaInfo.getName(), tmpRoot);
        Path destination = env.pluginsFile().resolve(metaInfo.getName());
        deleteOnFailure.add(destination);
        terminal.println(Terminal.Verbosity.VERBOSE, metaInfo.toString());
        ArrayList<Path> pluginPaths = new ArrayList<Path>();
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(tmpRoot);){
            for (Path path : paths) {
                if (MetaPluginInfo.isPropertiesFile((Path)path)) continue;
                PluginInfo pluginInfo = PluginInfo.readFromProperties((Path)path);
                this.verifyPluginName(env.pluginsFile(), pluginInfo.getName(), path);
                pluginPaths.add(path);
            }
        }
        HashSet permissions = new HashSet();
        ArrayList<PluginInfo> pluginInfos = new ArrayList<PluginInfo>();
        boolean hasNativeController = false;
        for (Path path : pluginPaths) {
            info = this.loadPluginInfo(terminal, path, isBatch, env);
            pluginInfos.add(info);
            hasNativeController |= info.hasNativeController();
            Path policy = path.resolve("plugin-security.policy");
            if (!Files.exists(policy, new LinkOption[0])) continue;
            permissions.addAll(PluginSecurity.parsePermissions((Path)policy, (Path)env.tmpFile()));
        }
        PluginSecurity.confirmPolicyExceptions((Terminal)terminal, permissions, (boolean)hasNativeController, (boolean)isBatch);
        boolean bl = false;
        while (var12_17 < pluginPaths.size()) {
            Path path = (Path)pluginPaths.get((int)var12_17);
            info = (PluginInfo)pluginInfos.get((int)var12_17);
            this.installPluginSupportFiles(info, path, env.binFile().resolve(metaInfo.getName()), env.configFile().resolve(metaInfo.getName()), deleteOnFailure);
            if (!path.getFileName().toString().equals(info.getName())) {
                Files.move(path, path.getParent().resolve(info.getName()), StandardCopyOption.ATOMIC_MOVE);
            }
            ++var12_17;
        }
        this.movePlugin(tmpRoot, destination);
        for (PluginInfo pluginInfo : pluginInfos) {
            if (!pluginInfo.requiresKeystore()) continue;
            this.createKeystoreIfNeeded(terminal, env, pluginInfo);
            break;
        }
        Object[] objectArray = (String[])pluginInfos.stream().map(PluginInfo::getName).toArray(String[]::new);
        terminal.println("-> Installed " + metaInfo.getName() + " with: " + Strings.arrayToCommaDelimitedString((Object[])objectArray));
    }

    private void installPlugin(Terminal terminal, boolean isBatch, Path tmpRoot, Environment env, List<Path> deleteOnFailure) throws Exception {
        PluginInfo info = this.loadPluginInfo(terminal, tmpRoot, isBatch, env);
        Path policy = tmpRoot.resolve("plugin-security.policy");
        if (Files.exists(policy, new LinkOption[0])) {
            Set permissions = PluginSecurity.parsePermissions((Path)policy, (Path)env.tmpFile());
            PluginSecurity.confirmPolicyExceptions((Terminal)terminal, (Set)permissions, (boolean)info.hasNativeController(), (boolean)isBatch);
        }
        Path destination = env.pluginsFile().resolve(info.getName());
        deleteOnFailure.add(destination);
        this.installPluginSupportFiles(info, tmpRoot, env.binFile().resolve(info.getName()), env.configFile().resolve(info.getName()), deleteOnFailure);
        this.movePlugin(tmpRoot, destination);
        if (info.requiresKeystore()) {
            this.createKeystoreIfNeeded(terminal, env, info);
        }
        terminal.println("-> Installed " + info.getName());
    }

    private void installPluginSupportFiles(PluginInfo info, Path tmpRoot, Path destBinDir, Path destConfigDir, List<Path> deleteOnFailure) throws Exception {
        Path tmpConfigDir;
        Path tmpBinDir = tmpRoot.resolve("bin");
        if (Files.exists(tmpBinDir, new LinkOption[0])) {
            deleteOnFailure.add(destBinDir);
            this.installBin(info, tmpBinDir, destBinDir);
        }
        if (Files.exists(tmpConfigDir = tmpRoot.resolve("config"), new LinkOption[0])) {
            this.installConfig(info, tmpConfigDir, destConfigDir);
        }
    }

    private void movePlugin(Path tmpRoot, Path destination) throws IOException {
        Files.move(tmpRoot, destination, StandardCopyOption.ATOMIC_MOVE);
        Files.walkFileTree(destination, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if ("bin".equals(file.getParent().getFileName().toString())) {
                    InstallPluginCommand.setFileAttributes(file, BIN_FILES_PERMS);
                } else {
                    InstallPluginCommand.setFileAttributes(file, PLUGIN_FILES_PERMS);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                InstallPluginCommand.setFileAttributes(dir, PLUGIN_DIR_PERMS);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void installBin(PluginInfo info, Path tmpBinDir, Path destBinDir) throws Exception {
        if (!Files.isDirectory(tmpBinDir, new LinkOption[0])) {
            throw new UserException(2, "bin in plugin " + info.getName() + " is not a directory");
        }
        Files.createDirectories(destBinDir, new FileAttribute[0]);
        InstallPluginCommand.setFileAttributes(destBinDir, BIN_DIR_PERMS);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tmpBinDir);){
            for (Path srcFile : stream) {
                if (Files.isDirectory(srcFile, new LinkOption[0])) {
                    throw new UserException(2, "Directories not allowed in bin dir for plugin " + info.getName() + ", found " + srcFile.getFileName());
                }
                Path destFile = destBinDir.resolve(tmpBinDir.relativize(srcFile));
                Files.copy(srcFile, destFile, new CopyOption[0]);
                InstallPluginCommand.setFileAttributes(destFile, BIN_FILES_PERMS);
            }
        }
        IOUtils.rm((Path[])new Path[]{tmpBinDir});
    }

    private void installConfig(PluginInfo info, Path tmpConfigDir, Path destConfigDir) throws Exception {
        PosixFileAttributes destConfigDirAttributes;
        if (!Files.isDirectory(tmpConfigDir, new LinkOption[0])) {
            throw new UserException(2, "config in plugin " + info.getName() + " is not a directory");
        }
        Files.createDirectories(destConfigDir, new FileAttribute[0]);
        InstallPluginCommand.setFileAttributes(destConfigDir, CONFIG_DIR_PERMS);
        PosixFileAttributeView destConfigDirAttributesView = Files.getFileAttributeView(destConfigDir.getParent(), PosixFileAttributeView.class, new LinkOption[0]);
        PosixFileAttributes posixFileAttributes = destConfigDirAttributes = destConfigDirAttributesView != null ? destConfigDirAttributesView.readAttributes() : null;
        if (destConfigDirAttributes != null) {
            InstallPluginCommand.setOwnerGroup(destConfigDir, destConfigDirAttributes);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tmpConfigDir);){
            for (Path srcFile : stream) {
                if (Files.isDirectory(srcFile, new LinkOption[0])) {
                    throw new UserException(2, "Directories not allowed in config dir for plugin " + info.getName());
                }
                Path destFile = destConfigDir.resolve(tmpConfigDir.relativize(srcFile));
                if (Files.exists(destFile, new LinkOption[0])) continue;
                Files.copy(srcFile, destFile, new CopyOption[0]);
                InstallPluginCommand.setFileAttributes(destFile, CONFIG_FILES_PERMS);
                if (destConfigDirAttributes == null) continue;
                InstallPluginCommand.setOwnerGroup(destFile, destConfigDirAttributes);
            }
        }
        IOUtils.rm((Path[])new Path[]{tmpConfigDir});
    }

    private void createKeystoreIfNeeded(Terminal terminal, Environment env, PluginInfo info) throws Exception {
        KeyStoreWrapper keystore = KeyStoreWrapper.load((Path)env.configFile());
        if (keystore == null) {
            terminal.println("Elasticsearch keystore is required by plugin [" + info.getName() + "], creating...");
            keystore = KeyStoreWrapper.create((char[])new char[0]);
            keystore.save(env.configFile());
        }
    }

    private static void setOwnerGroup(Path path, PosixFileAttributes attributes) throws IOException {
        Objects.requireNonNull(attributes);
        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        assert (fileAttributeView != null);
        fileAttributeView.setOwner(attributes.owner());
        fileAttributeView.setGroup(attributes.group());
    }

    private static void setFileAttributes(Path path, Set<PosixFilePermission> permissions) throws IOException {
        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (fileAttributeView != null) {
            Files.setPosixFilePermissions(path, permissions);
        }
    }

    public void close() throws IOException {
        IOUtils.rm((Path[])this.pathsToDeleteOnShutdown.toArray(new Path[this.pathsToDeleteOnShutdown.size()]));
    }

    static {
        String line;
        Throwable throwable;
        BufferedReader reader2;
        Throwable throwable2;
        InputStream stream;
        try {
            stream = InstallPluginCommand.class.getResourceAsStream("/modules.txt");
            throwable2 = null;
            try {
                reader2 = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                throwable = null;
                try {
                    HashSet<String> modules = new HashSet<String>();
                    line = reader2.readLine();
                    while (line != null) {
                        modules.add(line.trim());
                        line = reader2.readLine();
                    }
                    MODULES = Collections.unmodifiableSet(modules);
                }
                catch (Throwable modules) {
                    throwable = modules;
                    throw modules;
                }
                finally {
                    InstallPluginCommand.$closeResource(throwable, reader2);
                }
            }
            catch (Throwable reader2) {
                throwable2 = reader2;
                throw reader2;
            }
            finally {
                if (stream != null) {
                    InstallPluginCommand.$closeResource(throwable2, stream);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            stream = InstallPluginCommand.class.getResourceAsStream("/plugins.txt");
            throwable2 = null;
            try {
                reader2 = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                throwable = null;
                try {
                    TreeSet<String> plugins = new TreeSet<String>();
                    line = reader2.readLine();
                    while (line != null) {
                        plugins.add(line.trim());
                        line = reader2.readLine();
                    }
                    plugins.add("x-pack");
                    OFFICIAL_PLUGINS = Collections.unmodifiableSet(plugins);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    InstallPluginCommand.$closeResource(throwable, reader2);
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                if (stream != null) {
                    InstallPluginCommand.$closeResource(throwable2, stream);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        BIN_DIR_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-xr-x"));
        BIN_FILES_PERMS = BIN_DIR_PERMS;
        CONFIG_DIR_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-x---"));
        CONFIG_FILES_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-rw----"));
        PLUGIN_DIR_PERMS = BIN_DIR_PERMS;
        PLUGIN_FILES_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-r--r--"));
    }

    private class TerminalProgressInputStream
    extends ProgressInputStream {
        private final Terminal terminal;
        private int width;
        private final boolean enabled;

        TerminalProgressInputStream(InputStream is, int expectedTotalSize, Terminal terminal) {
            super(is, expectedTotalSize);
            this.width = 50;
            this.terminal = terminal;
            this.enabled = expectedTotalSize > 0;
        }

        @Override
        public void onProgress(int percent) {
            if (this.enabled) {
                int currentPosition = percent * this.width / 100;
                StringBuilder sb = new StringBuilder("\r[");
                sb.append(String.join((CharSequence)"=", Collections.nCopies(currentPosition, "")));
                if (currentPosition > 0 && percent < 100) {
                    sb.append(">");
                }
                sb.append(String.join((CharSequence)" ", Collections.nCopies(this.width - currentPosition, "")));
                sb.append("] %s\u00a0\u00a0 ");
                if (percent == 100) {
                    sb.append("\n");
                }
                this.terminal.print(Terminal.Verbosity.NORMAL, String.format(Locale.ROOT, sb.toString(), percent + "%"));
            }
        }
    }
}

