/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

final class EmptyMemberValueSource
extends ValueSource {
    final IndexFieldData<?> fieldData;

    EmptyMemberValueSource(IndexFieldData<?> fieldData) {
        this.fieldData = Objects.requireNonNull(fieldData);
    }

    public FunctionValues getValues(Map context, LeafReaderContext leaf) throws IOException {
        AtomicNumericFieldData leafData = (AtomicNumericFieldData)this.fieldData.load(leaf);
        final SortedNumericDoubleValues values = leafData.getDoubleValues();
        return new DoubleDocValues(this){

            public double doubleVal(int doc) throws IOException {
                if (values.advanceExact(doc)) {
                    return 0.0;
                }
                return 1.0;
            }
        };
    }

    public int hashCode() {
        return 31 * ((Object)((Object)this)).getClass().hashCode() + this.fieldData.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EmptyMemberValueSource other = (EmptyMemberValueSource)((Object)obj);
        return this.fieldData.equals(other.fieldData);
    }

    public String description() {
        return "empty: field(" + this.fieldData.getFieldName() + ")";
    }
}

