/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.IllegalFormatException;
import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.fibs.geotag.track.TrackMatcher;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class FillGapsTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(FillGapsTask.class);
    private ImagesTableModel imagesTableModel;
    private int currentProgress = 0;
    private List<ImageInfo> images;

    public FillGapsTask(String group, String name, ImagesTableModel imagesTableModel, List<ImageInfo> images) {
        super(group, name);
        this.imagesTableModel = imagesTableModel;
        this.images = images;
    }

    @Override
    protected String doInBackground() throws Exception {
        int gapsFilled = 0;
        TrackMatcher trackMatcher = new TrackMatcher();
        for (ImageInfo imageInfo : this.images) {
            if (this.interruptRequested()) break;
            try {
                TrackMatcher.Match match;
                ++this.currentProgress;
                this.setProgressMessage();
                if (imageInfo.hasLocation() || (match = trackMatcher.findMatch(imageInfo.getTimeGMT())) == null) continue;
                trackMatcher.performMatch(imageInfo, match);
                ++gapsFilled;
                this.publish(imageInfo);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        String result = null;
        if (gapsFilled == 0) {
            result = i18n.tr("No gaps filled.");
        } else if (gapsFilled == 1) {
            result = i18n.tr("Filled one gap.");
        } else {
            try {
                result = String.format(i18n.tr("Filled %d gaps."), gapsFilled);
            }
            catch (IllegalFormatException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public int getMaxProgress() {
        return this.images.size();
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    protected void process(List<ImageInfo> imageInfos) {
        for (ImageInfo imageInfo : imageInfos) {
            int imageRow = this.imagesTableModel.getRow(imageInfo);
            this.imagesTableModel.fireTableRowsUpdated(imageRow, imageRow);
        }
    }
}

