/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.MultifileClassCodegenImpl;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegenImpl;
import org.jetbrains.kotlin.codegen.PackagePartRegistry;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J.\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J,\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCodegenFactory;", "Lorg/jetbrains/kotlin/codegen/CodegenFactory;", "()V", "createMultifileClassCodegen", "Lorg/jetbrains/kotlin/codegen/MultifileClassCodegenImpl;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "registry", "Lorg/jetbrains/kotlin/codegen/PackagePartRegistry;", "createPackageCodegen", "Lorg/jetbrains/kotlin/codegen/PackageCodegenImpl;", "generateModule", "", "errorHandler", "Lorg/jetbrains/kotlin/codegen/CompilationErrorHandler;", "generateMultifileClass", "multifileClassFqName", "handler", "generatePackage", "packageFqName", "jetFiles", "backend"})
public final class DefaultCodegenFactory
implements CodegenFactory {
    public static final DefaultCodegenFactory INSTANCE;

    @Override
    public void generateModule(@NotNull GenerationState state2, @NotNull Collection<? extends KtFile> files2, @NotNull CompilationErrorHandler errorHandler) {
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)errorHandler, (String)"errorHandler");
        MultiMap<FqName, KtFile> filesInPackages = new MultiMap<FqName, KtFile>();
        MultiMap<FqName, KtFile> filesInMultifileClasses = new MultiMap<FqName, KtFile>();
        for (KtFile ktFile : files2) {
            if (ktFile == null) {
                throw (Throwable)new IllegalArgumentException("A null file given for compilation");
            }
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(ktFile);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                filesInMultifileClasses.putValue(fileClassInfo.getFacadeClassFqName(), ktFile);
                continue;
            }
            filesInPackages.putValue(ktFile.getPackageFqName(), ktFile);
        }
        HashSet hashSet = new HashSet(state2.getObsoleteMultifileClasses());
        Set set = filesInMultifileClasses.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"filesInMultifileClasses.keySet()");
        for (FqName multifileClassFqName : SetsKt.plus(set, (Iterable)hashSet)) {
            CodegenFactory.Companion.doCheckCancelled(state2);
            FqName fqName2 = multifileClassFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"multifileClassFqName");
            Collection collection = filesInMultifileClasses.get(multifileClassFqName);
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"filesInMultifileClasses.get(multifileClassFqName)");
            this.generateMultifileClass(state2, fqName2, collection, errorHandler);
        }
        HashSet packagesWithObsoleteParts = new HashSet(state2.getPackagesWithObsoleteParts());
        Set set2 = packagesWithObsoleteParts;
        Set set3 = filesInPackages.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set3, (String)"filesInPackages.keySet()");
        for (FqName packageFqName : SetsKt.plus((Set)set2, (Iterable)set3)) {
            CodegenFactory.Companion.doCheckCancelled(state2);
            FqName fqName3 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"packageFqName");
            Collection collection = filesInPackages.get(packageFqName);
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"filesInPackages.get(packageFqName)");
            this.generatePackage(state2, fqName3, collection, errorHandler);
        }
    }

    @Override
    @NotNull
    public PackageCodegenImpl createPackageCodegen(@NotNull GenerationState state2, @NotNull Collection<? extends KtFile> files2, @NotNull FqName fqName2, @NotNull PackagePartRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        return new PackageCodegenImpl(state2, files2, fqName2, registry);
    }

    @Override
    @NotNull
    public MultifileClassCodegenImpl createMultifileClassCodegen(@NotNull GenerationState state2, @NotNull Collection<? extends KtFile> files2, @NotNull FqName fqName2, @NotNull PackagePartRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        return new MultifileClassCodegenImpl(state2, files2, fqName2, registry);
    }

    private final void generateMultifileClass(GenerationState state2, FqName multifileClassFqName, Collection<? extends KtFile> files2, CompilationErrorHandler handler2) {
        MultifileClassCodegen codegen = state2.getFactory().forMultifileClass(multifileClassFqName, files2);
        codegen.generate(handler2);
    }

    public final void generatePackage(@NotNull GenerationState state2, @NotNull FqName packageFqName, @NotNull Collection<? extends KtFile> jetFiles, @NotNull CompilationErrorHandler errorHandler) {
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull(jetFiles, (String)"jetFiles");
        Intrinsics.checkParameterIsNotNull((Object)errorHandler, (String)"errorHandler");
        PackageCodegen codegen = state2.getFactory().forPackage(packageFqName, jetFiles);
        codegen.generate(errorHandler);
    }

    private DefaultCodegenFactory() {
    }

    static {
        DefaultCodegenFactory defaultCodegenFactory;
        INSTANCE = defaultCodegenFactory = new DefaultCodegenFactory();
    }
}

