/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.configurer;

import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.ProjectPathRegistry;
import org.gradle.plugins.ide.internal.configurer.HierarchicalElementAdapter;
import org.gradle.plugins.ide.internal.configurer.HierarchicalElementDeduplicator;
import org.gradle.plugins.ide.internal.configurer.UniqueProjectNameProvider;
import org.gradle.util.Path;

public class DefaultUniqueProjectNameProvider
implements UniqueProjectNameProvider {
    private final ProjectPathRegistry projectRegistry;
    private Map<Path, String> deduplicated;

    public DefaultUniqueProjectNameProvider(ProjectPathRegistry projectRegistry) {
        this.projectRegistry = projectRegistry;
    }

    @Override
    public String getUniqueName(Project project) {
        String uniqueName = this.getDeduplicatedNames().get(((ProjectInternal)project).getIdentityPath());
        if (uniqueName != null) {
            return uniqueName;
        }
        return project.getName();
    }

    private synchronized Map<Path, String> getDeduplicatedNames() {
        if (this.deduplicated == null) {
            HierarchicalElementDeduplicator<Path> deduplicator = new HierarchicalElementDeduplicator<Path>(new ProjectPathDeduplicationAdapter());
            this.deduplicated = deduplicator.deduplicate(this.projectRegistry.getAllProjectPaths());
        }
        return this.deduplicated;
    }

    private class ProjectPathDeduplicationAdapter
    implements HierarchicalElementAdapter<Path> {
        private ProjectPathDeduplicationAdapter() {
        }

        @Override
        public String getName(Path element) {
            if (element == Path.ROOT) {
                return DefaultUniqueProjectNameProvider.this.projectRegistry.getProjectName(element);
            }
            return element.getName();
        }

        @Override
        public Path getParent(Path element) {
            return element.getParent();
        }
    }
}

