/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentIdResolveResult;

class SelectorState
implements DependencyGraphSelector {
    private static final VersionSelectorScheme VERSION_SELECTOR_SCHEME = new DefaultVersionSelectorScheme(new DefaultVersionComparator());
    private final Long id;
    private final DependencyState dependencyState;
    private final DependencyMetadata dependencyMetadata;
    private final DependencyToComponentIdResolver resolver;
    private final ResolvedVersionConstraint versionConstraint;
    private ComponentIdResolveResult idResolveResult;
    private ModuleVersionResolveException failure;
    private ComponentSelectionReasonInternal failureSelectionReason;
    private ModuleResolveState targetModule;
    ComponentState selected;

    SelectorState(Long id, DependencyState dependencyState, DependencyToComponentIdResolver resolver, ResolveState resolveState, ModuleIdentifier targetModuleId) {
        this.id = id;
        this.dependencyState = dependencyState;
        this.dependencyMetadata = dependencyState.getDependency();
        this.resolver = resolver;
        this.targetModule = resolveState.getModule(targetModuleId);
        this.versionConstraint = this.resolveVersionConstraint(this.dependencyMetadata.getSelector());
        this.targetModule.addSelector(this);
    }

    private ResolvedVersionConstraint resolveVersionConstraint(ComponentSelector selector) {
        if (selector instanceof ModuleComponentSelector) {
            return new DefaultResolvedVersionConstraint(((ModuleComponentSelector)selector).getVersionConstraint(), VERSION_SELECTOR_SCHEME);
        }
        return null;
    }

    @Override
    public Long getResultId() {
        return this.id;
    }

    public String toString() {
        return this.dependencyMetadata.toString();
    }

    @Override
    public ComponentSelector getRequested() {
        return this.dependencyState.getRequested();
    }

    public ModuleResolveState getTargetModule() {
        return this.targetModule;
    }

    ModuleVersionResolveException getFailure() {
        return this.failure != null ? this.failure : this.selected.getFailure();
    }

    public ComponentState getSelected() {
        return this.targetModule.getSelected();
    }

    public ComponentIdResolveResult resolve() {
        if (this.idResolveResult != null) {
            return this.idResolveResult;
        }
        DefaultBuildableComponentIdResolveResult idResolveResult = new DefaultBuildableComponentIdResolveResult();
        if (this.dependencyState.failure != null) {
            idResolveResult.failed(this.dependencyState.failure);
        } else {
            this.resolver.resolve(this.dependencyMetadata, this.versionConstraint, idResolveResult);
        }
        if (idResolveResult.getFailure() != null) {
            this.failure = idResolveResult.getFailure();
            this.failureSelectionReason = this.getReasonForSelector();
        }
        this.idResolveResult = idResolveResult;
        return idResolveResult;
    }

    public void select(ComponentState selected) {
        selected.selectedBy(this);
        ComponentSelectionDescriptorInternal selectionDescriptor = this.selectionDescriptionForDependency(this.dependencyMetadata);
        selected.addCause(selectionDescriptor);
        if (this.dependencyState.getRuleDescriptor() != null) {
            selected.addCause(this.dependencyState.getRuleDescriptor());
        }
        this.selected = selected;
    }

    private ComponentSelectionDescriptorInternal selectionDescriptionForDependency(DependencyMetadata dependencyMetadata) {
        ComponentSelectionDescriptorInternal selectionDescriptor;
        ComponentSelectionDescriptorInternal componentSelectionDescriptorInternal = selectionDescriptor = dependencyMetadata.isPending() ? VersionSelectionReasons.CONSTRAINT : VersionSelectionReasons.REQUESTED;
        if (dependencyMetadata.getReason() != null) {
            selectionDescriptor = selectionDescriptor.withReason(dependencyMetadata.getReason());
        }
        return selectionDescriptor;
    }

    public ComponentSelectionReason getSelectionReason() {
        if (this.selected != null) {
            return this.selected.getSelectionReason();
        }
        assert (this.failure != null);
        assert (this.failureSelectionReason != null);
        return this.failureSelectionReason;
    }

    public ComponentSelectionReasonInternal getReasonForSelector() {
        ArrayList descriptors = Lists.newArrayListWithCapacity((int)2);
        descriptors.add(this.selectionDescriptionForDependency(this.dependencyMetadata));
        if (this.dependencyState.getRuleDescriptor() != null) {
            descriptors.add(this.dependencyState.getRuleDescriptor());
        }
        return VersionSelectionReasons.of(descriptors);
    }

    public void overrideSelection(ComponentState selectedComponent) {
        if (this.selected == null) {
            return;
        }
        this.selected = selectedComponent;
        this.targetModule = selectedComponent.getModule();
    }

    public DependencyMetadata getDependencyMetadata() {
        return this.dependencyMetadata;
    }

    public ResolvedVersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }
}

