/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.attributes.DefaultImmutableAttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.changedetection.state.isolation.IsolatableFactory;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.model.DefaultObjectFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.model.ObjectFactory;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.util.DeprecationLogger;

public class JavaLibrary
implements SoftwareComponentInternal {
    private static final ObjectFactory DEPRECATED_OBJECT_FACTORY = new DefaultObjectFactory(DirectInstantiator.INSTANCE, NamedObjectInstantiator.INSTANCE);
    private final Set<PublishArtifact> artifacts = new LinkedHashSet<PublishArtifact>();
    private final UsageContext runtimeUsage;
    private final UsageContext compileUsage;
    private final ConfigurationContainer configurations;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;

    @Inject
    public JavaLibrary(ObjectFactory objectFactory, ConfigurationContainer configurations, ImmutableAttributesFactory attributesFactory, PublishArtifact artifact) {
        this.configurations = configurations;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.runtimeUsage = new RuntimeUsageContext("java-runtime");
        this.compileUsage = new CompileUsageContext("java-api");
        if (artifact != null) {
            this.artifacts.add(artifact);
        }
    }

    @Deprecated
    public JavaLibrary(PublishArtifact jarArtifact, DependencySet runtimeDependencies) {
        DeprecationLogger.nagUserOfDeprecatedThing((String)"A constructor for `org.gradle.api.internal.java.JavaLibrary` is used by Shadow plugin v1.2.x, and has been preserved for compatibility", (String)"If you're using the Shadow plugin, try upgrading to v2.x");
        this.artifacts.add(jarArtifact);
        this.objectFactory = DEPRECATED_OBJECT_FACTORY;
        this.attributesFactory = new DefaultImmutableAttributesFactory((IsolatableFactory)new BackwardsCompatibilityIsolatableFactory(), NamedObjectInstantiator.INSTANCE);
        this.runtimeUsage = new BackwardsCompatibilityUsageContext("java-runtime", runtimeDependencies);
        this.compileUsage = new BackwardsCompatibilityUsageContext("java-api", runtimeDependencies);
        this.configurations = null;
    }

    @VisibleForTesting
    Set<PublishArtifact> getArtifacts() {
        return this.artifacts;
    }

    public String getName() {
        return "java";
    }

    public Set<UsageContext> getUsages() {
        return ImmutableSet.of((Object)this.runtimeUsage, (Object)this.compileUsage);
    }

    private static class BackwardsCompatibilityIsolatableFactory
    implements IsolatableFactory {
        private BackwardsCompatibilityIsolatableFactory() {
        }

        public <T> Isolatable<T> isolate(final T value) {
            return new Isolatable<T>(){

                public T isolate() {
                    return value;
                }

                @Nullable
                public <S> Isolatable<S> coerce(Class<S> type) {
                    return null;
                }

                public void appendToHasher(BuildCacheHasher hasher) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class BackwardsCompatibilityUsageContext
    extends AbstractUsageContext {
        private final DependencySet runtimeDependencies;

        private BackwardsCompatibilityUsageContext(String usageName, DependencySet runtimeDependencies) {
            super(usageName);
            this.runtimeDependencies = runtimeDependencies;
        }

        public String getName() {
            return this.getUsage().getName();
        }

        public Set<ModuleDependency> getDependencies() {
            return this.runtimeDependencies.withType(ModuleDependency.class);
        }

        public Set<? extends DependencyConstraint> getDependencyConstraints() {
            return Collections.emptySet();
        }

        public Set<? extends Capability> getCapabilities() {
            return Collections.emptySet();
        }
    }

    private class CompileUsageContext
    extends AbstractUsageContext {
        private DomainObjectSet<ModuleDependency> dependencies;
        private DomainObjectSet<DependencyConstraint> dependencyConstraints;
        private Set<? extends Capability> capabilities;

        CompileUsageContext(String usageName) {
            super(usageName);
        }

        public String getName() {
            return "api";
        }

        public Set<ModuleDependency> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = JavaLibrary.this.configurations.getByName("apiElements").getIncoming().getDependencies().withType(ModuleDependency.class);
            }
            return this.dependencies;
        }

        public Set<? extends DependencyConstraint> getDependencyConstraints() {
            if (this.dependencyConstraints == null) {
                this.dependencyConstraints = JavaLibrary.this.configurations.getByName("apiElements").getIncoming().getDependencyConstraints();
            }
            return this.dependencyConstraints;
        }

        public Set<? extends Capability> getCapabilities() {
            if (this.capabilities == null) {
                this.capabilities = ImmutableSet.copyOf((Collection)Configurations.collectCapabilities((Configuration)JavaLibrary.this.configurations.getByName("apiElements"), (Set)Sets.newHashSet(), (Set)Sets.newHashSet()));
            }
            return this.capabilities;
        }
    }

    private class RuntimeUsageContext
    extends AbstractUsageContext {
        private DomainObjectSet<ModuleDependency> dependencies;
        private DomainObjectSet<DependencyConstraint> dependencyConstraints;
        private Set<? extends Capability> capabilities;

        RuntimeUsageContext(String usageName) {
            super(usageName);
        }

        public String getName() {
            return "runtime";
        }

        public Set<ModuleDependency> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = JavaLibrary.this.configurations.getByName("runtimeElements").getIncoming().getDependencies().withType(ModuleDependency.class);
            }
            return this.dependencies;
        }

        public Set<? extends DependencyConstraint> getDependencyConstraints() {
            if (this.dependencyConstraints == null) {
                this.dependencyConstraints = JavaLibrary.this.configurations.getByName("runtimeElements").getIncoming().getDependencyConstraints();
            }
            return this.dependencyConstraints;
        }

        public Set<? extends Capability> getCapabilities() {
            if (this.capabilities == null) {
                this.capabilities = ImmutableSet.copyOf((Collection)Configurations.collectCapabilities((Configuration)JavaLibrary.this.configurations.getByName("runtimeElements"), (Set)Sets.newHashSet(), (Set)Sets.newHashSet()));
            }
            return this.capabilities;
        }
    }

    private abstract class AbstractUsageContext
    implements UsageContext {
        private final Usage usage;
        private final ImmutableAttributes attributes;

        AbstractUsageContext(String usageName) {
            this.usage = (Usage)JavaLibrary.this.objectFactory.named(Usage.class, usageName);
            this.attributes = JavaLibrary.this.attributesFactory.of(Usage.USAGE_ATTRIBUTE, (Object)this.usage);
        }

        public AttributeContainer getAttributes() {
            return this.attributes;
        }

        public Usage getUsage() {
            return this.usage;
        }

        public Set<PublishArtifact> getArtifacts() {
            return JavaLibrary.this.artifacts;
        }
    }
}

