/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.StartParameter;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.invocation.GradleBuildController;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InProcessBuildActionExecuter
implements BuildActionExecuter<BuildActionParameters> {
    private final BuildActionRunner buildActionRunner;

    public InProcessBuildActionExecuter(BuildActionRunner buildActionRunner) {
        this.buildActionRunner = buildActionRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(BuildAction action, BuildRequestContext buildRequestContext, BuildActionParameters actionParameters, ServiceRegistry contextServices) {
        GradleLauncherFactory gradleLauncherFactory = contextServices.get(GradleLauncherFactory.class);
        GradleLauncher gradleLauncher = gradleLauncherFactory.newInstance((StartParameter)action.getStartParameter(), buildRequestContext, contextServices);
        GradleBuildController buildController = new GradleBuildController(gradleLauncher);
        this.checkDeprecations(action.getStartParameter());
        try {
            Object object;
            RootBuildLifecycleListener buildLifecycleListener = (RootBuildLifecycleListener)contextServices.get(ListenerManager.class).getBroadcaster(RootBuildLifecycleListener.class);
            buildLifecycleListener.afterStart();
            try {
                this.buildActionRunner.run(action, (BuildController)buildController);
                object = buildController.getResult();
            }
            catch (Throwable throwable) {
                buildLifecycleListener.beforeComplete();
                throw throwable;
            }
            buildLifecycleListener.beforeComplete();
            return object;
        }
        finally {
            buildController.stop();
        }
    }

    private void checkDeprecations(StartParameterInternal startParameter) {
        UnsupportedJavaRuntimeException.javaDeprecationWarning();
        startParameter.checkDeprecation();
    }
}

