/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.ssl.CipherBox;
import sun.security.ssl.Debug;
import sun.security.ssl.JsseJce;
import sun.security.ssl.MAC;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SunJSSE;

final class CipherSuite
implements Comparable<CipherSuite> {
    static final int SUPPORTED_SUITES_PRIORITY = 1;
    static final int DEFAULT_SUITES_PRIORITY = 300;
    static final boolean DYNAMIC_AVAILABILITY = true;
    private static final boolean ALLOW_ECC = Debug.getBooleanProperty("com.sun.net.ssl.enableECC", true);
    private static final boolean PRESERVE_RC4 = Debug.getBooleanProperty("jdk.tls.preserveRC4CipherSuites", false);
    private static final Map<Integer, CipherSuite> idMap;
    private static final Map<String, CipherSuite> nameMap;
    final String name;
    final int id;
    final int priority;
    final KeyExchange keyExchange;
    final BulkCipher cipher;
    final MacAlg macAlg;
    final PRF prfAlg;
    final boolean exportable;
    final boolean allowed;
    final int obsoleted;
    final int supported;
    static final BulkCipher B_NULL;
    static final BulkCipher B_RC4_40;
    static final BulkCipher B_RC2_40;
    static final BulkCipher B_DES_40;
    static final BulkCipher B_RC4_128;
    static final BulkCipher B_DES;
    static final BulkCipher B_3DES;
    static final BulkCipher B_IDEA;
    static final BulkCipher B_AES_128;
    static final BulkCipher B_AES_256;
    static final MacAlg M_NULL;
    static final MacAlg M_MD5;
    static final MacAlg M_SHA;
    static final MacAlg M_SHA256;
    static final MacAlg M_SHA384;
    static final CipherSuite C_NULL;
    static final CipherSuite C_SCSV;

    private CipherSuite(String name, int id, int priority, KeyExchange keyExchange, BulkCipher cipher, boolean allowed, int obsoleted, int supported, PRF prfAlg) {
        this.name = name;
        this.id = id;
        this.priority = priority;
        this.keyExchange = keyExchange;
        this.cipher = cipher;
        this.exportable = cipher.exportable;
        if (name.endsWith("_MD5")) {
            this.macAlg = M_MD5;
        } else if (name.endsWith("_SHA")) {
            this.macAlg = M_SHA;
        } else if (name.endsWith("_SHA256")) {
            this.macAlg = M_SHA256;
        } else if (name.endsWith("_SHA384")) {
            this.macAlg = M_SHA384;
        } else if (name.endsWith("_NULL")) {
            this.macAlg = M_NULL;
        } else if (name.endsWith("_SCSV")) {
            this.macAlg = M_NULL;
        } else {
            throw new IllegalArgumentException("Unknown MAC algorithm for ciphersuite " + name);
        }
        allowed &= keyExchange.allowed;
        this.allowed = allowed &= cipher.allowed;
        this.obsoleted = obsoleted;
        this.supported = supported;
        this.prfAlg = prfAlg;
    }

    private CipherSuite(String name, int id) {
        this.name = name;
        this.id = id;
        this.allowed = false;
        this.priority = 0;
        this.keyExchange = null;
        this.cipher = null;
        this.macAlg = null;
        this.exportable = false;
        this.obsoleted = 65535;
        this.supported = 0;
        this.prfAlg = PRF.P_NONE;
    }

    boolean isAvailable() {
        return this.allowed && this.keyExchange.isAvailable() && this.cipher.isAvailable();
    }

    boolean isNegotiable() {
        return this != C_SCSV && this.isAvailable();
    }

    @Override
    public int compareTo(CipherSuite o) {
        return o.priority - this.priority;
    }

    public String toString() {
        return this.name;
    }

    static CipherSuite valueOf(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        CipherSuite c = nameMap.get(s);
        if (c == null || !c.allowed) {
            throw new IllegalArgumentException("Unsupported ciphersuite " + s);
        }
        return c;
    }

    static CipherSuite valueOf(int id1, int id2) {
        int id = (id1 &= 0xFF) << 8 | (id2 &= 0xFF);
        CipherSuite c = idMap.get(id);
        if (c == null) {
            String h1 = Integer.toString(id1, 16);
            String h2 = Integer.toString(id2, 16);
            c = new CipherSuite("Unknown 0x" + h1 + ":0x" + h2, id);
        }
        return c;
    }

    static Collection<CipherSuite> allowedCipherSuites() {
        return nameMap.values();
    }

    private static void add(String name, int id, int priority, KeyExchange keyExchange, BulkCipher cipher, boolean allowed, int obsoleted, int supported, PRF prf) {
        CipherSuite c = new CipherSuite(name, id, priority, keyExchange, cipher, allowed, obsoleted, supported, prf);
        if (idMap.put(id, c) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + id + ", " + name);
        }
        if (c.allowed && nameMap.put(name, c) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + id + ", " + name);
        }
    }

    private static void add(String name, int id, int priority, KeyExchange keyExchange, BulkCipher cipher, boolean allowed, int obsoleted) {
        PRF prf = PRF.P_SHA256;
        if (obsoleted < ProtocolVersion.TLS12.v) {
            prf = PRF.P_NONE;
        }
        CipherSuite.add(name, id, priority, keyExchange, cipher, allowed, obsoleted, 0, prf);
    }

    private static void add(String name, int id, int priority, KeyExchange keyExchange, BulkCipher cipher, boolean allowed) {
        CipherSuite.add(name, id, priority, keyExchange, cipher, allowed, 65535);
    }

    private static void add(String name, int id) {
        CipherSuite c = new CipherSuite(name, id);
        if (idMap.put(id, c) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + id + ", " + name);
        }
    }

    static /* synthetic */ boolean access$000() {
        return ALLOW_ECC;
    }

    static {
        B_NULL = new BulkCipher("NULL", 0, 0, 0, true);
        B_RC4_40 = new BulkCipher("RC4", 5, 16, 0, true);
        B_RC2_40 = new BulkCipher("RC2", 5, 16, 8, false);
        B_DES_40 = new BulkCipher("DES/CBC/NoPadding", 5, 8, 8, true);
        B_RC4_128 = new BulkCipher("RC4", 16, 0, true);
        B_DES = new BulkCipher("DES/CBC/NoPadding", 8, 8, true);
        B_3DES = new BulkCipher("DESede/CBC/NoPadding", 24, 8, true);
        B_IDEA = new BulkCipher("IDEA", 16, 8, false);
        B_AES_128 = new BulkCipher("AES/CBC/NoPadding", 16, 16, true);
        B_AES_256 = new BulkCipher("AES/CBC/NoPadding", 32, 16, true);
        M_NULL = new MacAlg("NULL", 0, 0, 0);
        M_MD5 = new MacAlg("MD5", 16, 64, 9);
        M_SHA = new MacAlg("SHA", 20, 64, 9);
        M_SHA256 = new MacAlg("SHA256", 32, 64, 9);
        M_SHA384 = new MacAlg("SHA384", 48, 128, 17);
        idMap = new HashMap<Integer, CipherSuite>();
        nameMap = new HashMap<String, CipherSuite>();
        boolean F = false;
        boolean T = true;
        boolean N = !SunJSSE.isFIPS();
        CipherSuite.add("SSL_NULL_WITH_NULL_NULL", 0, 1, KeyExchange.K_NULL, B_NULL, false);
        int p = 600;
        int max = 65535;
        int tls11 = ProtocolVersion.TLS11.v;
        int tls12 = ProtocolVersion.TLS12.v;
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 49188, --p, KeyExchange.K_ECDHE_ECDSA, B_AES_256, true, max, tls12, PRF.P_SHA384);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 49192, --p, KeyExchange.K_ECDHE_RSA, B_AES_256, true, max, tls12, PRF.P_SHA384);
        CipherSuite.add("TLS_RSA_WITH_AES_256_CBC_SHA256", 61, --p, KeyExchange.K_RSA, B_AES_256, true, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", 49190, --p, KeyExchange.K_ECDH_ECDSA, B_AES_256, true, max, tls12, PRF.P_SHA384);
        CipherSuite.add("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", 49194, --p, KeyExchange.K_ECDH_RSA, B_AES_256, true, max, tls12, PRF.P_SHA384);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", 107, --p, KeyExchange.K_DHE_RSA, B_AES_256, true, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", 106, --p, KeyExchange.K_DHE_DSS, B_AES_256, true, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", 49162, --p, KeyExchange.K_ECDHE_ECDSA, B_AES_256, true);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", 49172, --p, KeyExchange.K_ECDHE_RSA, B_AES_256, true);
        CipherSuite.add("TLS_RSA_WITH_AES_256_CBC_SHA", 53, --p, KeyExchange.K_RSA, B_AES_256, true);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", 49157, --p, KeyExchange.K_ECDH_ECDSA, B_AES_256, true);
        CipherSuite.add("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", 49167, --p, KeyExchange.K_ECDH_RSA, B_AES_256, true);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", 57, --p, KeyExchange.K_DHE_RSA, B_AES_256, true);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", 56, --p, KeyExchange.K_DHE_DSS, B_AES_256, true);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 49187, --p, KeyExchange.K_ECDHE_ECDSA, B_AES_128, true, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 49191, --p, KeyExchange.K_ECDHE_RSA, B_AES_128, true, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_RSA_WITH_AES_128_CBC_SHA256", 60, --p, KeyExchange.K_RSA, B_AES_128, true, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", 49189, --p, KeyExchange.K_ECDH_ECDSA, B_AES_128, true, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", 49193, --p, KeyExchange.K_ECDH_RSA, B_AES_128, true, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", 103, --p, KeyExchange.K_DHE_RSA, B_AES_128, true, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", 64, --p, KeyExchange.K_DHE_DSS, B_AES_128, true, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 49161, --p, KeyExchange.K_ECDHE_ECDSA, B_AES_128, true);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", 49171, --p, KeyExchange.K_ECDHE_RSA, B_AES_128, true);
        CipherSuite.add("TLS_RSA_WITH_AES_128_CBC_SHA", 47, --p, KeyExchange.K_RSA, B_AES_128, true);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", 49156, --p, KeyExchange.K_ECDH_ECDSA, B_AES_128, true);
        CipherSuite.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", 49166, --p, KeyExchange.K_ECDH_RSA, B_AES_128, true);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", 51, --p, KeyExchange.K_DHE_RSA, B_AES_128, true);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", 50, --p, KeyExchange.K_DHE_DSS, B_AES_128, true);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", 49160, --p, KeyExchange.K_ECDHE_ECDSA, B_3DES, true);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", 49170, --p, KeyExchange.K_ECDHE_RSA, B_3DES, true);
        CipherSuite.add("SSL_RSA_WITH_3DES_EDE_CBC_SHA", 10, --p, KeyExchange.K_RSA, B_3DES, true);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", 49155, --p, KeyExchange.K_ECDH_ECDSA, B_3DES, true);
        CipherSuite.add("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", 49165, --p, KeyExchange.K_ECDH_RSA, B_3DES, true);
        CipherSuite.add("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 22, --p, KeyExchange.K_DHE_RSA, B_3DES, true);
        CipherSuite.add("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19, --p, KeyExchange.K_DHE_DSS, B_3DES, N);
        CipherSuite.add("TLS_EMPTY_RENEGOTIATION_INFO_SCSV", 255, --p, KeyExchange.K_SCSV, B_NULL, true);
        p = 300;
        CipherSuite.add("TLS_DH_anon_WITH_AES_256_CBC_SHA256", 109, --p, KeyExchange.K_DH_ANON, B_AES_256, N, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDH_anon_WITH_AES_256_CBC_SHA", 49177, --p, KeyExchange.K_ECDH_ANON, B_AES_256, true);
        CipherSuite.add("TLS_DH_anon_WITH_AES_256_CBC_SHA", 58, --p, KeyExchange.K_DH_ANON, B_AES_256, N);
        CipherSuite.add("TLS_DH_anon_WITH_AES_128_CBC_SHA256", 108, --p, KeyExchange.K_DH_ANON, B_AES_128, N, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDH_anon_WITH_AES_128_CBC_SHA", 49176, --p, KeyExchange.K_ECDH_ANON, B_AES_128, true);
        CipherSuite.add("TLS_DH_anon_WITH_AES_128_CBC_SHA", 52, --p, KeyExchange.K_DH_ANON, B_AES_128, N);
        if (!PRESERVE_RC4) {
            CipherSuite.add("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", 49175, --p, KeyExchange.K_ECDH_ANON, B_3DES, true);
            CipherSuite.add("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", 27, --p, KeyExchange.K_DH_ANON, B_3DES, N);
        }
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", 49159, --p, KeyExchange.K_ECDHE_ECDSA, B_RC4_128, N);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_RC4_128_SHA", 49169, --p, KeyExchange.K_ECDHE_RSA, B_RC4_128, N);
        CipherSuite.add("SSL_RSA_WITH_RC4_128_SHA", 5, --p, KeyExchange.K_RSA, B_RC4_128, N);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_RC4_128_SHA", 49154, --p, KeyExchange.K_ECDH_ECDSA, B_RC4_128, N);
        CipherSuite.add("TLS_ECDH_RSA_WITH_RC4_128_SHA", 49164, --p, KeyExchange.K_ECDH_RSA, B_RC4_128, N);
        CipherSuite.add("SSL_RSA_WITH_RC4_128_MD5", 4, --p, KeyExchange.K_RSA, B_RC4_128, N);
        CipherSuite.add("TLS_ECDH_anon_WITH_RC4_128_SHA", 49174, --p, KeyExchange.K_ECDH_ANON, B_RC4_128, N);
        CipherSuite.add("SSL_DH_anon_WITH_RC4_128_MD5", 24, --p, KeyExchange.K_DH_ANON, B_RC4_128, N);
        if (!PRESERVE_RC4) {
            CipherSuite.add("SSL_RSA_WITH_DES_CBC_SHA", 9, --p, KeyExchange.K_RSA, B_DES, N, tls12);
            CipherSuite.add("SSL_DHE_RSA_WITH_DES_CBC_SHA", 21, --p, KeyExchange.K_DHE_RSA, B_DES, N, tls12);
            CipherSuite.add("SSL_DHE_DSS_WITH_DES_CBC_SHA", 18, --p, KeyExchange.K_DHE_DSS, B_DES, N, tls12);
            CipherSuite.add("SSL_DH_anon_WITH_DES_CBC_SHA", 26, --p, KeyExchange.K_DH_ANON, B_DES, N, tls12);
            CipherSuite.add("SSL_RSA_EXPORT_WITH_RC4_40_MD5", 3, --p, KeyExchange.K_RSA_EXPORT, B_RC4_40, N, tls11);
            CipherSuite.add("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", 23, --p, KeyExchange.K_DH_ANON, B_RC4_40, N, tls11);
            CipherSuite.add("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", 8, --p, KeyExchange.K_RSA_EXPORT, B_DES_40, N, tls11);
            CipherSuite.add("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", 20, --p, KeyExchange.K_DHE_RSA, B_DES_40, N, tls11);
            CipherSuite.add("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", 17, --p, KeyExchange.K_DHE_DSS, B_DES_40, N, tls11);
            CipherSuite.add("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", 25, --p, KeyExchange.K_DH_ANON, B_DES_40, N, tls11);
        }
        if (PRESERVE_RC4) {
            CipherSuite.add("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", 49175, --p, KeyExchange.K_ECDH_ANON, B_3DES, true);
            CipherSuite.add("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", 27, --p, KeyExchange.K_DH_ANON, B_3DES, N);
        }
        CipherSuite.add("TLS_RSA_WITH_NULL_SHA256", 59, --p, KeyExchange.K_RSA, B_NULL, N, max, tls12, PRF.P_SHA256);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_NULL_SHA", 49158, --p, KeyExchange.K_ECDHE_ECDSA, B_NULL, N);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_NULL_SHA", 49168, --p, KeyExchange.K_ECDHE_RSA, B_NULL, N);
        CipherSuite.add("SSL_RSA_WITH_NULL_SHA", 2, --p, KeyExchange.K_RSA, B_NULL, N);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_NULL_SHA", 49153, --p, KeyExchange.K_ECDH_ECDSA, B_NULL, N);
        CipherSuite.add("TLS_ECDH_RSA_WITH_NULL_SHA", 49163, --p, KeyExchange.K_ECDH_RSA, B_NULL, N);
        CipherSuite.add("TLS_ECDH_anon_WITH_NULL_SHA", 49173, --p, KeyExchange.K_ECDH_ANON, B_NULL, N);
        CipherSuite.add("SSL_RSA_WITH_NULL_MD5", 1, --p, KeyExchange.K_RSA, B_NULL, N);
        if (PRESERVE_RC4) {
            CipherSuite.add("SSL_RSA_WITH_DES_CBC_SHA", 9, --p, KeyExchange.K_RSA, B_DES, N, tls12);
            CipherSuite.add("SSL_DHE_RSA_WITH_DES_CBC_SHA", 21, --p, KeyExchange.K_DHE_RSA, B_DES, N, tls12);
            CipherSuite.add("SSL_DHE_DSS_WITH_DES_CBC_SHA", 18, --p, KeyExchange.K_DHE_DSS, B_DES, N, tls12);
            CipherSuite.add("SSL_DH_anon_WITH_DES_CBC_SHA", 26, --p, KeyExchange.K_DH_ANON, B_DES, N, tls12);
            CipherSuite.add("SSL_RSA_EXPORT_WITH_RC4_40_MD5", 3, --p, KeyExchange.K_RSA_EXPORT, B_RC4_40, N, tls11);
            CipherSuite.add("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", 23, --p, KeyExchange.K_DH_ANON, B_RC4_40, N, tls11);
            CipherSuite.add("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", 8, --p, KeyExchange.K_RSA_EXPORT, B_DES_40, N, tls11);
            CipherSuite.add("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", 20, --p, KeyExchange.K_DHE_RSA, B_DES_40, N, tls11);
            CipherSuite.add("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", 17, --p, KeyExchange.K_DHE_DSS, B_DES_40, N, tls11);
            CipherSuite.add("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", 25, --p, KeyExchange.K_DH_ANON, B_DES_40, N, tls11);
        }
        if (!PRESERVE_RC4) {
            CipherSuite.add("TLS_KRB5_WITH_3DES_EDE_CBC_SHA", 31, --p, KeyExchange.K_KRB5, B_3DES, N);
            CipherSuite.add("TLS_KRB5_WITH_3DES_EDE_CBC_MD5", 35, --p, KeyExchange.K_KRB5, B_3DES, N);
        }
        CipherSuite.add("TLS_KRB5_WITH_RC4_128_SHA", 32, --p, KeyExchange.K_KRB5, B_RC4_128, N);
        CipherSuite.add("TLS_KRB5_WITH_RC4_128_MD5", 36, --p, KeyExchange.K_KRB5, B_RC4_128, N);
        if (PRESERVE_RC4) {
            CipherSuite.add("TLS_KRB5_WITH_3DES_EDE_CBC_SHA", 31, --p, KeyExchange.K_KRB5, B_3DES, N);
            CipherSuite.add("TLS_KRB5_WITH_3DES_EDE_CBC_MD5", 35, --p, KeyExchange.K_KRB5, B_3DES, N);
        }
        CipherSuite.add("TLS_KRB5_WITH_DES_CBC_SHA", 30, --p, KeyExchange.K_KRB5, B_DES, N, tls12);
        CipherSuite.add("TLS_KRB5_WITH_DES_CBC_MD5", 34, --p, KeyExchange.K_KRB5, B_DES, N, tls12);
        if (!PRESERVE_RC4) {
            CipherSuite.add("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", 38, --p, KeyExchange.K_KRB5_EXPORT, B_DES_40, N, tls11);
            CipherSuite.add("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", 41, --p, KeyExchange.K_KRB5_EXPORT, B_DES_40, N, tls11);
        }
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_RC4_40_SHA", 40, --p, KeyExchange.K_KRB5_EXPORT, B_RC4_40, N, tls11);
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_RC4_40_MD5", 43, --p, KeyExchange.K_KRB5_EXPORT, B_RC4_40, N, tls11);
        if (PRESERVE_RC4) {
            CipherSuite.add("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", 38, --p, KeyExchange.K_KRB5_EXPORT, B_DES_40, N, tls11);
            CipherSuite.add("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", 41, --p, KeyExchange.K_KRB5_EXPORT, B_DES_40, N, tls11);
        }
        CipherSuite.add("SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", 6);
        CipherSuite.add("SSL_RSA_WITH_IDEA_CBC_SHA", 7);
        CipherSuite.add("SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", 11);
        CipherSuite.add("SSL_DH_DSS_WITH_DES_CBC_SHA", 12);
        CipherSuite.add("SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA", 13);
        CipherSuite.add("SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", 14);
        CipherSuite.add("SSL_DH_RSA_WITH_DES_CBC_SHA", 15);
        CipherSuite.add("SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA", 16);
        CipherSuite.add("SSL_FORTEZZA_DMS_WITH_NULL_SHA", 28);
        CipherSuite.add("SSL_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA", 29);
        CipherSuite.add("SSL_RSA_EXPORT1024_WITH_DES_CBC_SHA", 98);
        CipherSuite.add("SSL_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA", 99);
        CipherSuite.add("SSL_RSA_EXPORT1024_WITH_RC4_56_SHA", 100);
        CipherSuite.add("SSL_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA", 101);
        CipherSuite.add("SSL_DHE_DSS_WITH_RC4_128_SHA", 102);
        CipherSuite.add("NETSCAPE_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", 65504);
        CipherSuite.add("NETSCAPE_RSA_FIPS_WITH_DES_CBC_SHA", 65505);
        CipherSuite.add("SSL_RSA_FIPS_WITH_DES_CBC_SHA", 65278);
        CipherSuite.add("SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", 65279);
        CipherSuite.add("TLS_KRB5_WITH_IDEA_CBC_SHA", 33);
        CipherSuite.add("TLS_KRB5_WITH_IDEA_CBC_MD5", 37);
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA", 39);
        CipherSuite.add("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5", 42);
        CipherSuite.add("TLS_RSA_WITH_SEED_CBC_SHA", 150);
        CipherSuite.add("TLS_DH_DSS_WITH_SEED_CBC_SHA", 151);
        CipherSuite.add("TLS_DH_RSA_WITH_SEED_CBC_SHA", 152);
        CipherSuite.add("TLS_DHE_DSS_WITH_SEED_CBC_SHA", 153);
        CipherSuite.add("TLS_DHE_RSA_WITH_SEED_CBC_SHA", 154);
        CipherSuite.add("TLS_DH_anon_WITH_SEED_CBC_SHA", 155);
        CipherSuite.add("TLS_PSK_WITH_RC4_128_SHA", 138);
        CipherSuite.add("TLS_PSK_WITH_3DES_EDE_CBC_SHA", 139);
        CipherSuite.add("TLS_PSK_WITH_AES_128_CBC_SHA", 140);
        CipherSuite.add("TLS_PSK_WITH_AES_256_CBC_SHA", 141);
        CipherSuite.add("TLS_DHE_PSK_WITH_RC4_128_SHA", 142);
        CipherSuite.add("TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA", 143);
        CipherSuite.add("TLS_DHE_PSK_WITH_AES_128_CBC_SHA", 144);
        CipherSuite.add("TLS_DHE_PSK_WITH_AES_256_CBC_SHA", 145);
        CipherSuite.add("TLS_RSA_PSK_WITH_RC4_128_SHA", 146);
        CipherSuite.add("TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA", 147);
        CipherSuite.add("TLS_RSA_PSK_WITH_AES_128_CBC_SHA", 148);
        CipherSuite.add("TLS_RSA_PSK_WITH_AES_256_CBC_SHA", 149);
        CipherSuite.add("TLS_PSK_WITH_NULL_SHA", 44);
        CipherSuite.add("TLS_DHE_PSK_WITH_NULL_SHA", 45);
        CipherSuite.add("TLS_RSA_PSK_WITH_NULL_SHA", 46);
        CipherSuite.add("TLS_DH_DSS_WITH_AES_128_CBC_SHA", 48);
        CipherSuite.add("TLS_DH_RSA_WITH_AES_128_CBC_SHA", 49);
        CipherSuite.add("TLS_DH_DSS_WITH_AES_256_CBC_SHA", 54);
        CipherSuite.add("TLS_DH_RSA_WITH_AES_256_CBC_SHA", 55);
        CipherSuite.add("TLS_DH_DSS_WITH_AES_128_CBC_SHA256", 62);
        CipherSuite.add("TLS_DH_RSA_WITH_AES_128_CBC_SHA256", 63);
        CipherSuite.add("TLS_DH_DSS_WITH_AES_256_CBC_SHA256", 104);
        CipherSuite.add("TLS_DH_RSA_WITH_AES_256_CBC_SHA256", 105);
        CipherSuite.add("TLS_RSA_WITH_AES_128_GCM_SHA256", 156);
        CipherSuite.add("TLS_RSA_WITH_AES_256_GCM_SHA384", 157);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", 158);
        CipherSuite.add("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", 159);
        CipherSuite.add("TLS_DH_RSA_WITH_AES_128_GCM_SHA256", 160);
        CipherSuite.add("TLS_DH_RSA_WITH_AES_256_GCM_SHA384", 161);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", 162);
        CipherSuite.add("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", 163);
        CipherSuite.add("TLS_DH_DSS_WITH_AES_128_GCM_SHA256", 164);
        CipherSuite.add("TLS_DH_DSS_WITH_AES_256_GCM_SHA384", 165);
        CipherSuite.add("TLS_DH_anon_WITH_AES_128_GCM_SHA256", 166);
        CipherSuite.add("TLS_DH_anon_WITH_AES_256_GCM_SHA384", 167);
        CipherSuite.add("TLS_PSK_WITH_AES_128_GCM_SHA256", 168);
        CipherSuite.add("TLS_PSK_WITH_AES_256_GCM_SHA384", 169);
        CipherSuite.add("TLS_DHE_PSK_WITH_AES_128_GCM_SHA256", 170);
        CipherSuite.add("TLS_DHE_PSK_WITH_AES_256_GCM_SHA384", 171);
        CipherSuite.add("TLS_RSA_PSK_WITH_AES_128_GCM_SHA256", 172);
        CipherSuite.add("TLS_RSA_PSK_WITH_AES_256_GCM_SHA384", 173);
        CipherSuite.add("TLS_PSK_WITH_AES_128_CBC_SHA256", 174);
        CipherSuite.add("TLS_PSK_WITH_AES_256_CBC_SHA384", 175);
        CipherSuite.add("TLS_PSK_WITH_NULL_SHA256", 176);
        CipherSuite.add("TLS_PSK_WITH_NULL_SHA384", 177);
        CipherSuite.add("TLS_DHE_PSK_WITH_AES_128_CBC_SHA256", 178);
        CipherSuite.add("TLS_DHE_PSK_WITH_AES_256_CBC_SHA384", 179);
        CipherSuite.add("TLS_DHE_PSK_WITH_NULL_SHA256", 180);
        CipherSuite.add("TLS_DHE_PSK_WITH_NULL_SHA384", 181);
        CipherSuite.add("TLS_RSA_PSK_WITH_AES_128_CBC_SHA256", 182);
        CipherSuite.add("TLS_RSA_PSK_WITH_AES_256_CBC_SHA384", 183);
        CipherSuite.add("TLS_RSA_PSK_WITH_NULL_SHA256", 184);
        CipherSuite.add("TLS_RSA_PSK_WITH_NULL_SHA384", 185);
        CipherSuite.add("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA", 65);
        CipherSuite.add("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA", 66);
        CipherSuite.add("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA", 67);
        CipherSuite.add("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA", 68);
        CipherSuite.add("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA", 69);
        CipherSuite.add("TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA", 70);
        CipherSuite.add("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA", 132);
        CipherSuite.add("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA", 133);
        CipherSuite.add("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA", 134);
        CipherSuite.add("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA", 135);
        CipherSuite.add("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA", 136);
        CipherSuite.add("TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA", 137);
        CipherSuite.add("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256", 186);
        CipherSuite.add("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256", 187);
        CipherSuite.add("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256", 188);
        CipherSuite.add("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256", 189);
        CipherSuite.add("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", 190);
        CipherSuite.add("TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256", 191);
        CipherSuite.add("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256", 192);
        CipherSuite.add("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256", 193);
        CipherSuite.add("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256", 194);
        CipherSuite.add("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256", 195);
        CipherSuite.add("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256", 196);
        CipherSuite.add("TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256", 197);
        CipherSuite.add("TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA", 49178);
        CipherSuite.add("TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA", 49179);
        CipherSuite.add("TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA", 49180);
        CipherSuite.add("TLS_SRP_SHA_WITH_AES_128_CBC_SHA", 49181);
        CipherSuite.add("TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA", 49182);
        CipherSuite.add("TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA", 49183);
        CipherSuite.add("TLS_SRP_SHA_WITH_AES_256_CBC_SHA", 49184);
        CipherSuite.add("TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA", 49185);
        CipherSuite.add("TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA", 49186);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 49195);
        CipherSuite.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 49196);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", 49197);
        CipherSuite.add("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", 49198);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 49199);
        CipherSuite.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 49200);
        CipherSuite.add("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", 49201);
        CipherSuite.add("TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", 49202);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_RC4_128_SHA", 49203);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA", 49204);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA", 49205);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA", 49206);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256", 49207);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384", 49208);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_NULL_SHA", 49209);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_NULL_SHA256", 49210);
        CipherSuite.add("TLS_ECDHE_PSK_WITH_NULL_SHA384", 49211);
        C_NULL = CipherSuite.valueOf(0, 0);
        C_SCSV = CipherSuite.valueOf(0, 255);
    }

    static enum PRF {
        P_NONE("NONE", 0, 0),
        P_SHA256("SHA-256", 32, 64),
        P_SHA384("SHA-384", 48, 128),
        P_SHA512("SHA-512", 64, 128);

        private final String prfHashAlg;
        private final int prfHashLength;
        private final int prfBlockSize;

        private PRF(String prfHashAlg, int prfHashLength, int prfBlockSize) {
            this.prfHashAlg = prfHashAlg;
            this.prfHashLength = prfHashLength;
            this.prfBlockSize = prfBlockSize;
        }

        String getPRFHashAlg() {
            return this.prfHashAlg;
        }

        int getPRFHashLength() {
            return this.prfHashLength;
        }

        int getPRFBlockSize() {
            return this.prfBlockSize;
        }
    }

    static final class MacAlg {
        final String name;
        final int size;
        final int hashBlockSize;
        final int minimalPaddingSize;

        MacAlg(String name, int size, int hashBlockSize, int minimalPaddingSize) {
            this.name = name;
            this.size = size;
            this.hashBlockSize = hashBlockSize;
            this.minimalPaddingSize = minimalPaddingSize;
        }

        MAC newMac(ProtocolVersion protocolVersion, SecretKey secret) throws NoSuchAlgorithmException, InvalidKeyException {
            return new MAC(this, protocolVersion, secret);
        }

        public String toString() {
            return this.name;
        }
    }

    static final class BulkCipher {
        private static final Map<BulkCipher, Boolean> availableCache = new HashMap<BulkCipher, Boolean>(8);
        final String description;
        final String transformation;
        final String algorithm;
        final boolean allowed;
        final int keySize;
        final int expandedKeySize;
        final int ivSize;
        final boolean exportable;
        final boolean isCBCMode;

        BulkCipher(String transformation, int keySize, int expandedKeySize, int ivSize, boolean allowed) {
            this.transformation = transformation;
            String[] splits = transformation.split("/");
            this.algorithm = splits[0];
            this.isCBCMode = splits.length <= 1 ? false : "CBC".equalsIgnoreCase(splits[1]);
            this.description = this.algorithm + "/" + (keySize << 3);
            this.keySize = keySize;
            this.ivSize = ivSize;
            this.allowed = allowed;
            this.expandedKeySize = expandedKeySize;
            this.exportable = true;
        }

        BulkCipher(String transformation, int keySize, int ivSize, boolean allowed) {
            this.transformation = transformation;
            String[] splits = transformation.split("/");
            this.algorithm = splits[0];
            this.isCBCMode = splits.length <= 1 ? false : "CBC".equalsIgnoreCase(splits[1]);
            this.description = this.algorithm + "/" + (keySize << 3);
            this.keySize = keySize;
            this.ivSize = ivSize;
            this.allowed = allowed;
            this.expandedKeySize = keySize;
            this.exportable = false;
        }

        CipherBox newCipher(ProtocolVersion version, SecretKey key, IvParameterSpec iv, SecureRandom random, boolean encrypt) throws NoSuchAlgorithmException {
            return CipherBox.newCipherBox(version, this, key, iv, random, encrypt);
        }

        boolean isAvailable() {
            if (!this.allowed) {
                return false;
            }
            if (this == B_AES_256) {
                return BulkCipher.isAvailable(this);
            }
            return true;
        }

        static synchronized void clearAvailableCache() {
            availableCache.clear();
        }

        private static synchronized boolean isAvailable(BulkCipher cipher) {
            Boolean b = availableCache.get(cipher);
            if (b == null) {
                try {
                    SecretKeySpec key = new SecretKeySpec(new byte[cipher.expandedKeySize], cipher.algorithm);
                    IvParameterSpec iv = new IvParameterSpec(new byte[cipher.ivSize]);
                    cipher.newCipher(ProtocolVersion.DEFAULT, key, iv, null, true);
                    b = Boolean.TRUE;
                }
                catch (NoSuchAlgorithmException e) {
                    b = Boolean.FALSE;
                }
                availableCache.put(cipher, b);
            }
            return b;
        }

        public String toString() {
            return this.description;
        }
    }

    static enum KeyExchange {
        K_NULL("NULL", false, false),
        K_RSA("RSA", true, false),
        K_RSA_EXPORT("RSA_EXPORT", true, false),
        K_DH_RSA("DH_RSA", false, false),
        K_DH_DSS("DH_DSS", false, false),
        K_DHE_DSS("DHE_DSS", true, false),
        K_DHE_RSA("DHE_RSA", true, false),
        K_DH_ANON("DH_anon", true, false),
        K_ECDH_ECDSA("ECDH_ECDSA", CipherSuite.access$000(), true),
        K_ECDH_RSA("ECDH_RSA", CipherSuite.access$000(), true),
        K_ECDHE_ECDSA("ECDHE_ECDSA", CipherSuite.access$000(), true),
        K_ECDHE_RSA("ECDHE_RSA", CipherSuite.access$000(), true),
        K_ECDH_ANON("ECDH_anon", CipherSuite.access$000(), true),
        K_KRB5("KRB5", true, false),
        K_KRB5_EXPORT("KRB5_EXPORT", true, false),
        K_SCSV("SCSV", true, false);

        final String name;
        final boolean allowed;
        final boolean isEC;
        private final boolean alwaysAvailable;

        private KeyExchange(String name, boolean allowed, boolean isEC) {
            this.name = name;
            this.allowed = allowed;
            this.isEC = isEC;
            this.alwaysAvailable = allowed && !name.startsWith("EC") && !name.startsWith("KRB");
        }

        boolean isAvailable() {
            if (this.alwaysAvailable) {
                return true;
            }
            if (this.isEC) {
                return this.allowed && JsseJce.isEcAvailable();
            }
            if (this.name.startsWith("KRB")) {
                return this.allowed && JsseJce.isKerberosAvailable();
            }
            return this.allowed;
        }

        public String toString() {
            return this.name;
        }
    }
}

