/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.nkf;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.transcode.EConv;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.nkf.Command;
import org.jruby.ext.nkf.CommandParser;
import org.jruby.ext.nkf.Option;
import org.jruby.ext.nkf.Options;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.io.EncodingUtils;

@JRubyModule(name={"NKF"})
public class RubyNKF {
    private static final ByteList BEGIN_MIME_STRING = new ByteList(ByteList.plain("=?"));
    private static final ByteList END_MIME_STRING = new ByteList(ByteList.plain("?="));
    private static final ByteList PACK_BASE64 = new ByteList(ByteList.plain("m"));
    private static final ByteList PACK_QENCODE = new ByteList(ByteList.plain("M"));
    public static final Map<Integer, String> NKFCharsetMap = new HashMap<Integer, String>(20, 1.0f);
    @Deprecated
    public static final NKFCharset AUTO = NKFCharset.AUTO;
    @Deprecated
    public static final NKFCharset JIS = NKFCharset.JIS;
    @Deprecated
    public static final NKFCharset EUC = NKFCharset.EUC;
    @Deprecated
    public static final NKFCharset SJIS = NKFCharset.SJIS;
    @Deprecated
    public static final NKFCharset BINARY = NKFCharset.BINARY;
    @Deprecated
    public static final NKFCharset NOCONV = NKFCharset.NOCONV;
    @Deprecated
    public static final NKFCharset UNKNOWN = NKFCharset.UNKNOWN;
    @Deprecated
    public static final NKFCharset ASCII = NKFCharset.ASCII;
    @Deprecated
    public static final NKFCharset UTF8 = NKFCharset.UTF8;
    @Deprecated
    public static final NKFCharset UTF16 = NKFCharset.UTF16;
    @Deprecated
    public static final NKFCharset UTF32 = NKFCharset.UTF32;
    @Deprecated
    public static final NKFCharset OTHER = NKFCharset.OTHER;
    @Deprecated
    public static final NKFCharset BASE64 = NKFCharset.BASE64;
    @Deprecated
    public static final NKFCharset QENCODE = NKFCharset.QENCODE;
    @Deprecated
    public static final NKFCharset MIME_DETECT = NKFCharset.MIME_DETECT;

    public static void createNKF(Ruby runtime2) {
        RubyModule NKF = runtime2.defineModule("NKF");
        String version = "2.1.2";
        String relDate = "2011-09-08";
        NKF.defineConstant("NKF_VERSION", runtime2.newString("2.1.2"));
        NKF.defineConstant("NKF_RELEASE_DATE", runtime2.newString("2011-09-08"));
        NKF.defineConstant("VERSION", runtime2.newString("2.1.2 (JRuby_2011-09-08)"));
        for (NKFCharset charset : NKFCharset.values()) {
            NKFCharsetMap.put(charset.value, charset.name());
            if (charset.value > 12) continue;
            NKF.defineConstant(charset.name(), RubyNKF.charsetMappedValue(runtime2, charset));
        }
        NKF.defineAnnotatedMethods(RubyNKF.class);
    }

    @JRubyMethod(name={"guess"}, required=1, module=true)
    public static IRubyObject guess(ThreadContext context, IRubyObject recv2, IRubyObject s2) {
        return RubyNKF.charsetMappedValue(context.runtime, RubyNKF.guess(context, s2));
    }

    public static NKFCharset guess(ThreadContext context, IRubyObject s2) {
        CharsetDecoder decoder;
        Ruby runtime2 = context.runtime;
        if (!s2.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + s2.getMetaClass() + " into String");
        }
        ByteList bytes2 = s2.convertToString().getByteList();
        ByteBuffer buf = ByteBuffer.wrap(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        try {
            decoder = Charset.forName("x-JISAutoDetect").newDecoder();
        }
        catch (UnsupportedCharsetException e) {
            throw runtime2.newStandardError("charsets.jar is required to use NKF#guess. Please install JRE which supports m17n.");
        }
        try {
            decoder.decode(buf);
            if (!decoder.isCharsetDetected()) {
                return NKFCharset.UNKNOWN;
            }
            Charset charset = decoder.detectedCharset();
            String name2 = charset.name();
            if ("Shift_JIS".equals(name2)) {
                return NKFCharset.SJIS;
            }
            if ("Windows-31j".equalsIgnoreCase(name2)) {
                return NKFCharset.JIS;
            }
            if ("EUC-JP".equals(name2)) {
                return NKFCharset.EUC;
            }
            if ("ISO-2022-JP".equals(name2)) {
                return NKFCharset.JIS;
            }
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        if (bytes2.getEncoding() == UTF8Encoding.INSTANCE) {
            return NKFCharset.UTF8;
        }
        if (bytes2.getEncoding().toString().startsWith("UTF-16")) {
            return NKFCharset.UTF16;
        }
        if (bytes2.getEncoding().toString().startsWith("UTF-32")) {
            return NKFCharset.UTF32;
        }
        return NKFCharset.UNKNOWN;
    }

    private static IRubyObject charsetMappedValue(Ruby runtime2, NKFCharset charset) {
        switch (charset) {
            case AUTO: 
            case NOCONV: 
            case UNKNOWN: {
                return runtime2.getNil();
            }
            case BINARY: {
                Encoding encoding2 = runtime2.getEncodingService().getAscii8bitEncoding();
                return runtime2.getEncodingService().convertEncodingToRubyEncoding(encoding2);
            }
        }
        Encoding encoding3 = runtime2.getEncodingService().getEncodingFromString(charset.getCharset());
        return runtime2.getEncodingService().convertEncodingToRubyEncoding(encoding3);
    }

    @JRubyMethod(name={"guess1"}, required=1, module=true)
    public static IRubyObject guess1(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyNKF.guess(context, recv2, str);
    }

    @JRubyMethod(name={"guess2"}, required=1, module=true)
    public static IRubyObject guess2(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyNKF.guess(context, recv2, str);
    }

    @JRubyMethod(name={"nkf"}, required=2, module=true)
    public static IRubyObject nkf(ThreadContext context, IRubyObject recv2, IRubyObject opt, IRubyObject str) {
        ByteList bstr;
        Ruby runtime2 = context.runtime;
        if (!opt.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + opt.getMetaClass() + " into String");
        }
        if (!str.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + str.getMetaClass() + " into String");
        }
        Map<String, NKFCharset> options2 = RubyNKF.parseOpt(opt.convertToString().toString());
        if (options2.get("input").getValue() == NKFCharset.AUTO.getValue()) {
            options2.put("input", RubyNKF.guess(context, str));
        }
        Converter converter = Converter.isMimeText(bstr = str.convertToString().getByteList(), options2) ? new MimeConverter(context, options2) : new DefaultConverter(context, options2);
        RubyString result2 = converter.convert(bstr);
        if (options2.get("mime-encode") == NKFCharset.BASE64) {
            result2 = Converter.encodeMimeString(runtime2, result2, RubyNKF.PACK_BASE64);
        } else if (options2.get("mime-encode") == NKFCharset.QENCODE) {
            result2 = Converter.encodeMimeString(runtime2, result2, RubyNKF.PACK_QENCODE);
        }
        return result2;
    }

    public static Command parseOption(String s2) {
        Options options2 = new Options();
        options2.addOption("b");
        options2.addOption("u");
        options2.addOption("j", "jis");
        options2.addOption("s", "sjis");
        options2.addOption("e", "euc");
        options2.addOption("w", null, "[0-9][0-9]");
        options2.addOption("J", "jis-input");
        options2.addOption("S", "sjis-input");
        options2.addOption("E", "euc-input");
        options2.addOption("W", null, "[0-9][0-9]");
        options2.addOption("t");
        options2.addOption("i_");
        options2.addOption("o_");
        options2.addOption("r");
        options2.addOption("h1", "hiragana");
        options2.addOption("h2", "katakana");
        options2.addOption("h3", "katakana-hiragana");
        options2.addOption("T");
        options2.addOption("l");
        options2.addOption("f", null, "[0-9]+-[0-9]*");
        options2.addOption("F");
        options2.addOption("Z", null, "[0-3]");
        options2.addOption("X");
        options2.addOption("x");
        options2.addOption("B", null, "[0-2]");
        options2.addOption("I");
        options2.addOption("L", null, "[uwm]");
        options2.addOption("d");
        options2.addOption("c");
        options2.addOption("m", null, "[BQN0]");
        options2.addOption("M", null, "[BQ]");
        options2.addOption(null, "fj");
        options2.addOption(null, "unix");
        options2.addOption(null, "mac");
        options2.addOption(null, "msdos");
        options2.addOption(null, "windows");
        options2.addOption(null, "mime");
        options2.addOption(null, "base64");
        options2.addOption(null, "mime-input");
        options2.addOption(null, "base64-input");
        options2.addOption(null, "ic", "ic=(.*)");
        options2.addOption(null, "oc", "oc=(.*)");
        options2.addOption(null, "fb-skip");
        options2.addOption(null, "fb-html");
        options2.addOption(null, "fb-xml");
        options2.addOption(null, "fb-perl");
        options2.addOption(null, "fb-java");
        options2.addOption(null, "fb-subchar", "fb-subchar=(.*)");
        options2.addOption(null, "no-cp932ext");
        options2.addOption(null, "cap-input");
        options2.addOption(null, "url-input");
        options2.addOption(null, "numchar-input");
        options2.addOption(null, "no-best-fit-chars");
        CommandParser parser = new CommandParser();
        Command cmd = parser.parse(options2, s2);
        return cmd;
    }

    private static Map<String, NKFCharset> parseOpt(String s2) {
        Option opt;
        HashMap<String, NKFCharset> options2 = new HashMap<String, NKFCharset>();
        options2.put("input", NKFCharset.AUTO);
        options2.put("output", NKFCharset.JIS);
        options2.put("mime-decode", NKFCharset.MIME_DETECT);
        options2.put("mime-encode", NKFCharset.NOCONV);
        Command cmd = RubyNKF.parseOption(s2);
        if (cmd.hasOption("j")) {
            options2.put("output", NKFCharset.JIS);
        }
        if (cmd.hasOption("s")) {
            options2.put("output", NKFCharset.SJIS);
        }
        if (cmd.hasOption("e")) {
            options2.put("output", NKFCharset.EUC);
        }
        if (cmd.hasOption("w")) {
            opt = cmd.getOption("w");
            if ("32".equals(opt.getValue())) {
                options2.put("output", NKFCharset.UTF32);
            } else if ("16".equals(opt.getValue())) {
                options2.put("output", NKFCharset.UTF16);
            } else {
                options2.put("output", NKFCharset.UTF8);
            }
        }
        if (cmd.hasOption("J")) {
            options2.put("input", NKFCharset.JIS);
        }
        if (cmd.hasOption("S")) {
            options2.put("input", NKFCharset.SJIS);
        }
        if (cmd.hasOption("E")) {
            options2.put("input", NKFCharset.EUC);
        }
        if (cmd.hasOption("W")) {
            opt = cmd.getOption("W");
            if ("32".equals(opt.getValue())) {
                options2.put("input", NKFCharset.UTF32);
            } else if ("16".equals(opt.getValue())) {
                options2.put("input", NKFCharset.UTF16);
            } else {
                options2.put("input", NKFCharset.UTF8);
            }
        }
        if (cmd.hasOption("m")) {
            opt = cmd.getOption("m");
            if (opt.getValue() == null) {
                options2.put("mime-decode", NKFCharset.MIME_DETECT);
            } else if ("B".equals(opt.getValue())) {
                options2.put("mime-decode", NKFCharset.BASE64);
            } else if ("Q".equals(opt.getValue())) {
                options2.put("mime-decode", NKFCharset.QENCODE);
            } else if (!"N".equals(opt.getValue()) && "0".equals(opt.getValue())) {
                options2.put("mime-decode", NKFCharset.NOCONV);
            }
        }
        if (cmd.hasOption("M")) {
            opt = cmd.getOption("M");
            if (opt.getValue() == null) {
                options2.put("mime-encode", NKFCharset.NOCONV);
            } else if ("B".equals(opt.getValue())) {
                options2.put("mime-encode", NKFCharset.BASE64);
            } else if ("Q".equals(opt.getValue())) {
                options2.put("mime-encode", NKFCharset.QENCODE);
            }
        }
        if (cmd.hasOption("base64")) {
            options2.put("mime-encode", NKFCharset.BASE64);
        }
        if (cmd.hasOption("oc")) {
            opt = cmd.getOption("oc");
            if ("ISO-2022-JP".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", NKFCharset.JIS);
            } else if ("EUC-JP".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", NKFCharset.EUC);
            } else if ("CP932".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", NKFCharset.SJIS);
            } else if ("Shift_JIS".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", NKFCharset.SJIS);
            } else if ("Windows-31J".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", NKFCharset.JIS);
            } else if ("UTF-8".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", NKFCharset.UTF8);
            } else if ("UTF-8N".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", NKFCharset.UTF8);
            } else if ("UTF-16".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", NKFCharset.UTF16);
            } else if ("UTF-16BE-BOM".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", NKFCharset.UTF16);
            } else if ("UTF-32".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", NKFCharset.UTF32);
            } else if ("UTF-32BE-BOM".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("output", NKFCharset.UTF32);
            }
        }
        if (cmd.hasOption("ic")) {
            opt = cmd.getOption("ic");
            if ("ISO-2022-JP".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", NKFCharset.JIS);
            } else if ("EUC-JP".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", NKFCharset.EUC);
            } else if ("CP932".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", NKFCharset.SJIS);
            } else if ("Shift_JIS".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", NKFCharset.SJIS);
            } else if ("Windows-31J".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", NKFCharset.SJIS);
            } else if ("UTF-8".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", NKFCharset.UTF8);
            } else if ("UTF-8N".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", NKFCharset.UTF8);
            } else if ("UTF-16".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", NKFCharset.UTF16);
            } else if ("UTF-16BE-BOM".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", NKFCharset.UTF16);
            } else if ("UTF-32".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", NKFCharset.UTF32);
            } else if ("UTF-32BE-BOM".compareToIgnoreCase(opt.getValue()) == 0) {
                options2.put("input", NKFCharset.UTF32);
            }
        }
        return options2;
    }

    static class MimeConverter
    extends Converter {
        public MimeConverter(ThreadContext ctx, Map<String, NKFCharset> opt) {
            super(ctx, opt);
        }

        private String detectCharset(String charset) {
            if (charset.compareToIgnoreCase(NKFCharset.UTF8.getCharset()) == 0) {
                return NKFCharset.UTF8.getCharset();
            }
            if (charset.compareToIgnoreCase(NKFCharset.JIS.getCharset()) == 0) {
                return NKFCharset.JIS.getCharset();
            }
            if (charset.compareToIgnoreCase(NKFCharset.EUC.getCharset()) == 0) {
                return NKFCharset.EUC.getCharset();
            }
            return NKFCharset.ASCII.getCharset();
        }

        private ByteList decodeMimeString(String str) {
            String[] mime = str.split("^=\\?|\\?|\\?=$");
            String charset = this.detectCharset(mime[1]);
            char encode2 = mime[2].charAt(0);
            ByteList body = new ByteList(mime[3].getBytes(), ASCIIEncoding.INSTANCE);
            RubyArray array2 = 'B' == encode2 || 'b' == encode2 ? Pack.unpack(this.context.runtime, body, PACK_BASE64) : Pack.unpack(this.context.runtime, body, PACK_QENCODE);
            RubyString s2 = (RubyString)array2.entry(0);
            ByteList decodeStr = s2.asString().getByteList();
            return this.convert_byte(decodeStr, charset, (NKFCharset)((Object)this.options.get("output")));
        }

        RubyString makeRubyString(ArrayList<ByteList> list2) {
            ByteList r = new ByteList();
            for (ByteList l : list2) {
                r.append(l);
            }
            return this.context.runtime.newString(r);
        }

        @Override
        RubyString convert(ByteList str) {
            String s2 = Helpers.decodeByteList(this.context.runtime, str);
            String[] token = s2.split("\\s");
            ArrayList<ByteList> raw_data = new ArrayList<ByteList>();
            for (int i2 = 0; i2 < token.length; ++i2) {
                raw_data.add(this.decodeMimeString(token[i2]));
            }
            return this.makeRubyString(raw_data);
        }
    }

    static class DefaultConverter
    extends Converter {
        public DefaultConverter(ThreadContext ctx, Map<String, NKFCharset> opt) {
            super(ctx, opt);
        }

        @Override
        RubyString convert(ByteList str) {
            NKFCharset input = (NKFCharset)((Object)this.options.get("input"));
            NKFCharset output = (NKFCharset)((Object)this.options.get("output"));
            ByteList b2 = this.convert_byte(str, input.getCharset(), output);
            return this.context.runtime.newString(b2);
        }
    }

    static abstract class Converter {
        protected ThreadContext context;
        protected Map<String, NKFCharset> options;

        public Converter(ThreadContext ctx, Map<String, NKFCharset> opt) {
            this.context = ctx;
            this.options = opt;
        }

        static boolean isMimeText(ByteList str, Map<String, NKFCharset> options2) {
            if (str.length() <= 6) {
                return false;
            }
            if (options2.get("mime-decode") == NKFCharset.NOCONV) {
                return false;
            }
            if (str.indexOf(BEGIN_MIME_STRING) < 0) {
                return false;
            }
            return str.lastIndexOf(END_MIME_STRING) >= 0;
        }

        private static RubyString encodeMimeString(Ruby runtime2, RubyString str, ByteList format) {
            RubyArray array2 = RubyArray.newArray(runtime2, str);
            return Pack.pack(runtime2, array2, format).chomp(runtime2.getCurrentContext());
        }

        abstract RubyString convert(ByteList var1);

        ByteList convert_byte(ByteList str, String inputCharset, NKFCharset output) {
            String outputCharset = output.getCharset();
            if (inputCharset == null) {
                inputCharset = str.getEncoding().toString();
            }
            if (outputCharset.equals(inputCharset)) {
                return str.dup();
            }
            byte[] outCharsetBytes = outputCharset.getBytes();
            EConv ec = EncodingUtils.econvOpenOpts(this.context, inputCharset.getBytes(), outCharsetBytes, 0, this.context.nil);
            if (ec == null) {
                throw this.context.runtime.newArgumentError("invalid encoding pair: " + inputCharset + " to " + outputCharset);
            }
            ByteList converted = EncodingUtils.econvStrConvert(this.context, ec, str, 2);
            converted.setEncoding(this.context.runtime.getEncodingService().findEncodingOrAliasEntry(outCharsetBytes).getEncoding());
            return converted;
        }
    }

    public static enum NKFCharset {
        AUTO(0, "x-JISAutoDetect"),
        JIS(1, "ISO-2022-JP"),
        EUC(2, "EUC-JP"),
        SJIS(3, "Shift_JIS"),
        BINARY(4, null),
        NOCONV(4, null),
        UNKNOWN(0, null),
        ASCII(5, "iso-8859-1"),
        UTF8(6, "UTF-8"),
        UTF16(8, "UTF-16"),
        UTF32(12, "UTF-32"),
        OTHER(16, null),
        BASE64(20, "base64"),
        QENCODE(21, "qencode"),
        MIME_DETECT(22, "MimeAutoDetect");

        private final int value;
        private final String charset;

        private NKFCharset(int value2, String charset) {
            this.value = value2;
            this.charset = charset;
        }

        public int getValue() {
            return this.value;
        }

        public String getCharset() {
            return this.charset;
        }
    }
}

