/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.GetWikipediaXmlHandler;
import tim.prune.function.search.GenericDownloaderFunction;
import tim.prune.function.search.SearchResult;

public class GetWikipediaFunction
extends GenericDownloaderFunction {
    private static final int MAX_RESULTS = 20;
    private static final int MAX_DISTANCE = 15;
    private static final String GEONAMES_USERNAME = "gpsprune";

    public GetWikipediaFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.getwikipedia";
    }

    protected String getColumnKey(int n) {
        if (n == 0) {
            return "dialog.wikipedia.column.name";
        }
        return "dialog.wikipedia.column.distance";
    }

    public void run() {
        Object object;
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        double d = 0.0;
        double d2 = 0.0;
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        if (dataPoint == null) {
            object = this._app.getViewport().getBounds();
            d = (object[0] + object[2]) / 2.0;
            d2 = (object[1] + object[3]) / 2.0;
        } else {
            d = dataPoint.getLatitude().getDouble();
            d2 = dataPoint.getLongitude().getDouble();
        }
        this.searchWikimediaGalleries(d, d2);
        object = I18nManager.getText("wikipedia.lang");
        this.submitSearch(d, d2, (String)object);
        if (this._trackListModel.isEmpty() && this._errorMessage == null && ((String)object).equals("als")) {
            this.submitSearch(d, d2, "de");
        }
        if (this._trackListModel.isEmpty() && this._errorMessage == null && !((String)object).equals("en")) {
            this.submitSearch(d, d2, "en");
        }
        if (this._errorMessage == null && this._trackListModel.isEmpty()) {
            this._errorMessage = I18nManager.getText("dialog.wikipedia.nonefound");
        }
        this._statusLabel.setText(this._errorMessage == null ? "" : this._errorMessage);
    }

    private void submitSearch(double d, double d2, String string) {
        Object object;
        Serializable serializable;
        String string2 = "http://api.geonames.org/findNearbyWikipedia?lat=" + d + "&lng=" + d2 + "&maxRows=" + 20 + "&radius=" + 15 + "&lang=" + string + "&username=" + GEONAMES_USERNAME;
        GetWikipediaXmlHandler getWikipediaXmlHandler = new GetWikipediaXmlHandler();
        InputStream inputStream = null;
        try {
            serializable = new URL(string2);
            object = SAXParserFactory.newInstance().newSAXParser();
            inputStream = serializable.openStream();
            ((SAXParser)object).parse(inputStream, (DefaultHandler)getWikipediaXmlHandler);
        }
        catch (Exception exception) {
            this._errorMessage = String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage();
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        serializable = getWikipediaXmlHandler.getTrackList();
        this._trackListModel.addTracks((ArrayList<SearchResult>)serializable, true);
        if (this._trackListModel.isEmpty() && (object = getWikipediaXmlHandler.getErrorMessage()) != null && !((String)object).equals("")) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), (String)object);
            this._errorMessage = object;
        }
    }

    protected void loadSelected() {
        int n = this._trackTable.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int[] nArray = this._trackTable.getSelectedRows();
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 >= 0 && n3 < this._trackListModel.getRowCount()) {
                String string = this._trackListModel.getTrack(n3).getLatitude();
                String string2 = this._trackListModel.getTrack(n3).getLongitude();
                if (string != null && string2 != null) {
                    DataPoint dataPoint = new DataPoint(new Latitude(string), new Longitude(string2), null);
                    dataPoint.setFieldValue(Field.WAYPT_NAME, this._trackListModel.getTrack(n3).getTrackName(), false);
                    this._app.createPoint(dataPoint);
                }
            }
            ++n2;
        }
        this._cancelled = true;
        this._dialog.dispose();
    }

    private void searchWikimediaGalleries(double d, double d2) {
        block16: {
            BufferedReader bufferedReader = null;
            try {
                InputStream inputStream = GetWikipediaFunction.class.getResourceAsStream("/tim/prune/function/search/wikimedia_galleries.txt");
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                if (bufferedReader != null) {
                    ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
                    DataPoint dataPoint = new DataPoint(new Latitude(d, 12), new Longitude(d2, 12), null);
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        DataPoint dataPoint2;
                        double d3;
                        String[] stringArray = string.split("\t");
                        if (stringArray.length != 4 || !((d3 = Distance.convertRadiansToDistance(DataPoint.calculateRadiansBetween(dataPoint2 = new DataPoint(new Latitude(stringArray[2]), new Longitude(stringArray[3]), null), dataPoint), UnitSetLibrary.UNITS_KILOMETRES)) < 15.0)) continue;
                        SearchResult searchResult = new SearchResult();
                        searchResult.setTrackName(String.valueOf(I18nManager.getText("dialog.wikipedia.gallery")) + ": " + stringArray[0]);
                        searchResult.setDescription(stringArray[1]);
                        searchResult.setLatitude(stringArray[2]);
                        searchResult.setLongitude(stringArray[3]);
                        searchResult.setWebUrl("https://commons.wikimedia.org/wiki/" + stringArray[0]);
                        searchResult.setLength(d3 * 1000.0);
                        arrayList.add(searchResult);
                    }
                    this._trackListModel.addTracks(arrayList, true);
                }
            }
            catch (IOException iOException) {
                System.err.println("Exception trying to read wikimedia file : " + iOException.getMessage());
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
                break block16;
            }
            catch (NullPointerException nullPointerException) {
                try {
                    System.err.println("Couldn't find wikimedia file : " + nullPointerException.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
                break block16;
            }
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
    }
}

