/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.threedee;

public class TerrainPatch {
    private int _gridSize = 0;
    private double[] _altitudes = null;
    private int[] _tempDists = null;

    public TerrainPatch(int n) {
        this._gridSize = n;
        int n2 = n * n;
        this._altitudes = new double[n2];
        this._tempDists = new int[n2];
    }

    public void addAltitude(int n, double d, int n2, int n3) {
        int n4 = Math.min(n2, n3 - n2);
        if (this._tempDists[n] == 0) {
            if (this._altitudes[n] > 0.0) {
                System.err.println("Altitude shouldn't be 0 if dist is 0!");
            }
            this._altitudes[n] = d;
            this._tempDists[n] = n4;
        } else {
            double d2 = this._altitudes[n];
            int n5 = this._tempDists[n];
            double d3 = (double)n4 * 1.0 / (double)(n4 + n5);
            double d4 = (double)n5 * 1.0 / (double)(n4 + n5);
            this._altitudes[n] = d3 * d2 + d4 * d;
            this._tempDists[n] = 0;
        }
    }

    public void smooth() {
        double[] dArray = new double[this._altitudes.length];
        int n = 0;
        while (n < this._gridSize) {
            int n2 = 0;
            while (n2 < this._gridSize) {
                if (this.hasAltitude(n, n2) && this.hasAltitude(n - 1, n2) && this.hasAltitude(n + 1, n2) && this.hasAltitude(n, n2 + 1) && this.hasAltitude(n - 1, n2 + 1) && this.hasAltitude(n + 1, n2 + 1) && this.hasAltitude(n, n2 - 1) && this.hasAltitude(n - 1, n2 - 1) && this.hasAltitude(n + 1, n2 - 1)) {
                    double d;
                    dArray[n * this._gridSize + n2] = d = (this.getAltitude(n, n2) + this.getAltitude(n - 1, n2) + this.getAltitude(n + 1, n2) + this.getAltitude(n, n2 + 1) + this.getAltitude(n - 1, n2 + 1) + this.getAltitude(n + 1, n2 + 1) + this.getAltitude(n, n2 - 1) + this.getAltitude(n - 1, n2 - 1) + this.getAltitude(n + 1, n2 - 1)) / 9.0;
                }
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < dArray.length) {
            if (dArray[n] > 0.0) {
                this._altitudes[n] = dArray[n];
            }
            ++n;
        }
    }

    private boolean hasAltitude(int n, int n2) {
        return n >= 0 && n < this._gridSize && n2 >= 0 && n2 < this._gridSize && this._altitudes[n * this._gridSize + n2] > 0.0;
    }

    private double getAltitude(int n, int n2) {
        if (n >= 0 && n < this._gridSize && n2 >= 0 && n2 < this._gridSize) {
            return this._altitudes[n * this._gridSize + n2];
        }
        return 0.0;
    }

    public double getAltitude(int n) {
        if (this._tempDists[n] != 0) {
            System.err.println("Dists should be 0 if we're retrieving!");
        }
        return this._altitudes[n];
    }
}

