/*
 * Decompiled with CFR 0.152.
 */
package jspecview.popup;

import javajs.awt.SC;
import javajs.util.Lst;
import javajs.util.PT;
import jspecview.api.JSVPanel;
import jspecview.api.JSVPopupMenu;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.Spectrum;
import jspecview.popup.JSVPopupResourceBundle;
import org.jmol.popup.GenericSwingPopup;
import org.jmol.popup.PopupResource;

public abstract class JSVGenericPopup
extends GenericSwingPopup
implements JSVPopupMenu {
    protected static final boolean dumpList = false;
    protected static final int UPDATE_NEVER = -1;
    private static final int UPDATE_ALL = 0;
    private static final int UPDATE_CONFIG = 1;
    private static final int UPDATE_SHOW = 2;
    protected JSViewer vwr;
    protected int updateMode;
    private Lst<String> cnmrPeaks;
    private Lst<String> hnmrPeaks;
    private int aboutComputedMenuBaseCount;
    private boolean allowMenu;
    private boolean zoomEnabled;
    private PanelData pd;
    protected JSVPanel thisJsvp;

    protected void initialize(JSViewer jSViewer, PopupResource popupResource, String string) {
        this.vwr = jSViewer;
        this.initSwing(string, popupResource, jSViewer.getApplet(), jSViewer.isJS, jSViewer.isSigned, false);
    }

    @Override
    public void jpiDispose() {
        this.helper.menuClearListeners(this.popupMenu);
        this.thisPopup = null;
        this.popupMenu = null;
    }

    @Override
    public Object jpiGetMenuAsObject() {
        return this.popupMenu;
    }

    @Override
    public void jpiShow(int n, int n2) {
        this.show(n, n2, false);
        this.appRestorePopupMenu();
        this.menuShowPopup(this.popupMenu, this.thisx, this.thisy);
    }

    @Override
    public void jpiUpdateComputedMenus() {
        if (this.updateMode == -1) {
            return;
        }
        this.updateMode = 0;
        this.getViewerData();
        this.updateFileMenu();
        this.updateFileTypeDependentMenus();
        this.updateMode = 1;
        this.updateAboutSubmenu();
    }

    @Override
    protected void appCheckItem(String string, SC sC) {
    }

    @Override
    protected void appCheckSpecialMenu(String string, SC sC, String string2) {
    }

    @Override
    protected String appFixLabel(String string) {
        if (string.startsWith("_")) {
            string = string.substring(string.indexOf("_", 2) + 1);
        } else if (string.equals("VERSION")) {
            string = JSVersion.VERSION;
        }
        string = PT.rep(string, "JAVA", "");
        string = PT.rep(string, "CB", "");
        string = PT.rep(string, "Menu", "");
        string = PT.rep(string, "_", " ");
        return string;
    }

    @Override
    protected String appFixScript(String string, String string2) {
        return string2;
    }

    @Override
    public String appGetMenuAsString(String string) {
        return new JSVPopupResourceBundle().getMenuAsText(string);
    }

    @Override
    protected boolean appGetBooleanProperty(String string) {
        return false;
    }

    @Override
    protected boolean appIsSpecialCheckBox(SC sC, String string, String string2, boolean bl) {
        return false;
    }

    @Override
    protected void appRestorePopupMenu() {
        this.thisPopup = this.popupMenu;
    }

    @Override
    protected void appRunScript(String string) {
        this.vwr.runScript(string);
    }

    @Override
    protected void appUpdateForShow() {
        this.thisJsvp = this.vwr.selectedPanel;
        this.setEnables(this.thisJsvp);
        if (this.updateMode == -1) {
            return;
        }
        this.getViewerData();
        this.updateMode = 2;
        this.updateSpectraMenu();
        this.updateAboutSubmenu();
    }

    @Override
    protected void appUpdateSpecialCheckBoxValue(SC sC, String string, boolean bl) {
    }

    private void getViewerData() {
    }

    private void updateFileTypeDependentMenus() {
    }

    private void updateFileMenu() {
        Object v = this.htMenus.get("fileMenu");
        if (v == null) {
            return;
        }
    }

    private void updateSpectraMenu() {
        SC sC;
        SC sC2 = (SC)this.htMenus.get("hnmrMenu");
        SC sC3 = (SC)this.htMenus.get("cnmrMenu");
        if (sC2 != null) {
            this.menuRemoveAll(sC2, 0);
        }
        if (sC3 != null) {
            this.menuRemoveAll(sC3, 0);
        }
        if ((sC = (SC)this.htMenus.get("spectraMenu")) == null) {
            return;
        }
        this.menuRemoveAll(sC, 0);
        boolean bl = this.setSpectraMenu(sC2, this.hnmrPeaks) | this.setSpectraMenu(sC3, this.cnmrPeaks);
        if (bl) {
            if (sC2 != null) {
                this.menuAddSubMenu(sC, sC2);
            }
            if (sC3 != null) {
                this.menuAddSubMenu(sC, sC3);
            }
        }
        this.menuEnable(sC, bl);
    }

    private boolean setSpectraMenu(SC sC, Lst<String> lst) {
        int n;
        if (sC == null) {
            return false;
        }
        this.menuEnable(sC, false);
        int n2 = n = lst == null ? 0 : lst.size();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = (String)lst.get(i);
            String string2 = PT.getQuotedAttribute(string, "title");
            String string3 = PT.getQuotedAttribute(string, "atoms");
            if (string3 == null) continue;
            this.menuCreateItem(sC, string2, "select visible & (@" + PT.rep(string3, ",", " or @") + ")", "Focus" + i);
        }
        this.menuEnable(sC, true);
        return true;
    }

    private void updateAboutSubmenu() {
        SC sC = (SC)this.htMenus.get("aboutComputedMenu");
        if (sC == null) {
            return;
        }
        this.menuRemoveAll(sC, this.aboutComputedMenuBaseCount);
    }

    @Override
    public boolean getSelected(String string) {
        return false;
    }

    @Override
    public void setCompoundMenu(Lst<PanelNode> lst, boolean bl) {
    }

    @Override
    public void setEnabled(boolean bl, boolean bl2) {
        this.allowMenu = bl;
        this.zoomEnabled = bl2;
        this.enableMenus();
    }

    private void enableMenus() {
        this.setItemEnabled("_SIGNED_FileMenu", this.allowMenu);
        this.setItemEnabled("ViewMenu", this.pd != null && this.allowMenu);
        this.setItemEnabled("Open_File...", this.allowMenu);
        this.setItemEnabled("Open_Simulation...", this.allowMenu);
        this.setItemEnabled("Open_URL...", this.allowMenu);
        this.setItemEnabled("Save_AsMenu", this.pd != null && this.allowMenu);
        this.setItemEnabled("Export_AsMenu", this.pd != null && this.allowMenu);
        this.setItemEnabled("Append_File...", this.pd != null && this.allowMenu);
        this.setItemEnabled("Append_Simulation...", this.pd != null && this.allowMenu);
        this.setItemEnabled("Append_URL...", this.pd != null && this.allowMenu);
        this.setItemEnabled("Views...", this.pd != null && this.allowMenu);
        this.setItemEnabled("Script", this.allowMenu);
        this.setItemEnabled("Print...", this.pd != null && this.allowMenu);
        this.setItemEnabled("ZoomMenu", this.pd != null && this.zoomEnabled);
    }

    private void setEnables(JSVPanel jSVPanel) {
        this.pd = jSVPanel == null ? null : jSVPanel.getPanelData();
        Spectrum spectrum = this.pd == null ? null : this.pd.getSpectrum();
        boolean bl = this.pd != null && this.pd.isShowAllStacked();
        boolean bl2 = this.pd != null && this.pd.haveSelectedSpectrum();
        this.setItemEnabled("Integration", this.pd != null && this.pd.getSpectrum().canIntegrate());
        this.setItemEnabled("Measurements", true);
        this.setItemEnabled("Peaks", this.pd != null && this.pd.getSpectrum().is1D());
        this.setItemEnabled("Predicted_Solution_Colour_(fitted)", bl2 && spectrum.canShowSolutionColor());
        this.setItemEnabled("Predicted_Solution_Colour_(interpolated)", bl2 && spectrum.canShowSolutionColor());
        this.setItemEnabled("Toggle_Trans/Abs", bl2 && spectrum.canConvertTransAbs());
        this.setItemEnabled("Show_Overlay_Key", bl && this.pd.getNumberOfGraphSets() == 1);
        this.setItemEnabled("Overlay_Offset...", bl);
        this.setItemEnabled("JDXMenu", this.pd != null && spectrum.canSaveAsJDX());
        this.setItemEnabled("Export_AsMenu", this.pd != null);
        this.enableMenus();
    }

    private void setItemEnabled(String string, boolean bl) {
        this.menuEnable((SC)this.htMenus.get(string), bl);
    }

    @Override
    public void setSelected(String string, boolean bl) {
        SC sC = (SC)this.htMenus.get(string);
        if (sC == null || sC.isSelected() == bl) {
            return;
        }
        this.menuEnable(sC, false);
        sC.setSelected(bl);
        this.menuEnable(sC, true);
    }

    @Override
    protected String menuSetCheckBoxOption(SC sC, String string, String string2) {
        return null;
    }
}

