/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.TlsVerifier;

public class JcaTlsECDSAVerifier
implements TlsVerifier {
    private final JcaJceHelper helper;
    private final ECPublicKey pubKey;

    protected JcaTlsECDSAVerifier(ECPublicKey eCPublicKey, JcaJceHelper jcaJceHelper) {
        if (eCPublicKey == null) {
            throw new IllegalArgumentException("'pubKey' cannot be null");
        }
        this.pubKey = eCPublicKey;
        this.helper = jcaJceHelper;
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) {
        return null;
    }

    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() != 3) {
            throw new IllegalStateException();
        }
        try {
            Signature signature = this.helper.createSignature("NoneWithECDSA");
            signature.initVerify(this.pubKey);
            if (signatureAndHashAlgorithm == null) {
                signature.update(byArray, 16, 20);
            } else {
                signature.update(byArray, 0, byArray.length);
            }
            return signature.verify(digitallySigned.getSignature());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("unable to process signature: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

