/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_cs extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_kpe = "kpelle";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "ksh", "kol\u00edn\u0161tina" },
            { "Ogam", "ogamsk\u00e9" },
            { "mwl", "mirand\u0161tina" },
            { "Zsym", "symboly" },
            { "cch", "atsam" },
            { "mwr", "m\u00e1rv\u00e1r\u0161tina" },
            { "egl", "emilij\u0161tina" },
            { "mwv", "mentavaj\u0161tina" },
            { "Tagb", "tagbanwa" },
            { "xmf", "mingrel\u0161tina" },
            { "egy", "egypt\u0161tina star\u00e1" },
            { "raj", "r\u00e1d\u017east\u00e1n\u0161tina" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanuj\u0161tina" },
            { "ter", "tereno" },
            { "AC", "Ascension" },
            { "rar", "rarotong\u00e1n\u0161tina" },
            { "tet", "tetum\u0161tina" },
            { "AD", "Andorra" },
            { "AE", "Spojen\u00e9 arabsk\u00e9 emir\u00e1ty" },
            { "nl_BE", "vl\u00e1m\u0161tina" },
            { "AF", "Afgh\u00e1nist\u00e1n" },
            { "AG", "Antigua a Barbuda" },
            { "glk", "gila\u010dtina" },
            { "AI", "Anguilla" },
            { "AL", "Alb\u00e1nie" },
            { "AM", "Arm\u00e9nie" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktida" },
            { "AR", "Argentina" },
            { "Prti", "parthsk\u00e9 kl\u00ednov\u00e9" },
            { "AS", "Americk\u00e1 Samoa" },
            { "AT", "Rakousko" },
            { "AU", "Austr\u00e1lie" },
            { "AW", "Aruba" },
            { "en_US", "angli\u010dtina (USA)" },
            { "AX", "\u00c5landy" },
            { "mye", "myene" },
            { "AZ", "\u00c1zerb\u00e1jd\u017e\u00e1n" },
            { "BA", "Bosna a Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebu\u00e1n\u0161tina" },
            { "BD", "Banglad\u00e9\u0161" },
            { "kum", "kumy\u010dtina" },
            { "BE", "Belgie" },
            { "gmh", "hornon\u011bm\u010dina (st\u0159edov\u011bk\u00e1)" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulharsko" },
            { "BH", "Bahrajn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Svat\u00fd Bartolom\u011bj" },
            { "BM", "Bermudy" },
            { "kut", "kutenaj\u0161tina" },
            { "myv", "erzjan\u0161tina" },
            { "BN", "Brunej" },
            { "BO", "Bol\u00edvie" },
            { "BQ", "Karibsk\u00e9 Nizozemsko" },
            { "BR", "Braz\u00edlie" },
            { "BS", "Bahamy" },
            { "xog", "sog\u0161tina" },
            { "BT", "Bh\u00fat\u00e1n" },
            { "BV", "Bouvet\u016fv ostrov" },
            { "BW", "Botswana" },
            { "BY", "B\u011blorusko" },
            { "BZ", "Belize" },
            { "Visp", "viditeln\u00e1 \u0159e\u010d" },
            { "CA", "Kanada" },
            { "CC", "Kokosov\u00e9 ostrovy" },
            { "mzn", "m\u00e1zandar\u00e1n\u0161tina" },
            { "CD", "Kongo \u2013 Kinshasa" },
            { "CF", "St\u0159edoafrick\u00e1 republika" },
            { "CG", "Kongo \u2013 Brazzaville" },
            { "CH", "\u0160v\u00fdcarsko" },
            { "CI", "Pob\u0159e\u017e\u00ed slonoviny" },
            { "CK", "Cookovy ostrovy" },
            { "CL", "Chile" },
            { "Kthi", "kaithi" },
            { "CM", "Kamerun" },
            { "CN", "\u010c\u00edna" },
            { "CO", "Kolumbie" },
            { "CP", "Clipperton\u016fv ostrov" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Kapverdy" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "V\u00e1no\u010dn\u00ed ostrov" },
            { "CY", "Kypr" },
            { "CZ", "\u010cesk\u00e1 republika" },
            { "eka", "ekajuk" },
            { "Pauc", "pau cin hau" },
            { "vls", "vl\u00e1m\u0161tina (z\u00e1padn\u00ed)" },
            { "DE", "N\u011bmecko" },
            { "goh", "hornon\u011bm\u010dina (star\u00e1)" },
            { "ace", "aceh\u0161tina" },
            { "cgg", "kiga" },
            { "DG", "Diego Garc\u00eda" },
            { "gom", "konk\u00e1n\u0161tina (Goa)" },
            { "DJ", "D\u017eibutsko" },
            { "DK", "D\u00e1nsko" },
            { "ach", "akol\u0161tina" },
            { "gon", "g\u00f3nd\u0161tina" },
            { "Brai", "Braillovo p\u00edsmo" },
            { "Brah", "br\u00e1hm\u00ed" },
            { "DM", "Dominika" },
            { "DO", "Dominik\u00e1nsk\u00e1 republika" },
            { "gor", "gorontalo" },
            { "got", "g\u00f3t\u0161tina" },
            { "vmf", "n\u011bm\u010dina (mohansko-fransk\u00e9 dialekty)" },
            { "Mtei", "mejtej majek (manipursk\u00e9)" },
            { "zun", "zunij\u0161tina" },
            { "tig", "tigrej\u0161tina" },
            { "Takr", "takr\u00ed" },
            { "DZ", "Al\u017e\u00edrsko" },
            { "pag", "pangasinan\u0161tina" },
            { "pal", "pahlav\u0161tina" },
            { "EA", "Ceuta a Melilla" },
            { "chb", "\u010dib\u010da" },
            { "pam", "papangau" },
            { "EC", "Ekv\u00e1dor" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estonsko" },
            { "tiv", "tiv\u0161tina" },
            { "EG", "Egypt" },
            { "EH", "Z\u00e1padn\u00ed Sahara" },
            { "chg", "\u010dagataj\u0161tina" },
            { "pau", "palau\u0161tina" },
            { "chk", "\u010duk\u0161tina" },
            { "chn", "\u010dinuk pid\u017ein" },
            { "chm", "marij\u0161tina" },
            { "chp", "\u010dipevaj\u0161tina" },
            { "cho", "\u010dokt\u0161tina" },
            { "chr", "\u010derok\u00e9z\u0161tina" },
            { "ER", "Eritrea" },
            { "ES", "\u0160pan\u011blsko" },
            { "ET", "Etiopie" },
            { "EU", "Evropsk\u00e1 unie" },
            { "elx", "elamit\u0161tina" },
            { "chy", "\u010dejen\u0161tina" },
            { "Inds", "harappsk\u00e9" },
            { "ady", "adygej\u0161tina" },
            { "aeb", "arab\u0161tina (tunisk\u00e1)" },
            { "FI", "Finsko" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Falklandsk\u00e9 ostrovy" },
            { "FM", "Mikron\u00e9sie" },
            { "FO", "Faersk\u00e9 ostrovy" },
            { "Taml", "tamilsk\u00e9" },
            { "FR", "Francie" },
            { "Kpel", metaValue_kpe },
            { "pcd", "picard\u0161tina" },
            { "tkl", "tokelau\u0161tina" },
            { "grb", "grebo" },
            { "root", "ko\u0159en" },
            { "rgn", "roma\u0148ol\u0161tina" },
            { "grc", "staro\u0159e\u010dtina" },
            { "GA", "Gabon" },
            { "tkr", "cachur\u0161tina" },
            { "vot", "vot\u0161tina" },
            { "GB", "Velk\u00e1 Brit\u00e1nie" },
            { "GD", "Grenada" },
            { "GE", "Gruzie" },
            { "GF", "Francouzsk\u00e1 Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f3nsko" },
            { "enm", "angli\u010dtina (st\u0159edov\u011bk\u00e1)" },
            { "GM", "Gambie" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Rovn\u00edkov\u00e1 Guinea" },
            { "GR", "\u0158ecko" },
            { "GS", "Ji\u017en\u00ed Georgie a Ji\u017en\u00ed Sandwichovy ostrovy" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "n\u011bm\u010dina (pensylv\u00e1nsk\u00e1)" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingon\u0161tina" },
            { "Talu", "tai l\u00fc nov\u00e9" },
            { "GY", "Guyana" },
            { "ckb", "kurd\u0161tina (sor\u00e1n\u00ed)" },
            { "zxx", "\u017e\u00e1dn\u00fd jazykov\u00fd obsah" },
            { "Jurc", "d\u017e\u00fcr\u010densk\u00e9" },
            { "tly", "taly\u0161tina" },
            { "pdt", "n\u011bm\u010dina (plautdietsch)" },
            { "Vaii", metaValue_vai },
            { "HK", "Hongkong \u2013 ZAO \u010c\u00edny" },
            { "HM", "Heard\u016fv ostrov a McDonaldovy ostrovy" },
            { "HN", "Honduras" },
            { "HR", "Chorvatsko" },
            { "agq", "aghem" },
            { "gsw", "n\u011bm\u010dina (\u0160v\u00fdcarsko)" },
            { "HT", "Haiti" },
            { "HU", "Ma\u010farsko" },
            { "rif", "r\u00edf\u0161tina" },
            { "tmh", "tama\u0161ek" },
            { "IC", "Kan\u00e1rsk\u00e9 ostrovy" },
            { "nan", "\u010d\u00edn\u0161tina (dialekty Minnan)" },
            { "ID", "Indon\u00e9sie" },
            { "peo", "staroper\u0161tina" },
            { "IE", "Irsko" },
            { "nap", "neapol\u0161tina" },
            { "naq", "nama\u0161tina" },
            { "zza", "zaza" },
            { "Tang", "tangut" },
            { "IL", "Izrael" },
            { "Nbat", "nabatejsk\u00e9" },
            { "IM", "Ostrov Man" },
            { "IN", "Indie" },
            { "IO", "Britsk\u00e9 indickooce\u00e1nsk\u00e9 \u00fazem\u00ed" },
            { "IQ", "Ir\u00e1k" },
            { "IR", "\u00cdr\u00e1n" },
            { "IS", "Island" },
            { "IT", "It\u00e1lie" },
            { "Zmth", "matematick\u00fd z\u00e1pis" },
            { "vro", "v\u00f5ru\u0161tina" },
            { "guc", "way\u00fau\u0161tina" },
            { "pfl", "fal\u010dtina" },
            { "JE", "Jersey" },
            { "JM", "Jamajka" },
            { "Beng", "beng\u00e1lsk\u00e9" },
            { "JO", "Jord\u00e1nsko" },
            { "gur", "frafra" },
            { "JP", "Japonsko" },
            { "ain", "ain\u0161tina" },
            { "Mend", "mendsk\u00e9" },
            { "guz", "gusii" },
            { "tog", "ton\u017e\u0161tina (nyasa)" },
            { "Kali", "kayah li" },
            { "Sidd", "siddham" },
            { "de_CH", "n\u011bm\u010dina standardn\u00ed (\u0160v\u00fdcarsko)" },
            { "izh", "ingrij\u0161tina" },
            { "KE", "Ke\u0148a" },
            { "419", "Latinsk\u00e1 Amerika" },
            { "KG", "Kyrgyzst\u00e1n" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komory" },
            { "KN", "Svat\u00fd Kry\u0161tof a Nevis" },
            { "Knda", "kannadsk\u00e9" },
            { "KP", "Severn\u00ed Korea" },
            { "KR", "Ji\u017en\u00ed Korea" },
            { "Plrd", "Pollardova fonetick\u00e1 abeceda" },
            { "KW", "Kuvajt" },
            { "tpi", "tok pisin" },
            { "KY", "Kajmansk\u00e9 ostrovy" },
            { "KZ", "Kazachst\u00e1n" },
            { "Cyrl", "cyrilice" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Svat\u00e1 Lucie" },
            { "phn", "f\u00e9ni\u010dtina" },
            { "Cyrs", "cyrilce - staroslov\u011bnsk\u00e1" },
            { "gwi", "gwich\u02bcin" },
            { "nds", "dolnon\u011bm\u010dina" },
            { "LI", "Lichten\u0161tejnsko" },
            { "LK", "Sr\u00ed Lanka" },
            { "akk", "akkad\u0161tina" },
            { "cop", "kopt\u0161tina" },
            { "LR", "Lib\u00e9rie" },
            { "esu", "jupik\u0161tina (st\u0159edoalja\u0161sk\u00e1)" },
            { "LS", "Lesotho" },
            { "Phlv", "pahlavsk\u00e9 kni\u017en\u00ed" },
            { "LT", "Litva" },
            { "LU", "Lucembursko" },
            { "LV", "Loty\u0161sko" },
            { "Kana", "katakana" },
            { "Sora", "sora sompeng" },
            { "LY", "Libye" },
            { "lad", "ladin\u0161tina" },
            { "vun", "vunjo" },
            { "akz", "alabam\u0161tina" },
            { "lah", "lahnd\u0161tina" },
            { "Mahj", "mah\u00e1d\u017ean\u00ed" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavsko" },
            { "Nshu", "n\u00fc-\u0161u" },
            { "ME", "\u010cern\u00e1 Hora" },
            { "MF", "Svat\u00fd Martin (Francie)" },
            { "lam", "lamb\u0161tina" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallovy ostrovy" },
            { "ale", "aleut\u0161tina" },
            { "Thai", "thajsk\u00e9" },
            { "MK", "Makedonie" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Barma)" },
            { "MN", "Mongolsko" },
            { "new", "n\u00e9v\u00e1r\u0161tina" },
            { "MO", "Macao \u2013 ZAO \u010c\u00edny" },
            { "aln", "alb\u00e1n\u0161tina (Gheg)" },
            { "MP", "Severn\u00ed Mariany" },
            { "MQ", "Martinik" },
            { "MR", "Maurit\u00e1nie" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "cps", "kapiznon\u0161tina" },
            { "MU", "Mauricius" },
            { "alt", "altaj\u0161tina (ji\u017en\u00ed)" },
            { "MV", "Maledivy" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malajsie" },
            { "MZ", "Mosambik" },
            { "Phli", "pahlavsk\u00e9 kl\u00ednov\u00e9" },
            { "NA", "Namibie" },
            { "NC", "Nov\u00e1 Kaledonie" },
            { "%%WADEGILE", "Wade-Giles" },
            { "tru", "turoj\u0161tina" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nig\u00e9rie" },
            { "trv", "taroko" },
            { "Phlp", "pahlavsk\u00e9 \u017ealmov\u00e9" },
            { "NI", "Nikaragua" },
            { "Hmng", "hmongsk\u00e9" },
            { "NL", "Nizozemsko" },
            { "NO", "Norsko" },
            { "NP", "Nep\u00e1l" },
            { "NR", "Nauru" },
            { "tsd", "tsakon\u0161tina" },
            { "NU", "Niue" },
            { "Phnx", "f\u00e9nick\u00e9" },
            { "rof", "rombo" },
            { "tsi", "tsim\u0161ijsk\u00e9 jazyky" },
            { "NZ", "Nov\u00fd Z\u00e9land" },
            { "Merc", "meroitick\u00e9 psac\u00ed" },
            { "rom", "rom\u0161tina" },
            { "Mero", "meroitick\u00e9" },
            { "crh", "ture\u010dtina (krymsk\u00e1)" },
            { "ang", "staroangli\u010dtina" },
            { "OM", "Om\u00e1n" },
            { "anp", "angika" },
            { "Xpeo", "staropersk\u00e9 kl\u00ednov\u00e9 p\u00edsmo" },
            { "PA", "Panama" },
            { "csb", "ka\u0161ub\u0161tina" },
            { "PE", "Peru" },
            { "ttt", "tat\u0161tina" },
            { "PF", "Francouzsk\u00e1 Polyn\u00e9sie" },
            { "PG", "Papua-Nov\u00e1 Guinea" },
            { "PH", "Filip\u00edny" },
            { "PK", "P\u00e1kist\u00e1n" },
            { "PL", "Polsko" },
            { "ewo", "ewondo" },
            { "PM", "Saint-Pierre a Miquelon" },
            { "PN", "Pitcairnovy ostrovy" },
            { "PR", "Portoriko" },
            { "PS", "Palestinsk\u00e1 \u00fazem\u00ed" },
            { "Bali", "balijsk\u00e9" },
            { "PT", "Portugalsko" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "PY", "Paraguay" },
            { "tum", "tumbuk\u0161tina" },
            { "Hebr", "hebrejsk\u00e9" },
            { "QA", "Katar" },
            { "%%SCOTLAND", "angli\u010dtina (Skotsko)" },
            { "jam", "jamajsk\u00e1 kreol\u0161tina" },
            { "pms", "piemon\u0161tina" },
            { "niu", "niue\u0161tina" },
            { "QO", "Vn\u011bj\u0161\u00ed Oce\u00e1nie" },
            { "ext", "extremadur\u0161tina" },
            { "lez", "lezgin\u0161tina" },
            { "tvl", "tuval\u0161tina" },
            { "Tavt", "tai viet" },
            { "001", "Sv\u011bt" },
            { "002", "Afrika" },
            { "njo", "ao (jazyky N\u00e1g\u00e1landu)" },
            { "003", "Severn\u00ed Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "Ji\u017en\u00ed Amerika" },
            { "lfn", "lingua franca nova" },
            { "jbo", "lojban" },
            { "pnt", "pont\u0161tina" },
            { "Rjng", "red\u017eansk\u00e9" },
            { "009", "Oce\u00e1nie" },
            { "RO", "Rumunsko" },
            { "RS", "Srbsko" },
            { "Mroo", "mro" },
            { "RU", "Rusko" },
            { "RW", "Rwanda" },
            { "Mani", "manichejsk\u00e9" },
            { "Ugar", "ugaritsk\u00e9 kl\u00ednov\u00e9" },
            { "Khar", "kh\u00e1r\u00f3\u0161th\u00ed" },
            { "SA", "Sa\u00fadsk\u00e1 Ar\u00e1bie" },
            { "pon", "pohnpei\u0161tina" },
            { "Mand", "mandejsk\u00e9" },
            { "SB", "\u0160alamounovy ostrovy" },
            { "twq", "tasawaq" },
            { "011", "Z\u00e1padn\u00ed Afrika" },
            { "SC", "Seychely" },
            { "SD", "S\u00fad\u00e1n" },
            { "013", "St\u0159edn\u00ed Amerika" },
            { "SE", "\u0160v\u00e9dsko" },
            { "014", "V\u00fdchodn\u00ed Afrika" },
            { "arc", "aramej\u0161tina" },
            { "Loma", "loma" },
            { "015", "Severn\u00ed Afrika" },
            { "SG", "Singapur" },
            { "SH", "Svat\u00e1 Helena" },
            { "017", "St\u0159edn\u00ed Afrika" },
            { "SI", "Slovinsko" },
            { "018", "Ji\u017en\u00ed Afrika" },
            { "SJ", "\u0160picberky a Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovensko" },
            { "Bamu", "bamumsk\u00e9" },
            { "Wole", "karol\u00ednsk\u00e9 (woleai)" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Som\u00e1lsko" },
            { "arn", "arauk\u00e1n\u0161tina" },
            { "arp", "arapa\u017e\u0161tina" },
            { "SR", "Surinam" },
            { "aro", "araon\u0161tina" },
            { "SS", "Ji\u017en\u00ed S\u00fad\u00e1n" },
            { "ST", "Svat\u00fd Tom\u00e1\u0161 a Princ\u016fv ostrov" },
            { "arq", "arab\u0161tina (al\u017e\u00edrsk\u00e1)" },
            { "SV", "Salvador" },
            { "SX", "Svat\u00fd Martin (Nizozemsko)" },
            { "SY", "S\u00fdrie" },
            { "yao", "jao\u0161tina" },
            { "SZ", "Svazijsko" },
            { "arw", "arawack\u00e9 jazyky" },
            { "arz", "arab\u0161tina (egyptsk\u00e1)" },
            { "ary", "arab\u0161tina (marock\u00e1)" },
            { "yap", "jap\u0161tina" },
            { "rtm", "rotuman\u0161tina" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "021", "Severn\u00ed Amerika (oblast)" },
            { "TC", "Turks a Caicos" },
            { "yav", "jangben\u0161tina" },
            { "TD", "\u010cad" },
            { "TF", "Francouzsk\u00e1 ji\u017en\u00ed \u00fazem\u00ed" },
            { "ase", "znakov\u00e1 \u0159e\u010d (americk\u00e1)" },
            { "TG", "Togo" },
            { "TH", "Thajsko" },
            { "TJ", "T\u00e1d\u017eikist\u00e1n" },
            { "029", "Karibik" },
            { "TK", "Tokelau" },
            { "TL", "V\u00fdchodn\u00ed Timor" },
            { "ybb", "yemba" },
            { "TM", "Turkmenist\u00e1n" },
            { "TN", "Tunisko" },
            { "TO", "Tonga" },
            { "TR", "Turecko" },
            { "TT", "Trinidad a Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tchaj-wan" },
            { "ast", "astur\u0161tina" },
            { "rue", "rus\u00edn\u0161tina" },
            { "rug", "rovian\u0161tina" },
            { "Orkh", "orchonsk\u00e9" },
            { "TZ", "Tanzanie" },
            { "nmg", "kwasio" },
            { "Zzzz", "nezn\u00e1m\u00e9 p\u00edsmo" },
            { "Sind", "chud\u00e1b\u00e1d\u00ed" },
            { "UA", "Ukrajina" },
            { "lij", "ligur\u0161tina" },
            { "rup", "arumun\u0161tina" },
            { "030", "V\u00fdchodn\u00ed Asie" },
            { "tyv", "tuvin\u0161tina" },
            { "sw_CD", "svahil\u0161tina (Kongo)" },
            { "034", "Ji\u017en\u00ed Asie" },
            { "hai", "haid\u0161tina" },
            { "035", "Jihov\u00fdchodn\u00ed Asie" },
            { "UG", "Uganda" },
            { "hak", "\u010d\u00edn\u0161tina (dialekty Hakka)" },
            { "039", "Ji\u017en\u00ed Evropa" },
            { "Sinh", "sinh\u00e1lsk\u00e9" },
            { "UM", "Men\u0161\u00ed odlehl\u00e9 ostrovy USA" },
            { "liv", "livon\u0161tina" },
            { "US", "Spojen\u00e9 st\u00e1ty" },
            { "haw", "havaj\u0161tina" },
            { "UY", "Uruguay" },
            { "prg", "pru\u0161tina" },
            { "UZ", "Uzbekist\u00e1n" },
            { "tzm", "tamazight (st\u0159edn\u00ed Maroko)" },
            { "nnh", "ngiemboon" },
            { "VA", "Vatik\u00e1n" },
            { "pro", "provens\u00e1l\u0161tina" },
            { "VC", "Svat\u00fd Vincenc a Grenadiny" },
            { "VE", "Venezuela" },
            { "VG", "Britsk\u00e9 Panensk\u00e9 ostrovy" },
            { "VI", "Americk\u00e9 Panensk\u00e9 ostrovy" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogaj\u0161tina" },
            { "rwk", "rwa" },
            { "non", "nor\u0161tina historick\u00e1" },
            { "053", "Australasie" },
            { "054", "Melan\u00e9sie" },
            { "WF", "Wallis a Futuna" },
            { "057", "Mikron\u00e9sie (region)" },
            { "jgo", "ngomba" },
            { "lkt", "lakot\u0161tina" },
            { "nov", "novial" },
            { "avk", "kotava" },
            { "wae", "n\u011bm\u010dina (walser)" },
            { "WS", "Samoa" },
            { "Bass", "bassa vah" },
            { "wal", "wolajt\u0161tina" },
            { "was", "wa\u0161tina" },
            { "war", "waraj\u0161tina" },
            { "awa", "awadh\u0161tina" },
            { "061", "Polyn\u00e9sie" },
            { "XK", "Kosovo" },
            { "Gujr", "gud\u017ear\u00e1t\u00ed" },
            { "Zxxx", "bez z\u00e1pisu" },
            { "Olck", "sant\u00e1lsk\u00e9 (ol chiki)" },
            { "wbp", "warlpiri" },
            { "Batk", "batack\u00e9" },
            { "Blis", "Blissovo p\u00edsmo" },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "lmo", "lombard\u0161tina" },
            { "fan", "fang" },
            { "fat", "fant\u0161tina" },
            { "Sgnw", "SignWriting" },
            { "YT", "Mayotte" },
            { "ZA", "Jihoafrick\u00e1 republika" },
            { "Deva", "d\u00e9van\u00e1g\u00e1r\u00ed" },
            { "Hira", "hiragana" },
            { "ZM", "Zambie" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Nezn\u00e1m\u00e1 oblast" },
            { "Runr", "runov\u00e9" },
            { "lol", "mong\u0161tina" },
            { "nso", "sot\u0161tina (severn\u00ed)" },
            { "loz", "loz\u0161tina" },
            { "Nkgb", "naxi geba" },
            { "jmc", "ma\u0161ame" },
            { "hif", "hind\u0161tina (Fid\u017ei)" },
            { "hil", "hiligajnon\u0161tina" },
            { "nus", "nuer\u0161tina" },
            { "dak", "dakot\u0161tina" },
            { "hit", "chetit\u0161tina" },
            { "dar", "darg\u0161tina" },
            { "dav", "taita" },
            { "Maya", "maysk\u00e9 hieroglyfy" },
            { "lrc", "l\u00far\u0161tina (severn\u00ed)" },
            { "Copt", "koptsk\u00e9" },
            { "nwc", "newar\u0161tina (klasick\u00e1)" },
            { "udm", "udmurt\u0161tina" },
            { "Khmr", "khmersk\u00e9" },
            { "Limb", "limbu" },
            { "sad", "sandaw\u0161tina" },
            { "sah", "jakut\u0161tina" },
            { "ltg", "latgal\u0161tina" },
            { "sam", "samar\u0161tina" },
            { "Aghb", "kavkazskoalb\u00e1nsk\u00e9" },
            { "saq", "samburu" },
            { "sas", "sasak\u0161tina" },
            { "sat", "sant\u00e1l\u0161tina" },
            { "Tfng", "berbersk\u00e9" },
            { "jpr", "judeoper\u0161tina" },
            { "saz", "saur\u00e1\u0161ter\u0161tina" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "lua", "luba-lulua\u0161tina" },
            { "sbp", "sango\u0161tina" },
            { "lui", "luise\u0148o" },
            { "nyn", "\u0148ankol\u0161tina" },
            { "nym", "\u0148amwe\u017e\u0161tina" },
            { "lun", "lund\u0161tina" },
            { "nyo", "\u0148or\u0161tina" },
            { "luo", "luo\u0161tina" },
            { "fil", "filip\u00edn\u0161tina" },
            { "hmn", "hmong\u0161tina" },
            { "del", "delawar\u0161tina" },
            { "lus", "mizo\u0161tina" },
            { "bal", "bal\u00fa\u010d\u0161tina" },
            { "den", "slejv\u0161tina (athabask\u00fd jazyk)" },
            { "ban", "balij\u0161tina" },
            { "uga", "ugarit\u0161tina" },
            { "fit", "fin\u0161tina (tornedalsk\u00e1)" },
            { "luy", "luhja" },
            { "bar", "bavor\u0161tina" },
            { "bas", "basa" },
            { "bax", "bamun" },
            { "jrb", "judeoarab\u0161tina" },
            { "es_ES", "\u0161pan\u011bl\u0161tina (Evropa)" },
            { "nzi", "nzima" },
            { "sco", "skot\u0161tina" },
            { "scn", "sicil\u0161tina" },
            { "aa", "afar\u0161tina" },
            { "ab", "abch\u00e1z\u0161tina" },
            { "bbc", "batak toba" },
            { "ae", "avest\u00e1n\u0161tina" },
            { "af", "afrik\u00e1n\u0161tina" },
            { "ak", "akan\u0161tina" },
            { "bbj", "ghomala" },
            { "am", "amhar\u0161tina" },
            { "an", "aragon\u0161tina" },
            { "Arab", "arabsk\u00e9" },
            { "Jpan", "japonsk\u00e9" },
            { "ar", "arab\u0161tina" },
            { "Hrkt", "japonsk\u00e9 slabi\u010dn\u00e9" },
            { "as", "\u00e1s\u00e1m\u0161tina" },
            { "sdc", "sassar\u0161tina" },
            { "Lina", "line\u00e1rn\u00ed A" },
            { "av", "avar\u0161tina" },
            { "Linb", "line\u00e1rn\u00ed B" },
            { "sdh", "kurd\u0161tina (ji\u017en\u00ed)" },
            { "ay", "ajmar\u0161tina" },
            { "az", "\u00e1zerb\u00e1jd\u017e\u00e1n\u0161tina" },
            { "Khoj", "chod\u017eiki" },
            { "ba", "ba\u0161kir\u0161tina" },
            { "be", "b\u011bloru\u0161tina" },
            { "bg", "bulhar\u0161tina" },
            { "bi", "bislam\u0161tina" },
            { "bm", "bambar\u0161tina" },
            { "bn", "beng\u00e1l\u0161tina" },
            { "bo", "tibet\u0161tina" },
            { "dgr", "dogrib" },
            { "br", "breton\u0161tina" },
            { "bs", "bosen\u0161tina" },
            { "see", "seneca" },
            { "Mymr", "myanmarsk\u00e9" },
            { "sei", "seri\u0161tina" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkup\u0161tina" },
            { "ca", "katal\u00e1n\u0161tina" },
            { "ses", "koyraboro senni" },
            { "ce", "\u010de\u010den\u0161tina" },
            { "ch", "\u010damoro" },
            { "co", "korsi\u010dtina" },
            { "Orya", "urijsk\u00e9" },
            { "cr", "kr\u00edj\u0161tina" },
            { "cs", "\u010de\u0161tina" },
            { "cu", "staroslov\u011bn\u0161tina" },
            { "yrl", "nheengatu" },
            { "cv", "\u010duva\u0161tina" },
            { "cy", "vel\u0161tina" },
            { "Yiii", "yi" },
            { "da", "d\u00e1n\u0161tina" },
            { "pt_PT", "portugal\u0161tina (Evropa)" },
            { "de", "n\u011bm\u010dina" },
            { "bej", "bed\u017ea" },
            { "din", "dink\u0161tina" },
            { "jut", "jut\u0161tina" },
            { "Bugi", "buginsk\u00e9" },
            { "bem", "bemb\u0161tina" },
            { "sga", "ir\u0161tina (star\u00e1)" },
            { "dv", "malediv\u0161tina" },
            { "bew", "batav\u0161tina" },
            { "dz", "dzongk\u00e4" },
            { "bez", "bena" },
            { "lzh", "\u010d\u00edn\u0161tina (klasick\u00e1)" },
            { "Lisu", "Fraserovo" },
            { "dje", "zarm\u0161tina" },
            { "sgs", "\u017eemait\u0161tina" },
            { "ee", "ewe\u0161tina" },
            { "bfd", "bafut" },
            { "ro_MD", "moldav\u0161tina" },
            { "el", "\u0159e\u010dtina" },
            { "en", "angli\u010dtina" },
            { "eo", "esperanto" },
            { "bfq", "badag\u0161tina" },
            { "lzz", "laz\u0161tina" },
            { "es", "\u0161pan\u011bl\u0161tina" },
            { "et", "eston\u0161tina" },
            { "eu", "baski\u010dtina" },
            { "Buhd", "buhidsk\u00e9" },
            { "Hang", "hangul" },
            { "Samr", "sama\u0159sk\u00e9" },
            { "shi", "tachelhit" },
            { "hsb", "hornolu\u017eick\u00e1 srb\u0161tina" },
            { "Hani", "han" },
            { "shn", "\u0161an\u0161tina" },
            { "Hano", "hanun\u00f3o" },
            { "fa", "per\u0161tina" },
            { "Hans", "zjednodu\u0161en\u00e9" },
            { "Hant", "tradi\u010dn\u00ed" },
            { "ff", "fulb\u0161tina" },
            { "shu", "arab\u0161tina (\u010dadsk\u00e1)" },
            { "hsn", "\u010d\u00edn\u0161tina (dialekty Xiang)" },
            { "fi", "fin\u0161tina" },
            { "fj", "fid\u017eij\u0161tina" },
            { "fon", "fon\u0161tina" },
            { "bgn", "bal\u00fa\u010d\u0161tina (z\u00e1padn\u00ed)" },
            { "yue", "kanton\u0161tina" },
            { "fo", "faer\u0161tina" },
            { "umb", "umbundu" },
            { "fr", "francouz\u0161tina" },
            { "sid", "sidamo" },
            { "fy", "fr\u00ed\u0161tina" },
            { "ga", "ir\u0161tina" },
            { "gd", "skotsk\u00e1 gael\u0161tina" },
            { "gl", "galicij\u0161tina" },
            { "gn", "guaran\u0161tina" },
            { "bho", "bhojpur\u0161tina" },
            { "und", "nezn\u00e1m\u00fd jazyk" },
            { "gu", "gud\u017ear\u00e1t\u0161tina" },
            { "gv", "man\u0161tina" },
            { "ha", "hau\u0161tina" },
            { "he", "hebrej\u0161tina" },
            { "hi", "hind\u0161tina" },
            { "hup", "hupa" },
            { "bik", "bikol\u0161tina" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "chorvat\u0161tina" },
            { "ht", "hait\u0161tina" },
            { "hu", "ma\u010far\u0161tina" },
            { "hy", "arm\u00e9n\u0161tina" },
            { "hz", "herer\u0161tina" },
            { "frc", "francouz\u0161tina (kajunsk\u00e1)" },
            { "ia", "interlingua" },
            { "id", "indon\u00e9\u0161tina" },
            { "ie", "interlingue" },
            { "ig", "igbo\u0161tina" },
            { "ii", "i\u0161tina (se\u010du\u00e1nsk\u00e1)" },
            { "frm", "francouz\u0161tina (st\u0159edov\u011bk\u00e1)" },
            { "ik", "inupiak\u0161tina" },
            { "fro", "francouz\u0161tina (star\u00e1)" },
            { "frp", "franko-provens\u00e1l\u0161tina" },
            { "io", "ido" },
            { "frs", "fr\u00ed\u0161tina (v\u00fdchodn\u00ed)" },
            { "bjn", "band\u017ear\u0161tina" },
            { "frr", "fr\u00ed\u0161tina (severn\u00ed)" },
            { "is", "island\u0161tina" },
            { "it", "ital\u0161tina" },
            { "iu", "inuktitut\u0161tina" },
            { "sli", "n\u011bm\u010dina (slezsk\u00e1)" },
            { "ja", "japon\u0161tina" },
            { "Mlym", "malajl\u00e1msk\u00e9" },
            { "Sarb", "starojihoarabsk\u00e9" },
            { "Sara", "sarati" },
            { "doi", "dogar\u0161tina" },
            { "sly", "selajar\u0161tina" },
            { "bkm", "kom" },
            { "sma", "s\u00e1m\u0161tina (ji\u017en\u00ed)" },
            { "jv", "jav\u00e1n\u0161tina" },
            { "Shaw", "Shawova abeceda" },
            { "mad", "madur\u0161tina" },
            { "smj", "s\u00e1m\u0161tina (lulejsk\u00e1)" },
            { "mag", "magahij\u0161tina" },
            { "maf", "mafa" },
            { "mai", "maithili\u0161tina" },
            { "smn", "s\u00e1m\u0161tina (inarijsk\u00e1)" },
            { "ka", "gruz\u00edn\u0161tina" },
            { "bla", "siksika" },
            { "mak", "makasar\u0161tina" },
            { "wuu", "\u010d\u00edn\u0161tina (dialekty Wu)" },
            { "sms", "s\u00e1m\u0161tina (skoltsk\u00e1)" },
            { "man", "manding\u0161tina" },
            { "kg", "kon\u017e\u0161tina" },
            { "Goth", "gotick\u00e9" },
            { "ki", "kikuj\u0161tina" },
            { "mas", "masaj\u0161tina" },
            { "kj", "kua\u0148am\u0161tina" },
            { "kk", "kaza\u0161tina" },
            { "kl", "gr\u00f3n\u0161tina" },
            { "km", "khm\u00e9r\u0161tina" },
            { "kn", "kannad\u0161tina" },
            { "ko", "korej\u0161tina" },
            { "kr", "kanuri" },
            { "ks", "ka\u0161m\u00edr\u0161tina" },
            { "Cirt", "kirt" },
            { "Lepc", "lep\u010dsk\u00e9" },
            { "Avst", "avest\u00e1nsk\u00e9" },
            { "ku", "kurd\u0161tina" },
            { "kv", "komij\u0161tina" },
            { "kw", "korn\u0161tina" },
            { "ky", "kyrgyz\u0161tina" },
            { "snk", "sonik\u0161tina" },
            { "la", "latina" },
            { "lb", "lucembur\u0161tina" },
            { "lg", "gand\u0161tina" },
            { "Roro", "rongorongo" },
            { "li", "limbur\u0161tina" },
            { "Tibt", "tibetsk\u00e9" },
            { "ln", "lingal\u0161tina" },
            { "fur", "furlan\u0161tina" },
            { "lo", "lao\u0161tina" },
            { "lt", "litev\u0161tina" },
            { "lu", "lubu-katan\u017e\u0161tina" },
            { "lv", "loty\u0161tina" },
            { "sog", "sogd\u0161tina" },
            { "mg", "malga\u0161tina" },
            { "mh", "mar\u0161\u00e1l\u0161tina" },
            { "mi", "maor\u0161tina" },
            { "mk", "makedon\u0161tina" },
            { "ml", "malaj\u00e1lam\u0161tina" },
            { "mn", "mongol\u0161tina" },
            { "mr", "mar\u00e1th\u0161tina" },
            { "ms", "malaj\u0161tina" },
            { "mt", "malt\u0161tina" },
            { "my", "barm\u0161tina" },
            { "Saur", "saur\u00e1\u0161tersk\u00e9" },
            { "Armn", "arm\u00e9nsk\u00e9" },
            { "mdf", "mok\u0161an\u0161tina" },
            { "mde", "maba" },
            { "dsb", "dolnolu\u017eick\u00e1 srb\u0161tina" },
            { "Armi", "aramejsk\u00e9 (imperi\u00e1ln\u00ed)" },
            { "na", "naur\u0161tina" },
            { "nb", "nor\u0161tina (bokm\u00e5l)" },
            { "nd", "ndebele (Zimbabwe)" },
            { "ne", "nep\u00e1l\u0161tina" },
            { "ng", "ndond\u0161tina" },
            { "mdr", "mandar" },
            { "nl", "nizozem\u0161tina" },
            { "nn", "nor\u0161tina (nynorsk)" },
            { "no", "nor\u0161tina" },
            { "nr", "ndebele (Ji\u017en\u00ed Afrika)" },
            { "nv", "nava\u017e\u0161tina" },
            { "kaa", "karakalpa\u010dtina" },
            { "ny", "\u0148and\u017e\u0161tina" },
            { "kac", "ka\u010dij\u0161tina" },
            { "kab", "kabyl\u0161tina" },
            { "oc", "okcit\u00e1n\u0161tina" },
            { "kaj", "jju" },
            { "kam", "kamb\u0161tina" },
            { "men", "mende" },
            { "oj", "od\u017eibvej\u0161tina" },
            { "mer", "meru" },
            { "om", "orom\u0161tina" },
            { "kaw", "kawi" },
            { "dtp", "kadazandusun\u0161tina" },
            { "or", "urij\u0161tina" },
            { "Modi", "mod\u00ed" },
            { "os", "oset\u0161tina" },
            { "bpy", "bi\u0161nuprijskomanipur\u0161tina" },
            { "kbd", "kabardin\u0161tina" },
            { "mfe", "mauricijsk\u00e1 kreol\u0161tina" },
            { "srn", "sranan tongo" },
            { "pa", "pa\u0148d\u017e\u00e1b\u0161tina" },
            { "dua", "dual\u0161tina" },
            { "srr", "serer\u0161tina" },
            { "kbl", "kanembu" },
            { "pi", "p\u00e1l\u00ed" },
            { "bqi", "bachtij\u00e1r\u0161tina" },
            { "pl", "pol\u0161tina" },
            { "dum", "holand\u0161tina (st\u0159edov\u011bk\u00e1)" },
            { "ps", "pa\u0161t\u0161tina" },
            { "pt", "portugal\u0161tina" },
            { "mga", "ir\u0161tina (st\u0159edov\u011bk\u00e1)" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "bra", "brad\u017e\u0161tina" },
            { "Laoo", "laosk\u00e9" },
            { "mgo", "meta\u2019" },
            { "ssy", "saho" },
            { "brh", "brahuj\u0161tina" },
            { "qu", "ke\u010du\u00e1n\u0161tina" },
            { "zap", "zapot\u00e9\u010dtina" },
            { "brx", "bodo\u0161tina" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "stq", "fr\u00ed\u0161tina (saterlandsk\u00e1)" },
            { "Ethi", "etiopsk\u00e9" },
            { "rm", "r\u00e9torom\u00e1n\u0161tina" },
            { "rn", "kirund\u0161tina" },
            { "ro", "rumun\u0161tina" },
            { "ru", "ru\u0161tina" },
            { "bss", "akoose" },
            { "rw", "ki\u0148arwand\u0161tina" },
            { "zbl", "bliss syst\u00e9m" },
            { "kea", "kapverd\u0161tina" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "Dupl", "Duploy\u00e9ho t\u011bsnopis" },
            { "sa", "sanskrt" },
            { "sc", "sard\u0161tina" },
            { "sus", "susu" },
            { "sd", "sindh\u0161tina" },
            { "se", "s\u00e1m\u0161tina (severn\u00ed)" },
            { "min", "minangkabau" },
            { "sg", "sang\u0161tina" },
            { "sh", "srbochorvat\u0161tina" },
            { "ken", "kenyang" },
            { "si", "sinh\u00e1l\u0161tina" },
            { "sux", "sumer\u0161tina" },
            { "sk", "sloven\u0161tina" },
            { "sl", "slovin\u0161tina" },
            { "Gran", "grantha" },
            { "sm", "samoj\u0161tina" },
            { "sn", "\u0161on\u0161tina" },
            { "so", "som\u00e1l\u0161tina" },
            { "sq", "alb\u00e1n\u0161tina" },
            { "sr", "srb\u0161tina" },
            { "ss", "siswat\u0161tina" },
            { "st", "sot\u0161tina (ji\u017en\u00ed)" },
            { "Java", "jav\u00e1nsk\u00e9" },
            { "su", "sund\u0161tina" },
            { "sv", "\u0161v\u00e9d\u0161tina" },
            { "sw", "svahil\u0161tina" },
            { "ibb", "ibibio" },
            { "iba", "iban\u0161tina" },
            { "ta", "tamil\u0161tina" },
            { "142", "Asie" },
            { "bua", "burjat\u0161tina" },
            { "143", "St\u0159edn\u00ed Asie" },
            { "te", "telug\u0161tina" },
            { "145", "Z\u00e1padn\u00ed Asie" },
            { "tg", "t\u00e1d\u017ei\u010dtina" },
            { "th", "thaj\u0161tina" },
            { "ti", "tigrinij\u0161tina" },
            { "bug", "bugi\u0161tina" },
            { "kfo", "koro" },
            { "tk", "turkmen\u0161tina" },
            { "tl", "tagalog" },
            { "tn", "setswan\u0161tina" },
            { "to", "tong\u00e1n\u0161tina" },
            { "bum", "bulu" },
            { "dyo", "jola-fonyi" },
            { "tr", "ture\u010dtina" },
            { "ts", "tsonga" },
            { "swb", "komor\u0161tina" },
            { "Cakm", "\u010dakma" },
            { "tt", "tatar\u0161tina" },
            { "dyu", "djula" },
            { "tw", "twi" },
            { "ty", "tahit\u0161tina" },
            { "150", "Evropa" },
            { "151", "V\u00fdchodn\u00ed Evropa" },
            { "154", "Severn\u00ed Evropa" },
            { "dzg", "dazaga" },
            { "155", "Z\u00e1padn\u00ed Evropa" },
            { "ug", "ujgur\u0161tina" },
            { "Ital", "etrusk\u00e9" },
            { "Kore", "korejsk\u00e9" },
            { "kgp", "kaingang" },
            { "Zyyy", "obecn\u00e9" },
            { "uk", "ukrajin\u0161tina" },
            { "zea", "z\u00e9land\u0161tina" },
            { "ur", "urd\u0161tina" },
            { "xal", "kalmy\u010dtina" },
            { "zen", "zenaga" },
            { "uz", "uzbe\u010dtina" },
            { "kha", "kh\u00e1s\u00ed" },
            { "nds_NL", "dolnosa\u0161tina" },
            { "Sylo", "sylhetsk\u00e9" },
            { "ve", "venda" },
            { "Wara", "varang k\u0161iti" },
            { "vi", "vietnam\u0161tina" },
            { "kho", "chot\u00e1n\u0161tina" },
            { "khq", "koyra chiini" },
            { "vo", "volap\u00fck" },
            { "khw", "chovar\u0161tina" },
            { "syc", "syr\u0161tina (klasick\u00e1)" },
            { "Osma", "osmansk\u00e9" },
            { "quc", "ki\u010d\u00e9" },
            { "qug", "ke\u010du\u00e1n\u0161tina (chimborazo)" },
            { "gaa", "ga\u0161tina" },
            { "wa", "valon\u0161tina" },
            { "gag", "gagauz\u0161tina" },
            { "syr", "syr\u0161tina" },
            { "Grek", "\u0159eck\u00e9" },
            { "gan", "\u010d\u00edn\u0161tina (dialekty Gan)" },
            { "kiu", "zazak\u0161tina" },
            { "Lydi", "l\u00fddsk\u00e9" },
            { "Xsux", "sumero-akkadsk\u00e9 kl\u00ednov\u00e9 p\u00edsmo" },
            { "wo", "wolof\u0161tina" },
            { "zgh", "tamazight (standardn\u00ed marock\u00fd)" },
            { "ar_001", "arab\u0161tina (modern\u00ed standardn\u00ed)" },
            { "Cans", "slabi\u010dn\u00e9 p\u00edsmo kanadsk\u00fdch domorodc\u016f" },
            { "gay", "gayo" },
            { "Mong", "mongolsk\u00e9" },
            { "mnc", "mand\u017eu\u0161tina" },
            { "Latf", "latinka - lomen\u00e1" },
            { "szl", "slez\u0161tina" },
            { "Hluw", "anatolsk\u00e9 hieroglyfy" },
            { "gba", "gbaja" },
            { "mni", "manipur\u0161tina" },
            { "Latn", "latinka" },
            { "Latg", "latinka - galsk\u00e1" },
            { "xh", "xho\u0161tina" },
            { "byn", "blin\u0161tina" },
            { "Lyci", "l\u00fdkijsk\u00e9" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "gbz", "dar\u00edj\u0161tina (zoroastrijsk\u00e1)" },
            { "Moon", "Moonovo" },
            { "moh", "mohawk\u0161tina" },
            { "kkj", "kako" },
            { "yi", "jidi\u0161" },
            { "mos", "mosi" },
            { "Syrc", "syrsk\u00e9" },
            { "Dsrt", "deseret" },
            { "yo", "jorub\u0161tina" },
            { "Syrj", "syrsk\u00e9 - z\u00e1padn\u00ed" },
            { "ota", "ture\u010dtina (osmansk\u00e1)" },
            { "Syre", "syrsk\u00e9 - estrangelo" },
            { "vai", metaValue_vai },
            { "za", "\u010duang\u0161tina" },
            { "Cari", "karijsk\u00e9" },
            { "kln", "kalend\u017ein" },
            { "zh", "\u010d\u00edn\u0161tina" },
            { "Afak", "afaka" },
            { "Bopo", "bopomofo" },
            { "Perm", "staropermsk\u00e9" },
            { "zu", "zulu\u0161tina" },
            { "Geor", "gruz\u00ednsk\u00e9" },
            { "Shrd", "\u0161\u00e1rad\u00e1" },
            { "kmb", "kimbund\u0161tina" },
            { "Cham", "\u010dam" },
            { "gez", "geez" },
            { "mrj", "marij\u0161tina (z\u00e1padn\u00ed)" },
            { "Syrn", "syrsk\u00e9 - v\u00fdchodn\u00ed" },
            { "Elba", "elbasansk\u00e9" },
            { "Narb", "staroseveroarabsk\u00e9" },
            { "Tglg", "tagalsk\u00e9" },
            { "Egyd", "egyptsk\u00e9 d\u00e9motick\u00e9" },
            { "Egyh", "egyptsk\u00e9 hieratick\u00e9" },
            { "Palm", "palm\u00fdrsk\u00e9" },
            { "ebu", "embu" },
            { "Egyp", "egyptsk\u00e9 hieroglyfy" },
            { "Geok", "gruz\u00ednsk\u00e9 chutsuri" },
            { "zh_Hans", "\u010d\u00edn\u0161tina (zjednodu\u0161en\u00e1)" },
            { "koi", "komi-permja\u010dtina" },
            { "Hung", "staroma\u010farsk\u00e9" },
            { "kok", "konk\u00e1n\u0161tina" },
            { "kos", "kosraj\u0161tina" },
            { "vec", "ben\u00e1t\u0161tina" },
            { "Sund", "sundsk\u00e9" },
            { "vep", "vep\u0161tina" },
            { "kpe", metaValue_kpe },
            { "Tirh", "tirhuta" },
            { "ilo", "ilok\u00e1n\u0161tina" },
            { "Cprt", "kypersk\u00e9" },
            { "mua", "mundang" },
            { "mul", "slo\u017een\u00e9 (v\u00edce\u0159\u00e1dkov\u00e9) jazyky" },
            { "cad", "caddo" },
            { "mus", "kr\u00edk\u0161tina" },
            { "Glag", "hlaholice" },
            { "gil", "kiribat\u0161tina" },
            { "Cher", "\u010derok\u00ed" },
            { "car", "karib\u0161tina" },
            { "cay", "kajug\u0161tina" },
            { "krc", "kara\u010dajevo-balkar\u0161tina" },
            { "inh", "ingu\u0161tina" },
            { "krj", "kinaraj-a" },
            { "kri", "krio" },
            { "krl", "karel\u0161tina" },
            { "efi", "efik\u0161tina" },
            { "tcy", "tulu\u0161tina" },
            { "kru", "kuruch\u0161tina" },
            { "ksb", "\u0161ambala" },
            { "Telu", "telugsk\u00e9" },
            { "ksf", "bafia" },
        };
        return data;
    }
}
