/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts.xy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemChange;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemPainter;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerGCXYItem;

public class ProfilerGCXYItemPainter
extends SynchronousXYItemPainter {
    public static ProfilerGCXYItemPainter painter(Color color) {
        return new ProfilerGCXYItemPainter(color);
    }

    ProfilerGCXYItemPainter(Color color) {
        super(0.0f, null, color, 0, 0);
    }

    public LongRect getItemBounds(ChartItem chartItem, ChartContext chartContext) {
        LongRect longRect = super.getItemBounds(chartItem, chartContext);
        longRect.y = 0L;
        longRect.height = chartContext.getViewportHeight();
        return longRect;
    }

    public LongRect getDirtyBounds(ChartItemChange chartItemChange, ChartContext chartContext) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        ProfilerGCXYItem profilerGCXYItem = (ProfilerGCXYItem)xYItemChange.getItem();
        int[] nArray = xYItemChange.getValuesIndexes();
        if (nArray.length == 1 && nArray[0] == -1) {
            LongRect longRect = xYItemChange.getDirtyValuesBounds();
            long l = (long)chartContext.getViewX((double)longRect.x);
            long l2 = (long)chartContext.getViewY((double)(chartContext.getDataOffsetY() + chartContext.getDataHeight()));
            long l3 = (long)chartContext.getViewWidth((double)longRect.width);
            long l4 = chartContext.getViewportHeight();
            return new LongRect(l, l2, l3, l4);
        }
        int n = nArray[nArray.length - 1];
        long l = -1L;
        long l5 = -1L;
        for (int i = nArray[0]; i <= n; ++i) {
            long[] lArray = profilerGCXYItem.getGCEnds(i);
            if (lArray.length <= 0) continue;
            l5 = lArray[lArray.length - 1];
            if (l != -1L) continue;
            long[] lArray2 = profilerGCXYItem.getGCStarts(i);
            l = lArray2[0];
        }
        if (l == -1L) {
            return new LongRect();
        }
        if (l5 == -1L) {
            l5 = profilerGCXYItem.getXValue(profilerGCXYItem.getValuesCount() - 1);
        }
        long l6 = (long)chartContext.getViewX((double)l);
        long l7 = (long)chartContext.getViewY((double)(chartContext.getDataOffsetY() + chartContext.getDataHeight()));
        long l8 = (long)chartContext.getViewWidth((double)(l5 - l));
        l8 = Math.max(l8, 1L);
        long l9 = chartContext.getViewportHeight();
        return new LongRect(l6, l7, l8, l9);
    }

    public double getItemView(double d, XYItem xYItem, ChartContext chartContext) {
        return 0.0;
    }

    public double getItemValue(double d, XYItem xYItem, ChartContext chartContext) {
        return 0.0;
    }

    public double getItemValueScale(XYItem xYItem, ChartContext chartContext) {
        return -1.0;
    }

    protected void paint(XYItem xYItem, List<ItemSelection> list, List<ItemSelection> list2, Graphics2D graphics2D, Rectangle rectangle, SynchronousXYChartContext synchronousXYChartContext) {
        int n;
        int n2;
        int n3 = xYItem.getValuesCount();
        if (n3 < 2) {
            return;
        }
        if (synchronousXYChartContext.getViewWidth() == 0L || synchronousXYChartContext.getViewHeight() == 0L) {
            return;
        }
        int[][] nArray = synchronousXYChartContext.getVisibleBounds(rectangle);
        int n4 = nArray[0][0];
        int n5 = n4;
        if (n5 == -1) {
            n5 = nArray[0][1];
        }
        if (n5 == -1) {
            return;
        }
        int n6 = nArray[1][0];
        int n7 = n6;
        if (n7 == -1) {
            n7 = nArray[1][1];
        }
        if (n7 == -1) {
            n7 = n3 - 1;
        }
        if (n6 != -1 && n7 < n3 - 1) {
            ++n7;
        }
        if ((n2 = (int)Math.ceil((double)n3 / (double)synchronousXYChartContext.getViewWidth())) == 0) {
            n2 = 1;
        }
        int n8 = n7 - n5 + 1;
        if (n2 > 1) {
            int n9 = n5 % n2;
            n = n7 % n2;
            n7 = n7 - n + n2;
            n8 = (n7 - (n5 -= n9)) / n2 + 1;
            n7 = Math.min(n7, n3 - 1);
        }
        ProfilerGCXYItem profilerGCXYItem = (ProfilerGCXYItem)xYItem;
        graphics2D.setColor(this.fillColor);
        n = (int)synchronousXYChartContext.getViewY((double)(synchronousXYChartContext.getDataOffsetY() + synchronousXYChartContext.getDataHeight()));
        int n10 = synchronousXYChartContext.getViewportHeight();
        for (int i = 0; i < n8; ++i) {
            long[] lArray = profilerGCXYItem.getGCStarts(n5);
            if (lArray.length > 0) {
                long[] lArray2 = profilerGCXYItem.getGCEnds(n5);
                for (int j = 0; j < lArray.length; ++j) {
                    int n11 = Utils.checkedInt((double)synchronousXYChartContext.getViewX((double)lArray[j]));
                    long l = lArray2[j];
                    if (l == -1L) {
                        l = xYItem.getXValue(xYItem.getValuesCount() - 1);
                    }
                    int n12 = Utils.checkedInt((double)synchronousXYChartContext.getViewWidth((double)(l - lArray[j])));
                    graphics2D.fillRect(n11, n, Math.max(n12, 1), n10);
                }
            }
            n5 = Math.min(n5 + n2, n7);
        }
    }
}

