/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jspecview.application.MainFrame;
import jspecview.common.JSVersion;
import org.jmol.api.JSVInterface;
import org.jmol.util.Logger;

public class JSpecView
implements JSVInterface {
    private MainFrame mainFrame;
    private static String propertiesFileName = "jspecview.properties";

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.info("JSpecView Application " + JSVersion.VERSION);
        JSpecView jsv = new JSpecView();
        jsv.mainFrame = new MainFrame(null, jsv);
        if (args.length > 0) {
            if (args.length == 2 && args[0].equalsIgnoreCase("-script")) {
                jsv.mainFrame.runScriptNow(args[1]);
            } else {
                int i = 0;
                while (i < args.length) {
                    System.out.println("JSpecView is attempting to open " + args[i]);
                    jsv.mainFrame.vwr.openFile(args[i], false);
                    ++i;
                }
            }
        }
        jsv.mainFrame.setVisible(true);
    }

    @Override
    public void runScript(String script) {
        this.mainFrame.runScriptNow(script);
    }

    @Override
    public void setProperties(Properties properties) {
        try {
            FileInputStream fileIn = new FileInputStream(propertiesFileName);
            properties.load(fileIn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveProperties(Properties properties) {
        try {
            FileOutputStream fileOut = new FileOutputStream(propertiesFileName);
            properties.store(fileOut, "JSpecView Application Properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exitJSpecView(boolean withDialog, Object frame) {
        if (withDialog && JOptionPane.showConfirmDialog((Component)frame, "Exit JSpecView?", "Exit", 0, 3) != 0) {
            return;
        }
        System.exit(0);
    }

    @Override
    public void syncToJmol(String peak) {
    }
}

