/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.KeyStroke;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Messages;

public class InternalDialog
extends JInternalFrame {
    protected JLabel statusBar;

    public InternalDialog(JConsole jConsole, String title, boolean modal) {
        super(title, true, true, false, false);
        this.setLayer(JLayeredPane.PALETTE_LAYER);
        this.putClientProperty("JInternalFrame.frameType", "optionDialog");
        jConsole.getDesktopPane().add(this);
        this.getActionMap().put("cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalDialog.this.setVisible(false);
                if (InternalDialog.this.statusBar != null) {
                    InternalDialog.this.statusBar.setText("");
                }
            }
        });
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
    }

    public void setLocationRelativeTo(Component c) {
        this.setLocation((c.getWidth() - this.getWidth()) / 2, (c.getHeight() - this.getHeight()) / 2);
    }

    protected class MastheadIcon
    implements Icon {
        private ImageIcon leftIcon = new ImageIcon(InternalDialog.class.getResource("resources/masthead-left.png"));
        private ImageIcon rightIcon = new ImageIcon(InternalDialog.class.getResource("resources/masthead-right.png"));
        private Font font = Font.decode(Messages.MASTHEAD_FONT);
        private int gap = 10;
        private String title;

        public MastheadIcon(String title) {
            this.title = title;
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            g = g.create();
            x = 0;
            int width = c.getWidth();
            int lWidth = this.leftIcon.getIconWidth();
            int rWidth = this.rightIcon.getIconWidth();
            int height = this.getIconHeight();
            int textHeight = g.getFontMetrics(this.font).getAscent();
            g.setColor(Color.white);
            g.fillRect(x, y, width, height);
            this.leftIcon.paintIcon(c, g, x, y);
            this.rightIcon.paintIcon(c, g, width - rWidth, y);
            g.setFont(this.font);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setColor(new Color(3495275));
            g.drawString(this.title, lWidth + this.gap, height / 2 + textHeight / 2);
        }

        @Override
        public int getIconWidth() {
            FontMetrics fm;
            int textWidth = 0;
            Graphics g = InternalDialog.this.getGraphics();
            if (g != null && (fm = g.getFontMetrics(this.font)) != null) {
                textWidth = fm.stringWidth(this.title);
            }
            return this.leftIcon.getIconWidth() + this.gap + textWidth + this.gap + this.rightIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.leftIcon.getIconHeight();
        }
    }
}

