/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.FileDescriptor;
import java.net.SocketOption;
import java.security.AccessController;
import jdk.net.NetworkPermission;
import jdk.net.SocketFlow;

public class ExtendedOptionsImpl {
    private ExtendedOptionsImpl() {
    }

    public static void checkSetOptionPermission(SocketOption<?> socketOption) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        String string = "setOption." + socketOption.name();
        securityManager.checkPermission(new NetworkPermission(string));
    }

    public static void checkGetOptionPermission(SocketOption<?> socketOption) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        String string = "getOption." + socketOption.name();
        securityManager.checkPermission(new NetworkPermission(string));
    }

    public static void checkValueType(Object object, Class<?> clazz) {
        if (!clazz.isAssignableFrom(object.getClass())) {
            String string = "Found: " + object.getClass().toString() + " Expected: " + clazz.toString();
            throw new IllegalArgumentException(string);
        }
    }

    private static native void init();

    public static native void setFlowOption(FileDescriptor var0, SocketFlow var1);

    public static native void getFlowOption(FileDescriptor var0, SocketFlow var1);

    public static native boolean flowSupported();

    static {
        AccessController.doPrivileged(() -> {
            System.loadLibrary("net");
            return null;
        });
        ExtendedOptionsImpl.init();
    }
}

