/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.StackFrame;
import org.netbeans.lib.profiler.heap.TagBounds;

class StackFrameSegment
extends TagBounds {
    HprofHeap hprofHeap;
    final int methodIDOffset;
    final int stackFrameIDOffset;
    final int lengthOffset;
    final int sourceIDOffset;
    final int methodSignatureIDOffset;
    final int timeOffset;
    final int classSerialNumberOffset;
    final int lineNumberOffset;

    StackFrameSegment(HprofHeap hprofHeap, long l, long l2) {
        super(5, l, l2);
        int n = hprofHeap.dumpBuffer.getIDSize();
        this.hprofHeap = hprofHeap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.stackFrameIDOffset = this.lengthOffset + 4;
        this.methodIDOffset = this.stackFrameIDOffset + n;
        this.methodSignatureIDOffset = this.methodIDOffset + n;
        this.sourceIDOffset = this.methodSignatureIDOffset + n;
        this.classSerialNumberOffset = this.sourceIDOffset + n;
        this.lineNumberOffset = this.classSerialNumberOffset + 4;
    }

    StackFrame getStackFrameByID(long l) {
        long[] lArray = new long[]{this.startOffset};
        while (lArray[0] < this.endOffset) {
            long l2 = lArray[0];
            long l3 = this.readStackFrameTag(lArray);
            if (l3 != l) continue;
            return new StackFrame(this, l2);
        }
        return null;
    }

    private HprofByteBuffer getDumpBuffer() {
        return this.hprofHeap.dumpBuffer;
    }

    private long readStackFrameTag(long[] lArray) {
        long l = lArray[0];
        if (this.hprofHeap.readTag(lArray) != 4) {
            return 0L;
        }
        return this.getDumpBuffer().getID(l + (long)this.stackFrameIDOffset);
    }
}

