/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.SecureRandom;
import java.util.concurrent.ThreadLocalRandom;
import jnr.posix.util.Platform;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;

public class Random {
    static final String HOLDER_TYPE = SafePropertyAccessor.getProperty((String)"jruby.openssl.random", (String)"");

    private static Holder createHolderImpl() {
        if (HOLDER_TYPE.equals("default") || HOLDER_TYPE.equals("thread-local")) {
            return new ThreadLocalHolder();
        }
        if (HOLDER_TYPE.equals("shared")) {
            return new SharedHolder();
        }
        if (HOLDER_TYPE.equals("strong")) {
            return new StrongHolder();
        }
        if (ThreadLocalHolder.secureRandomField == null) {
            return new SharedHolder();
        }
        return new ThreadLocalHolder();
    }

    public static void createRandom(Ruby runtime, RubyModule OpenSSL2) {
        RubyModule Random2 = OpenSSL2.defineModuleUnder("Random");
        RubyClass OpenSSLError = (RubyClass)OpenSSL2.getConstant("OpenSSLError");
        Random2.defineClassUnder("RandomError", OpenSSLError, OpenSSLError.getAllocator());
        Random2.defineAnnotatedMethods(Random.class);
        Random2.dataWrapStruct((Object)Random.createHolderImpl());
    }

    @JRubyMethod(meta=true)
    public static RubyString random_bytes(ThreadContext context2, IRubyObject self, IRubyObject arg) {
        return Random.random_bytes(context2, self, Random.toInt(context2.runtime, arg));
    }

    static RubyString random_bytes(ThreadContext context2, int len) {
        RubyModule Random2 = (RubyModule)context2.runtime.getModule("OpenSSL").getConstantAt("Random");
        return Random.generate(context2, (IRubyObject)Random2, len, true);
    }

    private static RubyString random_bytes(ThreadContext context2, IRubyObject self, int len) {
        return Random.generate(context2, self, len, true);
    }

    @JRubyMethod(meta=true)
    public static RubyString pseudo_bytes(ThreadContext context2, IRubyObject self, IRubyObject len) {
        return Random.generate(context2, self, Random.toInt(context2.runtime, len), false);
    }

    private static int toInt(Ruby runtime, IRubyObject arg) {
        long len = RubyNumeric.fix2long((IRubyObject)arg);
        if (len < 0L || len > Integer.MAX_VALUE) {
            throw runtime.newArgumentError("negative string size (or size too big) " + len);
        }
        return (int)len;
    }

    private static RubyString generate(ThreadContext context2, IRubyObject self, int len, boolean secure) {
        Holder holder = Random.retrieveHolder((RubyModule)self);
        byte[] bytes = new byte[len];
        (secure ? holder.getSecureRandom(context2) : holder.getPlainRandom()).nextBytes(bytes);
        return RubyString.newString((Ruby)context2.runtime, (ByteList)new ByteList(bytes, false));
    }

    static Holder getHolder(Ruby runtime) {
        return Random.retrieveHolder((RubyModule)runtime.getModule("OpenSSL").getConstantAt("Random"));
    }

    private static Holder retrieveHolder(RubyModule Random2) {
        return (Holder)Random2.dataGetStruct();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject seed(ThreadContext context2, IRubyObject self, IRubyObject str) {
        Random.seedImpl(context2, (RubyModule)self, str);
        return str;
    }

    private static void seedImpl(ThreadContext context2, RubyModule Random2, IRubyObject str) {
        byte[] seed2 = str.asString().getBytes();
        Holder holder = Random.retrieveHolder(Random2);
        holder.seedSecureRandom(context2, seed2);
        int l = seed2.length;
        if (l >= 4) {
            long s2 = seed2[0] << 24 | seed2[1] << 16 | seed2[2] << 8 | seed2[3];
            if (l >= 8) {
                s2 = s2 ^ (long)(seed2[l - 4] << 24) | (long)(seed2[l - 3] << 16) | (long)(seed2[l - 2] << 8) | (long)seed2[l - 1];
            }
            holder.seedPlainRandom(s2);
        }
    }

    @JRubyMethod(meta=true, name={"status?"})
    public static IRubyObject status_p(ThreadContext context2, IRubyObject self) {
        return context2.runtime.newBoolean(true);
    }

    @JRubyMethod(meta=true, name={"random_add", "add"})
    public static IRubyObject random_add(ThreadContext context2, IRubyObject self, IRubyObject str, IRubyObject entropy) {
        Random.seedImpl(context2, (RubyModule)self, str);
        return self;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject load_random_file(ThreadContext context2, IRubyObject self, IRubyObject fname) {
        return context2.runtime.getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject write_random_file(ThreadContext context2, IRubyObject self, IRubyObject fname) {
        return context2.runtime.getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject egd(ThreadContext context2, IRubyObject self, IRubyObject fname) {
        return context2.runtime.getTrue();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject egd_bytes(ThreadContext context2, IRubyObject self, IRubyObject fname, IRubyObject len) {
        return context2.runtime.getTrue();
    }

    private static class StrongHolder
    extends Holder {
        private static final Method getInstanceStrong;

        private StrongHolder() {
        }

        @Override
        java.util.Random getPlainRandom() {
            return new java.util.Random();
        }

        @Override
        SecureRandom getSecureRandom(ThreadContext context2) {
            if (getInstanceStrong == null) {
                return SecurityHelper.getSecureRandom();
            }
            try {
                return (SecureRandom)getInstanceStrong.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                Utils.throwException(ex);
                return null;
            }
            catch (InvocationTargetException ex) {
                Utils.throwException(ex.getTargetException());
                return null;
            }
        }

        @Override
        void seedSecureRandom(ThreadContext context2, byte[] seed2) {
        }

        @Override
        void seedPlainRandom(long seed2) {
        }

        static {
            Method method = null;
            if (OpenSSL.javaVersion8(true)) {
                try {
                    method = SecureRandom.class.getMethod("getInstanceStrong", new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    OpenSSL.debugStackTrace(ex);
                }
            }
            getInstanceStrong = method;
        }
    }

    private static class ThreadLocalHolder
    extends Holder {
        private static final Field secureRandomField;
        private static final String PREFERRED_PRNG;
        private static boolean tryPreferredPRNG;
        private static boolean trySHA1PRNG;
        private static boolean tryStrongPRNG;

        private ThreadLocalHolder() {
        }

        @Override
        java.util.Random getPlainRandom() {
            return ThreadLocalRandom.current();
        }

        @Override
        void seedPlainRandom(long seed2) {
        }

        @Override
        SecureRandom getSecureRandom(ThreadContext context2) {
            SecureRandom secureRandom = context2.secureRandom;
            if (secureRandom == null) {
                secureRandom = this.getSecureRandomImpl();
                ThreadLocalHolder.setSecureRandom(context2, secureRandom);
            }
            return secureRandom;
        }

        private static void setSecureRandom(ThreadContext context2, SecureRandom secureRandom) {
            if (secureRandomField != null) {
                try {
                    secureRandomField.set(context2, secureRandom);
                }
                catch (IllegalAccessException ex) {
                    Utils.throwException(ex);
                }
            }
        }

        public SecureRandom getSecureRandomImpl() {
            SecureRandom secureRandom = null;
            if (tryPreferredPRNG) {
                try {
                    secureRandom = SecureRandom.getInstance(PREFERRED_PRNG);
                }
                catch (Exception e) {
                    tryPreferredPRNG = false;
                    OpenSSL.debug("SecureRandom '" + PREFERRED_PRNG + "' failed:", e);
                }
            }
            if (secureRandom == null && trySHA1PRNG) {
                try {
                    secureRandom = SecureRandom.getInstance("SHA1PRNG");
                }
                catch (Exception e) {
                    trySHA1PRNG = false;
                    OpenSSL.debug("SecureRandom SHA1PRNG failed:", e);
                }
            }
            if (secureRandom == null) {
                secureRandom = new SecureRandom();
            }
            return secureRandom;
        }

        static {
            String prng = SafePropertyAccessor.getProperty((String)"jruby.preferred.prng", null);
            if (prng == null) {
                prng = "NativePRNGNonBlocking";
                if (SafePropertyAccessor.getProperty((String)"os.name") != null && Platform.IS_WINDOWS) {
                    prng = "Windows-PRNG";
                }
            }
            if (prng.isEmpty() || prng.equalsIgnoreCase("default")) {
                prng = null;
                tryPreferredPRNG = false;
                trySHA1PRNG = false;
            }
            PREFERRED_PRNG = prng;
            Field secureRandom = null;
            try {
                secureRandom = ThreadContext.class.getField("secureRandom");
                if (!secureRandom.isAccessible() || Modifier.isFinal(secureRandom.getModifiers())) {
                    secureRandom = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            secureRandomField = secureRandom;
            tryPreferredPRNG = true;
            trySHA1PRNG = true;
            tryStrongPRNG = false;
        }
    }

    private static class SharedHolder
    extends Holder {
        private volatile java.util.Random plainRandom;
        private volatile SecureRandom secureRandom;

        private SharedHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        java.util.Random getPlainRandom() {
            if (this.plainRandom == null) {
                SharedHolder sharedHolder = this;
                synchronized (sharedHolder) {
                    if (this.plainRandom == null) {
                        this.plainRandom = new java.util.Random();
                    }
                }
            }
            return this.plainRandom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        SecureRandom getSecureRandom(ThreadContext context2) {
            if (this.secureRandom == null) {
                SharedHolder sharedHolder = this;
                synchronized (sharedHolder) {
                    if (this.secureRandom == null) {
                        this.secureRandom = SecurityHelper.getSecureRandom();
                    }
                }
            }
            return this.secureRandom;
        }
    }

    static abstract class Holder {
        Holder() {
        }

        abstract java.util.Random getPlainRandom();

        abstract SecureRandom getSecureRandom(ThreadContext var1);

        void seedSecureRandom(ThreadContext context2, byte[] seed2) {
            this.getSecureRandom(context2).setSeed(seed2);
        }

        void seedPlainRandom(long seed2) {
            this.getPlainRandom().setSeed(seed2);
        }
    }
}

