/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.stubs.KotlinModifierListStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.ModifierMaskUtils;

public class KtModifierListElementType<T extends KtModifierList>
extends KtStubElementType<KotlinModifierListStub, T> {
    public KtModifierListElementType(@NotNull @NonNls String debugName, @NotNull Class<T> psiClass) {
        super(debugName, psiClass, KotlinModifierListStub.class);
    }

    @Override
    public KotlinModifierListStub createStub(@NotNull T psi, StubElement parentStub) {
        return new KotlinModifierListStubImpl(parentStub, ModifierMaskUtils.computeMaskFromModifierList(psi), this);
    }

    @Override
    public void serialize(@NotNull KotlinModifierListStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        int mask = ((KotlinModifierListStubImpl)stub).getMask();
        dataStream.writeVarInt(mask);
    }

    @Override
    @NotNull
    public KotlinModifierListStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        int mask = dataStream.readVarInt();
        return new KotlinModifierListStubImpl(parentStub, mask, this);
    }
}

