/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.network.Socket;
import com.tigervnc.network.TcpSocket;
import com.tigervnc.rdr.FdInStreamBlockCallback;
import com.tigervnc.rdr.MemInStream;
import com.tigervnc.rdr.MemOutStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.CConnection;
import com.tigervnc.rfb.Encodings;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.Hostname;
import com.tigervnc.rfb.Keysyms;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.ScreenSet;
import com.tigervnc.rfb.Security;
import com.tigervnc.rfb.UserPasswdGetter;
import com.tigervnc.rfb.VncAuth;
import com.tigervnc.vncviewer.ClipboardDialog;
import com.tigervnc.vncviewer.DesktopWindow;
import com.tigervnc.vncviewer.OptionsDialog;
import com.tigervnc.vncviewer.Parameters;
import com.tigervnc.vncviewer.PasswdDialog;
import com.tigervnc.vncviewer.PlatformPixelBuffer;
import com.tigervnc.vncviewer.Tunnel;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CConn
extends CConnection
implements UserPasswdGetter,
FdInStreamBlockCallback,
ActionListener {
    static final PixelFormat verylowColorPF = new PixelFormat(8, 3, false, true, 1, 1, 1, 2, 1, 0);
    static final PixelFormat lowColorPF = new PixelFormat(8, 6, false, true, 3, 3, 3, 4, 2, 0);
    static final PixelFormat mediumColorPF = new PixelFormat(8, 8, false, true, 7, 7, 3, 5, 2, 0);
    static final int KEY_LOC_SHIFT_R = 0;
    static final int KEY_LOC_SHIFT_L = 16;
    static final int SUPER_MASK = 32768;
    public static UserPasswdGetter upg;
    boolean shuttingDown = false;
    int buttonMask;
    private String serverHost = null;
    private int serverPort = 0;
    private Socket sock;
    protected DesktopWindow desktop = null;
    private PixelFormat serverPF;
    private PixelFormat fullColorPF;
    private boolean pendingPFChange = false;
    private PixelFormat pendingPF;
    private int currentEncoding = 7;
    private int lastServerEncoding = -1;
    private boolean formatChange = false;
    private boolean encodingChange = false;
    private boolean firstUpdate = true;
    private boolean pendingUpdate = false;
    private boolean continuousUpdates = false;
    private boolean forceNonincremental = true;
    private boolean supportsSyncFence = false;
    private HashMap<Integer, Integer> downKeySym;
    public ActionListener closeListener = null;
    static LogWriter vlog;

    public CConn(String string, Socket socket) {
        this.setShared(Parameters.shared.getValue());
        this.sock = socket;
        this.downKeySym = new HashMap();
        upg = this;
        int n = Encodings.encodingNum(Parameters.preferredEncoding.getValue());
        if (n != -1) {
            this.currentEncoding = n;
        }
        this.cp.supportsLocalCursor = true;
        this.cp.supportsDesktopResize = true;
        this.cp.supportsExtendedDesktopSize = true;
        this.cp.supportsDesktopRename = true;
        this.cp.supportsSetDesktopSize = false;
        this.cp.supportsClientRedirect = true;
        this.cp.compressLevel = Parameters.customCompressLevel.getValue() ? Parameters.compressLevel.getValue() : -1;
        this.cp.qualityLevel = !Parameters.noJpeg.getValue() ? Parameters.qualityLevel.getValue() : -1;
        if (this.sock == null) {
            this.setServerName(Hostname.getHost(string));
            this.setServerPort(Hostname.getPort(string));
            try {
                if (Parameters.tunnel.getValue() || !Parameters.via.getValue().isEmpty()) {
                    int n2 = TcpSocket.findFreeTcpPort();
                    if (n2 == 0) {
                        throw new Exception("Could not obtain free TCP port");
                    }
                    Tunnel.createTunnel(this, n2);
                    this.sock = new TcpSocket("localhost", n2);
                } else {
                    this.sock = new TcpSocket(this.getServerName(), this.getServerPort());
                }
            }
            catch (java.lang.Exception exception) {
                throw new Exception(exception.getMessage());
            }
            vlog.info("connected to host " + this.getServerName() + " port " + this.getServerPort());
        } else {
            String string2 = this.sock.getPeerEndpoint();
            if (Parameters.listenMode.getValue()) {
                vlog.info("Accepted connection from " + string2);
            } else {
                vlog.info("connected to host " + Hostname.getHost(string2) + " port " + Hostname.getPort(string2));
            }
        }
        this.sock.inStream().setBlockCallback(this);
        this.setStreams(this.sock.inStream(), this.sock.outStream());
        this.initialiseProtocol();
        OptionsDialog.addCallback("handleOptions", this);
    }

    public void refreshFramebuffer() {
        this.forceNonincremental = true;
        if (this.supportsSyncFence) {
            this.requestNewUpdate();
        }
    }

    public String connectionInfo() {
        String string = new String("Desktop name: %s%nHost: %s:%d%nSize: %dx%d%nPixel format: %s%n  (server default: %s)%nRequested encoding: %s%nLast used encoding: %s%nLine speed estimate: %d kbit/s%nProtocol version: %d.%d%nSecurity method: %s [%s]%n");
        String string2 = String.format(string, this.cp.name(), this.sock.getPeerName(), this.sock.getPeerPort(), this.cp.width, this.cp.height, this.cp.pf().print(), this.serverPF.print(), Encodings.encodingName(this.currentEncoding), Encodings.encodingName(this.lastServerEncoding), this.sock.inStream().kbitsPerSecond(), this.cp.majorVersion, this.cp.minorVersion, Security.secTypeName(this.csecurity.getType()), this.csecurity.description());
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockCallback() {
        try {
            CConn cConn = this;
            synchronized (cConn) {
                this.wait(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new Exception(interruptedException.getMessage());
        }
    }

    @Override
    public final boolean getUserPasswd(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        PasswdDialog passwdDialog;
        String string = "VNC Authentication [" + this.csecurity.description() + "]";
        String string2 = Parameters.passwordFile.getValue();
        if (stringBuffer == null && !string2.equals("")) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Exception("Opening password file failed");
            }
            byte[] byArray = new byte[256];
            try {
                ((InputStream)fileInputStream).read(byArray);
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                throw new Exception("Failed to read VncPasswd file");
            }
            String string3 = VncAuth.unobfuscatePasswd(byArray);
            stringBuffer2.append(string3);
            stringBuffer2.setLength(string3.length());
            return true;
        }
        if (stringBuffer == null) {
            passwdDialog = new PasswdDialog(string, stringBuffer == null, stringBuffer2 == null);
        } else {
            if (stringBuffer2 == null && Parameters.sendLocalUsername.getValue()) {
                stringBuffer.append((String)System.getProperties().get("user.name"));
                return true;
            }
            passwdDialog = new PasswdDialog(string, Parameters.sendLocalUsername.getValue(), stringBuffer2 == null);
        }
        passwdDialog.showDialog();
        if (stringBuffer != null) {
            if (Parameters.sendLocalUsername.getValue()) {
                stringBuffer.append((String)System.getProperties().get("user.name"));
            } else {
                stringBuffer.append(passwdDialog.userEntry.getText());
            }
        }
        if (stringBuffer2 != null) {
            stringBuffer2.append(new String(passwdDialog.passwdEntry.getPassword()));
        }
        return true;
    }

    @Override
    public void serverInit() {
        super.serverInit();
        if (this.cp.beforeVersion(3, 8) && Parameters.autoSelect.getValue()) {
            Parameters.fullColor.setParam(true);
        }
        this.serverPF = this.cp.pf();
        this.desktop = new DesktopWindow(this.cp.width, this.cp.height, this.cp.name(), this.serverPF, this);
        this.fullColorPF = this.desktop.getPreferredPF();
        this.formatChange = true;
        this.encodingChange = true;
        this.requestNewUpdate();
        assert (this.pendingPFChange);
        this.cp.setPF(this.pendingPF);
        this.pendingPFChange = false;
    }

    @Override
    public void setDesktopSize(int n, int n2) {
        super.setDesktopSize(n, n2);
        this.resizeFramebuffer();
    }

    @Override
    public void setExtendedDesktopSize(int n, int n2, int n3, int n4, ScreenSet screenSet) {
        super.setExtendedDesktopSize(n, n2, n3, n4, screenSet);
        if (n == 1 && n2 != 0) {
            vlog.error("SetDesktopSize failed: " + n2);
            return;
        }
        this.resizeFramebuffer();
    }

    @Override
    public void clientRedirect(int n, String string, String string2) {
        try {
            this.sock.close();
            this.sock = new TcpSocket(string, n);
            vlog.info("Redirected to " + string + ":" + n);
            this.setServerName(string);
            this.setServerPort(n);
            this.sock.inStream().setBlockCallback(this);
            this.setStreams(this.sock.inStream(), this.sock.outStream());
            if (this.desktop != null) {
                this.desktop.dispose();
            }
            this.initialiseProtocol();
        }
        catch (java.lang.Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        if (this.desktop != null) {
            this.desktop.setName(string);
        }
    }

    @Override
    public void framebufferUpdateStart() {
        super.framebufferUpdateStart();
        this.pendingUpdate = false;
        this.requestNewUpdate();
        ModifiablePixelBuffer modifiablePixelBuffer = this.getFramebuffer();
        assert (modifiablePixelBuffer != null);
        PlatformPixelBuffer platformPixelBuffer = (PlatformPixelBuffer)modifiablePixelBuffer;
        assert (platformPixelBuffer != null);
    }

    @Override
    public void framebufferUpdateEnd() {
        super.framebufferUpdateEnd();
        this.desktop.updateWindow();
        if (this.firstUpdate) {
            if (this.cp.supportsFence) {
                this.writer().writeFence(-2147483644, 0, null);
            }
            this.firstUpdate = false;
        }
        if (this.pendingPFChange) {
            this.cp.setPF(this.pendingPF);
            this.pendingPFChange = false;
        }
        if (Parameters.autoSelect.getValue()) {
            this.autoSelectFormatAndEncoding();
        }
    }

    @Override
    public void setColourMapEntries(int n, int n2, int[] nArray) {
        vlog.error("Invalid SetColourMapEntries from server!");
    }

    @Override
    public void bell() {
        if (Parameters.acceptBell.getValue()) {
            this.desktop.getToolkit().beep();
        }
    }

    @Override
    public void serverCutText(String string, int n) {
        if (!Parameters.acceptClipboard.getValue()) {
            return;
        }
        ClipboardDialog.serverCutText(string);
    }

    @Override
    public void dataRect(Rect rect, int n) {
        this.sock.inStream().startTiming();
        if (n != 1) {
            this.lastServerEncoding = n;
        }
        super.dataRect(rect, n);
        this.sock.inStream().stopTiming();
    }

    @Override
    public void setCursor(int n, int n2, Point point, byte[] byArray) {
        this.desktop.setCursor(n, n2, point, byArray);
    }

    @Override
    public void fence(int n, int n2, byte[] byArray) {
        this.cp.supportsFence = true;
        if ((n & Integer.MIN_VALUE) != 0) {
            this.writer().writeFence(n &= 3, n2, byArray);
            return;
        }
        if (n2 == 0) {
            if ((n & 4) != 0) {
                this.supportsSyncFence = true;
                if (this.cp.supportsContinuousUpdates) {
                    vlog.info("Enabling continuous updates");
                    this.continuousUpdates = true;
                    this.writer().writeEnableContinuousUpdates(true, 0, 0, this.cp.width, this.cp.height);
                }
            }
        } else {
            MemInStream memInStream = new MemInStream(byArray, 0, n2);
            PixelFormat pixelFormat = new PixelFormat();
            pixelFormat.read(memInStream);
            this.cp.setPF(pixelFormat);
        }
    }

    private void resizeFramebuffer() {
        if (this.desktop == null) {
            return;
        }
        if (this.continuousUpdates) {
            this.writer().writeEnableContinuousUpdates(true, 0, 0, this.cp.width, this.cp.height);
        }
        this.desktop.resizeFramebuffer(this.cp.width, this.cp.height);
    }

    private void autoSelectFormatAndEncoding() {
        long l = this.sock.inStream().kbitsPerSecond();
        long l2 = this.sock.inStream().timeWaited();
        boolean bl = Parameters.fullColor.getValue();
        int n = Parameters.qualityLevel.getValue();
        if (this.currentEncoding != 7) {
            this.currentEncoding = 7;
            this.encodingChange = true;
        }
        if (l == 0L || l2 < 100L) {
            return;
        }
        if (!Parameters.noJpeg.getValue() && (n = l > 16000L ? 8 : 6) != Parameters.qualityLevel.getValue()) {
            vlog.info("Throughput " + l + " kbit/s - changing to quality " + n);
            this.cp.qualityLevel = n;
            Parameters.qualityLevel.setParam(n);
            this.encodingChange = true;
        }
        if (this.cp.beforeVersion(3, 8)) {
            return;
        }
        boolean bl2 = bl = l > 256L;
        if (bl != Parameters.fullColor.getValue()) {
            vlog.info("Throughput " + l + " kbit/s - full color is now " + (bl ? "enabled" : "disabled"));
            Parameters.fullColor.setParam(bl);
            this.formatChange = true;
        }
    }

    private void checkEncodings() {
        if (this.encodingChange && this.writer() != null) {
            vlog.info("Using " + Encodings.encodingName(this.currentEncoding) + " encoding");
            this.writer().writeSetEncodings(this.currentEncoding, true);
            this.encodingChange = false;
        }
    }

    private void requestNewUpdate() {
        if (this.formatChange) {
            Object object;
            assert (!this.pendingUpdate || this.supportsSyncFence);
            PixelFormat pixelFormat = Parameters.fullColor.getValue() ? this.fullColorPF : (Parameters.lowColorLevel.getValue() == 0 ? verylowColorPF : (Parameters.lowColorLevel.getValue() == 1 ? lowColorPF : mediumColorPF));
            if (this.supportsSyncFence) {
                object = new MemOutStream();
                pixelFormat.write((OutStream)object);
                this.writer().writeFence(-2147483644, ((MemOutStream)object).length(), ((MemOutStream)object).data());
            } else {
                this.pendingPFChange = true;
                this.pendingPF = pixelFormat;
            }
            object = pixelFormat.print();
            vlog.info("Using pixel format " + (String)object);
            this.writer().writeSetPixelFormat(pixelFormat);
            this.formatChange = false;
        }
        this.checkEncodings();
        if (this.forceNonincremental || !this.continuousUpdates) {
            this.pendingUpdate = true;
            this.writer().writeFramebufferUpdateRequest(new Rect(0, 0, this.cp.width, this.cp.height), !this.forceNonincremental);
        }
        this.forceNonincremental = false;
    }

    public void handleOptions() {
        int n;
        if (!Parameters.autoSelect.getValue() && (n = Encodings.encodingNum(Parameters.preferredEncoding.getValue())) != -1) {
            this.currentEncoding = n;
        }
        this.cp.supportsLocalCursor = true;
        this.cp.compressLevel = Parameters.customCompressLevel.getValue() ? Parameters.compressLevel.getValue() : -1;
        this.cp.qualityLevel = !Parameters.noJpeg.getValue() && !Parameters.autoSelect.getValue() ? Parameters.qualityLevel.getValue() : -1;
        this.encodingChange = true;
        PixelFormat pixelFormat = Parameters.fullColor.getValue() ? this.fullColorPF : (Parameters.lowColorLevel.getValue() == 0 ? verylowColorPF : (Parameters.lowColorLevel.getValue() == 1 ? lowColorPF : mediumColorPF));
        if (!pixelFormat.equal(this.cp.pf())) {
            this.formatChange = true;
            if (this.supportsSyncFence) {
                this.requestNewUpdate();
            }
        }
    }

    public void close() {
        if (this.closeListener != null) {
            Parameters.embed.setParam(true);
            JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.desktop);
            if (jFrame != null) {
                jFrame.dispatchEvent(new WindowEvent(jFrame, 201));
            }
        }
        this.shuttingDown = true;
        try {
            if (this.sock != null) {
                this.sock.shutdown();
            }
        }
        catch (java.lang.Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    void showInfo() {
        Window window = DesktopWindow.getFullScreenWindow();
        if (window != null) {
            DesktopWindow.setFullScreenWindow(null);
        }
        String string = new String("Desktop name: %s%nHost: %s:%d%nSize: %dx%d%nPixel format: %s%n  (server default: %s)%nRequested encoding: %s%nLast used encoding: %s%nLine speed estimate: %d kbit/s%nProtocol version: %d.%d%nSecurity method: %s [%s]%n");
        String string2 = String.format(string, this.cp.name(), this.sock.getPeerName(), this.sock.getPeerPort(), this.cp.width, this.cp.height, this.cp.pf().print(), this.serverPF.print(), Encodings.encodingName(this.currentEncoding), Encodings.encodingName(this.lastServerEncoding), this.sock.inStream().kbitsPerSecond(), this.cp.majorVersion, this.cp.minorVersion, Security.secTypeName(this.csecurity.getType()), this.csecurity.description());
        JOptionPane jOptionPane = new JOptionPane(string2, -1, -1);
        JDialog jDialog = jOptionPane.createDialog(this.desktop, "VNC connection info");
        jDialog.setIconImage(VncViewer.frameIcon);
        jDialog.setAlwaysOnTop(true);
        jDialog.setVisible(true);
        if (window != null) {
            DesktopWindow.setFullScreenWindow(window);
        }
    }

    public void refresh() {
        this.writer().writeFramebufferUpdateRequest(new Rect(0, 0, this.cp.width, this.cp.height), false);
        this.pendingUpdate = true;
    }

    public void writeClientCutText(String string, int n) {
        if (this.state() != 6 || this.shuttingDown) {
            return;
        }
        this.writer().writeClientCutText(string, n);
    }

    public void writeKeyEvent(int n, boolean bl) {
        if (this.state() != 6 || this.shuttingDown) {
            return;
        }
        this.writer().writeKeyEvent(n, bl);
    }

    public void writeKeyEvent(KeyEvent keyEvent) {
        if (Parameters.viewOnly.getValue() || this.shuttingDown) {
            return;
        }
        boolean bl = keyEvent.getID() == 401;
        int n = keyEvent.getKeyCode();
        if (n == 0 && keyEvent.getKeyChar() == '\uffff') {
            return;
        }
        if (!bl) {
            Integer n2 = this.downKeySym.get(n);
            if (n2 == null) {
                vlog.debug("Unexpected key release of keyCode " + n);
                String string = keyEvent.paramString().replaceAll("%", "%%");
                vlog.debug(String.format(string.replaceAll(",", "%n       "), new Object[0]));
                return;
            }
            vlog.debug(String.format("Key released: 0x%04x => 0x%04x", n, n2));
            this.writeKeyEvent(n2, false);
            this.downKeySym.remove(n);
            return;
        }
        int n3 = Keysyms.translateKeyEvent(keyEvent);
        if (n3 == 0xFFFFFF) {
            return;
        }
        boolean bl2 = true;
        if (VncViewer.os.startsWith("windows")) {
            if (KeyEvent.getKeyText(n).isEmpty()) {
                bl2 = false;
            } else if (!this.downKeySym.containsValue(65507) && !this.downKeySym.containsValue(65508)) {
                bl2 = false;
            } else if (!this.downKeySym.containsValue(65513) && !this.downKeySym.containsValue(65514)) {
                bl2 = false;
            }
            if (bl2) {
                vlog.info("Faking release of AltGr (Ctrl+Alt)");
                if (this.downKeySym.containsValue(65507)) {
                    this.writeKeyEvent(65507, false);
                }
                if (this.downKeySym.containsValue(65508)) {
                    this.writeKeyEvent(65508, false);
                }
                if (this.downKeySym.containsValue(65513)) {
                    this.writeKeyEvent(65513, false);
                }
                if (this.downKeySym.containsValue(65514)) {
                    this.writeKeyEvent(65514, false);
                }
            }
        }
        vlog.debug(String.format("Key pressed: 0x%04x '%s' => 0x%04x", n, Character.toString(keyEvent.getKeyChar()), n3));
        this.downKeySym.put(n, n3);
        this.writeKeyEvent(n3, bl);
        if (VncViewer.os.startsWith("windows") && bl2) {
            vlog.debug("Restoring AltGr state");
            if (this.downKeySym.containsValue(65507)) {
                this.writeKeyEvent(65507, true);
            }
            if (this.downKeySym.containsValue(65508)) {
                this.writeKeyEvent(65508, true);
            }
            if (this.downKeySym.containsValue(65513)) {
                this.writeKeyEvent(65513, true);
            }
            if (this.downKeySym.containsValue(65514)) {
                this.writeKeyEvent(65514, true);
            }
        }
    }

    public void writePointerEvent(MouseEvent mouseEvent) {
        if (this.state() != 6 || this.shuttingDown) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this.buttonMask = 1;
                if ((mouseEvent.getModifiers() & 8) != 0) {
                    this.buttonMask = 2;
                }
                if ((mouseEvent.getModifiers() & 4) == 0) break;
                this.buttonMask = 4;
                break;
            }
            case 502: {
                this.buttonMask = 0;
            }
        }
        this.writer().writePointerEvent(new Point(mouseEvent.getX(), mouseEvent.getY()), this.buttonMask);
    }

    public void writeWheelEvent(MouseWheelEvent mouseWheelEvent) {
        if (this.state() != 6 || this.shuttingDown) {
            return;
        }
        int n = mouseWheelEvent.getWheelRotation();
        this.buttonMask = n < 0 ? 8 : 16;
        for (int i = 0; i < Math.abs(n); ++i) {
            int n2 = mouseWheelEvent.getX();
            int n3 = mouseWheelEvent.getY();
            this.writer().writePointerEvent(new Point(n2, n3), this.buttonMask);
            this.buttonMask = 0;
            this.writer().writePointerEvent(new Point(n2, n3), this.buttonMask);
        }
    }

    synchronized void releaseDownKeys() {
        for (Map.Entry<Integer, Integer> entry : this.downKeySym.entrySet()) {
            this.writeKeyEvent(entry.getValue(), false);
        }
        this.downKeySym.clear();
    }

    public void setCloseListener(ActionListener actionListener) {
        this.closeListener = actionListener;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public Socket getSocket() {
        return this.sock;
    }

    static {
        vlog = new LogWriter("CConn");
    }
}

