/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.controlpanel.NamedBorderPanel;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditor;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class PolicyPanel
extends NamedBorderPanel {
    private PolicyEditor.PolicyEditorWindow policyEditor = null;
    private final DeploymentConfiguration config;

    public PolicyPanel(JFrame frame, DeploymentConfiguration config) {
        super(Translator.R("CPHeadPolicy"), new GridBagLayout());
        this.config = config;
        this.addComponents(frame);
    }

    private void addComponents(JFrame frame) {
        JLabel aboutLabel = new JLabel("<html>" + Translator.R("CPPolicyDetail") + "</html>");
        String fileUrlString = PathsAndFiles.JAVA_POLICY.getFullPath(this.config);
        JButton simpleEditorButton = new JButton(Translator.R("CPButSimpleEditor"));
        simpleEditorButton.addActionListener(new LaunchSimplePolicyEditorAction(frame, fileUrlString));
        JButton advancedEditorButton = new JButton(Translator.R("CPButAdvancedEditor"));
        advancedEditorButton.addActionListener(new LaunchPolicyToolAction(frame, fileUrlString));
        String pathPart = PolicyPanel.localFilePathFromUrlString(fileUrlString);
        simpleEditorButton.setToolTipText(Translator.R("CPPolicyTooltip", FileUtils.displayablePath(pathPart, 60)));
        JTextField locationField = new JTextField(pathPart);
        locationField.setEditable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        this.add((Component)aboutLabel, c);
        c.weighty = 0.0;
        c.weightx = 0.0;
        ++c.gridy;
        this.add((Component)locationField, c);
        c.fill = 0;
        ++c.gridx;
        this.add((Component)simpleEditorButton, c);
        ++c.gridx;
        this.add((Component)advancedEditorButton, c);
        --c.gridx;
        c.fill = 1;
        Component filler1 = Box.createRigidArea(new Dimension(240, 1));
        Component filler2 = Box.createRigidArea(new Dimension(1, 1));
        ++c.gridx;
        this.add(filler1, c);
        --c.gridx;
        c.weighty = 1.0;
        ++c.gridy;
        this.add(filler2, c);
    }

    private static void launchPolicyTool(JFrame frame, String filePath) {
        try {
            File policyFile = new File(filePath).getCanonicalFile();
            FileUtils.OpenFileResult result = FileUtils.testFilePermissions(policyFile);
            if (result == FileUtils.OpenFileResult.SUCCESS) {
                PolicyPanel.policyToolLaunchHelper(frame, filePath);
            } else if (result == FileUtils.OpenFileResult.CANT_WRITE) {
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, "Opening user JNLP policy read-only");
                FileUtils.showReadOnlyDialog(frame);
                PolicyPanel.policyToolLaunchHelper(frame, filePath);
            } else {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Could not open user JNLP policy");
                FileUtils.showCouldNotOpenFileDialog(frame, policyFile.getPath(), result);
            }
        }
        catch (IOException e) {
            OutputController.getLogger().log(e);
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Could not open user JNLP policy");
            FileUtils.showCouldNotOpenFilepathDialog(frame, filePath);
        }
    }

    private void launchSimplePolicyEditor(String filePath) {
        if (this.policyEditor == null || this.policyEditor.getPolicyEditor().isClosed()) {
            this.policyEditor = PolicyEditor.getPolicyEditorFrame(filePath);
            this.policyEditor.getPolicyEditor().openAndParsePolicyFile();
            this.policyEditor.asWindow().setVisible(true);
        } else {
            this.policyEditor.asWindow().toFront();
            this.policyEditor.asWindow().repaint();
        }
    }

    private static void policyToolLaunchHelper(final JFrame frame, final String filePath) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ProcessBuilder pb = new ProcessBuilder("policytool", "-file", filePath).directory(new File(System.getProperty("user.home")));
                try {
                    pb.start();
                }
                catch (IOException ioe) {
                    OutputController.getLogger().log(ioe);
                    try {
                        PolicyPanel.reflectivePolicyToolLaunch(filePath);
                    }
                    catch (Exception e) {
                        OutputController.getLogger().log(e);
                        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Could not open user JNLP policy");
                        FileUtils.showCouldNotOpenDialog(frame, Translator.R("CPPolicyEditorNotFound"));
                    }
                }
            }
        }).start();
    }

    private static void reflectivePolicyToolLaunch(String filePath) throws Exception {
        Class<?> policyTool;
        try {
            policyTool = Class.forName("sun.security.tools.policytool.PolicyTool");
        }
        catch (ClassNotFoundException cnfe) {
            policyTool = Class.forName("sun.security.tools.PolicyTool");
        }
        Class[] signature = new Class[]{String[].class};
        Method main = policyTool.getMethod("main", signature);
        String[] args = new String[]{"-file", filePath};
        main.invoke(null, new Object[]{args});
    }

    private static String localFilePathFromUrlString(String url) {
        try {
            URL u = new URL(url);
            return u.getPath();
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    private class LaunchSimplePolicyEditorAction
    implements ActionListener {
        private final JFrame frame;
        private final String fileUrlString;

        public LaunchSimplePolicyEditorAction(JFrame frame, String fileUrlString) {
            this.fileUrlString = fileUrlString;
            this.frame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                final URL fileUrl = new URL(this.fileUrlString);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PolicyPanel.this.launchSimplePolicyEditor(fileUrl.getPath());
                    }
                });
            }
            catch (MalformedURLException ex) {
                OutputController.getLogger().log(ex);
                FileUtils.showCouldNotOpenFilepathDialog(this.frame, this.fileUrlString);
            }
        }
    }

    private class LaunchPolicyToolAction
    implements ActionListener {
        private final JFrame frame;
        private final String fileUrlString;

        public LaunchPolicyToolAction(JFrame frame, String fileUrlString) {
            this.fileUrlString = fileUrlString;
            this.frame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                final URL fileUrl = new URL(this.fileUrlString);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PolicyPanel.launchPolicyTool(LaunchPolicyToolAction.this.frame, fileUrl.getPath());
                    }
                });
            }
            catch (MalformedURLException ex) {
                OutputController.getLogger().log(ex);
                FileUtils.showCouldNotOpenFilepathDialog(this.frame, this.fileUrlString);
            }
        }
    }
}

