/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.pom.java.LanguageLevel;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public enum JavaSdkVersion {
    JDK_1_0(LanguageLevel.JDK_1_3, 0, new String[]{"1.0"}),
    JDK_1_1(LanguageLevel.JDK_1_3, 1, new String[]{"1.1"}),
    JDK_1_2(LanguageLevel.JDK_1_3, 2, new String[]{"1.2"}),
    JDK_1_3(LanguageLevel.JDK_1_3, 3, new String[]{"1.3"}),
    JDK_1_4(LanguageLevel.JDK_1_4, 4, new String[]{"1.4"}),
    JDK_1_5(LanguageLevel.JDK_1_5, 5, new String[]{"1.5", "5.0"}),
    JDK_1_6(LanguageLevel.JDK_1_6, 6, new String[]{"1.6", "6.0"}),
    JDK_1_7(LanguageLevel.JDK_1_7, 7, new String[]{"1.7", "7.0"}),
    JDK_1_8(LanguageLevel.JDK_1_8, 8, new String[]{"1.8", "8.0"}),
    JDK_1_9(LanguageLevel.JDK_1_9, 9, new String[]{"1.9", "9.0", "9-ea"}),
    JDK_10(LanguageLevel.JDK_1_9, 10, new String[]{"10.0", "10-ea"});

    private static final JavaSdkVersion MAX_JDK;
    private static final Pattern JAVA_VERSION;
    private final LanguageLevel myMaxLanguageLevel;
    private final int myRelease;
    private final String[] myVersionStrings;

    private JavaSdkVersion(@NotNull LanguageLevel maxLanguageLevel, int release, @NotNull String[] description2) {
        if (maxLanguageLevel == null) {
            JavaSdkVersion.$$$reportNull$$$0(0);
        }
        if (description2 == null) {
            JavaSdkVersion.$$$reportNull$$$0(1);
        }
        this.myMaxLanguageLevel = maxLanguageLevel;
        this.myRelease = release;
        this.myVersionStrings = description2;
    }

    @NotNull
    public LanguageLevel getMaxLanguageLevel() {
        LanguageLevel languageLevel = this.myMaxLanguageLevel;
        if (languageLevel == null) {
            JavaSdkVersion.$$$reportNull$$$0(2);
        }
        return languageLevel;
    }

    @NotNull
    public String getDescription() {
        String string = this.myVersionStrings[0];
        if (string == null) {
            JavaSdkVersion.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String toString() {
        return super.toString() + ", description: " + this.getDescription();
    }

    static {
        MAX_JDK = JDK_1_9;
        JAVA_VERSION = Pattern.compile("java version \"(\\d.*)\"");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxLanguageLevel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/JavaSdkVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/JavaSdkVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxLanguageLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromLanguageLevel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromVersionString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

