/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.NetPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.cache.Resource;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialogMessage;
import net.sourceforge.jnlp.security.dialogresults.AccessWarningPaneComplexReturn;
import net.sourceforge.jnlp.security.dialogresults.DialogResult;
import net.sourceforge.jnlp.security.dialogresults.NamePassword;
import net.sourceforge.jnlp.security.dialogresults.YesCancel;
import net.sourceforge.jnlp.security.dialogresults.YesNoSandbox;
import net.sourceforge.jnlp.security.dialogresults.YesNoSandboxLimited;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class SecurityDialogs {
    public static AccessWarningPaneComplexReturn showAccessWarningDialog(AccessType accessType, JNLPFile file, Object[] extras) {
        SecurityDialogMessage message = new SecurityDialogMessage(file);
        message.dialogType = DialogType.ACCESS_WARNING;
        message.accessType = accessType;
        message.extras = extras;
        return (AccessWarningPaneComplexReturn)SecurityDialogs.getUserResponse(message);
    }

    public static YesNoSandboxLimited showUnsignedWarningDialog(JNLPFile file) {
        SecurityDialogMessage message = new SecurityDialogMessage(file);
        message.dialogType = DialogType.UNSIGNED_WARNING;
        message.accessType = AccessType.UNSIGNED;
        DialogResult r = SecurityDialogs.getUserResponse(message);
        return (YesNoSandboxLimited)r;
    }

    public static YesNoSandbox showCertWarningDialog(AccessType accessType, JNLPFile file, CertVerifier certVerifier, JNLPClassLoader.SecurityDelegate securityDelegate) {
        SecurityDialogMessage message = new SecurityDialogMessage(file);
        message.dialogType = DialogType.CERT_WARNING;
        message.accessType = accessType;
        message.certVerifier = certVerifier;
        message.extras = new Object[]{securityDelegate};
        DialogResult selectedValue = SecurityDialogs.getUserResponse(message);
        return (YesNoSandbox)selectedValue;
    }

    public static YesNoSandbox showPartiallySignedWarningDialog(JNLPFile file, CertVerifier certVerifier, JNLPClassLoader.SecurityDelegate securityDelegate) {
        SecurityDialogMessage message = new SecurityDialogMessage(file);
        message.dialogType = DialogType.PARTIALLYSIGNED_WARNING;
        message.accessType = AccessType.PARTIALLYSIGNED;
        message.certVerifier = certVerifier;
        message.extras = new Object[]{securityDelegate};
        DialogResult r = SecurityDialogs.getUserResponse(message);
        return (YesNoSandbox)r;
    }

    public static NamePassword showAuthenicationPrompt(String host, int port, String prompt, String type) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            NetPermission requestPermission = new NetPermission("requestPasswordAuthentication");
            sm.checkPermission(requestPermission);
        }
        SecurityDialogMessage message = new SecurityDialogMessage(null);
        message.dialogType = DialogType.AUTHENTICATION;
        message.extras = new Object[]{host, port, prompt, type};
        DialogResult response = SecurityDialogs.getUserResponse(message);
        OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Decided action for matching alaca at  was " + response);
        return (NamePassword)response;
    }

    public static boolean showMissingALACAttributePanel(JNLPFile file, URL codeBase, Set<URL> remoteUrls) {
        SecurityDialogMessage message = new SecurityDialogMessage(file);
        message.dialogType = DialogType.MISSING_ALACA;
        String urlToShow = file.getNotNullProbalbeCodeBase().toExternalForm();
        if (codeBase != null) {
            urlToShow = codeBase.toString();
        } else {
            OutputController.getLogger().log("Warning, null codebase wants to show in ALACA!");
        }
        message.extras = new Object[]{urlToShow, UrlUtils.setOfUrlsToHtmlList(remoteUrls)};
        DialogResult selectedValue = SecurityDialogs.getUserResponse(message);
        OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Decided action for matching alaca at " + file.getCodeBase() + " was " + selectedValue);
        if (selectedValue == null) {
            return false;
        }
        return selectedValue.toBoolean();
    }

    public static boolean showMatchingALACAttributePanel(JNLPFile file, URL documentBase, Set<URL> remoteUrls) {
        SecurityDialogMessage message = new SecurityDialogMessage(file);
        message.dialogType = DialogType.MATCHING_ALACA;
        String docBaseString = "null-documentbase";
        if (documentBase != null) {
            docBaseString = documentBase.toString();
        }
        message.extras = new Object[]{docBaseString, UrlUtils.setOfUrlsToHtmlList(remoteUrls)};
        DialogResult selectedValue = SecurityDialogs.getUserResponse(message);
        OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Decided action for matching alaca at " + file.getCodeBase() + " was " + selectedValue);
        if (selectedValue != null) {
            return selectedValue.toBoolean();
        }
        return false;
    }

    public static boolean showMissingPermissionsAttributeDialogue(JNLPFile file) {
        SecurityDialogMessage message = new SecurityDialogMessage(file);
        message.dialogType = DialogType.UNSIGNED_EAS_NO_PERMISSIONS_WARNING;
        DialogResult selectedValue = SecurityDialogs.getUserResponse(message);
        OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Decided action for missing permissions at " + file.getCodeBase() + " was " + selectedValue);
        if (selectedValue != null) {
            return selectedValue.toBoolean();
        }
        return false;
    }

    private static DialogResult getUserResponse(final SecurityDialogMessage message) {
        if (SwingUtilities.isEventDispatchThread()) {
            final JDialog fakeDialog = new JDialog();
            fakeDialog.setSize(0, 0);
            fakeDialog.setResizable(false);
            fakeDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            fakeDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    message.toDispose = fakeDialog;
                    message.lock = null;
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            JNLPRuntime.getSecurityDialogHandler().postMessage(message);
                            return null;
                        }
                    });
                }
            });
            fakeDialog.setVisible(true);
        } else {
            message.toDispose = null;
            message.lock = new Semaphore(0);
            JNLPRuntime.getSecurityDialogHandler().postMessage(message);
            boolean done = false;
            while (!done) {
                try {
                    message.lock.acquire();
                    done = true;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return message.userResponse;
    }

    public static boolean show511Dialogue(Resource r) {
        SecurityDialogMessage message = new SecurityDialogMessage(null);
        message.dialogType = DialogType.SECURITY_511;
        message.extras = new Object[]{r.getLocation()};
        DialogResult selectedValue = SecurityDialogs.getUserResponse(message);
        return selectedValue == null || !selectedValue.equals(YesCancel.cancel());
    }

    public static enum AccessType {
        READ_FILE,
        WRITE_FILE,
        CREATE_DESTKOP_SHORTCUT,
        CLIPBOARD_READ,
        CLIPBOARD_WRITE,
        PRINTER,
        NETWORK,
        VERIFIED,
        UNVERIFIED,
        PARTIALLYSIGNED,
        UNSIGNED,
        SIGNING_ERROR;

    }

    public static enum DialogType {
        CERT_WARNING,
        MORE_INFO,
        CERT_INFO,
        SINGLE_CERT_INFO,
        ACCESS_WARNING,
        PARTIALLYSIGNED_WARNING,
        UNSIGNED_WARNING,
        APPLET_WARNING,
        AUTHENTICATION,
        UNSIGNED_EAS_NO_PERMISSIONS_WARNING,
        MISSING_ALACA,
        MATCHING_ALACA,
        SECURITY_511;

    }
}

