/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;

public class MailcapCommandMap
extends CommandMap {
    private static final int PROG = 0;
    private static final int HOME = 1;
    private static final int SYS = 2;
    private static final int JAR = 3;
    private static final int DEF = 4;
    private static boolean debug = false;
    private static final int NORMAL = 0;
    private static final int FALLBACK = 1;
    private Map[][] mailcaps;

    public MailcapCommandMap() {
        this.init(null);
    }

    public MailcapCommandMap(String fileName) throws IOException {
        FileReader in = null;
        try {
            in = new FileReader(fileName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.init(in);
        if (in != null) {
            try {
                ((Reader)in).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public MailcapCommandMap(InputStream is) {
        this.init(new InputStreamReader(is));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Reader in) {
        List systemResources;
        int len;
        this.mailcaps = new Map[5][2];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.mailcaps[i][j] = new LinkedHashMap();
            }
        }
        if (in != null) {
            if (debug) {
                System.out.println("MailcapCommandMap: load PROG");
            }
            try {
                this.parse(0, in);
            }
            catch (IOException i) {
                // empty catch block
            }
        }
        if (debug) {
            System.out.println("MailcapCommandMap: load HOME");
        }
        try {
            String home = System.getProperty("user.home");
            if (home != null) {
                this.parseFile(1, new StringBuffer(home).append(File.separatorChar).append(".mailcap").toString());
            }
        }
        catch (SecurityException home) {
            // empty catch block
        }
        if (debug) {
            System.out.println("MailcapCommandMap: load SYS");
        }
        try {
            this.parseFile(2, new StringBuffer(System.getProperty("java.home")).append(File.separatorChar).append("lib").append(File.separatorChar).append("mailcap").toString());
        }
        catch (SecurityException home) {
            // empty catch block
        }
        if (debug) {
            System.out.println("MailcapCommandMap: load JAR");
        }
        if ((len = (systemResources = this.getSystemResources("META-INF/mailcap")).size()) > 0) {
            for (int i = 0; i < len; ++i) {
                Reader urlIn = null;
                URL url = (URL)systemResources.get(i);
                try {
                    if (debug) {
                        System.out.println("\t" + url.toString());
                    }
                    urlIn = new InputStreamReader(url.openStream());
                    this.parse(3, urlIn);
                    continue;
                }
                catch (IOException e) {
                    if (!debug) continue;
                    System.out.println(e.getClass().getName() + ": " + e.getMessage());
                    continue;
                }
                finally {
                    if (urlIn != null) {
                        try {
                            urlIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            this.parseResource(3, "/META-INF/mailcap");
        }
        if (debug) {
            System.out.println("MailcapCommandMap: load DEF");
        }
        this.parseResource(4, "/META-INF/mailcap.default");
    }

    @Override
    public synchronized CommandInfo[] getPreferredCommands(String mimeType) {
        ArrayList<CommandInfo> cmdList = new ArrayList<CommandInfo>();
        ArrayList<String> verbList = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                Map map = this.getCommands(this.mailcaps[j][i], mimeType);
                if (map == null) continue;
                for (Map.Entry entry : map.entrySet()) {
                    String verb = (String)entry.getKey();
                    if (verbList.contains(verb)) continue;
                    List classNames = (List)entry.getValue();
                    String className = (String)classNames.get(0);
                    CommandInfo cmd = new CommandInfo(verb, className);
                    cmdList.add(cmd);
                    verbList.add(verb);
                }
            }
        }
        CommandInfo[] cmds = new CommandInfo[cmdList.size()];
        cmdList.toArray(cmds);
        return cmds;
    }

    @Override
    public synchronized CommandInfo[] getAllCommands(String mimeType) {
        ArrayList<CommandInfo> cmdList = new ArrayList<CommandInfo>();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                Map map = this.getCommands(this.mailcaps[j][i], mimeType);
                if (map == null) continue;
                for (Map.Entry entry : map.entrySet()) {
                    String verb = (String)entry.getKey();
                    List classNames = (List)entry.getValue();
                    int len = classNames.size();
                    for (int l = 0; l < len; ++l) {
                        String className = (String)classNames.get(l);
                        CommandInfo cmd = new CommandInfo(verb, className);
                        cmdList.add(cmd);
                    }
                }
            }
        }
        CommandInfo[] cmds = new CommandInfo[cmdList.size()];
        cmdList.toArray(cmds);
        return cmds;
    }

    @Override
    public synchronized CommandInfo getCommand(String mimeType, String cmdName) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                Map map = this.getCommands(this.mailcaps[j][i], mimeType);
                if (map == null) continue;
                List classNames = (List)map.get(cmdName);
                if (classNames == null) {
                    classNames = (List)map.get("x-java-" + cmdName);
                }
                if (classNames == null) continue;
                String className = (String)classNames.get(0);
                return new CommandInfo(cmdName, className);
            }
        }
        return null;
    }

    public synchronized void addMailcap(String mail_cap) {
        if (debug) {
            System.out.println("MailcapCommandMap: add to PROG");
        }
        try {
            this.parse(0, new StringReader(mail_cap));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized DataContentHandler createDataContentHandler(String mimeType) {
        if (debug) {
            System.out.println("MailcapCommandMap: createDataContentHandler for " + mimeType);
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                Map map;
                if (debug) {
                    System.out.println("  search DB #" + i);
                }
                if ((map = this.getCommands(this.mailcaps[j][i], mimeType)) == null) continue;
                List classNames = (List)map.get("content-handler");
                if (classNames == null) {
                    classNames = (List)map.get("x-java-content-handler");
                }
                if (classNames == null) continue;
                String className = (String)classNames.get(0);
                if (debug) {
                    System.out.println("  In " + MailcapCommandMap.nameOf(j) + ", content-handler=" + className);
                }
                try {
                    Class<?> clazz = Class.forName(className);
                    return (DataContentHandler)clazz.newInstance();
                }
                catch (IllegalAccessException e) {
                    if (!debug) continue;
                    e.printStackTrace();
                    continue;
                }
                catch (ClassNotFoundException e) {
                    if (!debug) continue;
                    e.printStackTrace();
                    continue;
                }
                catch (InstantiationException e) {
                    if (!debug) continue;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public String[] getNativeCommands(String mimeType) {
        ArrayList acc = new ArrayList();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.addNativeCommands(acc, this.mailcaps[j][i], mimeType);
            }
        }
        String[] ret = new String[acc.size()];
        acc.toArray(ret);
        return ret;
    }

    private void addNativeCommands(List acc, Map mailcap, String mimeType) {
        for (Map.Entry m_entry : mailcap.entrySet()) {
            Map commands;
            String viewCommand;
            String entryMimeType = (String)m_entry.getKey();
            if (!entryMimeType.equals(mimeType) || (viewCommand = (String)(commands = (Map)m_entry.getValue()).get("view-command")) == null) continue;
            StringBuffer buf = new StringBuffer();
            buf.append(mimeType);
            buf.append(';');
            buf.append(' ');
            buf.append(viewCommand);
            for (Map.Entry c_entry : commands.entrySet()) {
                String verb = (String)c_entry.getKey();
                List classNames = (List)c_entry.getValue();
                if ("view-command".equals(verb)) continue;
                for (String command : classNames) {
                    buf.append(';');
                    buf.append(' ');
                    buf.append(verb);
                    buf.append('=');
                    buf.append(command);
                }
            }
            if (buf.length() <= 0) continue;
            acc.add(buf.toString());
        }
    }

    private static String nameOf(int mailcap) {
        switch (mailcap) {
            case 0: {
                return "PROG";
            }
            case 1: {
                return "HOME";
            }
            case 2: {
                return "SYS";
            }
            case 3: {
                return "JAR";
            }
            case 4: {
                return "DEF";
            }
        }
        return "ERR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(int index, String filename) {
        FileReader in = null;
        try {
            if (debug) {
                System.out.println("\t" + filename);
            }
            in = new FileReader(filename);
            this.parse(index, in);
        }
        catch (IOException e) {
            if (debug) {
                System.out.println(e.getClass().getName() + ": " + e.getMessage());
            }
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseResource(int index, String name) {
        Reader in = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(name);
            if (is != null) {
                if (debug) {
                    System.out.println("\t" + name);
                }
                in = new InputStreamReader(is);
                this.parse(index, in);
            }
        }
        catch (IOException e) {
            if (debug) {
                System.out.println(e.getClass().getName() + ": " + e.getMessage());
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parse(int index, Reader in) throws IOException {
        BufferedReader br = new BufferedReader(in);
        StringBuffer buf = null;
        String line = br.readLine();
        while (line != null) {
            int len = (line = line.trim()).length();
            if (len != 0 && line.charAt(0) != '#') {
                if (line.charAt(len - 1) == '\\') {
                    if (buf == null) {
                        buf = new StringBuffer();
                    }
                    buf.append(line.substring(0, len - 1));
                } else if (buf != null) {
                    buf.append(line);
                    this.parseEntry(index, buf.toString());
                    buf = null;
                } else {
                    this.parseEntry(index, line);
                }
            }
            line = br.readLine();
        }
    }

    private void parseEntry(int index, String line) {
        char[] chars = line.toCharArray();
        int len = chars.length;
        boolean inQuotedString = false;
        boolean fallback = false;
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> fields = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (c == '\\') {
                c = chars[++i];
            }
            if (c == ';' && !inQuotedString) {
                String field = buffer.toString().trim();
                if ("x-java-fallback-entry".equals(field)) {
                    fallback = true;
                }
                fields.add(field);
                buffer.setLength(0);
                continue;
            }
            if (c == '\"') {
                inQuotedString = !inQuotedString;
            }
            buffer.append(c);
        }
        String field = buffer.toString().trim();
        if ("x-java-fallback-entry".equals(field)) {
            fallback = true;
        }
        fields.add(field);
        len = fields.size();
        if (len < 2) {
            if (debug) {
                System.err.println("Invalid mailcap entry: " + line);
            }
            return;
        }
        Map mailcap = fallback ? this.mailcaps[index][1] : this.mailcaps[index][0];
        String mimeType = (String)fields.get(0);
        this.addField(mailcap, mimeType, "view-command", (String)fields.get(1));
        for (int i = 2; i < len; ++i) {
            this.addField(mailcap, mimeType, null, (String)fields.get(i));
        }
    }

    private void addField(Map mailcap, String mimeType, String verb, String command) {
        ArrayList<String> classNames;
        int ei;
        if (verb == null && (ei = command.indexOf(61)) != -1) {
            verb = command.substring(0, ei);
            command = command.substring(ei + 1);
        }
        if (command.length() == 0 || verb == null || verb.length() == 0) {
            return;
        }
        LinkedHashMap<String, ArrayList<String>> commands = (LinkedHashMap<String, ArrayList<String>>)mailcap.get(mimeType);
        if (commands == null) {
            commands = new LinkedHashMap<String, ArrayList<String>>();
            mailcap.put(mimeType, commands);
        }
        if ((classNames = (ArrayList<String>)commands.get(verb)) == null) {
            classNames = new ArrayList<String>();
            commands.put(verb, classNames);
        }
        classNames.add(command);
    }

    private Map getCommands(Map mailcap, String mimeType) {
        int si = mimeType.indexOf(47);
        String genericMimeType = new StringBuffer(mimeType.substring(0, si)).append('/').append('*').toString();
        Map specific = (Map)mailcap.get(mimeType);
        Map generic = (Map)mailcap.get(genericMimeType);
        if (generic == null) {
            return specific;
        }
        if (specific == null) {
            return generic;
        }
        LinkedHashMap<String, List> combined = new LinkedHashMap<String, List>();
        combined.putAll(specific);
        for (String verb : generic.keySet()) {
            List genericClassNames = (List)generic.get(verb);
            List classNames = (List)combined.get(verb);
            if (classNames == null) {
                combined.put(verb, genericClassNames);
                continue;
            }
            classNames.addAll(genericClassNames);
        }
        return combined;
    }

    private List getSystemResources(String name) {
        ArrayList<URL> acc = new ArrayList<URL>();
        try {
            Enumeration<URL> i = ClassLoader.getSystemResources(name);
            while (i.hasMoreElements()) {
                acc.add(i.nextElement());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return acc;
    }

    static {
        try {
            String d = System.getProperty("javax.activation.debug");
            debug = Boolean.valueOf(d);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

