/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_is extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "g\u00fajarat\u00ed";
        final String metaValue_km = "kmer";
        final String metaValue_kn = "kannada";
        final String metaValue_te = "tel\u00fag\u00fa";
        final Object[][] data = new Object[][] {
            { "Zsym", "t\u00e1kn" },
            { "mwr", "marvar\u00ed" },
            { "egy", "fornegypska" },
            { "raj", "rajastan\u00ed" },
            { "tem", "t\u00edmne" },
            { "teo", "tes\u00f3" },
            { "rap", "rapan\u00fa\u00ed" },
            { "ter", "teren\u00f3" },
            { "AC", "Ascension-eyja" },
            { "rar", "rar\u00f3tongska" },
            { "tet", "tet\u00fam" },
            { "AD", "Andorra" },
            { "AE", "Sameinu\u00f0u arab\u00edsku furstad\u00e6min" },
            { "nl_BE", "fl\u00e6mska" },
            { "AF", "Afganistan" },
            { "AG", "Ant\u00edgva og Barb\u00fada" },
            { "AI", "Angvilla" },
            { "AL", "Alban\u00eda" },
            { "AM", "Armen\u00eda" },
            { "AO", "Ang\u00f3la" },
            { "AQ", "Su\u00f0urskautslandi\u00f0" },
            { "AR", "Argent\u00edna" },
            { "AS", "Bandar\u00edska Sam\u00f3a" },
            { "AT", "Austurr\u00edki" },
            { "AU", "\u00c1stral\u00eda" },
            { "AW", "Ar\u00faba" },
            { "en_US", "bandar\u00edsk enska" },
            { "AX", "\u00c1landseyjar" },
            { "AZ", "Aserba\u00eddsjan" },
            { "BA", "Bosn\u00eda og Herseg\u00f3v\u00edna" },
            { "BB", "Barbados" },
            { "ceb", "keb\u00faan\u00f3" },
            { "BD", "Bangladess" },
            { "kum", "k\u00fam\u00edk" },
            { "BE", "Belg\u00eda" },
            { "gmh", "mi\u00f0h\u00e1\u00fe\u00fdska" },
            { "BF", "B\u00fark\u00edna Fas\u00f3" },
            { "BG", "B\u00falgar\u00eda" },
            { "BH", "Barein" },
            { "BI", "B\u00far\u00fand\u00ed" },
            { "BJ", "Ben\u00edn" },
            { "BL", "Sankti Bart\u00f3l\u00f3meusareyjar" },
            { "BM", "Berm\u00fadaeyjar" },
            { "kut", "k\u00fatena\u00ed" },
            { "myv", "ersja" },
            { "BN", "Br\u00fanei" },
            { "BO", "B\u00f3liv\u00eda" },
            { "BQ", "Kar\u00edbahafshluti Hollands" },
            { "BR", "Brasil\u00eda" },
            { "BS", "Bahamaeyjar" },
            { "xog", "s\u00f3ga" },
            { "BT", "B\u00fatan" },
            { "BV", "Bouveteyja" },
            { "BW", "Botsvana" },
            { "BY", "Hv\u00edta-R\u00fassland" },
            { "BZ", "Bel\u00eds" },
            { "CA", "Kanada" },
            { "CC", "K\u00f3koseyjar (Keeling)" },
            { "mzn", "masanderan\u00ed" },
            { "CD", "Kong\u00f3-Kinshasa" },
            { "CF", "Mi\u00f0-Afr\u00edkul\u00fd\u00f0veldi\u00f0" },
            { "CG", "Kong\u00f3-Brazzaville" },
            { "CH", "Sviss" },
            { "CI", "F\u00edlabeinsstr\u00f6ndin" },
            { "CK", "Cooks-eyjar" },
            { "CL", "S\u00edle" },
            { "CM", "Kamer\u00fan" },
            { "CN", "K\u00edna" },
            { "CO", "K\u00f3lumb\u00eda" },
            { "CP", "Clipperton-eyja" },
            { "CR", "Kostar\u00edka" },
            { "CU", "K\u00faba" },
            { "CV", "Gr\u00e6nh\u00f6f\u00f0aeyjar" },
            { "CW", "Curacao" },
            { "CX", "J\u00f3laey" },
            { "CY", "K\u00fdpur" },
            { "CZ", "T\u00e9kkland" },
            { "eka", "ekaj\u00fak" },
            { "DE", "\u00de\u00fdskaland" },
            { "goh", "fornh\u00e1\u00fe\u00fdska" },
            { "ace", "akk\u00edska" },
            { "cgg", "k\u00edga" },
            { "DG", "Diego Garcia" },
            { "DJ", "Dj\u00edb\u00fat\u00ed" },
            { "DK", "Danm\u00f6rk" },
            { "ach", "acoli" },
            { "gon", "gond\u00ed" },
            { "Brai", "blindraletur" },
            { "DM", "D\u00f3min\u00edka" },
            { "DO", "D\u00f3min\u00edska l\u00fd\u00f0veldi\u00f0" },
            { "gor", "gorontal\u00f3" },
            { "got", "gotneska" },
            { "zun", "s\u00fan\u00ed" },
            { "tig", "t\u00edgre" },
            { "DZ", "Als\u00edr" },
            { "pag", "pangas\u00ednm\u00e1l" },
            { "pal", "palav\u00ed" },
            { "EA", "Ceuta og Melilla" },
            { "chb", "s\u00edbsja" },
            { "pam", "pampanga" },
            { "EC", "Ekvador" },
            { "pap", "pap\u00edament\u00f3" },
            { "ada", "adangme" },
            { "EE", "Eistland" },
            { "tiv", "t\u00edv" },
            { "EG", "Egyptaland" },
            { "EH", "Vestur-Sahara" },
            { "chg", "sjagata\u00ed" },
            { "pau", "pal\u00e1ska" },
            { "chk", "sj\u00fak\u00edska" },
            { "chn", "s\u00edn\u00fak" },
            { "chm", "mar\u00ed" },
            { "chp", "s\u00edpev\u00edska" },
            { "cho", "sjokt\u00e1" },
            { "chr", "Cherokee-m\u00e1l" },
            { "ER", "Er\u00edtrea" },
            { "ES", "Sp\u00e1nn" },
            { "ET", "E\u00fe\u00ed\u00f3p\u00eda" },
            { "EU", "Evr\u00f3pusambandi\u00f0" },
            { "elx", "elam\u00edt" },
            { "chy", "sjeyen" },
            { "ady", "ad\u00fdge" },
            { "FI", "Finnland" },
            { "FJ", "F\u00eddj\u00edeyjar" },
            { "FK", "Falklandseyjar" },
            { "FM", "M\u00edkr\u00f3nes\u00eda" },
            { "FO", "F\u00e6reyjar" },
            { "Taml", "tam\u00edlskt" },
            { "FR", "Frakkland" },
            { "tkl", "t\u00f3kel\u00e1ska" },
            { "grb", "gerb\u00f3" },
            { "root", "r\u00f3t" },
            { "grc", "forngr\u00edska" },
            { "GA", "Gabon" },
            { "vot", "vot\u00edska" },
            { "GB", "Bretland" },
            { "GD", "Grenada" },
            { "GE", "Georg\u00eda" },
            { "GF", "Franska Gv\u00e6jana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "G\u00edbraltar" },
            { "afh", "afr\u00edh\u00edl\u00ed" },
            { "GL", "Gr\u00e6nland" },
            { "enm", "mi\u00f0enska" },
            { "GM", "Gamb\u00eda" },
            { "GN", "G\u00ednea" },
            { "GP", "Gvadel\u00fapeyjar" },
            { "GQ", "Mi\u00f0baugs-G\u00ednea" },
            { "GR", "Grikkland" },
            { "GS", "Su\u00f0ur-Georg\u00eda og Su\u00f0ur-Sandv\u00edkureyjar" },
            { "GT", "Gvatemala" },
            { "GU", "Gvam" },
            { "GW", "G\u00ednea-Biss\u00e1" },
            { "tli", "tlingit" },
            { "tlh", "klingonska" },
            { "GY", "Gv\u00e6jana" },
            { "ckb", "sorani-k\u00fard\u00edska" },
            { "zxx", "ekkert tungum\u00e1laefni" },
            { "de_AT", "austurr\u00edsk \u00fe\u00fdska" },
            { "HK", "Sj\u00e1lfstj\u00f3rnarsv\u00e6\u00f0i\u00f0 Hong Kong" },
            { "HM", "Heard og McDonaldseyjar" },
            { "HN", "Hond\u00faras" },
            { "HR", "Kr\u00f3at\u00eda" },
            { "agq", "aghem" },
            { "gsw", "svissnesk \u00fe\u00fdska" },
            { "HT", "Ha\u00edt\u00ed" },
            { "HU", "Ungverjaland" },
            { "tmh", "tamasjek" },
            { "IC", "Kanar\u00edeyjar" },
            { "ID", "Ind\u00f3nes\u00eda" },
            { "peo", "fornpersneska" },
            { "IE", "\u00cdrland" },
            { "nap", "nap\u00f3l\u00edska" },
            { "naq", "nama" },
            { "IL", "\u00cdsrael" },
            { "IM", "M\u00f6n" },
            { "IN", "Indland" },
            { "IO", "Bresku Indlandshafseyjar" },
            { "IQ", "\u00cdrak" },
            { "IR", "\u00cdran" },
            { "IS", "\u00cdsland" },
            { "IT", "\u00cdtal\u00eda" },
            { "JE", "Jersey" },
            { "JM", "Jama\u00edka" },
            { "Beng", "bengalskt" },
            { "JO", "J\u00f3rdan\u00eda" },
            { "JP", "Japan" },
            { "guz", "gusii" },
            { "tog", "tongverska (nyasa)" },
            { "de_CH", "svissnesk h\u00e1\u00fe\u00fdska" },
            { "KE", "Ken\u00eda" },
            { "419", "R\u00f3manska Amer\u00edka" },
            { "KG", "Kirgistan" },
            { "KH", "Kamb\u00f3d\u00eda" },
            { "KI", "K\u00edribat\u00ed" },
            { "KM", "K\u00f3moreyjar" },
            { "Knda", metaValue_kn },
            { "KN", "Sankti Kitts og Nevis" },
            { "fr_CA", "kanad\u00edsk franska" },
            { "KP", "Nor\u00f0ur-K\u00f3rea" },
            { "KR", "Su\u00f0ur-K\u00f3rea" },
            { "fr_CH", "svissnesk franska" },
            { "KW", "K\u00faveit" },
            { "tpi", "tokpisin" },
            { "KY", "Caymaneyjar" },
            { "KZ", "Kasakstan" },
            { "Cyrl", "kyrill\u00edskt" },
            { "LA", "Laos" },
            { "LB", "L\u00edbanon" },
            { "LC", "Sankti L\u00fas\u00eda" },
            { "phn", "f\u00f6nik\u00edska" },
            { "gwi", "gv\u00eds\u00edn" },
            { "nds", "l\u00e1g\u00fe\u00fdska; l\u00e1gsaxneska" },
            { "LI", "Liechtenstein" },
            { "LK", "Sr\u00ed Lanka" },
            { "akk", "akkad\u00edska" },
            { "cop", "kopt\u00edska" },
            { "LR", "L\u00edber\u00eda" },
            { "LS", "Les\u00f3t\u00f3" },
            { "LT", "Lith\u00e1en" },
            { "LU", "L\u00faxemborg" },
            { "LV", "Lettland" },
            { "Kana", "katakana" },
            { "LY", "L\u00edb\u00eda" },
            { "lad", "lad\u00ednska" },
            { "vun", "vunj\u00f3" },
            { "lah", "landa" },
            { "lag", "lang\u00ed" },
            { "Thaa", "thaana" },
            { "MA", "Marokk\u00f3" },
            { "MC", "M\u00f3nak\u00f3" },
            { "MD", "Mold\u00f3va" },
            { "ME", "Svartfjallaland" },
            { "MF", "St. Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "MH", "Marshalleyjar" },
            { "ale", "ale\u00faska" },
            { "Thai", "ta\u00edlenskt" },
            { "MK", "Maked\u00f3n\u00eda" },
            { "ML", "Mal\u00ed" },
            { "MM", "Mjanmar (B\u00farma)" },
            { "MN", "Mong\u00f3l\u00eda" },
            { "new", "nevar\u00ed" },
            { "MO", "Sj\u00e1lfstj\u00f3rnarsv\u00e6\u00f0i\u00f0 Maka\u00f3" },
            { "MP", "Nor\u00f0ur-Mar\u00edanaeyjar" },
            { "MQ", "Martin\u00edk" },
            { "MR", "M\u00e1ritan\u00eda" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "M\u00e1rit\u00edus" },
            { "MV", "Mald\u00edveyjar" },
            { "MW", "Malav\u00ed" },
            { "MX", "Mex\u00edk\u00f3" },
            { "MY", "Malas\u00eda" },
            { "MZ", "M\u00f3samb\u00edk" },
            { "NA", "Namib\u00eda" },
            { "NC", "N\u00fdja-Kaled\u00f3n\u00eda" },
            { "NE", "N\u00edger" },
            { "NF", "Norfolkeyja" },
            { "NG", "N\u00edger\u00eda" },
            { "NI", "N\u00edkaragva" },
            { "NL", "Holland" },
            { "NO", "Noregur" },
            { "NP", "Nepal" },
            { "NR", "N\u00e1r\u00fa" },
            { "NU", "Niue" },
            { "rof", "romb\u00f3" },
            { "tsi", "tsims\u00edska" },
            { "NZ", "N\u00fdja-Sj\u00e1land" },
            { "rom", "roman\u00ed" },
            { "crh", "kr\u00edmtyrkneska" },
            { "ang", "fornenska" },
            { "OM", "\u00d3man" },
            { "PA", "Panama" },
            { "csb", "kas\u00fab\u00edska" },
            { "en_GB", "bresk enska" },
            { "PE", "Per\u00fa" },
            { "PF", "Franska P\u00f3l\u00fdnes\u00eda" },
            { "PG", "Pap\u00faa N\u00fdja-G\u00ednea" },
            { "PH", "Filippseyjar" },
            { "PK", "Pakistan" },
            { "PL", "P\u00f3lland" },
            { "ewo", "evond\u00f3" },
            { "PM", "Sankti Pierre og Miquelon" },
            { "PN", "Pitcairn-eyjar" },
            { "PR", "P\u00faert\u00f3 R\u00edk\u00f3" },
            { "PS", "Heimastj\u00f3rnarsv\u00e6\u00f0i Palest\u00ednumanna" },
            { "PT", "Port\u00fagal" },
            { "PW", "Pal\u00e1" },
            { "nia", "n\u00edas" },
            { "PY", "Paragv\u00e6" },
            { "tum", "t\u00famb\u00faka" },
            { "Hebr", "hebreskt" },
            { "QA", "Katar" },
            { "niu", "n\u00edveska" },
            { "QO", "Ytri Eyja\u00e1lfa" },
            { "lez", "lesg\u00edska" },
            { "tvl", "t\u00faval\u00faska" },
            { "001", "Heimurinn" },
            { "002", "Afr\u00edka" },
            { "003", "Nor\u00f0ur-Amer\u00edka" },
            { "RE", "R\u00e9union" },
            { "005", "Su\u00f0ur-Amer\u00edka" },
            { "jbo", "lojban" },
            { "009", "Eyja\u00e1lfa" },
            { "RO", "R\u00famen\u00eda" },
            { "RS", "Serb\u00eda" },
            { "RU", "R\u00fassland" },
            { "RW", "R\u00faanda" },
            { "SA", "S\u00e1di-Arab\u00eda" },
            { "pon", "ponpeiska" },
            { "SB", "Sal\u00f3monseyjar" },
            { "twq", "tasawaq" },
            { "011", "Vestur-Afr\u00edka" },
            { "SC", "Seychelles-eyjar" },
            { "SD", "S\u00fadan" },
            { "013", "Mi\u00f0-Amer\u00edka" },
            { "SE", "Sv\u00ed\u00fej\u00f3\u00f0" },
            { "014", "Austur-Afr\u00edka" },
            { "arc", "arame\u00edska" },
            { "015", "Nor\u00f0ur-Afr\u00edka" },
            { "SG", "Singap\u00far" },
            { "SH", "Sankti Helena" },
            { "017", "Mi\u00f0-Afr\u00edka" },
            { "SI", "Sl\u00f3ven\u00eda" },
            { "018", "Su\u00f0urhluti Afr\u00edku" },
            { "SJ", "Svalbar\u00f0i og Jan Mayen" },
            { "019", "Amer\u00edka" },
            { "SK", "Sl\u00f3vak\u00eda" },
            { "SL", "S\u00ederra Le\u00f3ne" },
            { "SM", "San Mar\u00edn\u00f3" },
            { "SN", "Senegal" },
            { "SO", "S\u00f3mal\u00eda" },
            { "arn", "ar\u00e1kan\u00edska" },
            { "arp", "arapah\u00f3" },
            { "SR", "S\u00far\u00ednam" },
            { "SS", "Su\u00f0ur-S\u00fadan" },
            { "ST", "Sa\u00f3 T\u00f3me og Prins\u00edpe" },
            { "SV", "El Salvador" },
            { "SX", "Sankti Martin" },
            { "SY", "S\u00fdrland" },
            { "yao", "ja\u00f3" },
            { "SZ", "Svas\u00edland" },
            { "arw", "aravakska" },
            { "yap", "jap\u00edska" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "021", "Amer\u00edka nor\u00f0an Mexik\u00f3" },
            { "TC", "Turks- og Caicoseyjar" },
            { "TD", "Tsjad" },
            { "TF", "Fr\u00f6nsku su\u00f0l\u00e6gu landsv\u00e6\u00f0in" },
            { "TG", "T\u00f3g\u00f3" },
            { "TH", "Ta\u00edland" },
            { "TJ", "Tadsjikistan" },
            { "029", "Kar\u00edbahafi\u00f0" },
            { "TK", "T\u00f3kel\u00e1" },
            { "TL", "T\u00edmor-Leste" },
            { "TM", "T\u00farkmenistan" },
            { "TN", "T\u00fanis" },
            { "TO", "Tonga" },
            { "TR", "Tyrkland" },
            { "TT", "Tr\u00ednidad og T\u00f3bag\u00f3" },
            { "TV", "T\u00faval\u00fa" },
            { "TW", "Ta\u00edvan" },
            { "ast", "ast\u00far\u00edska" },
            { "TZ", "Tansan\u00eda" },
            { "nmg", "kwasio" },
            { "Zzzz", "\u00f3\u00feekkt letur" },
            { "UA", "\u00dakra\u00edna" },
            { "030", "Austur-As\u00eda" },
            { "tyv", "t\u00fav\u00ednska" },
            { "sw_CD", "Kong\u00f3-svah\u00edl\u00ed" },
            { "034", "Su\u00f0ur-As\u00eda" },
            { "hai", "ha\u00edda" },
            { "035", "Su\u00f0austur-As\u00eda" },
            { "UG", "\u00daganda" },
            { "039", "Su\u00f0ur-Evr\u00f3pa" },
            { "Sinh", "sinhala" },
            { "UM", "Sm\u00e1eyjar Bandar\u00edkjanna" },
            { "US", "Bandar\u00edkin" },
            { "haw", "hava\u00edska" },
            { "UY", "\u00dar\u00fagv\u00e6" },
            { "UZ", "\u00dasbekistan" },
            { "tzm", "tamazight" },
            { "VA", "Vat\u00edkani\u00f0" },
            { "pro", "fornpr\u00f3vensalska" },
            { "VC", "Sankti Vinsent og Grenad\u00edneyjar" },
            { "VE", "Venes\u00faela" },
            { "VG", "Bresku J\u00f3mfr\u00faaeyjar" },
            { "VI", "Bandar\u00edsku J\u00f3mfr\u00faaeyjar" },
            { "VN", "V\u00edetnam" },
            { "VU", "Van\u00faat\u00fa" },
            { "nog", "n\u00f3ga\u00ed" },
            { "rwk", "r\u00faa" },
            { "non", "norr\u00e6na" },
            { "053", "\u00c1stralas\u00eda" },
            { "054", "Melanes\u00eda" },
            { "WF", "Wallis- og F\u00fat\u00fanaeyjar" },
            { "057", "M\u00edkr\u00f3nes\u00edusv\u00e6\u00f0i\u00f0" },
            { "jgo", "ngomba" },
            { "lkt", "lak\u00f3ta" },
            { "WS", "Sam\u00f3a" },
            { "wal", "valam\u00f3" },
            { "was", "vasj\u00f3" },
            { "war", "vara\u00ed" },
            { "awa", "avad\u00ed" },
            { "061", "P\u00f3l\u00fdnes\u00eda" },
            { "XK", "K\u00f3s\u00f3v\u00f3" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u00f3skrifa\u00f0" },
            { "wbp", "varlpiri" },
            { "YE", "Jemen" },
            { "nqo", "n\u2019ko" },
            { "fan", "fang" },
            { "fat", "fant\u00ed" },
            { "YT", "Mayotte" },
            { "ZA", "Su\u00f0ur-Afr\u00edka" },
            { "Deva", "devanagari" },
            { "Hira", "hiragana" },
            { "ZM", "Samb\u00eda" },
            { "ZW", "Simbabve" },
            { "ZZ", "\u00d3\u00feekkt sv\u00e6\u00f0i" },
            { "lol", "mong\u00f3" },
            { "nso", "nor\u00f0urs\u00f3t\u00f3" },
            { "loz", "lozi" },
            { "jmc", "masj\u00e1me" },
            { "hil", "h\u00edliga\u00ednon" },
            { "nus", "n\u00faer" },
            { "dak", "dak\u00f3ta" },
            { "hit", "hettit\u00edska" },
            { "dar", "dargva" },
            { "dav", "ta\u00edta" },
            { "lrc", "nor\u00f0url\u00far\u00ed" },
            { "udm", "\u00fadm\u00fart" },
            { "Khmr", metaValue_km },
            { "sad", "sandave" },
            { "sah", "jak\u00fat" },
            { "sam", "samversk arame\u00edska" },
            { "saq", "samb\u00far\u00fa" },
            { "sas", "sasak" },
            { "sat", "santal\u00ed" },
            { "jpr", "gy\u00f0ingapersneska" },
            { "Guru", "gurmukhi" },
            { "lua", "luba-lulua" },
            { "sbp", "sang\u00fa" },
            { "lui", "l\u00faisen\u00f3" },
            { "nyn", "nyankole" },
            { "nym", "njamves\u00ed" },
            { "lun", "l\u00fanda" },
            { "nyo", "nj\u00f3r\u00f3" },
            { "luo", "l\u00fa\u00f3" },
            { "fil", "filippseyska" },
            { "hmn", "hmong" },
            { "del", "delaver" },
            { "lus", "l\u00fasa\u00ed" },
            { "bal", "bal\u00fak\u00ed" },
            { "den", "slavneska" },
            { "ban", "bal\u00edska" },
            { "uga", "\u00fagar\u00edt\u00edska" },
            { "luy", "luyia" },
            { "bas", "basa" },
            { "jrb", "gy\u00f0ingaarab\u00edska" },
            { "es_ES", "evr\u00f3psk sp\u00e6nska" },
            { "nzi", "ns\u00edma" },
            { "sco", "skoska" },
            { "scn", "sikileyska" },
            { "ab", "abkas\u00edska" },
            { "ae", "avest\u00edska" },
            { "af", "afr\u00edkanska" },
            { "ak", "akan" },
            { "am", "amhar\u00edska" },
            { "an", "aragonska" },
            { "Arab", "arab\u00edskt" },
            { "Jpan", "japanskt" },
            { "ar", "arab\u00edska" },
            { "Hrkt", "katakana e\u00f0a hiragana" },
            { "as", "assamska" },
            { "av", "avar\u00edska" },
            { "sdh", "su\u00f0urk\u00fard\u00edska" },
            { "ay", "a\u00edmara" },
            { "az", "aserska" },
            { "ba", "bask\u00edr" },
            { "be", "hv\u00edtr\u00fassneska" },
            { "bg", "b\u00falgarska" },
            { "bi", "b\u00edslama" },
            { "bm", "bambara" },
            { "bn", "bengalska" },
            { "bo", "t\u00edbeska" },
            { "dgr", "dogr\u00edb" },
            { "br", "bret\u00f3nska" },
            { "bs", "bosn\u00edska" },
            { "Mymr", "mjanmarskt" },
            { "seh", "sena" },
            { "sel", "selk\u00fap" },
            { "ca", "katal\u00f3nska" },
            { "ses", "ko\u00edrabor\u00f3-senn\u00ed" },
            { "ce", "tsjetsjenska" },
            { "ch", "kamorr\u00f3" },
            { "co", "kors\u00edska" },
            { "Orya", "oriya" },
            { "cr", "kr\u00ed" },
            { "cs", "t\u00e9kkneska" },
            { "cu", "kirkjuslavneska" },
            { "cv", "sj\u00favas" },
            { "cy", "velska" },
            { "da", "danska" },
            { "pt_PT", "evr\u00f3psk port\u00fagalska" },
            { "de", "\u00fe\u00fdska" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "bem", "bemba" },
            { "sga", "forn\u00edrska" },
            { "dv", "d\u00edveh\u00ed" },
            { "es_419", "r\u00f3m\u00f6nsk-amer\u00edsk sp\u00e6nska" },
            { "dz", "dsongka" },
            { "bez", "bena" },
            { "dje", "zarma" },
            { "ee", "ewe" },
            { "ro_MD", "mold\u00f3vska" },
            { "el", "gr\u00edska" },
            { "en", "enska" },
            { "eo", "esperant\u00f3" },
            { "es", "sp\u00e6nska" },
            { "et", "eistneska" },
            { "eu", "baskneska" },
            { "Hang", "hangul" },
            { "shi", "tachelhit" },
            { "hsb", "h\u00e1sorbneska" },
            { "Hani", "k\u00ednverskt" },
            { "shn", "sjan" },
            { "fa", "persneska" },
            { "Hans", "einfalda\u00f0" },
            { "Hant", "hef\u00f0bundi\u00f0" },
            { "ff", "f\u00fala" },
            { "fi", "finnska" },
            { "fj", "f\u00eddjeyska" },
            { "fon", "f\u00f3n" },
            { "bgn", "vesturbalots\u00ed" },
            { "fo", "f\u00e6reyska" },
            { "umb", "\u00famb\u00fand\u00fa" },
            { "fr", "franska" },
            { "sid", "s\u00eddam\u00f3" },
            { "fy", "vesturfr\u00edsneska" },
            { "ga", "\u00edrska" },
            { "gd", "skosk gel\u00edska" },
            { "gl", "gal\u00edanska" },
            { "gn", "gvaran\u00ed" },
            { "bho", "bojp\u00far\u00ed" },
            { "und", "\u00f3\u00feekkt tungum\u00e1l" },
            { "gu", metaValue_gu },
            { "gv", "manska" },
            { "ha", "h\u00e1sa" },
            { "he", "hebreska" },
            { "hi", "hind\u00ed" },
            { "hup", "h\u00fapa" },
            { "bik", "b\u00edkol" },
            { "bin", "b\u00edn\u00ed" },
            { "ho", "h\u00edr\u00edm\u00f3t\u00fa" },
            { "hr", "kr\u00f3at\u00edska" },
            { "ht", "ha\u00edt\u00edska" },
            { "hu", "ungverska" },
            { "hy", "armenska" },
            { "hz", "herer\u00f3" },
            { "ia", "al\u00fej\u00f3\u00f0atunga" },
            { "id", "ind\u00f3nes\u00edska" },
            { "ie", "interlingve" },
            { "ig", "\u00edgb\u00f3" },
            { "ii", "s\u00eds\u00faanj\u00ed" },
            { "frm", "mi\u00f0franska" },
            { "ik", "\u00edn\u00fap\u00edak" },
            { "fro", "fornfranska" },
            { "io", "\u00edd\u00f3" },
            { "frs", "austurfr\u00edsneska" },
            { "frr", "nor\u00f0urfr\u00edsneska" },
            { "is", "\u00edslenska" },
            { "it", "\u00edtalska" },
            { "iu", "in\u00faktit\u00fat" },
            { "ja", "japanska" },
            { "Mlym", "malalajam" },
            { "doi", "dogr\u00ed" },
            { "sma", "su\u00f0ursam\u00edska" },
            { "jv", "javanska" },
            { "mad", "mad\u00farska" },
            { "smj", "l\u00falesam\u00edska" },
            { "mag", "magah\u00ed" },
            { "mai", "ma\u00edt\u00edl\u00ed" },
            { "smn", "enaresam\u00edska" },
            { "ka", "georg\u00edska" },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "sms", "skoltesam\u00edska" },
            { "man", "manding\u00f3" },
            { "kg", "kong\u00f3ska" },
            { "ki", "k\u00edk\u00faj\u00fa" },
            { "mas", "masa\u00ed" },
            { "kj", "k\u00faanjama" },
            { "kk", "kasakska" },
            { "kl", "gr\u00e6nlenska" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", "k\u00f3reska" },
            { "kr", "kan\u00far\u00ed" },
            { "ks", "kasm\u00edrska" },
            { "ku", "k\u00fard\u00edska" },
            { "kv", "kom\u00edska" },
            { "kw", "kornbreska" },
            { "ky", "kirgiska" },
            { "snk", "s\u00f3ninke" },
            { "la", "lat\u00edna" },
            { "lb", "l\u00faxemborg\u00edska" },
            { "lg", "ganda" },
            { "li", "limb\u00farg\u00edska" },
            { "Tibt", "t\u00edbeskt" },
            { "ln", "lingala" },
            { "fur", "fr\u00ed\u00falska" },
            { "lo", "la\u00f3" },
            { "lt", "lith\u00e1\u00edska" },
            { "lu", "l\u00fabakatanga" },
            { "lv", "lettneska" },
            { "sog", "sogd\u00eden" },
            { "mg", "malagas\u00edska" },
            { "mh", "marshallska" },
            { "mi", "maor\u00ed" },
            { "mk", "maked\u00f3nska" },
            { "ml", "malajalam" },
            { "mn", "mong\u00f3lska" },
            { "mr", "marat\u00ed" },
            { "ms", "mala\u00edska" },
            { "mt", "maltneska" },
            { "my", "burmneska" },
            { "Armn", "armenskt" },
            { "mdf", "moksa" },
            { "dsb", "l\u00e1gsorbneska" },
            { "na", "n\u00e1r\u00faska" },
            { "nb", "norskt b\u00f3km\u00e1l" },
            { "nd", "nor\u00f0ur-ndebele" },
            { "ne", "nepalska" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "hollenska" },
            { "nn", "n\u00fdnorska" },
            { "no", "norska" },
            { "nr", "su\u00f0urndebele" },
            { "nv", "navah\u00f3" },
            { "kaa", "karakalpak" },
            { "ny", "njanja; s\u00edsjeva; sjeva" },
            { "kac", "kas\u00edn" },
            { "kab", "kab\u00edle" },
            { "oc", "oks\u00edtan\u00edska" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "oj", "ojibva" },
            { "mer", "mer\u00fa" },
            { "om", "oromo" },
            { "kaw", "kav\u00ed" },
            { "or", "\u00f3r\u00eda" },
            { "os", "osset\u00edska" },
            { "kbd", "kabard\u00edska" },
            { "mfe", "m\u00e1rit\u00edska" },
            { "pa", "p\u00fanjab\u00ed" },
            { "dua", "d\u00faala" },
            { "srr", "serer" },
            { "pi", "pal\u00ed" },
            { "pl", "p\u00f3lska" },
            { "dum", "mi\u00f0hollenska" },
            { "ps", "past\u00fa" },
            { "pt", "port\u00fagalska" },
            { "mga", "mi\u00f0\u00edrska" },
            { "pt_BR", "bras\u00edl\u00edsk port\u00fagalska" },
            { "mgh", "makhuwa-meetto" },
            { "bra", "bra\u00ed" },
            { "Laoo", "lao" },
            { "mgo", "meta\u2019" },
            { "qu", "kvesj\u00faa" },
            { "zap", "sap\u00f3tek" },
            { "brx", "b\u00f3d\u00f3" },
            { "kde", "makonde" },
            { "Ethi", "e\u00fe\u00ed\u00f3p\u00edskt" },
            { "rm", "r\u00f3manska" },
            { "rn", "r\u00fand\u00ed" },
            { "ro", "r\u00famenska" },
            { "ru", "r\u00fassneska" },
            { "rw", "k\u00ednjarvanda" },
            { "zbl", "blisst\u00e1kn" },
            { "kea", "gr\u00e6nh\u00f6f\u00f0eyska" },
            { "mic", "mikmak" },
            { "suk", "s\u00fak\u00fama" },
            { "en_AU", "\u00e1str\u00f6lsk enska" },
            { "sa", "sanskr\u00edt" },
            { "sc", "sard\u00ednska" },
            { "sus", "s\u00fas\u00fa" },
            { "sd", "sind\u00ed" },
            { "se", "nor\u00f0ursam\u00edska" },
            { "min", "m\u00ednangkab\u00e1" },
            { "sg", "sang\u00f3" },
            { "sh", "serb\u00f3kr\u00f3at\u00edska" },
            { "si", "singal\u00edska" },
            { "sux", "s\u00famerska" },
            { "sk", "sl\u00f3vak\u00edska" },
            { "sl", "sl\u00f3venska" },
            { "sm", "sam\u00f3ska" },
            { "sn", "shona" },
            { "so", "s\u00f3malska" },
            { "sq", "albanska" },
            { "sr", "serbneska" },
            { "ss", "svat\u00ed" },
            { "st", "su\u00f0urs\u00f3t\u00f3" },
            { "su", "s\u00fandanska" },
            { "sv", "s\u00e6nska" },
            { "sw", "svah\u00edl\u00ed" },
            { "iba", "\u00edban" },
            { "ta", "tam\u00edlska" },
            { "142", "As\u00eda" },
            { "bua", "b\u00far\u00edat" },
            { "143", "Mi\u00f0-As\u00eda" },
            { "te", metaValue_te },
            { "145", "Vestur-As\u00eda" },
            { "tg", "tadsjikska" },
            { "th", "ta\u00edlenska" },
            { "ti", "t\u00edgrinja" },
            { "bug", "b\u00fag\u00edska" },
            { "en_CA", "kanad\u00edsk enska" },
            { "tk", "t\u00farkmenska" },
            { "tl", "tagalog" },
            { "tn", "ts\u00faana" },
            { "to", "tongverska" },
            { "dyo", "jola-fonyi" },
            { "tr", "tyrkneska" },
            { "ts", "tsonga" },
            { "tt", "tatarska" },
            { "dyu", "dj\u00fala" },
            { "tw", "tv\u00ed" },
            { "ty", "tah\u00edt\u00edska" },
            { "150", "Evr\u00f3pa" },
            { "151", "Austur-Evr\u00f3pa" },
            { "154", "Nor\u00f0ur-Evr\u00f3pa" },
            { "155", "Vestur-Evr\u00f3pa" },
            { "ug", "\u00fa\u00edg\u00far" },
            { "Kore", "k\u00f3reskt" },
            { "Zyyy", "almennt" },
            { "uk", "\u00fakra\u00ednska" },
            { "ur", "\u00fard\u00fa" },
            { "xal", "kalm\u00fakska" },
            { "zen", "senaga" },
            { "uz", "\u00fasbekska" },
            { "kha", "kas\u00ed" },
            { "nds_NL", "l\u00e1gsaxneska" },
            { "ve", "venda" },
            { "vi", "v\u00edetnamska" },
            { "kho", "kotaska" },
            { "khq", "koyra chiini" },
            { "syc", "klass\u00edsk s\u00fdrlenska" },
            { "quc", "kiche" },
            { "gaa", "ga" },
            { "wa", "vall\u00f3nska" },
            { "gag", "gag\u00e1s" },
            { "syr", "s\u00fdrlenska" },
            { "Grek", "gr\u00edskt" },
            { "wo", "volof" },
            { "zgh", "sta\u00f0la\u00f0 marokk\u00f3skt tamazight" },
            { "ar_001", "st\u00f6\u00f0lu\u00f0 n\u00fat\u00edmaarab\u00edska" },
            { "gay", "gaj\u00f3" },
            { "Mong", "mong\u00f3lskt" },
            { "mnc", "mansj\u00fa" },
            { "gba", "gbaja" },
            { "mni", "man\u00edp\u00far\u00ed" },
            { "Latn", "latneskt" },
            { "xh", "s\u00f3sa" },
            { "byn", "bl\u00edn" },
            { "osa", "\u00f3sage" },
            { "moh", "m\u00f3h\u00edska" },
            { "yi", "jidd\u00edska" },
            { "mos", "moss\u00ed" },
            { "yo", "j\u00f3r\u00faba" },
            { "es_MX", "mex\u00edk\u00f3sk sp\u00e6nska" },
            { "ota", "tyrkneska, ott\u00f3man" },
            { "vai", "va\u00ed" },
            { "za", "s\u00faang" },
            { "kln", "kalenjin" },
            { "zh", "k\u00ednverska" },
            { "Bopo", "bopomofo" },
            { "zu", "s\u00fal\u00fa" },
            { "Geor", "georg\u00edskt" },
            { "kmb", "kimb\u00fand\u00fa" },
            { "gez", "g\u00eds" },
            { "ebu", "embu" },
            { "zh_Hans", "k\u00ednverska (einf\u00f6ldu\u00f0)" },
            { "koi", "k\u00f3m\u00ed-permyak" },
            { "kok", "konkan\u00ed" },
            { "kos", "kosraska" },
            { "zh_Hant", "k\u00ednverska (hef\u00f0bundin)" },
            { "kpe", "kpelle" },
            { "ilo", "\u00edlok\u00f3" },
            { "mua", "mundang" },
            { "mul", "margv\u00edsleg m\u00e1l" },
            { "cad", "kadd\u00f3" },
            { "mus", "kr\u00edk" },
            { "gil", "gilberska" },
            { "car", "kar\u00edbam\u00e1l" },
            { "krc", "karasa\u00edbalkar" },
            { "inh", "ing\u00fas" },
            { "efi", "ef\u00edk" },
            { "kru", "k\u00far\u00fak" },
            { "ksb", "sjambala" },
            { "Telu", metaValue_te },
            { "ksf", "baf\u00eda" },
        };
        return data;
    }
}
