/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.RootPaneContainer;
import org.netbeans.core.startup.ManifestSection;
import org.openide.actions.ActionManager;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.actions.SystemAction;

public class ModuleActions
extends ActionManager {
    private static SystemAction[] array;
    private static Map<Object, List<ManifestSection.ActionSection>> map;
    private static Object module;
    private Map<ActionEvent, Action> runningActions = new HashMap<ActionEvent, Action>();
    private static final Logger err;
    private static final Map<Object, Component> glassPaneUses;

    public static ModuleActions getDefaultInstance() {
        ActionManager actionManager = ActionManager.getDefault();
        assert (actionManager instanceof ModuleActions) : "Got wrong ActionManager instance: " + actionManager + " from " + Lookup.getDefault();
        return (ModuleActions)actionManager;
    }

    public SystemAction[] getContextActions() {
        SystemAction[] systemActionArray = array;
        if (systemActionArray != null) {
            return systemActionArray;
        }
        array = systemActionArray = ModuleActions.createActions();
        return systemActionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAction(Action action, final ActionEvent actionEvent) {
        try {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    ModuleActions.showWaitCursor(actionEvent);
                }
            });
            this.addRunningAction(action, actionEvent);
            action.actionPerformed(actionEvent);
            this.removeRunningAction(actionEvent);
        }
        catch (Throwable throwable) {
            this.removeRunningAction(actionEvent);
            Mutex.EVENT.readAccess(new Runnable(actionEvent){
                final /* synthetic */ ActionEvent val$e;
                {
                    this.val$e = actionEvent;
                }

                @Override
                public void run() {
                    ModuleActions.hideWaitCursor(this.val$e);
                }
            });
            throw throwable;
        }
        Mutex.EVENT.readAccess(new /* invalid duplicate definition of identical inner class */);
    }

    private void fireChange() {
        this.firePropertyChange("contextActions", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRunningAction(Action action, ActionEvent actionEvent) {
        Map<ActionEvent, Action> map = this.runningActions;
        synchronized (map) {
            this.runningActions.put(actionEvent, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRunningAction(ActionEvent actionEvent) {
        Map<ActionEvent, Action> map = this.runningActions;
        synchronized (map) {
            this.runningActions.remove(actionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Action> getRunningActions() {
        Map<ActionEvent, Action> map = this.runningActions;
        synchronized (map) {
            return new ArrayList<Action>(this.runningActions.values());
        }
    }

    public static synchronized void attachTo(Object object) {
        module = object;
    }

    public static synchronized void add(ManifestSection.ActionSection actionSection) {
        List<ManifestSection.ActionSection> list = map.get(module);
        if (list == null) {
            list = new ArrayList<ManifestSection.ActionSection>();
            map.put(module, list);
        }
        list.add(actionSection);
        array = null;
        ModuleActions.getDefaultInstance().fireChange();
    }

    public static synchronized void remove(ManifestSection.ActionSection actionSection) {
        List<ManifestSection.ActionSection> list = map.get(module);
        if (list == null) {
            return;
        }
        list.remove(actionSection);
        if (list.isEmpty()) {
            map.remove(module);
        }
        array = null;
        ModuleActions.getDefaultInstance().fireChange();
    }

    private static synchronized SystemAction[] createActions() {
        Iterator<List<ManifestSection.ActionSection>> iterator = map.values().iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>(map.size() * 5);
        while (iterator.hasNext()) {
            List<ManifestSection.ActionSection> list = iterator.next();
            for (ManifestSection.ActionSection actionSection : list) {
                try {
                    arrayList.add(actionSection.getInstance());
                }
                catch (Exception exception) {
                    Logger.getLogger(ModuleActions.class.getName()).log(Level.WARNING, null, exception);
                }
            }
            if (!iterator.hasNext()) continue;
            arrayList.add(null);
        }
        return arrayList.toArray(new SystemAction[arrayList.size()]);
    }

    private static Component activeGlassPane() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)window)).getGlassPane();
        }
        return null;
    }

    public static void showWaitCursor(Object object) {
        assert (EventQueue.isDispatchThread());
        assert (!glassPaneUses.containsKey(object));
        Component component = ModuleActions.activeGlassPane();
        if (component == null) {
            err.warning("showWaitCursor could not find a suitable glass pane; key=" + object);
            return;
        }
        if (glassPaneUses.values().contains(component)) {
            err.fine("wait cursor already displayed on " + component);
        } else {
            err.fine("wait cursor will be displayed on " + component);
            component.setCursor(Cursor.getPredefinedCursor(3));
            component.setVisible(true);
        }
        glassPaneUses.put(object, component);
    }

    public static void hideWaitCursor(Object object) {
        assert (EventQueue.isDispatchThread());
        Component component = glassPaneUses.get(object);
        if (component == null) {
            return;
        }
        glassPaneUses.remove(object);
        if (glassPaneUses.values().contains(component)) {
            err.fine("wait cursor still displayed on " + component);
        } else {
            err.fine("wait cursor will be hidden on " + component);
            component.setVisible(false);
            component.setCursor(null);
        }
    }

    static {
        map = new HashMap<Object, List<ManifestSection.ActionSection>>(8);
        module = null;
        err = Logger.getLogger("org.openide.util.actions.MouseCursorUtils");
        glassPaneUses = new HashMap<Object, Component>();
    }
}

