/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.wireprotocol.HeapHistogramResponse;

class HeapHistogramManager {
    private static final String BOOLEAN_TEXT = "boolean";
    private static final String CHAR_TEXT = "char";
    private static final String BYTE_TEXT = "byte";
    private static final String SHORT_TEXT = "short";
    private static final String INT_TEXT = "int";
    private static final String LONG_TEXT = "long";
    private static final String FLOAT_TEXT = "float";
    private static final String DOUBLE_TEXT = "double";
    private static final String VOID_TEXT = "void";
    private static final char BOOLEAN_CODE = 'Z';
    private static final char CHAR_CODE = 'C';
    private static final char BYTE_CODE = 'B';
    private static final char SHORT_CODE = 'S';
    private static final char INT_CODE = 'I';
    private static final char LONG_CODE = 'J';
    private static final char FLOAT_CODE = 'F';
    private static final char DOUBLE_CODE = 'D';
    private static final char OBJECT_CODE = 'L';
    private static final Map permGenNames = new HashMap();
    Map classesIdMap = new HashMap(8000);
    boolean isJrockitVM;

    HeapHistogramManager() {
        String string = System.getProperty("java.vm.name");
        if (string != null) {
            if ("BEA JRockit(R)".equals(string)) {
                this.isJrockitVM = true;
            } else if ("Oracle JRockit(R)".equals(string)) {
                this.isJrockitVM = true;
            }
        }
    }

    HeapHistogramResponse computeHistogram(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        HeapHistogramResponse heapHistogramResponse = this.isJrockitVM ? this.computeHistogramJRockit(inputStream) : this.computeHistogramImpl(inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("*** Profiler engine warning: " + this.getClass() + "cannot close InputStream");
        }
        return heapHistogramResponse;
    }

    private HeapHistogramResponse computeHistogramJRockit(InputStream inputStream) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        HashMap hashMap = new HashMap(1024);
        Date date = new Date();
        Scanner scanner = new Scanner(inputStream, "UTF-8");
        scanner.useRadix(10);
        scanner.nextLine();
        scanner.skip("-+");
        scanner.nextLine();
        while (scanner.hasNext("[0-9]+\\.[0-9]%")) {
            JRockitClassInfoImpl jRockitClassInfoImpl = new JRockitClassInfoImpl(scanner);
            if (ProfilerInterface.serverInternalClassName(jRockitClassInfoImpl.getName())) continue;
            HeapHistogramManager.storeClassInfo(jRockitClassInfoImpl, hashMap);
            l += jRockitClassInfoImpl.getBytes();
            l2 += jRockitClassInfoImpl.getInstancesCount();
        }
        l3 = l2;
        l4 = l;
        return this.getResponse(hashMap, date);
    }

    private HeapHistogramResponse computeHistogramImpl(InputStream inputStream) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        HashMap hashMap = new HashMap(1024);
        HashMap hashMap2 = new HashMap(1024);
        Date date = new Date();
        Scanner scanner = new Scanner(inputStream, "UTF-8");
        scanner.useRadix(10);
        scanner.nextLine();
        scanner.nextLine();
        scanner.skip("-+");
        scanner.nextLine();
        while (scanner.hasNext("[0-9]+:")) {
            ClassInfoImpl classInfoImpl = new ClassInfoImpl(scanner);
            if (ProfilerInterface.serverInternalClassName(classInfoImpl.getName())) continue;
            if (classInfoImpl.isPermGen()) {
                HeapHistogramManager.storeClassInfo(classInfoImpl, hashMap);
                l5 += classInfoImpl.getBytes();
                l6 += classInfoImpl.getInstancesCount();
                continue;
            }
            HeapHistogramManager.storeClassInfo(classInfoImpl, hashMap2);
            l3 += classInfoImpl.getBytes();
            l4 += classInfoImpl.getInstancesCount();
        }
        scanner.next("Total");
        l2 = scanner.nextLong();
        l = scanner.nextLong();
        return this.getResponse(hashMap2, date);
    }

    static void storeClassInfo(ClassInfoImpl classInfoImpl, Map map) {
        ClassInfoImpl classInfoImpl2 = (ClassInfoImpl)map.get(classInfoImpl.getName());
        if (classInfoImpl2 == null) {
            map.put(classInfoImpl.getName(), classInfoImpl);
        } else {
            classInfoImpl2.bytes += classInfoImpl.getBytes();
            classInfoImpl2.instances += classInfoImpl.getInstancesCount();
        }
    }

    private HeapHistogramResponse getResponse(Map map, Date date) {
        Object object;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(100);
        int[] nArray = new int[map.size()];
        long[] lArray = new long[map.size()];
        long[] lArray2 = new long[map.size()];
        int n = 0;
        Iterator<Object> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            object = (ClassInfoImpl)iterator.next();
            String string = ((ClassInfoImpl)object).getName();
            Integer n2 = (Integer)this.classesIdMap.get(string);
            if (n2 == null) {
                n2 = new Integer(this.classesIdMap.size());
                this.classesIdMap.put(string, n2);
                hashMap.put(string, n2);
            }
            nArray[n] = n2;
            lArray[n] = ((ClassInfoImpl)object).instances;
            lArray2[n] = ((ClassInfoImpl)object).bytes;
            ++n;
        }
        int[] nArray2 = new int[hashMap.size()];
        String[] stringArray = new String[hashMap.size()];
        n = 0;
        iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            nArray2[n] = (Integer)object.getValue();
            stringArray[n] = (String)object.getKey();
            ++n;
        }
        return new HeapHistogramResponse(date, stringArray, nArray2, nArray, lArray, lArray2);
    }

    static {
        permGenNames.put("<methodKlass>", "Read-Write Method Metadata");
        permGenNames.put("<constMethodKlass>", "Read-Only Method Metadata");
        permGenNames.put("<methodDataKlass>", "Method Profiling Information");
        permGenNames.put("<constantPoolKlass>", "Constant Pool Metadata");
        permGenNames.put("<constantPoolCacheKlass>", "Class Resolution Optimization Metadata");
        permGenNames.put("<symbolKlass>", "VM Symbol Metadata");
        permGenNames.put("<compiledICHolderKlass>", "Inline Cache Metadata");
        permGenNames.put("<instanceKlassKlass>", "Instance Class Metadata");
        permGenNames.put("<objArrayKlassKlass>", "Object Array Class Metadata");
        permGenNames.put("<typeArrayKlassKlass>", "Scalar Array Class Metadata");
        permGenNames.put("<klassKlass>", "Base Class Metadata");
        permGenNames.put("<arrayKlassKlass>", "Base Array Class Metadata");
    }

    static class JRockitClassInfoImpl
    extends ClassInfoImpl {
        JRockitClassInfoImpl(Scanner scanner) {
            scanner.next();
            this.bytes = this.computeBytes(scanner.next());
            this.instances = scanner.nextLong();
            scanner.next();
            String string = scanner.next();
            this.name = this.convertJVMName(string.replace('/', '.'));
        }

        private long computeBytes(String string) {
            String string2 = string.substring(string.length() - 1);
            long l = Long.parseLong(string.substring(0, string.length() - 1));
            if ("K".equalsIgnoreCase(string2)) {
                l *= 1024L;
            } else if ("M".equalsIgnoreCase(string2)) {
                l *= 0x100000L;
            } else if ("G".equalsIgnoreCase(string2)) {
                l *= 0x40000000L;
            }
            return l;
        }
    }

    static class ClassInfoImpl {
        long instances;
        long bytes;
        String name;
        boolean permGen;

        ClassInfoImpl() {
        }

        ClassInfoImpl(Scanner scanner) {
            scanner.next();
            this.instances = scanner.nextLong();
            this.bytes = scanner.nextLong();
            String string = scanner.next();
            this.permGen = string.charAt(0) == '<';
            this.name = this.convertJVMName(string);
        }

        public String getName() {
            return this.name;
        }

        public long getInstancesCount() {
            return this.instances;
        }

        public long getBytes() {
            return this.bytes;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ClassInfoImpl) {
                return this.getName().equals(((ClassInfoImpl)object).getName());
            }
            return false;
        }

        private boolean isPermGen() {
            return this.permGen;
        }

        String convertJVMName(String string) {
            String string2 = null;
            int n = string.lastIndexOf(91);
            if (n != -1) {
                switch (string.charAt(n + 1)) {
                    case 'Z': {
                        string2 = HeapHistogramManager.BOOLEAN_TEXT;
                        break;
                    }
                    case 'C': {
                        string2 = HeapHistogramManager.CHAR_TEXT;
                        break;
                    }
                    case 'B': {
                        string2 = HeapHistogramManager.BYTE_TEXT;
                        break;
                    }
                    case 'S': {
                        string2 = HeapHistogramManager.SHORT_TEXT;
                        break;
                    }
                    case 'I': {
                        string2 = HeapHistogramManager.INT_TEXT;
                        break;
                    }
                    case 'J': {
                        string2 = HeapHistogramManager.LONG_TEXT;
                        break;
                    }
                    case 'F': {
                        string2 = HeapHistogramManager.FLOAT_TEXT;
                        break;
                    }
                    case 'D': {
                        string2 = HeapHistogramManager.DOUBLE_TEXT;
                        break;
                    }
                    case 'L': {
                        string2 = string.substring(n + 2, string.length() - 1);
                        break;
                    }
                    default: {
                        System.err.println("Uknown name " + string);
                        string2 = string;
                    }
                }
                for (int i = 0; i <= n; ++i) {
                    string2 = string2 + "[]";
                }
            } else if (this.isPermGen()) {
                string2 = (String)permGenNames.get(string);
            }
            if (string2 == null) {
                string2 = string;
            }
            return string2;
        }
    }
}

