/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.tools.ico;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.jnlp.tools.ico.impl.ImageInputStreamIco;

public class IcoReader
extends ImageReader {
    ImageInputStreamIco cheat;

    private void loadIcon() {
        if (this.cheat == null) {
            try {
                if (this.input instanceof ImageInputStream) {
                    ImageInputStream iis = (ImageInputStream)this.input;
                    this.cheat = new ImageInputStreamIco(iis);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public IcoReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean isStreamable) {
        super.setInput(input, isStreamable);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IIOException {
        this.loadIcon();
        return this.cheat.getHeader().getCountOfIcons();
    }

    private void checkIndex(int imageIndex) {
        this.loadIcon();
        if (imageIndex < 0 || imageIndex >= this.cheat.getHeader().getCountOfIcons()) {
            throw new IndexOutOfBoundsException("bad index " + imageIndex + ". Should be >=0 and < " + this.cheat.getHeader().getCountOfIcons());
        }
    }

    @Override
    public int getWidth(int imageIndex) throws IIOException {
        this.checkIndex(imageIndex);
        return this.cheat.getHeader().getEntries().get(imageIndex).getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IIOException {
        this.checkIndex(imageIndex);
        return this.cheat.getHeader().getEntries().get(imageIndex).getHeight();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        Vector<RenderedImage> q = this.cheat.getImage(imageIndex).getSources();
        for (RenderedImage q1 : q) {
            l.add(new ImageTypeSpecifier(q1));
        }
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        return this.cheat.getImage(imageIndex);
    }
}

