/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.Objects;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.Utility;

public final class AnalyzerCaster {
    private Definition definition;

    public AnalyzerCaster(Definition definition) {
        this.definition = definition;
    }

    public Definition.Cast getLegalCast(Location location, Definition.Type actual, Definition.Type expected, boolean explicit, boolean internal) {
        Objects.requireNonNull(actual);
        Objects.requireNonNull(expected);
        if (actual.equals(expected)) {
            return null;
        }
        if (actual.dynamic) {
            if (expected.clazz == Boolean.TYPE) {
                return Definition.Cast.unboxTo(this.definition.DefType, this.definition.BooleanType, explicit, this.definition.booleanType);
            }
            if (expected.clazz == Byte.TYPE) {
                return Definition.Cast.unboxTo(this.definition.DefType, this.definition.ByteType, explicit, this.definition.byteType);
            }
            if (expected.clazz == Short.TYPE) {
                return Definition.Cast.unboxTo(this.definition.DefType, this.definition.ShortType, explicit, this.definition.shortType);
            }
            if (expected.clazz == Character.TYPE) {
                return Definition.Cast.unboxTo(this.definition.DefType, this.definition.CharacterType, explicit, this.definition.charType);
            }
            if (expected.clazz == Integer.TYPE) {
                return Definition.Cast.unboxTo(this.definition.DefType, this.definition.IntegerType, explicit, this.definition.intType);
            }
            if (expected.clazz == Long.TYPE) {
                return Definition.Cast.unboxTo(this.definition.DefType, this.definition.LongType, explicit, this.definition.longType);
            }
            if (expected.clazz == Float.TYPE) {
                return Definition.Cast.unboxTo(this.definition.DefType, this.definition.FloatType, explicit, this.definition.floatType);
            }
            if (expected.clazz == Double.TYPE) {
                return Definition.Cast.unboxTo(this.definition.DefType, this.definition.DoubleType, explicit, this.definition.doubleType);
            }
        } else if (actual.clazz == Object.class) {
            if (expected.clazz == Byte.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.ObjectType, this.definition.ByteType, true, this.definition.byteType);
            }
            if (expected.clazz == Short.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.ObjectType, this.definition.ShortType, true, this.definition.shortType);
            }
            if (expected.clazz == Character.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.ObjectType, this.definition.CharacterType, true, this.definition.charType);
            }
            if (expected.clazz == Integer.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.ObjectType, this.definition.IntegerType, true, this.definition.intType);
            }
            if (expected.clazz == Long.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.ObjectType, this.definition.LongType, true, this.definition.longType);
            }
            if (expected.clazz == Float.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.ObjectType, this.definition.FloatType, true, this.definition.floatType);
            }
            if (expected.clazz == Double.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.ObjectType, this.definition.DoubleType, true, this.definition.doubleType);
            }
        } else if (actual.clazz == Number.class) {
            if (expected.clazz == Byte.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.NumberType, this.definition.ByteType, true, this.definition.byteType);
            }
            if (expected.clazz == Short.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.NumberType, this.definition.ShortType, true, this.definition.shortType);
            }
            if (expected.clazz == Character.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.NumberType, this.definition.CharacterType, true, this.definition.charType);
            }
            if (expected.clazz == Integer.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.NumberType, this.definition.IntegerType, true, this.definition.intType);
            }
            if (expected.clazz == Long.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.NumberType, this.definition.LongType, true, this.definition.longType);
            }
            if (expected.clazz == Float.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.NumberType, this.definition.FloatType, true, this.definition.floatType);
            }
            if (expected.clazz == Double.TYPE && explicit && internal) {
                return Definition.Cast.unboxTo(this.definition.NumberType, this.definition.DoubleType, true, this.definition.doubleType);
            }
        } else if (actual.clazz == String.class) {
            if (expected.clazz == Character.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.StringType, this.definition.charType, true);
            }
        } else if (actual.clazz == Boolean.TYPE) {
            if (expected.dynamic) {
                return Definition.Cast.boxFrom(this.definition.BooleanType, this.definition.DefType, explicit, this.definition.booleanType);
            }
            if (expected.clazz == Object.class && internal) {
                return Definition.Cast.boxFrom(this.definition.BooleanType, this.definition.ObjectType, explicit, this.definition.booleanType);
            }
            if (expected.clazz == Boolean.class && internal) {
                return Definition.Cast.boxTo(this.definition.booleanType, this.definition.booleanType, explicit, this.definition.booleanType);
            }
        } else if (actual.clazz == Byte.TYPE) {
            if (expected.dynamic) {
                return Definition.Cast.boxFrom(this.definition.ByteType, this.definition.DefType, explicit, this.definition.byteType);
            }
            if (expected.clazz == Object.class && internal) {
                return Definition.Cast.boxFrom(this.definition.ByteType, this.definition.ObjectType, explicit, this.definition.byteType);
            }
            if (expected.clazz == Number.class && internal) {
                return Definition.Cast.boxFrom(this.definition.ByteType, this.definition.NumberType, explicit, this.definition.byteType);
            }
            if (expected.clazz == Short.TYPE) {
                return Definition.Cast.standard(this.definition.byteType, this.definition.shortType, explicit);
            }
            if (expected.clazz == Character.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.byteType, this.definition.charType, true);
            }
            if (expected.clazz == Integer.TYPE) {
                return Definition.Cast.standard(this.definition.byteType, this.definition.intType, explicit);
            }
            if (expected.clazz == Long.TYPE) {
                return Definition.Cast.standard(this.definition.byteType, this.definition.longType, explicit);
            }
            if (expected.clazz == Float.TYPE) {
                return Definition.Cast.standard(this.definition.byteType, this.definition.floatType, explicit);
            }
            if (expected.clazz == Double.TYPE) {
                return Definition.Cast.standard(this.definition.byteType, this.definition.doubleType, explicit);
            }
            if (expected.clazz == Byte.class && internal) {
                return Definition.Cast.boxTo(this.definition.byteType, this.definition.byteType, explicit, this.definition.byteType);
            }
            if (expected.clazz == Short.class && internal) {
                return Definition.Cast.boxTo(this.definition.byteType, this.definition.shortType, explicit, this.definition.shortType);
            }
            if (expected.clazz == Character.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.byteType, this.definition.charType, true, this.definition.charType);
            }
            if (expected.clazz == Integer.class && internal) {
                return Definition.Cast.boxTo(this.definition.byteType, this.definition.intType, explicit, this.definition.intType);
            }
            if (expected.clazz == Long.class && internal) {
                return Definition.Cast.boxTo(this.definition.byteType, this.definition.longType, explicit, this.definition.longType);
            }
            if (expected.clazz == Float.class && internal) {
                return Definition.Cast.boxTo(this.definition.byteType, this.definition.floatType, explicit, this.definition.floatType);
            }
            if (expected.clazz == Double.class && internal) {
                return Definition.Cast.boxTo(this.definition.byteType, this.definition.doubleType, explicit, this.definition.doubleType);
            }
        } else if (actual.clazz == Short.TYPE) {
            if (expected.dynamic) {
                return Definition.Cast.boxFrom(this.definition.ShortType, this.definition.DefType, explicit, this.definition.shortType);
            }
            if (expected.clazz == Object.class && internal) {
                return Definition.Cast.boxFrom(this.definition.ShortType, this.definition.ObjectType, explicit, this.definition.shortType);
            }
            if (expected.clazz == Number.class && internal) {
                return Definition.Cast.boxFrom(this.definition.ShortType, this.definition.NumberType, explicit, this.definition.shortType);
            }
            if (expected.clazz == Byte.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.shortType, this.definition.byteType, true);
            }
            if (expected.clazz == Character.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.shortType, this.definition.charType, true);
            }
            if (expected.clazz == Integer.TYPE) {
                return Definition.Cast.standard(this.definition.shortType, this.definition.intType, explicit);
            }
            if (expected.clazz == Long.TYPE) {
                return Definition.Cast.standard(this.definition.shortType, this.definition.longType, explicit);
            }
            if (expected.clazz == Float.TYPE) {
                return Definition.Cast.standard(this.definition.shortType, this.definition.floatType, explicit);
            }
            if (expected.clazz == Double.TYPE) {
                return Definition.Cast.standard(this.definition.shortType, this.definition.doubleType, explicit);
            }
            if (expected.clazz == Byte.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.shortType, this.definition.byteType, true, this.definition.byteType);
            }
            if (expected.clazz == Short.class && internal) {
                return Definition.Cast.boxTo(this.definition.shortType, this.definition.shortType, explicit, this.definition.shortType);
            }
            if (expected.clazz == Character.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.shortType, this.definition.charType, true, this.definition.charType);
            }
            if (expected.clazz == Integer.class && internal) {
                return Definition.Cast.boxTo(this.definition.shortType, this.definition.intType, explicit, this.definition.intType);
            }
            if (expected.clazz == Long.class && internal) {
                return Definition.Cast.boxTo(this.definition.shortType, this.definition.longType, explicit, this.definition.longType);
            }
            if (expected.clazz == Float.class && internal) {
                return Definition.Cast.boxTo(this.definition.shortType, this.definition.floatType, explicit, this.definition.floatType);
            }
            if (expected.clazz == Double.class && internal) {
                return Definition.Cast.boxTo(this.definition.shortType, this.definition.doubleType, explicit, this.definition.doubleType);
            }
        } else if (actual.clazz == Character.TYPE) {
            if (expected.dynamic) {
                return Definition.Cast.boxFrom(this.definition.CharacterType, this.definition.DefType, explicit, this.definition.charType);
            }
            if (expected.clazz == Object.class && internal) {
                return Definition.Cast.boxFrom(this.definition.CharacterType, this.definition.ObjectType, explicit, this.definition.charType);
            }
            if (expected.clazz == Number.class && internal) {
                return Definition.Cast.boxFrom(this.definition.CharacterType, this.definition.NumberType, explicit, this.definition.charType);
            }
            if (expected.clazz == String.class) {
                return Definition.Cast.standard(this.definition.charType, this.definition.StringType, explicit);
            }
            if (expected.clazz == Byte.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.charType, this.definition.byteType, true);
            }
            if (expected.clazz == Short.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.charType, this.definition.shortType, true);
            }
            if (expected.clazz == Integer.TYPE) {
                return Definition.Cast.standard(this.definition.charType, this.definition.intType, explicit);
            }
            if (expected.clazz == Long.TYPE) {
                return Definition.Cast.standard(this.definition.charType, this.definition.longType, explicit);
            }
            if (expected.clazz == Float.TYPE) {
                return Definition.Cast.standard(this.definition.charType, this.definition.floatType, explicit);
            }
            if (expected.clazz == Double.TYPE) {
                return Definition.Cast.standard(this.definition.charType, this.definition.doubleType, explicit);
            }
            if (expected.clazz == Byte.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.charType, this.definition.byteType, true, this.definition.byteType);
            }
            if (expected.clazz == Short.class && internal) {
                return Definition.Cast.boxTo(this.definition.charType, this.definition.shortType, explicit, this.definition.shortType);
            }
            if (expected.clazz == Character.class && internal) {
                return Definition.Cast.boxTo(this.definition.charType, this.definition.charType, true, this.definition.charType);
            }
            if (expected.clazz == Integer.class && internal) {
                return Definition.Cast.boxTo(this.definition.charType, this.definition.intType, explicit, this.definition.intType);
            }
            if (expected.clazz == Long.class && internal) {
                return Definition.Cast.boxTo(this.definition.charType, this.definition.longType, explicit, this.definition.longType);
            }
            if (expected.clazz == Float.class && internal) {
                return Definition.Cast.boxTo(this.definition.charType, this.definition.floatType, explicit, this.definition.floatType);
            }
            if (expected.clazz == Double.class && internal) {
                return Definition.Cast.boxTo(this.definition.charType, this.definition.doubleType, explicit, this.definition.doubleType);
            }
        } else if (actual.clazz == Integer.TYPE) {
            if (expected.dynamic) {
                return Definition.Cast.boxFrom(this.definition.IntegerType, this.definition.DefType, explicit, this.definition.intType);
            }
            if (expected.clazz == Object.class && internal) {
                return Definition.Cast.boxFrom(this.definition.IntegerType, this.definition.ObjectType, explicit, this.definition.intType);
            }
            if (expected.clazz == Number.class && internal) {
                return Definition.Cast.boxFrom(this.definition.IntegerType, this.definition.NumberType, explicit, this.definition.intType);
            }
            if (expected.clazz == Byte.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.intType, this.definition.byteType, true);
            }
            if (expected.clazz == Character.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.intType, this.definition.charType, true);
            }
            if (expected.clazz == Short.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.intType, this.definition.shortType, true);
            }
            if (expected.clazz == Long.TYPE) {
                return Definition.Cast.standard(this.definition.intType, this.definition.longType, explicit);
            }
            if (expected.clazz == Float.TYPE) {
                return Definition.Cast.standard(this.definition.intType, this.definition.floatType, explicit);
            }
            if (expected.clazz == Double.TYPE) {
                return Definition.Cast.standard(this.definition.intType, this.definition.doubleType, explicit);
            }
            if (expected.clazz == Byte.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.intType, this.definition.byteType, true, this.definition.byteType);
            }
            if (expected.clazz == Short.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.intType, this.definition.shortType, true, this.definition.shortType);
            }
            if (expected.clazz == Character.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.intType, this.definition.charType, true, this.definition.charType);
            }
            if (expected.clazz == Integer.class && internal) {
                return Definition.Cast.boxTo(this.definition.intType, this.definition.intType, explicit, this.definition.intType);
            }
            if (expected.clazz == Long.class && internal) {
                return Definition.Cast.boxTo(this.definition.intType, this.definition.longType, explicit, this.definition.longType);
            }
            if (expected.clazz == Float.class && internal) {
                return Definition.Cast.boxTo(this.definition.intType, this.definition.floatType, explicit, this.definition.floatType);
            }
            if (expected.clazz == Double.class && internal) {
                return Definition.Cast.boxTo(this.definition.intType, this.definition.doubleType, explicit, this.definition.doubleType);
            }
        } else if (actual.clazz == Long.TYPE) {
            if (expected.dynamic) {
                return Definition.Cast.boxFrom(this.definition.LongType, this.definition.DefType, explicit, this.definition.longType);
            }
            if (expected.clazz == Object.class && internal) {
                return Definition.Cast.boxFrom(this.definition.LongType, this.definition.ObjectType, explicit, this.definition.longType);
            }
            if (expected.clazz == Number.class && internal) {
                return Definition.Cast.boxFrom(this.definition.LongType, this.definition.NumberType, explicit, this.definition.longType);
            }
            if (expected.clazz == Byte.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.longType, this.definition.byteType, true);
            }
            if (expected.clazz == Character.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.longType, this.definition.charType, true);
            }
            if (expected.clazz == Short.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.longType, this.definition.shortType, true);
            }
            if (expected.clazz == Integer.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.longType, this.definition.intType, true);
            }
            if (expected.clazz == Float.TYPE) {
                return Definition.Cast.standard(this.definition.longType, this.definition.floatType, explicit);
            }
            if (expected.clazz == Double.TYPE) {
                return Definition.Cast.standard(this.definition.longType, this.definition.doubleType, explicit);
            }
            if (expected.clazz == Byte.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.longType, this.definition.byteType, true, this.definition.byteType);
            }
            if (expected.clazz == Short.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.longType, this.definition.shortType, true, this.definition.shortType);
            }
            if (expected.clazz == Character.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.longType, this.definition.charType, true, this.definition.charType);
            }
            if (expected.clazz == Integer.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.longType, this.definition.intType, true, this.definition.intType);
            }
            if (expected.clazz == Long.class && internal) {
                return Definition.Cast.boxTo(this.definition.longType, this.definition.longType, explicit, this.definition.longType);
            }
            if (expected.clazz == Float.class && internal) {
                return Definition.Cast.boxTo(this.definition.longType, this.definition.floatType, explicit, this.definition.floatType);
            }
            if (expected.clazz == Double.class && internal) {
                return Definition.Cast.boxTo(this.definition.longType, this.definition.doubleType, explicit, this.definition.doubleType);
            }
        } else if (actual.clazz == Float.TYPE) {
            if (expected.dynamic) {
                return Definition.Cast.boxFrom(this.definition.FloatType, this.definition.DefType, explicit, this.definition.floatType);
            }
            if (expected.clazz == Object.class && internal) {
                return Definition.Cast.boxFrom(this.definition.FloatType, this.definition.ObjectType, explicit, this.definition.floatType);
            }
            if (expected.clazz == Number.class && internal) {
                return Definition.Cast.boxFrom(this.definition.FloatType, this.definition.NumberType, explicit, this.definition.floatType);
            }
            if (expected.clazz == Byte.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.floatType, this.definition.byteType, true);
            }
            if (expected.clazz == Character.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.floatType, this.definition.charType, true);
            }
            if (expected.clazz == Short.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.floatType, this.definition.shortType, true);
            }
            if (expected.clazz == Integer.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.floatType, this.definition.intType, true);
            }
            if (expected.clazz == Long.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.floatType, this.definition.longType, true);
            }
            if (expected.clazz == Double.TYPE) {
                return Definition.Cast.standard(this.definition.floatType, this.definition.doubleType, explicit);
            }
            if (expected.clazz == Byte.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.floatType, this.definition.byteType, true, this.definition.byteType);
            }
            if (expected.clazz == Short.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.floatType, this.definition.shortType, true, this.definition.shortType);
            }
            if (expected.clazz == Character.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.floatType, this.definition.charType, true, this.definition.charType);
            }
            if (expected.clazz == Integer.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.floatType, this.definition.intType, true, this.definition.intType);
            }
            if (expected.clazz == Long.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.floatType, this.definition.longType, true, this.definition.longType);
            }
            if (expected.clazz == Float.class && internal) {
                return Definition.Cast.boxTo(this.definition.floatType, this.definition.floatType, explicit, this.definition.floatType);
            }
            if (expected.clazz == Double.class && internal) {
                return Definition.Cast.boxTo(this.definition.floatType, this.definition.doubleType, explicit, this.definition.doubleType);
            }
        } else if (actual.clazz == Double.TYPE) {
            if (expected.dynamic) {
                return Definition.Cast.boxFrom(this.definition.DoubleType, this.definition.DefType, explicit, this.definition.doubleType);
            }
            if (expected.clazz == Object.class && internal) {
                return Definition.Cast.boxFrom(this.definition.DoubleType, this.definition.ObjectType, explicit, this.definition.doubleType);
            }
            if (expected.clazz == Number.class && internal) {
                return Definition.Cast.boxFrom(this.definition.DoubleType, this.definition.NumberType, explicit, this.definition.doubleType);
            }
            if (expected.clazz == Byte.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.doubleType, this.definition.byteType, true);
            }
            if (expected.clazz == Character.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.doubleType, this.definition.charType, true);
            }
            if (expected.clazz == Short.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.doubleType, this.definition.shortType, true);
            }
            if (expected.clazz == Integer.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.doubleType, this.definition.intType, true);
            }
            if (expected.clazz == Long.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.doubleType, this.definition.longType, true);
            }
            if (expected.clazz == Float.TYPE && explicit) {
                return Definition.Cast.standard(this.definition.doubleType, this.definition.floatType, true);
            }
            if (expected.clazz == Byte.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.doubleType, this.definition.byteType, true, this.definition.byteType);
            }
            if (expected.clazz == Short.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.doubleType, this.definition.shortType, true, this.definition.shortType);
            }
            if (expected.clazz == Character.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.doubleType, this.definition.charType, true, this.definition.charType);
            }
            if (expected.clazz == Integer.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.doubleType, this.definition.intType, true, this.definition.intType);
            }
            if (expected.clazz == Long.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.doubleType, this.definition.longType, true, this.definition.longType);
            }
            if (expected.clazz == Float.class && explicit && internal) {
                return Definition.Cast.boxTo(this.definition.doubleType, this.definition.floatType, true, this.definition.floatType);
            }
            if (expected.clazz == Double.class && internal) {
                return Definition.Cast.boxTo(this.definition.doubleType, this.definition.doubleType, explicit, this.definition.doubleType);
            }
        } else if (actual.clazz == Boolean.class) {
            if (expected.clazz == Boolean.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.booleanType, this.definition.booleanType, explicit, this.definition.booleanType);
            }
        } else if (actual.clazz == Byte.class) {
            if (expected.clazz == Byte.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.byteType, this.definition.byteType, explicit, this.definition.byteType);
            }
            if (expected.clazz == Short.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.byteType, this.definition.shortType, explicit, this.definition.byteType);
            }
            if (expected.clazz == Character.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.byteType, this.definition.charType, true, this.definition.byteType);
            }
            if (expected.clazz == Integer.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.byteType, this.definition.intType, explicit, this.definition.byteType);
            }
            if (expected.clazz == Long.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.byteType, this.definition.longType, explicit, this.definition.byteType);
            }
            if (expected.clazz == Float.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.byteType, this.definition.floatType, explicit, this.definition.byteType);
            }
            if (expected.clazz == Double.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.byteType, this.definition.doubleType, explicit, this.definition.byteType);
            }
        } else if (actual.clazz == Short.class) {
            if (expected.clazz == Byte.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.shortType, this.definition.byteType, true, this.definition.shortType);
            }
            if (expected.clazz == Short.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.shortType, this.definition.shortType, explicit, this.definition.shortType);
            }
            if (expected.clazz == Character.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.shortType, this.definition.charType, true, this.definition.shortType);
            }
            if (expected.clazz == Integer.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.shortType, this.definition.intType, explicit, this.definition.shortType);
            }
            if (expected.clazz == Long.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.shortType, this.definition.longType, explicit, this.definition.shortType);
            }
            if (expected.clazz == Float.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.shortType, this.definition.floatType, explicit, this.definition.shortType);
            }
            if (expected.clazz == Double.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.shortType, this.definition.doubleType, explicit, this.definition.shortType);
            }
        } else if (actual.clazz == Character.class) {
            if (expected.clazz == Byte.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.charType, this.definition.byteType, true, this.definition.charType);
            }
            if (expected.clazz == Short.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.charType, this.definition.shortType, true, this.definition.charType);
            }
            if (expected.clazz == Character.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.charType, this.definition.charType, explicit, this.definition.charType);
            }
            if (expected.clazz == Integer.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.charType, this.definition.intType, explicit, this.definition.charType);
            }
            if (expected.clazz == Long.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.charType, this.definition.longType, explicit, this.definition.charType);
            }
            if (expected.clazz == Float.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.charType, this.definition.floatType, explicit, this.definition.charType);
            }
            if (expected.clazz == Double.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.charType, this.definition.doubleType, explicit, this.definition.charType);
            }
        } else if (actual.clazz == Integer.class) {
            if (expected.clazz == Byte.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.intType, this.definition.byteType, true, this.definition.intType);
            }
            if (expected.clazz == Short.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.intType, this.definition.shortType, true, this.definition.intType);
            }
            if (expected.clazz == Character.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.intType, this.definition.charType, true, this.definition.intType);
            }
            if (expected.clazz == Integer.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.intType, this.definition.intType, explicit, this.definition.intType);
            }
            if (expected.clazz == Long.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.intType, this.definition.longType, explicit, this.definition.intType);
            }
            if (expected.clazz == Float.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.intType, this.definition.floatType, explicit, this.definition.intType);
            }
            if (expected.clazz == Double.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.intType, this.definition.doubleType, explicit, this.definition.intType);
            }
        } else if (actual.clazz == Long.class) {
            if (expected.clazz == Byte.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.longType, this.definition.byteType, true, this.definition.longType);
            }
            if (expected.clazz == Short.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.longType, this.definition.shortType, true, this.definition.longType);
            }
            if (expected.clazz == Character.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.longType, this.definition.charType, true, this.definition.longType);
            }
            if (expected.clazz == Integer.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.longType, this.definition.intType, true, this.definition.longType);
            }
            if (expected.clazz == Long.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.longType, this.definition.longType, explicit, this.definition.longType);
            }
            if (expected.clazz == Float.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.longType, this.definition.floatType, explicit, this.definition.longType);
            }
            if (expected.clazz == Double.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.longType, this.definition.doubleType, explicit, this.definition.longType);
            }
        } else if (actual.clazz == Float.class) {
            if (expected.clazz == Byte.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.floatType, this.definition.byteType, true, this.definition.floatType);
            }
            if (expected.clazz == Short.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.floatType, this.definition.shortType, true, this.definition.floatType);
            }
            if (expected.clazz == Character.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.floatType, this.definition.charType, true, this.definition.floatType);
            }
            if (expected.clazz == Integer.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.floatType, this.definition.intType, true, this.definition.floatType);
            }
            if (expected.clazz == Long.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.floatType, this.definition.longType, true, this.definition.floatType);
            }
            if (expected.clazz == Float.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.floatType, this.definition.floatType, explicit, this.definition.floatType);
            }
            if (expected.clazz == Double.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.floatType, this.definition.doubleType, explicit, this.definition.floatType);
            }
        } else if (actual.clazz == Double.class) {
            if (expected.clazz == Byte.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.doubleType, this.definition.byteType, true, this.definition.doubleType);
            }
            if (expected.clazz == Short.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.doubleType, this.definition.shortType, true, this.definition.doubleType);
            }
            if (expected.clazz == Character.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.doubleType, this.definition.charType, true, this.definition.doubleType);
            }
            if (expected.clazz == Integer.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.doubleType, this.definition.intType, true, this.definition.doubleType);
            }
            if (expected.clazz == Long.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.doubleType, this.definition.longType, true, this.definition.doubleType);
            }
            if (expected.clazz == Float.TYPE && explicit && internal) {
                return Definition.Cast.unboxFrom(this.definition.doubleType, this.definition.floatType, true, this.definition.doubleType);
            }
            if (expected.clazz == Double.TYPE && internal) {
                return Definition.Cast.unboxFrom(this.definition.doubleType, this.definition.doubleType, explicit, this.definition.doubleType);
            }
        }
        if (actual.dynamic || actual.clazz != Void.TYPE && expected.dynamic || expected.clazz.isAssignableFrom(actual.clazz) || actual.clazz.isAssignableFrom(expected.clazz) && explicit) {
            return Definition.Cast.standard(actual, expected, explicit);
        }
        throw location.createError(new ClassCastException("Cannot cast from [" + actual.name + "] to [" + expected.name + "]."));
    }

    public Object constCast(Location location, Object constant, Definition.Cast cast) {
        Class<?> fsort = cast.from.clazz;
        Class<?> tsort = cast.to.clazz;
        if (fsort == tsort) {
            return constant;
        }
        if (fsort == String.class && tsort == Character.TYPE) {
            return Character.valueOf(Utility.StringTochar((String)constant));
        }
        if (fsort == Character.TYPE && tsort == String.class) {
            return Utility.charToString(((Character)constant).charValue());
        }
        if (fsort.isPrimitive() && fsort != Boolean.TYPE && tsort.isPrimitive() && tsort != Boolean.TYPE) {
            Number number = fsort == Character.TYPE ? (Number)Integer.valueOf(((Character)constant).charValue()) : (Number)((Number)constant);
            if (tsort == Byte.TYPE) {
                return number.byteValue();
            }
            if (tsort == Short.TYPE) {
                return number.shortValue();
            }
            if (tsort == Character.TYPE) {
                return Character.valueOf((char)number.intValue());
            }
            if (tsort == Integer.TYPE) {
                return number.intValue();
            }
            if (tsort == Long.TYPE) {
                return number.longValue();
            }
            if (tsort == Float.TYPE) {
                return Float.valueOf(number.floatValue());
            }
            if (tsort == Double.TYPE) {
                return number.doubleValue();
            }
            throw location.createError(new IllegalStateException("Cannot cast from [" + cast.from.clazz.getCanonicalName() + "] to [" + cast.to.clazz.getCanonicalName() + "]."));
        }
        throw location.createError(new IllegalStateException("Cannot cast from [" + cast.from.clazz.getCanonicalName() + "] to [" + cast.to.clazz.getCanonicalName() + "]."));
    }

    public Definition.Type promoteNumeric(Definition.Type from, boolean decimal) {
        Class<?> sort = from.clazz;
        if (from.dynamic) {
            return this.definition.DefType;
        }
        if (sort == Double.TYPE && decimal) {
            return this.definition.doubleType;
        }
        if (sort == Float.TYPE && decimal) {
            return this.definition.floatType;
        }
        if (sort == Long.TYPE) {
            return this.definition.longType;
        }
        if (sort == Integer.TYPE || sort == Character.TYPE || sort == Short.TYPE || sort == Byte.TYPE) {
            return this.definition.intType;
        }
        return null;
    }

    public Definition.Type promoteNumeric(Definition.Type from0, Definition.Type from1, boolean decimal) {
        Class<?> sort0 = from0.clazz;
        Class<?> sort1 = from1.clazz;
        if (from0.dynamic || from1.dynamic) {
            return this.definition.DefType;
        }
        if (decimal) {
            if (sort0 == Double.TYPE || sort1 == Double.TYPE) {
                return this.definition.doubleType;
            }
            if (sort0 == Float.TYPE || sort1 == Float.TYPE) {
                return this.definition.floatType;
            }
        }
        if (sort0 == Long.TYPE || sort1 == Long.TYPE) {
            return this.definition.longType;
        }
        if (sort0 == Integer.TYPE || sort1 == Integer.TYPE || sort0 == Character.TYPE || sort1 == Character.TYPE || sort0 == Short.TYPE || sort1 == Short.TYPE || sort0 == Byte.TYPE || sort1 == Byte.TYPE) {
            return this.definition.intType;
        }
        return null;
    }

    public Definition.Type promoteAdd(Definition.Type from0, Definition.Type from1) {
        Class<?> sort0 = from0.clazz;
        Class<?> sort1 = from1.clazz;
        if (sort0 == String.class || sort1 == String.class) {
            return this.definition.StringType;
        }
        return this.promoteNumeric(from0, from1, true);
    }

    public Definition.Type promoteXor(Definition.Type from0, Definition.Type from1) {
        Class<?> sort0 = from0.clazz;
        Class<?> sort1 = from1.clazz;
        if (from0.dynamic || from1.dynamic) {
            return this.definition.DefType;
        }
        if (sort0 == Boolean.TYPE || sort1 == Boolean.TYPE) {
            return this.definition.booleanType;
        }
        return this.promoteNumeric(from0, from1, false);
    }

    public Definition.Type promoteEquality(Definition.Type from0, Definition.Type from1) {
        Class<?> sort0 = from0.clazz;
        Class<?> sort1 = from1.clazz;
        if (from0.dynamic || from1.dynamic) {
            return this.definition.DefType;
        }
        if (sort0.isPrimitive() && sort1.isPrimitive()) {
            if (sort0 == Boolean.TYPE && sort1 == Boolean.TYPE) {
                return this.definition.booleanType;
            }
            return this.promoteNumeric(from0, from1, true);
        }
        return this.definition.ObjectType;
    }

    public Definition.Type promoteConditional(Definition.Type from0, Definition.Type from1, Object const0, Object const1) {
        if (from0.equals(from1)) {
            return from0;
        }
        Class<?> sort0 = from0.clazz;
        Class<?> sort1 = from1.clazz;
        if (from0.dynamic || from1.dynamic) {
            return this.definition.DefType;
        }
        if (sort0.isPrimitive() && sort1.isPrimitive()) {
            if (sort0 == Boolean.TYPE && sort1 == Boolean.TYPE) {
                return this.definition.booleanType;
            }
            if (sort0 == Double.TYPE || sort1 == Double.TYPE) {
                return this.definition.doubleType;
            }
            if (sort0 == Float.TYPE || sort1 == Float.TYPE) {
                return this.definition.floatType;
            }
            if (sort0 == Long.TYPE || sort1 == Long.TYPE) {
                return this.definition.longType;
            }
            if (sort0 == Byte.TYPE) {
                if (sort1 == Byte.TYPE) {
                    return this.definition.byteType;
                }
                if (sort1 == Short.TYPE) {
                    short constant;
                    if (const1 != null && (constant = ((Short)const1).shortValue()) <= 127 && constant >= -128) {
                        return this.definition.byteType;
                    }
                    return this.definition.shortType;
                }
                if (sort1 == Character.TYPE) {
                    return this.definition.intType;
                }
                if (sort1 == Integer.TYPE) {
                    int constant;
                    if (const1 != null && (constant = ((Integer)const1).intValue()) <= 127 && constant >= -128) {
                        return this.definition.byteType;
                    }
                    return this.definition.intType;
                }
            } else if (sort0 == Short.TYPE) {
                if (sort1 == Byte.TYPE) {
                    short constant;
                    if (const0 != null && (constant = ((Short)const0).shortValue()) <= 127 && constant >= -128) {
                        return this.definition.byteType;
                    }
                    return this.definition.shortType;
                }
                if (sort1 == Short.TYPE) {
                    return this.definition.shortType;
                }
                if (sort1 == Character.TYPE) {
                    return this.definition.intType;
                }
                if (sort1 == Integer.TYPE) {
                    int constant;
                    if (const1 != null && (constant = ((Integer)const1).intValue()) <= Short.MAX_VALUE && constant >= Short.MIN_VALUE) {
                        return this.definition.shortType;
                    }
                    return this.definition.intType;
                }
            } else if (sort0 == Character.TYPE) {
                if (sort1 == Byte.TYPE) {
                    return this.definition.intType;
                }
                if (sort1 == Short.TYPE) {
                    return this.definition.intType;
                }
                if (sort1 == Character.TYPE) {
                    return this.definition.charType;
                }
                if (sort1 == Integer.TYPE) {
                    int constant;
                    if (const1 != null && (constant = ((Integer)const1).intValue()) <= 65535 && constant >= 0) {
                        return this.definition.byteType;
                    }
                    return this.definition.intType;
                }
            } else if (sort0 == Integer.TYPE) {
                if (sort1 == Byte.TYPE) {
                    int constant;
                    if (const0 != null && (constant = ((Integer)const0).intValue()) <= 127 && constant >= -128) {
                        return this.definition.byteType;
                    }
                    return this.definition.intType;
                }
                if (sort1 == Short.TYPE) {
                    int constant;
                    if (const0 != null && (constant = ((Integer)const0).intValue()) <= Short.MAX_VALUE && constant >= Short.MIN_VALUE) {
                        return this.definition.byteType;
                    }
                    return this.definition.intType;
                }
                if (sort1 == Character.TYPE) {
                    int constant;
                    if (const0 != null && (constant = ((Integer)const0).intValue()) <= 65535 && constant >= 0) {
                        return this.definition.byteType;
                    }
                    return this.definition.intType;
                }
                if (sort1 == Integer.TYPE) {
                    return this.definition.intType;
                }
            }
        }
        return this.definition.ObjectType;
    }
}

