/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.analyzing;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;

public class AnalyzingInfixSuggester
extends Lookup
implements Closeable {
    protected static final String TEXTGRAMS_FIELD_NAME = "textgrams";
    protected static final String TEXT_FIELD_NAME = "text";
    protected static final String EXACT_TEXT_FIELD_NAME = "exacttext";
    protected static final String CONTEXTS_FIELD_NAME = "contexts";
    protected final Analyzer queryAnalyzer;
    protected final Analyzer indexAnalyzer;
    private final Directory dir;
    final int minPrefixChars;
    private final boolean allTermsRequired;
    private final boolean highlight;
    private final boolean commitOnBuild;
    private final boolean closeIndexWriterOnBuild;
    protected IndexWriter writer;
    protected SearcherManager searcherMgr;
    protected final Object searcherMgrLock = new Object();
    public static final int DEFAULT_MIN_PREFIX_CHARS = 4;
    public static final boolean DEFAULT_ALL_TERMS_REQUIRED = true;
    public static final boolean DEFAULT_HIGHLIGHT = true;
    protected static final boolean DEFAULT_CLOSE_INDEXWRITER_ON_BUILD = true;
    private static final Sort SORT = new Sort(new SortField("weight", SortField.Type.LONG, true));

    public AnalyzingInfixSuggester(Directory dir, Analyzer analyzer) throws IOException {
        this(dir, analyzer, analyzer, 4, false, true, true);
    }

    public AnalyzingInfixSuggester(Directory dir, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int minPrefixChars, boolean commitOnBuild) throws IOException {
        this(dir, indexAnalyzer, queryAnalyzer, minPrefixChars, commitOnBuild, true, true);
    }

    public AnalyzingInfixSuggester(Directory dir, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int minPrefixChars, boolean commitOnBuild, boolean allTermsRequired, boolean highlight) throws IOException {
        this(dir, indexAnalyzer, queryAnalyzer, minPrefixChars, commitOnBuild, allTermsRequired, highlight, true);
    }

    public AnalyzingInfixSuggester(Directory dir, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int minPrefixChars, boolean commitOnBuild, boolean allTermsRequired, boolean highlight, boolean closeIndexWriterOnBuild) throws IOException {
        if (minPrefixChars < 0) {
            throw new IllegalArgumentException("minPrefixChars must be >= 0; got: " + minPrefixChars);
        }
        this.queryAnalyzer = queryAnalyzer;
        this.indexAnalyzer = indexAnalyzer;
        this.dir = dir;
        this.minPrefixChars = minPrefixChars;
        this.commitOnBuild = commitOnBuild;
        this.allTermsRequired = allTermsRequired;
        this.highlight = highlight;
        this.closeIndexWriterOnBuild = closeIndexWriterOnBuild;
        if (DirectoryReader.indexExists((Directory)dir)) {
            this.searcherMgr = new SearcherManager(dir, null);
        }
    }

    protected IndexWriterConfig getIndexWriterConfig(Analyzer indexAnalyzer, IndexWriterConfig.OpenMode openMode) {
        IndexWriterConfig iwc = new IndexWriterConfig(indexAnalyzer);
        iwc.setOpenMode(openMode);
        iwc.setIndexSort(SORT);
        return iwc;
    }

    protected Directory getDirectory(Path path) throws IOException {
        return FSDirectory.open((Path)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(InputIterator iter) throws IOException {
        Object object = this.searcherMgrLock;
        synchronized (object) {
            if (this.searcherMgr != null) {
                this.searcherMgr.close();
                this.searcherMgr = null;
            }
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            boolean success = false;
            try {
                BytesRef text;
                this.writer = new IndexWriter(this.dir, this.getIndexWriterConfig(this.getGramAnalyzer(), IndexWriterConfig.OpenMode.CREATE));
                while ((text = iter.next()) != null) {
                    BytesRef payload = iter.hasPayloads() ? iter.payload() : null;
                    this.add(text, iter.contexts(), iter.weight(), payload);
                }
                if (this.commitOnBuild || this.closeIndexWriterOnBuild) {
                    this.commit();
                }
                this.searcherMgr = new SearcherManager(this.writer, null);
                success = true;
            }
            finally {
                if (success) {
                    if (this.closeIndexWriterOnBuild) {
                        this.writer.close();
                        this.writer = null;
                    }
                } else if (this.writer != null) {
                    this.writer.rollback();
                    this.writer = null;
                }
            }
        }
    }

    public void commit() throws IOException {
        if (this.writer == null) {
            if (this.searcherMgr == null || !this.closeIndexWriterOnBuild) {
                throw new IllegalStateException("Cannot commit on an closed writer. Add documents first");
            }
        } else {
            this.writer.commit();
        }
    }

    private Analyzer getGramAnalyzer() {
        return new AnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            protected Analyzer getWrappedAnalyzer(String fieldName) {
                return AnalyzingInfixSuggester.this.indexAnalyzer;
            }

            protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
                assert (!fieldName.equals(AnalyzingInfixSuggester.TEXTGRAMS_FIELD_NAME) || AnalyzingInfixSuggester.this.minPrefixChars != 0) : "no need \"textgrams\" when minPrefixChars=" + AnalyzingInfixSuggester.this.minPrefixChars;
                if (fieldName.equals(AnalyzingInfixSuggester.TEXTGRAMS_FIELD_NAME) && AnalyzingInfixSuggester.this.minPrefixChars > 0) {
                    EdgeNGramTokenFilter filter = new EdgeNGramTokenFilter(components.getTokenStream(), 1, AnalyzingInfixSuggester.this.minPrefixChars);
                    return new Analyzer.TokenStreamComponents(components.getTokenizer(), (TokenStream)filter);
                }
                return components;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void ensureOpen() throws IOException {
        if (this.writer == null) {
            this.writer = DirectoryReader.indexExists((Directory)this.dir) ? new IndexWriter(this.dir, this.getIndexWriterConfig(this.getGramAnalyzer(), IndexWriterConfig.OpenMode.APPEND)) : new IndexWriter(this.dir, this.getIndexWriterConfig(this.getGramAnalyzer(), IndexWriterConfig.OpenMode.CREATE));
            Object object = this.searcherMgrLock;
            synchronized (object) {
                SearcherManager oldSearcherMgr = this.searcherMgr;
                this.searcherMgr = new SearcherManager(this.writer, null);
                if (oldSearcherMgr != null) {
                    oldSearcherMgr.close();
                }
            }
        }
    }

    public void add(BytesRef text, Set<BytesRef> contexts, long weight, BytesRef payload) throws IOException {
        this.ensureOpen();
        this.writer.addDocument((Iterable)this.buildDocument(text, contexts, weight, payload));
    }

    public void update(BytesRef text, Set<BytesRef> contexts, long weight, BytesRef payload) throws IOException {
        this.ensureOpen();
        this.writer.updateDocument(new Term(EXACT_TEXT_FIELD_NAME, text.utf8ToString()), (Iterable)this.buildDocument(text, contexts, weight, payload));
    }

    private Document buildDocument(BytesRef text, Set<BytesRef> contexts, long weight, BytesRef payload) throws IOException {
        String textString = text.utf8ToString();
        Document doc = new Document();
        FieldType ft = this.getTextFieldType();
        doc.add((IndexableField)new Field(TEXT_FIELD_NAME, textString, (IndexableFieldType)ft));
        if (this.minPrefixChars > 0) {
            doc.add((IndexableField)new Field(TEXTGRAMS_FIELD_NAME, textString, (IndexableFieldType)ft));
        }
        doc.add((IndexableField)new StringField(EXACT_TEXT_FIELD_NAME, textString, Field.Store.NO));
        doc.add((IndexableField)new BinaryDocValuesField(TEXT_FIELD_NAME, text));
        doc.add((IndexableField)new NumericDocValuesField("weight", weight));
        if (payload != null) {
            doc.add((IndexableField)new BinaryDocValuesField("payloads", payload));
        }
        if (contexts != null) {
            for (BytesRef context : contexts) {
                doc.add((IndexableField)new StringField(CONTEXTS_FIELD_NAME, context, Field.Store.NO));
                doc.add((IndexableField)new SortedSetDocValuesField(CONTEXTS_FIELD_NAME, context));
            }
        }
        return doc;
    }

    public void refresh() throws IOException {
        if (this.searcherMgr == null) {
            throw new IllegalStateException("suggester was not built");
        }
        if (this.writer != null) {
            this.searcherMgr.maybeRefreshBlocking();
        }
    }

    protected FieldType getTextFieldType() {
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(IndexOptions.DOCS);
        ft.setOmitNorms(true);
        return ft;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean onlyMorePopular, int num) throws IOException {
        return this.lookup(key, contexts, num, this.allTermsRequired, this.highlight);
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, int num, boolean allTermsRequired, boolean doHighlight) throws IOException {
        return this.lookup(key, (BooleanQuery)null, num, allTermsRequired, doHighlight);
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, int num, boolean allTermsRequired, boolean doHighlight) throws IOException {
        return this.lookup(key, this.toQuery(contexts), num, allTermsRequired, doHighlight);
    }

    protected Query getLastTokenQuery(String token) throws IOException {
        if (token.length() < this.minPrefixChars) {
            return new TermQuery(new Term(TEXTGRAMS_FIELD_NAME, token));
        }
        return new PrefixQuery(new Term(TEXT_FIELD_NAME, token));
    }

    public List<Lookup.LookupResult> lookup(CharSequence key, Map<BytesRef, BooleanClause.Occur> contextInfo, int num, boolean allTermsRequired, boolean doHighlight) throws IOException {
        return this.lookup(key, this.toQuery(contextInfo), num, allTermsRequired, doHighlight);
    }

    private BooleanQuery toQuery(Map<BytesRef, BooleanClause.Occur> contextInfo) {
        if (contextInfo == null || contextInfo.isEmpty()) {
            return null;
        }
        BooleanQuery.Builder contextFilter = new BooleanQuery.Builder();
        for (Map.Entry<BytesRef, BooleanClause.Occur> entry : contextInfo.entrySet()) {
            this.addContextToQuery(contextFilter, entry.getKey(), entry.getValue());
        }
        return contextFilter.build();
    }

    private BooleanQuery toQuery(Set<BytesRef> contextInfo) {
        if (contextInfo == null || contextInfo.isEmpty()) {
            return null;
        }
        BooleanQuery.Builder contextFilter = new BooleanQuery.Builder();
        for (BytesRef context : contextInfo) {
            this.addContextToQuery(contextFilter, context, BooleanClause.Occur.SHOULD);
        }
        return contextFilter.build();
    }

    public void addContextToQuery(BooleanQuery.Builder query, BytesRef context, BooleanClause.Occur clause) {
        query.add((Query)new TermQuery(new Term(CONTEXTS_FIELD_NAME, context)), clause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, BooleanQuery contextQuery, int num, boolean allTermsRequired, boolean doHighlight) throws IOException {
        IndexSearcher searcher;
        SearcherManager mgr;
        HashSet<String> matchedTokens;
        BooleanQuery.Builder query;
        if (this.searcherMgr == null) {
            throw new IllegalStateException("suggester was not built");
        }
        BooleanClause.Occur occur = allTermsRequired ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
        String prefixToken = null;
        try (TokenStream ts = this.queryAnalyzer.tokenStream("", (Reader)new StringReader(key.toString()));){
            ts.reset();
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
            String lastToken = null;
            query = new BooleanQuery.Builder();
            int maxEndOffset = -1;
            matchedTokens = new HashSet<String>();
            while (ts.incrementToken()) {
                if (lastToken != null) {
                    matchedTokens.add(lastToken);
                    query.add((Query)new TermQuery(new Term(TEXT_FIELD_NAME, lastToken)), occur);
                }
                if ((lastToken = termAtt.toString()) == null) continue;
                maxEndOffset = Math.max(maxEndOffset, offsetAtt.endOffset());
            }
            ts.end();
            if (lastToken != null) {
                Query lastQuery;
                if (maxEndOffset == offsetAtt.endOffset()) {
                    lastQuery = this.getLastTokenQuery(lastToken);
                    prefixToken = lastToken;
                } else {
                    matchedTokens.add(lastToken);
                    lastQuery = new TermQuery(new Term(TEXT_FIELD_NAME, lastToken));
                }
                if (lastQuery != null) {
                    query.add(lastQuery, occur);
                }
            }
            if (contextQuery != null) {
                boolean allMustNot = true;
                for (BooleanClause clause : contextQuery.clauses()) {
                    if (clause.getOccur() == BooleanClause.Occur.MUST_NOT) continue;
                    allMustNot = false;
                    break;
                }
                if (allMustNot) {
                    for (BooleanClause clause : contextQuery.clauses()) {
                        query.add(clause);
                    }
                } else if (!allTermsRequired) {
                    BooleanQuery.Builder newQuery = new BooleanQuery.Builder();
                    newQuery.add((Query)query.build(), BooleanClause.Occur.MUST);
                    newQuery.add((Query)contextQuery, BooleanClause.Occur.MUST);
                    query = newQuery;
                } else {
                    query.add((Query)contextQuery, BooleanClause.Occur.MUST);
                }
            }
        }
        Query finalQuery = this.finishQuery(query, allTermsRequired);
        TopFieldCollector c = TopFieldCollector.create((Sort)SORT, (int)num, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
        List<Lookup.LookupResult> results = null;
        Object maxEndOffset = this.searcherMgrLock;
        synchronized (maxEndOffset) {
            mgr = this.searcherMgr;
            searcher = (IndexSearcher)mgr.acquire();
        }
        try {
            searcher.search(finalQuery, (Collector)c);
            TopFieldDocs hits = c.topDocs();
            results = this.createResults(searcher, hits, num, key, doHighlight, matchedTokens, prefixToken);
        }
        finally {
            mgr.release((Object)searcher);
        }
        return results;
    }

    protected List<Lookup.LookupResult> createResults(IndexSearcher searcher, TopFieldDocs hits, int num, CharSequence charSequence, boolean doHighlight, Set<String> matchedTokens, String prefixToken) throws IOException {
        List leaves = searcher.getIndexReader().leaves();
        ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>();
        for (int i = 0; i < hits.scoreDocs.length; ++i) {
            HashSet<BytesRef> contexts;
            FieldDoc fd = (FieldDoc)hits.scoreDocs[i];
            BinaryDocValues textDV = MultiDocValues.getBinaryValues((IndexReader)searcher.getIndexReader(), (String)TEXT_FIELD_NAME);
            textDV.advance(fd.doc);
            BytesRef term = textDV.binaryValue();
            String text = term.utf8ToString();
            long score = (Long)fd.fields[0];
            BinaryDocValues payloadsDV = MultiDocValues.getBinaryValues((IndexReader)searcher.getIndexReader(), (String)"payloads");
            BytesRef payload = payloadsDV != null ? (payloadsDV.advance(fd.doc) == fd.doc ? BytesRef.deepCopyOf((BytesRef)payloadsDV.binaryValue()) : new BytesRef(BytesRef.EMPTY_BYTES)) : null;
            int segment = ReaderUtil.subIndex((int)fd.doc, (List)leaves);
            SortedSetDocValues contextsDV = ((LeafReaderContext)leaves.get(segment)).reader().getSortedSetDocValues(CONTEXTS_FIELD_NAME);
            if (contextsDV != null) {
                contexts = new HashSet<BytesRef>();
                int targetDocID = fd.doc - ((LeafReaderContext)leaves.get((int)segment)).docBase;
                if (contextsDV.advance(targetDocID) == targetDocID) {
                    long ord;
                    while ((ord = contextsDV.nextOrd()) != -1L) {
                        BytesRef context = BytesRef.deepCopyOf((BytesRef)contextsDV.lookupOrd(ord));
                        contexts.add(context);
                    }
                }
            } else {
                contexts = null;
            }
            Lookup.LookupResult result = doHighlight ? new Lookup.LookupResult(text, this.highlight(text, matchedTokens, prefixToken), score, payload, contexts) : new Lookup.LookupResult((CharSequence)text, score, payload, contexts);
            results.add(result);
        }
        return results;
    }

    protected Query finishQuery(BooleanQuery.Builder in, boolean allTermsRequired) {
        return in.build();
    }

    protected Object highlight(String text, Set<String> matchedTokens, String prefixToken) throws IOException {
        try (TokenStream ts = this.queryAnalyzer.tokenStream(TEXT_FIELD_NAME, (Reader)new StringReader(text));){
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
            ts.reset();
            StringBuilder sb = new StringBuilder();
            int upto = 0;
            while (ts.incrementToken()) {
                String token = termAtt.toString();
                int startOffset = offsetAtt.startOffset();
                int endOffset = offsetAtt.endOffset();
                if (upto < startOffset) {
                    this.addNonMatch(sb, text.substring(upto, startOffset));
                    upto = startOffset;
                } else if (upto > startOffset) continue;
                if (matchedTokens.contains(token)) {
                    this.addWholeMatch(sb, text.substring(startOffset, endOffset), token);
                    upto = endOffset;
                    continue;
                }
                if (prefixToken == null || !token.startsWith(prefixToken)) continue;
                this.addPrefixMatch(sb, text.substring(startOffset, endOffset), token, prefixToken);
                upto = endOffset;
            }
            ts.end();
            int endOffset = offsetAtt.endOffset();
            if (upto < endOffset) {
                this.addNonMatch(sb, text.substring(upto));
            }
            String string = sb.toString();
            return string;
        }
    }

    protected void addNonMatch(StringBuilder sb, String text) {
        sb.append(text);
    }

    protected void addWholeMatch(StringBuilder sb, String surface, String analyzed) {
        sb.append("<b>");
        sb.append(surface);
        sb.append("</b>");
    }

    protected void addPrefixMatch(StringBuilder sb, String surface, String analyzed, String prefixToken) {
        if (prefixToken.length() >= surface.length()) {
            this.addWholeMatch(sb, surface, analyzed);
            return;
        }
        sb.append("<b>");
        sb.append(surface.substring(0, prefixToken.length()));
        sb.append("</b>");
        sb.append(surface.substring(prefixToken.length()));
    }

    @Override
    public boolean store(DataOutput in) throws IOException {
        return false;
    }

    @Override
    public boolean load(DataInput out) throws IOException {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.searcherMgr != null) {
            this.searcherMgr.close();
            this.searcherMgr = null;
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.dir != null) {
            this.dir.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ramBytesUsed() {
        long mem = RamUsageEstimator.shallowSizeOf((Object)this);
        try {
            if (this.searcherMgr != null) {
                IndexSearcher searcher;
                SearcherManager mgr;
                Iterator iterator = this.searcherMgrLock;
                synchronized (iterator) {
                    mgr = this.searcherMgr;
                    searcher = (IndexSearcher)mgr.acquire();
                }
                try {
                    for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
                        LeafReader reader = FilterLeafReader.unwrap((LeafReader)context.reader());
                        if (!(reader instanceof SegmentReader)) continue;
                        mem += ((SegmentReader)context.reader()).ramBytesUsed();
                    }
                }
                finally {
                    mgr.release((Object)searcher);
                }
            }
            return mem;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        try {
            if (this.searcherMgr != null) {
                IndexSearcher searcher;
                SearcherManager mgr;
                Iterator iterator = this.searcherMgrLock;
                synchronized (iterator) {
                    mgr = this.searcherMgr;
                    searcher = (IndexSearcher)mgr.acquire();
                }
                try {
                    for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
                        LeafReader reader = FilterLeafReader.unwrap((LeafReader)context.reader());
                        if (!(reader instanceof SegmentReader)) continue;
                        resources.add(Accountables.namedAccountable((String)"segment", (Accountable)((SegmentReader)reader)));
                    }
                }
                finally {
                    mgr.release((Object)searcher);
                }
            }
            return Collections.unmodifiableList(resources);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCount() throws IOException {
        IndexSearcher searcher;
        SearcherManager mgr;
        if (this.searcherMgr == null) {
            return 0L;
        }
        Object object = this.searcherMgrLock;
        synchronized (object) {
            mgr = this.searcherMgr;
            searcher = (IndexSearcher)mgr.acquire();
        }
        try {
            long l = searcher.getIndexReader().numDocs();
            return l;
        }
        finally {
            mgr.release((Object)searcher);
        }
    }
}

