/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDirectionCalculator$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinder;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtom;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002&'B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\n\u0010\u0012\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0012\u0010\u0016\u001a\u00020\u000e2\n\u0010\u0017\u001a\u00060\fj\u0002`\rJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\bH\u0002J\f\u0010\u001e\u001a\u00020\u000e*\u00020\u000eH\u0002JP\u0010\u001f\u001a\u00020\u0011*\u00020 2\u0006\u0010!\u001a\u00020\u000e2:\u0010\"\u001a6\u0012\u0017\u0012\u00150\fj\u0002`\r\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00110#H\u0002JP\u0010\u001f\u001a\u00020\u0011*\u00020\b2\u0006\u0010!\u001a\u00020\u000e2:\u0010\"\u001a6\u0012\u0017\u0012\u00150\fj\u0002`\r\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00110#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\b\u0012\u00060\fj\u0002`\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u0012\u0012\b\u0012\u00060\fj\u0002`\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator;", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;", "postponedKtPrimitives", "", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtom;", "topLevelType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;Ljava/util/List;Lorg/jetbrains/kotlin/types/UnwrappedType;)V", "directions", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/Variable;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "Lkotlin/collections/HashMap;", "enterToNode", "", "variable", "direction", "getConstraintDependencies", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$NodeWithDirection;", "getDirection", "typeVariable", "isInterestingConstraint", "", "constraint", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "setupDirections", "topReturnType", "opposite", "visitType", "Lorg/jetbrains/kotlin/types/SimpleType;", "startDirection", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "NodeWithDirection", "ResolveDirection", "resolution"})
public final class TypeVariableDirectionCalculator {
    private final HashMap<VariableWithConstraints, ResolveDirection> directions;
    private final VariableFixationFinder.Context c;
    private final List<PostponedResolvedAtom> postponedKtPrimitives;

    @NotNull
    public final ResolveDirection getDirection(@NotNull VariableWithConstraints typeVariable2) {
        Intrinsics.checkParameterIsNotNull(typeVariable2, "typeVariable");
        ResolveDirection resolveDirection = this.directions.getOrDefault(typeVariable2, ResolveDirection.UNKNOWN);
        Intrinsics.checkExpressionValueIsNotNull((Object)resolveDirection, "directions.getOrDefault(\u2026ResolveDirection.UNKNOWN)");
        return resolveDirection;
    }

    private final void setupDirections(UnwrappedType topReturnType) {
        this.visitType(topReturnType, ResolveDirection.TO_SUBTYPE, (Function2<? super VariableWithConstraints, ? super ResolveDirection, Unit>)new Function2<VariableWithConstraints, ResolveDirection, Unit>(this){
            final /* synthetic */ TypeVariableDirectionCalculator this$0;

            public final void invoke(@NotNull VariableWithConstraints variableWithConstraints, @NotNull ResolveDirection direction) {
                Intrinsics.checkParameterIsNotNull(variableWithConstraints, "variableWithConstraints");
                Intrinsics.checkParameterIsNotNull((Object)((Object)direction), "direction");
                TypeVariableDirectionCalculator.access$enterToNode(this.this$0, variableWithConstraints, direction);
            }
            {
                this.this$0 = typeVariableDirectionCalculator;
                super(2);
            }
        });
        for (PostponedResolvedAtom postponedArgument : this.postponedKtPrimitives) {
            for (UnwrappedType inputType : postponedArgument.getInputTypes()) {
                this.visitType(inputType, ResolveDirection.TO_SUBTYPE, (Function2<? super VariableWithConstraints, ? super ResolveDirection, Unit>)new Function2<VariableWithConstraints, ResolveDirection, Unit>(this){
                    final /* synthetic */ TypeVariableDirectionCalculator this$0;

                    public final void invoke(@NotNull VariableWithConstraints variableWithConstraints, @NotNull ResolveDirection direction) {
                        Intrinsics.checkParameterIsNotNull(variableWithConstraints, "variableWithConstraints");
                        Intrinsics.checkParameterIsNotNull((Object)((Object)direction), "direction");
                        TypeVariableDirectionCalculator.access$enterToNode(this.this$0, variableWithConstraints, direction);
                    }
                    {
                        this.this$0 = typeVariableDirectionCalculator;
                        super(2);
                    }
                });
            }
        }
    }

    private final void enterToNode(VariableWithConstraints variable2, ResolveDirection direction) {
        if (direction == ResolveDirection.UNKNOWN) {
            return;
        }
        ResolveDirection previous = this.directions.get(variable2);
        if (previous != null) {
            if (previous != direction) {
                Map map2 = this.directions;
                ResolveDirection resolveDirection = ResolveDirection.UNKNOWN;
                map2.put(variable2, resolveDirection);
            }
            return;
        }
        Map object2 = this.directions;
        ResolveDirection resolveDirection = direction;
        object2.put(variable2, resolveDirection);
        for (NodeWithDirection nodeWithDirection : this.getConstraintDependencies(variable2, direction)) {
            VariableWithConstraints otherVariable = nodeWithDirection.component1();
            ResolveDirection otherDirection = nodeWithDirection.component2();
            this.enterToNode(otherVariable, otherDirection);
        }
    }

    private final List<NodeWithDirection> getConstraintDependencies(VariableWithConstraints variable2, ResolveDirection direction) {
        SmartList smartList;
        SmartList result2 = smartList = new SmartList();
        for (Constraint constraint : variable2.getConstraints()) {
            if (!this.isInterestingConstraint(direction, constraint)) continue;
            this.visitType(constraint.getType(), direction, (Function2<? super VariableWithConstraints, ? super ResolveDirection, Unit>)new Function2<VariableWithConstraints, ResolveDirection, Unit>(result2){
                final /* synthetic */ SmartList $result;

                public final void invoke(@NotNull VariableWithConstraints nodeVariable, @NotNull ResolveDirection nodeDirection) {
                    Intrinsics.checkParameterIsNotNull(nodeVariable, "nodeVariable");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)nodeDirection), "nodeDirection");
                    this.$result.add(new NodeWithDirection(nodeVariable, nodeDirection));
                }
                {
                    this.$result = smartList;
                    super(2);
                }
            });
        }
        return smartList;
    }

    private final boolean isInterestingConstraint(ResolveDirection direction, Constraint constraint) {
        return !(direction == ResolveDirection.TO_SUBTYPE && constraint.getKind() == ConstraintKind.UPPER || direction == ResolveDirection.TO_SUPERTYPE && constraint.getKind() == ConstraintKind.LOWER);
    }

    private final void visitType(@NotNull UnwrappedType $receiver, ResolveDirection startDirection, Function2<? super VariableWithConstraints, ? super ResolveDirection, Unit> action2) {
        UnwrappedType unwrappedType = $receiver;
        if (unwrappedType instanceof SimpleType) {
            this.visitType((SimpleType)$receiver, startDirection, action2);
        } else if (unwrappedType instanceof FlexibleType) {
            this.visitType(((FlexibleType)$receiver).getLowerBound(), startDirection, action2);
            this.visitType(((FlexibleType)$receiver).getUpperBound(), startDirection, action2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void visitType(@NotNull SimpleType $receiver, ResolveDirection startDirection, Function2<? super VariableWithConstraints, ? super ResolveDirection, Unit> action2) {
        if (NewKotlinTypeCheckerKt.isIntersectionType($receiver)) {
            Collection<KotlinType> collection = $receiver.getConstructor().getSupertypes();
            Intrinsics.checkExpressionValueIsNotNull(collection, "constructor.supertypes");
            Iterable $receiver$iv = collection;
            for (Object element$iv : $receiver$iv) {
                KotlinType it = (KotlinType)element$iv;
                this.visitType(it.unwrap(), startDirection, action2);
            }
            return;
        }
        if ($receiver.getArguments().isEmpty()) {
            VariableWithConstraints variableWithConstraints = this.c.getNotFixedTypeVariables().get($receiver.getConstructor());
            if (variableWithConstraints != null) {
                VariableWithConstraints $receiver$iv;
                VariableWithConstraints it = $receiver$iv = variableWithConstraints;
                action2.invoke(it, startDirection);
            }
            return;
        }
        List<TypeParameterDescriptor> parameters2 = $receiver.getConstructor().getParameters();
        if (parameters2.size() != $receiver.getArguments().size()) {
            return;
        }
        Iterable iterable = $receiver.getArguments();
        List<TypeParameterDescriptor> list2 = parameters2;
        Intrinsics.checkExpressionValueIsNotNull(list2, "parameters");
        for (Pair pair : CollectionsKt.zip(iterable, (Iterable)list2)) {
            ResolveDirection resolveDirection;
            TypeProjection argument = (TypeProjection)pair.component1();
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)pair.component2();
            if (argument.isStarProjection()) continue;
            TypeParameterDescriptor typeParameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "parameter");
            Variance variance = typeParameterDescriptor.getVariance();
            Intrinsics.checkExpressionValueIsNotNull((Object)variance, "parameter.variance");
            Variance variance2 = argument.getProjectionKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)variance2, "argument.projectionKind");
            Variance variance3 = NewKotlinTypeChecker.INSTANCE.effectiveVariance(variance, variance2);
            if (variance3 == null) {
                variance3 = Variance.INVARIANT;
            }
            Variance variance4 = variance3;
            switch (TypeVariableDirectionCalculator$WhenMappings.$EnumSwitchMapping$0[variance4.ordinal()]) {
                case 1: {
                    resolveDirection = ResolveDirection.UNKNOWN;
                    break;
                }
                case 2: {
                    resolveDirection = startDirection;
                    break;
                }
                case 3: {
                    resolveDirection = this.opposite(startDirection);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            ResolveDirection innerDirection = resolveDirection;
            this.visitType(argument.getType().unwrap(), innerDirection, action2);
        }
    }

    private final ResolveDirection opposite(@NotNull ResolveDirection $receiver) {
        ResolveDirection resolveDirection;
        switch (TypeVariableDirectionCalculator$WhenMappings.$EnumSwitchMapping$1[$receiver.ordinal()]) {
            case 1: {
                resolveDirection = ResolveDirection.UNKNOWN;
                break;
            }
            case 2: {
                resolveDirection = ResolveDirection.TO_SUBTYPE;
                break;
            }
            case 3: {
                resolveDirection = ResolveDirection.TO_SUPERTYPE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resolveDirection;
    }

    public TypeVariableDirectionCalculator(@NotNull VariableFixationFinder.Context c, @NotNull List<? extends PostponedResolvedAtom> postponedKtPrimitives, @NotNull UnwrappedType topLevelType) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(postponedKtPrimitives, "postponedKtPrimitives");
        Intrinsics.checkParameterIsNotNull(topLevelType, "topLevelType");
        this.c = c;
        this.postponedKtPrimitives = postponedKtPrimitives;
        this.directions = new HashMap();
        this.setupDirections(topLevelType);
    }

    public static final /* synthetic */ void access$enterToNode(TypeVariableDirectionCalculator $this, @NotNull VariableWithConstraints variable2, @NotNull ResolveDirection direction) {
        $this.enterToNode(variable2, direction);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "", "(Ljava/lang/String;I)V", "TO_SUBTYPE", "TO_SUPERTYPE", "UNKNOWN", "resolution"})
    public static final class ResolveDirection
    extends Enum<ResolveDirection> {
        public static final /* enum */ ResolveDirection TO_SUBTYPE;
        public static final /* enum */ ResolveDirection TO_SUPERTYPE;
        public static final /* enum */ ResolveDirection UNKNOWN;
        private static final /* synthetic */ ResolveDirection[] $VALUES;

        static {
            ResolveDirection[] resolveDirectionArray = new ResolveDirection[3];
            ResolveDirection[] resolveDirectionArray2 = resolveDirectionArray;
            resolveDirectionArray[0] = TO_SUBTYPE = new ResolveDirection();
            resolveDirectionArray[1] = TO_SUPERTYPE = new ResolveDirection();
            resolveDirectionArray[2] = UNKNOWN = new ResolveDirection();
            $VALUES = resolveDirectionArray;
        }

        public static ResolveDirection[] values() {
            return (ResolveDirection[])$VALUES.clone();
        }

        public static ResolveDirection valueOf(String string) {
            return Enum.valueOf(ResolveDirection.class, string);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$NodeWithDirection;", "", "variableWithConstraints", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "direction", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;)V", "getDirection", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "getVariableWithConstraints", "()Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolution"})
    public static final class NodeWithDirection {
        @NotNull
        private final VariableWithConstraints variableWithConstraints;
        @NotNull
        private final ResolveDirection direction;

        @NotNull
        public String toString() {
            return "" + this.variableWithConstraints + " to " + (Object)((Object)this.direction);
        }

        @NotNull
        public final VariableWithConstraints getVariableWithConstraints() {
            return this.variableWithConstraints;
        }

        @NotNull
        public final ResolveDirection getDirection() {
            return this.direction;
        }

        public NodeWithDirection(@NotNull VariableWithConstraints variableWithConstraints, @NotNull ResolveDirection direction) {
            Intrinsics.checkParameterIsNotNull(variableWithConstraints, "variableWithConstraints");
            Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
            this.variableWithConstraints = variableWithConstraints;
            this.direction = direction;
        }

        @NotNull
        public final VariableWithConstraints component1() {
            return this.variableWithConstraints;
        }

        @NotNull
        public final ResolveDirection component2() {
            return this.direction;
        }

        @NotNull
        public final NodeWithDirection copy(@NotNull VariableWithConstraints variableWithConstraints, @NotNull ResolveDirection direction) {
            Intrinsics.checkParameterIsNotNull(variableWithConstraints, "variableWithConstraints");
            Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
            return new NodeWithDirection(variableWithConstraints, direction);
        }

        @NotNull
        public static /* synthetic */ NodeWithDirection copy$default(NodeWithDirection nodeWithDirection, VariableWithConstraints variableWithConstraints, ResolveDirection resolveDirection, int n, Object object) {
            if ((n & 1) != 0) {
                variableWithConstraints = nodeWithDirection.variableWithConstraints;
            }
            if ((n & 2) != 0) {
                resolveDirection = nodeWithDirection.direction;
            }
            return nodeWithDirection.copy(variableWithConstraints, resolveDirection);
        }

        public int hashCode() {
            VariableWithConstraints variableWithConstraints = this.variableWithConstraints;
            ResolveDirection resolveDirection = this.direction;
            return (variableWithConstraints != null ? variableWithConstraints.hashCode() : 0) * 31 + (resolveDirection != null ? ((Object)((Object)resolveDirection)).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NodeWithDirection)) break block3;
                    NodeWithDirection nodeWithDirection = (NodeWithDirection)object;
                    if (!Intrinsics.areEqual(this.variableWithConstraints, nodeWithDirection.variableWithConstraints) || !Intrinsics.areEqual((Object)this.direction, (Object)nodeWithDirection.direction)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

