// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `ObjectAdapter.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_ObjectAdapter_h__
#define __Ice_ObjectAdapter_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/CommunicatorF.h>
#include <Ice/ServantLocatorF.h>
#include <Ice/Locator.h>
#include <Ice/FacetMap.h>
#include <Ice/Endpoint.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class ObjectAdapter;

}

namespace Ice
{

class ICE_CLASS(ICE_API) ObjectAdapter
{
public:

    ICE_MEMBER(ICE_API) virtual ~ObjectAdapter();

    virtual ::std::string getName() const = 0;

    virtual ::std::shared_ptr<::Ice::Communicator> getCommunicator() const = 0;

    virtual void activate() = 0;

    virtual void hold() = 0;

    virtual void waitForHold() = 0;

    virtual void deactivate() = 0;

    virtual void waitForDeactivate() = 0;

    virtual bool isDeactivated() const = 0;

    virtual void destroy() noexcept = 0;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> add(const ::std::shared_ptr<::Ice::Object>&, const ::Ice::Identity&) = 0;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> addFacet(const ::std::shared_ptr<::Ice::Object>&, const ::Ice::Identity&, const ::std::string&) = 0;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> addWithUUID(const ::std::shared_ptr<::Ice::Object>&) = 0;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> addFacetWithUUID(const ::std::shared_ptr<::Ice::Object>&, const ::std::string&) = 0;

    virtual void addDefaultServant(const ::std::shared_ptr<::Ice::Object>&, const ::std::string&) = 0;

    virtual ::std::shared_ptr<::Ice::Object> remove(const ::Ice::Identity&) = 0;

    virtual ::std::shared_ptr<::Ice::Object> removeFacet(const ::Ice::Identity&, const ::std::string&) = 0;

    virtual ::Ice::FacetMap removeAllFacets(const ::Ice::Identity&) = 0;

    virtual ::std::shared_ptr<::Ice::Object> removeDefaultServant(const ::std::string&) = 0;

    virtual ::std::shared_ptr<::Ice::Object> find(const ::Ice::Identity&) const = 0;

    virtual ::std::shared_ptr<::Ice::Object> findFacet(const ::Ice::Identity&, const ::std::string&) const = 0;

    virtual ::Ice::FacetMap findAllFacets(const ::Ice::Identity&) const = 0;

    virtual ::std::shared_ptr<::Ice::Object> findByProxy(const ::std::shared_ptr<::Ice::ObjectPrx>&) const = 0;

    virtual void addServantLocator(const ::std::shared_ptr<::Ice::ServantLocator>&, const ::std::string&) = 0;

    virtual ::std::shared_ptr<::Ice::ServantLocator> removeServantLocator(const ::std::string&) = 0;

    virtual ::std::shared_ptr<::Ice::ServantLocator> findServantLocator(const ::std::string&) const = 0;

    virtual ::std::shared_ptr<::Ice::Object> findDefaultServant(const ::std::string&) const = 0;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> createProxy(const ::Ice::Identity&) const = 0;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> createDirectProxy(const ::Ice::Identity&) const = 0;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> createIndirectProxy(const ::Ice::Identity&) const = 0;

    virtual void setLocator(const ::std::shared_ptr<::Ice::LocatorPrx>&) = 0;

    virtual ::std::shared_ptr<::Ice::LocatorPrx> getLocator() const = 0;

    virtual ::Ice::EndpointSeq getEndpoints() const = 0;

    virtual void refreshPublishedEndpoints() = 0;

    virtual ::Ice::EndpointSeq getPublishedEndpoints() const = 0;

    virtual void setPublishedEndpoints(const ::Ice::EndpointSeq&) = 0;
};

}

namespace Ice
{

}

namespace Ice
{

using ObjectAdapterPtr = ::std::shared_ptr<ObjectAdapter>;

}

#else // C++98 mapping

namespace IceProxy
{

}

namespace Ice
{

class ObjectAdapter;
ICE_API ::Ice::LocalObject* upCast(::Ice::ObjectAdapter*);
typedef ::IceInternal::Handle< ::Ice::ObjectAdapter> ObjectAdapterPtr;

}

namespace IceAsync
{

}

namespace IceProxy
{

}

namespace Ice
{

class ICE_API ObjectAdapter : public virtual ::Ice::LocalObject
{
public:

    typedef ObjectAdapterPtr PointerType;

    virtual ~ObjectAdapter();

    virtual ::std::string getName() const = 0;

    virtual ::Ice::CommunicatorPtr getCommunicator() const = 0;

    virtual void activate() = 0;

    virtual void hold() = 0;

    virtual void waitForHold() = 0;

    virtual void deactivate() = 0;

    virtual void waitForDeactivate() = 0;

    virtual bool isDeactivated() const = 0;

    virtual void destroy() ICE_NOEXCEPT = 0;

    virtual ::Ice::ObjectPrx add(const ::Ice::ObjectPtr&, const ::Ice::Identity&) = 0;

    virtual ::Ice::ObjectPrx addFacet(const ::Ice::ObjectPtr&, const ::Ice::Identity&, const ::std::string&) = 0;

    virtual ::Ice::ObjectPrx addWithUUID(const ::Ice::ObjectPtr&) = 0;

    virtual ::Ice::ObjectPrx addFacetWithUUID(const ::Ice::ObjectPtr&, const ::std::string&) = 0;

    virtual void addDefaultServant(const ::Ice::ObjectPtr&, const ::std::string&) = 0;

    virtual ::Ice::ObjectPtr remove(const ::Ice::Identity&) = 0;

    virtual ::Ice::ObjectPtr removeFacet(const ::Ice::Identity&, const ::std::string&) = 0;

    virtual ::Ice::FacetMap removeAllFacets(const ::Ice::Identity&) = 0;

    virtual ::Ice::ObjectPtr removeDefaultServant(const ::std::string&) = 0;

    virtual ::Ice::ObjectPtr find(const ::Ice::Identity&) const = 0;

    virtual ::Ice::ObjectPtr findFacet(const ::Ice::Identity&, const ::std::string&) const = 0;

    virtual ::Ice::FacetMap findAllFacets(const ::Ice::Identity&) const = 0;

    virtual ::Ice::ObjectPtr findByProxy(const ::Ice::ObjectPrx&) const = 0;

    virtual void addServantLocator(const ::Ice::ServantLocatorPtr&, const ::std::string&) = 0;

    virtual ::Ice::ServantLocatorPtr removeServantLocator(const ::std::string&) = 0;

    virtual ::Ice::ServantLocatorPtr findServantLocator(const ::std::string&) const = 0;

    virtual ::Ice::ObjectPtr findDefaultServant(const ::std::string&) const = 0;

    virtual ::Ice::ObjectPrx createProxy(const ::Ice::Identity&) const = 0;

    virtual ::Ice::ObjectPrx createDirectProxy(const ::Ice::Identity&) const = 0;

    virtual ::Ice::ObjectPrx createIndirectProxy(const ::Ice::Identity&) const = 0;

    virtual void setLocator(const ::Ice::LocatorPrx&) = 0;

    virtual ::Ice::LocatorPrx getLocator() const = 0;

    virtual ::Ice::EndpointSeq getEndpoints() const = 0;

    virtual void refreshPublishedEndpoints() = 0;

    virtual ::Ice::EndpointSeq getPublishedEndpoints() const = 0;

    virtual void setPublishedEndpoints(const ::Ice::EndpointSeq&) = 0;
};

inline bool operator==(const ObjectAdapter& lhs, const ObjectAdapter& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const ObjectAdapter& lhs, const ObjectAdapter& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

}

namespace Ice
{

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
