/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceMX;

import com.zeroc.IceInternal.MetricsMap;
import com.zeroc.IceMX.Metrics;
import com.zeroc.IceMX.MetricsHelper;
import com.zeroc.IceUtilInternal.StopWatch;
import java.util.ArrayList;
import java.util.List;

public class Observer<T extends Metrics>
extends StopWatch
implements com.zeroc.Ice.Instrumentation.Observer {
    private List<MetricsMap.MetricsMap.Entry> _objects;
    private long _previousDelay = 0L;

    @Override
    public void attach() {
        if (!this.isStarted()) {
            this.start();
        }
    }

    @Override
    public void detach() {
        long lifetime = this._previousDelay + this.stop();
        for (MetricsMap.Entry entry : this._objects) {
            entry.detach(lifetime);
        }
    }

    @Override
    public void failed(String exceptionName) {
        for (MetricsMap.Entry entry : this._objects) {
            entry.failed(exceptionName);
        }
    }

    public void forEach(MetricsUpdate<T> u) {
        for (MetricsMap.Entry entry : this._objects) {
            entry.execute(u);
        }
    }

    public void init(MetricsHelper<T> helper, List<MetricsMap.MetricsMap.Entry> objects, Observer<T> previous) {
        this._objects = objects;
        if (previous == null) {
            return;
        }
        this._previousDelay = previous._previousDelay + previous.delay();
        for (MetricsMap.Entry entry : previous._objects) {
            if (this._objects.contains(entry)) continue;
            entry.detach(this._previousDelay);
        }
    }

    public <S extends Metrics, ObserverImpl extends Observer<S>> ObserverImpl getObserver(String mapName, MetricsHelper<S> helper, Class<S> mcl, Class<ObserverImpl> ocl) {
        ArrayList<MetricsMap.Entry> metricsObjects = null;
        for (MetricsMap.Entry entry : this._objects) {
            MetricsMap.Entry e = entry.getMatching(mapName, helper, mcl);
            if (e == null) continue;
            if (metricsObjects == null) {
                metricsObjects = new ArrayList<MetricsMap.Entry>(this._objects.size());
            }
            metricsObjects.add(e);
        }
        if (metricsObjects == null) {
            return null;
        }
        try {
            Observer obsv = (Observer)ocl.newInstance();
            obsv.init(helper, metricsObjects, null);
            return (ObserverImpl)obsv;
        }
        catch (Exception ex) {
            assert (false);
            return null;
        }
    }

    public MetricsMap.MetricsMap.Entry getEntry(MetricsMap<?> map) {
        for (MetricsMap.Entry entry : this._objects) {
            if (entry.getMap() != map) continue;
            return entry;
        }
        return null;
    }

    public static interface MetricsUpdate<T> {
        public void update(T var1);
    }
}

