/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.cacheops;

import org.gradle.cache.internal.cacheops.CacheOperationStack;

public class CacheAccessOperationsStack {
    private final ThreadLocal<CacheOperationStack> stackForThread = new ThreadLocal();

    public void pushCacheAction() {
        CacheOperationStack stack = this.getOrCreateStack();
        stack.pushCacheAction();
    }

    public void popCacheAction() {
        CacheOperationStack stack = this.stackForThread.get();
        if (stack == null) {
            throw new IllegalStateException("Operation stack is empty.");
        }
        stack.popCacheAction();
        if (stack.isEmpty()) {
            this.stackForThread.remove();
        }
    }

    public boolean isInCacheAction() {
        CacheOperationStack stack = this.stackForThread.get();
        return stack != null && stack.isInCacheAction();
    }

    private CacheOperationStack getOrCreateStack() {
        CacheOperationStack stack = this.stackForThread.get();
        if (stack == null) {
            stack = new CacheOperationStack();
            this.stackForThread.set(stack);
        }
        return stack;
    }
}

